/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.DecryptionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDecryptionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputDecryptionSettings> {
    private static final SdkField<String> DECRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DecryptionMode").getter(InputDecryptionSettings.getter(InputDecryptionSettings::decryptionModeAsString)).setter(InputDecryptionSettings.setter(Builder::decryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryptionMode").build()}).build();
    private static final SdkField<String> ENCRYPTED_DECRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptedDecryptionKey").getter(InputDecryptionSettings.getter(InputDecryptionSettings::encryptedDecryptionKey)).setter(InputDecryptionSettings.setter(Builder::encryptedDecryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptedDecryptionKey").build()}).build();
    private static final SdkField<String> INITIALIZATION_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitializationVector").getter(InputDecryptionSettings.getter(InputDecryptionSettings::initializationVector)).setter(InputDecryptionSettings.setter(Builder::initializationVector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationVector").build()}).build();
    private static final SdkField<String> KMS_KEY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyRegion").getter(InputDecryptionSettings.getter(InputDecryptionSettings::kmsKeyRegion)).setter(InputDecryptionSettings.setter(Builder::kmsKeyRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECRYPTION_MODE_FIELD, ENCRYPTED_DECRYPTION_KEY_FIELD, INITIALIZATION_VECTOR_FIELD, KMS_KEY_REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String decryptionMode;
    private final String encryptedDecryptionKey;
    private final String initializationVector;
    private final String kmsKeyRegion;

    private InputDecryptionSettings(BuilderImpl builder) {
        this.decryptionMode = builder.decryptionMode;
        this.encryptedDecryptionKey = builder.encryptedDecryptionKey;
        this.initializationVector = builder.initializationVector;
        this.kmsKeyRegion = builder.kmsKeyRegion;
    }

    public final DecryptionMode decryptionMode() {
        return DecryptionMode.fromValue(this.decryptionMode);
    }

    public final String decryptionModeAsString() {
        return this.decryptionMode;
    }

    public final String encryptedDecryptionKey() {
        return this.encryptedDecryptionKey;
    }

    public final String initializationVector() {
        return this.initializationVector;
    }

    public final String kmsKeyRegion() {
        return this.kmsKeyRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.decryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptedDecryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.initializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDecryptionSettings)) {
            return false;
        }
        InputDecryptionSettings other = (InputDecryptionSettings)obj;
        return Objects.equals(this.decryptionModeAsString(), other.decryptionModeAsString()) && Objects.equals(this.encryptedDecryptionKey(), other.encryptedDecryptionKey()) && Objects.equals(this.initializationVector(), other.initializationVector()) && Objects.equals(this.kmsKeyRegion(), other.kmsKeyRegion());
    }

    public final String toString() {
        return ToString.builder((String)"InputDecryptionSettings").add("DecryptionMode", (Object)this.decryptionModeAsString()).add("EncryptedDecryptionKey", (Object)this.encryptedDecryptionKey()).add("InitializationVector", (Object)this.initializationVector()).add("KmsKeyRegion", (Object)this.kmsKeyRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DecryptionMode": {
                return Optional.ofNullable(clazz.cast(this.decryptionModeAsString()));
            }
            case "EncryptedDecryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptedDecryptionKey()));
            }
            case "InitializationVector": {
                return Optional.ofNullable(clazz.cast(this.initializationVector()));
            }
            case "KmsKeyRegion": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDecryptionSettings, T> g) {
        return obj -> g.apply((InputDecryptionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String decryptionMode;
        private String encryptedDecryptionKey;
        private String initializationVector;
        private String kmsKeyRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDecryptionSettings model) {
            this.decryptionMode(model.decryptionMode);
            this.encryptedDecryptionKey(model.encryptedDecryptionKey);
            this.initializationVector(model.initializationVector);
            this.kmsKeyRegion(model.kmsKeyRegion);
        }

        public final String getDecryptionMode() {
            return this.decryptionMode;
        }

        public final void setDecryptionMode(String decryptionMode) {
            this.decryptionMode = decryptionMode;
        }

        @Override
        @Transient
        public final Builder decryptionMode(String decryptionMode) {
            this.decryptionMode = decryptionMode;
            return this;
        }

        @Override
        @Transient
        public final Builder decryptionMode(DecryptionMode decryptionMode) {
            this.decryptionMode(decryptionMode == null ? null : decryptionMode.toString());
            return this;
        }

        public final String getEncryptedDecryptionKey() {
            return this.encryptedDecryptionKey;
        }

        public final void setEncryptedDecryptionKey(String encryptedDecryptionKey) {
            this.encryptedDecryptionKey = encryptedDecryptionKey;
        }

        @Override
        @Transient
        public final Builder encryptedDecryptionKey(String encryptedDecryptionKey) {
            this.encryptedDecryptionKey = encryptedDecryptionKey;
            return this;
        }

        public final String getInitializationVector() {
            return this.initializationVector;
        }

        public final void setInitializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
        }

        @Override
        @Transient
        public final Builder initializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
            return this;
        }

        public final String getKmsKeyRegion() {
            return this.kmsKeyRegion;
        }

        public final void setKmsKeyRegion(String kmsKeyRegion) {
            this.kmsKeyRegion = kmsKeyRegion;
        }

        @Override
        @Transient
        public final Builder kmsKeyRegion(String kmsKeyRegion) {
            this.kmsKeyRegion = kmsKeyRegion;
            return this;
        }

        public InputDecryptionSettings build() {
            return new InputDecryptionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputDecryptionSettings> {
        public Builder decryptionMode(String var1);

        public Builder decryptionMode(DecryptionMode var1);

        public Builder encryptedDecryptionKey(String var1);

        public Builder initializationVector(String var1);

        public Builder kmsKeyRegion(String var1);
    }
}

