/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.CmfcSettings;
import software.amazon.awssdk.services.mediaconvert.model.ContainerType;
import software.amazon.awssdk.services.mediaconvert.model.F4vSettings;
import software.amazon.awssdk.services.mediaconvert.model.M2tsSettings;
import software.amazon.awssdk.services.mediaconvert.model.M3u8Settings;
import software.amazon.awssdk.services.mediaconvert.model.MovSettings;
import software.amazon.awssdk.services.mediaconvert.model.Mp4Settings;
import software.amazon.awssdk.services.mediaconvert.model.MpdSettings;
import software.amazon.awssdk.services.mediaconvert.model.MxfSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerSettings> {
    private static final SdkField<CmfcSettings> CMFC_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CmfcSettings").getter(ContainerSettings.getter(ContainerSettings::cmfcSettings)).setter(ContainerSettings.setter(Builder::cmfcSettings)).constructor(CmfcSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cmfcSettings").build()}).build();
    private static final SdkField<String> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Container").getter(ContainerSettings.getter(ContainerSettings::containerAsString)).setter(ContainerSettings.setter(Builder::container)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()}).build();
    private static final SdkField<F4vSettings> F4_V_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("F4vSettings").getter(ContainerSettings.getter(ContainerSettings::f4vSettings)).setter(ContainerSettings.setter(Builder::f4vSettings)).constructor(F4vSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("f4vSettings").build()}).build();
    private static final SdkField<M2tsSettings> M2_TS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("M2tsSettings").getter(ContainerSettings.getter(ContainerSettings::m2tsSettings)).setter(ContainerSettings.setter(Builder::m2tsSettings)).constructor(M2tsSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2tsSettings").build()}).build();
    private static final SdkField<M3u8Settings> M3_U8_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("M3u8Settings").getter(ContainerSettings.getter(ContainerSettings::m3u8Settings)).setter(ContainerSettings.setter(Builder::m3u8Settings)).constructor(M3u8Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m3u8Settings").build()}).build();
    private static final SdkField<MovSettings> MOV_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MovSettings").getter(ContainerSettings.getter(ContainerSettings::movSettings)).setter(ContainerSettings.setter(Builder::movSettings)).constructor(MovSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("movSettings").build()}).build();
    private static final SdkField<Mp4Settings> MP4_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Mp4Settings").getter(ContainerSettings.getter(ContainerSettings::mp4Settings)).setter(ContainerSettings.setter(Builder::mp4Settings)).constructor(Mp4Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mp4Settings").build()}).build();
    private static final SdkField<MpdSettings> MPD_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MpdSettings").getter(ContainerSettings.getter(ContainerSettings::mpdSettings)).setter(ContainerSettings.setter(Builder::mpdSettings)).constructor(MpdSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpdSettings").build()}).build();
    private static final SdkField<MxfSettings> MXF_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MxfSettings").getter(ContainerSettings.getter(ContainerSettings::mxfSettings)).setter(ContainerSettings.setter(Builder::mxfSettings)).constructor(MxfSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mxfSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CMFC_SETTINGS_FIELD, CONTAINER_FIELD, F4_V_SETTINGS_FIELD, M2_TS_SETTINGS_FIELD, M3_U8_SETTINGS_FIELD, MOV_SETTINGS_FIELD, MP4_SETTINGS_FIELD, MPD_SETTINGS_FIELD, MXF_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final CmfcSettings cmfcSettings;
    private final String container;
    private final F4vSettings f4vSettings;
    private final M2tsSettings m2tsSettings;
    private final M3u8Settings m3u8Settings;
    private final MovSettings movSettings;
    private final Mp4Settings mp4Settings;
    private final MpdSettings mpdSettings;
    private final MxfSettings mxfSettings;

    private ContainerSettings(BuilderImpl builder) {
        this.cmfcSettings = builder.cmfcSettings;
        this.container = builder.container;
        this.f4vSettings = builder.f4vSettings;
        this.m2tsSettings = builder.m2tsSettings;
        this.m3u8Settings = builder.m3u8Settings;
        this.movSettings = builder.movSettings;
        this.mp4Settings = builder.mp4Settings;
        this.mpdSettings = builder.mpdSettings;
        this.mxfSettings = builder.mxfSettings;
    }

    public final CmfcSettings cmfcSettings() {
        return this.cmfcSettings;
    }

    public final ContainerType container() {
        return ContainerType.fromValue(this.container);
    }

    public final String containerAsString() {
        return this.container;
    }

    public final F4vSettings f4vSettings() {
        return this.f4vSettings;
    }

    public final M2tsSettings m2tsSettings() {
        return this.m2tsSettings;
    }

    public final M3u8Settings m3u8Settings() {
        return this.m3u8Settings;
    }

    public final MovSettings movSettings() {
        return this.movSettings;
    }

    public final Mp4Settings mp4Settings() {
        return this.mp4Settings;
    }

    public final MpdSettings mpdSettings() {
        return this.mpdSettings;
    }

    public final MxfSettings mxfSettings() {
        return this.mxfSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cmfcSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.f4vSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.m2tsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.m3u8Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.movSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mp4Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mpdSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mxfSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerSettings)) {
            return false;
        }
        ContainerSettings other = (ContainerSettings)obj;
        return Objects.equals(this.cmfcSettings(), other.cmfcSettings()) && Objects.equals(this.containerAsString(), other.containerAsString()) && Objects.equals(this.f4vSettings(), other.f4vSettings()) && Objects.equals(this.m2tsSettings(), other.m2tsSettings()) && Objects.equals(this.m3u8Settings(), other.m3u8Settings()) && Objects.equals(this.movSettings(), other.movSettings()) && Objects.equals(this.mp4Settings(), other.mp4Settings()) && Objects.equals(this.mpdSettings(), other.mpdSettings()) && Objects.equals(this.mxfSettings(), other.mxfSettings());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerSettings").add("CmfcSettings", (Object)this.cmfcSettings()).add("Container", (Object)this.containerAsString()).add("F4vSettings", (Object)this.f4vSettings()).add("M2tsSettings", (Object)this.m2tsSettings()).add("M3u8Settings", (Object)this.m3u8Settings()).add("MovSettings", (Object)this.movSettings()).add("Mp4Settings", (Object)this.mp4Settings()).add("MpdSettings", (Object)this.mpdSettings()).add("MxfSettings", (Object)this.mxfSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CmfcSettings": {
                return Optional.ofNullable(clazz.cast(this.cmfcSettings()));
            }
            case "Container": {
                return Optional.ofNullable(clazz.cast(this.containerAsString()));
            }
            case "F4vSettings": {
                return Optional.ofNullable(clazz.cast(this.f4vSettings()));
            }
            case "M2tsSettings": {
                return Optional.ofNullable(clazz.cast(this.m2tsSettings()));
            }
            case "M3u8Settings": {
                return Optional.ofNullable(clazz.cast(this.m3u8Settings()));
            }
            case "MovSettings": {
                return Optional.ofNullable(clazz.cast(this.movSettings()));
            }
            case "Mp4Settings": {
                return Optional.ofNullable(clazz.cast(this.mp4Settings()));
            }
            case "MpdSettings": {
                return Optional.ofNullable(clazz.cast(this.mpdSettings()));
            }
            case "MxfSettings": {
                return Optional.ofNullable(clazz.cast(this.mxfSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerSettings, T> g) {
        return obj -> g.apply((ContainerSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CmfcSettings cmfcSettings;
        private String container;
        private F4vSettings f4vSettings;
        private M2tsSettings m2tsSettings;
        private M3u8Settings m3u8Settings;
        private MovSettings movSettings;
        private Mp4Settings mp4Settings;
        private MpdSettings mpdSettings;
        private MxfSettings mxfSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerSettings model) {
            this.cmfcSettings(model.cmfcSettings);
            this.container(model.container);
            this.f4vSettings(model.f4vSettings);
            this.m2tsSettings(model.m2tsSettings);
            this.m3u8Settings(model.m3u8Settings);
            this.movSettings(model.movSettings);
            this.mp4Settings(model.mp4Settings);
            this.mpdSettings(model.mpdSettings);
            this.mxfSettings(model.mxfSettings);
        }

        public final CmfcSettings.Builder getCmfcSettings() {
            return this.cmfcSettings != null ? this.cmfcSettings.toBuilder() : null;
        }

        public final void setCmfcSettings(CmfcSettings.BuilderImpl cmfcSettings) {
            this.cmfcSettings = cmfcSettings != null ? cmfcSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder cmfcSettings(CmfcSettings cmfcSettings) {
            this.cmfcSettings = cmfcSettings;
            return this;
        }

        public final String getContainer() {
            return this.container;
        }

        public final void setContainer(String container) {
            this.container = container;
        }

        @Override
        @Transient
        public final Builder container(String container) {
            this.container = container;
            return this;
        }

        @Override
        @Transient
        public final Builder container(ContainerType container) {
            this.container(container == null ? null : container.toString());
            return this;
        }

        public final F4vSettings.Builder getF4vSettings() {
            return this.f4vSettings != null ? this.f4vSettings.toBuilder() : null;
        }

        public final void setF4vSettings(F4vSettings.BuilderImpl f4vSettings) {
            this.f4vSettings = f4vSettings != null ? f4vSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder f4vSettings(F4vSettings f4vSettings) {
            this.f4vSettings = f4vSettings;
            return this;
        }

        public final M2tsSettings.Builder getM2tsSettings() {
            return this.m2tsSettings != null ? this.m2tsSettings.toBuilder() : null;
        }

        public final void setM2tsSettings(M2tsSettings.BuilderImpl m2tsSettings) {
            this.m2tsSettings = m2tsSettings != null ? m2tsSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder m2tsSettings(M2tsSettings m2tsSettings) {
            this.m2tsSettings = m2tsSettings;
            return this;
        }

        public final M3u8Settings.Builder getM3u8Settings() {
            return this.m3u8Settings != null ? this.m3u8Settings.toBuilder() : null;
        }

        public final void setM3u8Settings(M3u8Settings.BuilderImpl m3u8Settings) {
            this.m3u8Settings = m3u8Settings != null ? m3u8Settings.build() : null;
        }

        @Override
        @Transient
        public final Builder m3u8Settings(M3u8Settings m3u8Settings) {
            this.m3u8Settings = m3u8Settings;
            return this;
        }

        public final MovSettings.Builder getMovSettings() {
            return this.movSettings != null ? this.movSettings.toBuilder() : null;
        }

        public final void setMovSettings(MovSettings.BuilderImpl movSettings) {
            this.movSettings = movSettings != null ? movSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder movSettings(MovSettings movSettings) {
            this.movSettings = movSettings;
            return this;
        }

        public final Mp4Settings.Builder getMp4Settings() {
            return this.mp4Settings != null ? this.mp4Settings.toBuilder() : null;
        }

        public final void setMp4Settings(Mp4Settings.BuilderImpl mp4Settings) {
            this.mp4Settings = mp4Settings != null ? mp4Settings.build() : null;
        }

        @Override
        @Transient
        public final Builder mp4Settings(Mp4Settings mp4Settings) {
            this.mp4Settings = mp4Settings;
            return this;
        }

        public final MpdSettings.Builder getMpdSettings() {
            return this.mpdSettings != null ? this.mpdSettings.toBuilder() : null;
        }

        public final void setMpdSettings(MpdSettings.BuilderImpl mpdSettings) {
            this.mpdSettings = mpdSettings != null ? mpdSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder mpdSettings(MpdSettings mpdSettings) {
            this.mpdSettings = mpdSettings;
            return this;
        }

        public final MxfSettings.Builder getMxfSettings() {
            return this.mxfSettings != null ? this.mxfSettings.toBuilder() : null;
        }

        public final void setMxfSettings(MxfSettings.BuilderImpl mxfSettings) {
            this.mxfSettings = mxfSettings != null ? mxfSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder mxfSettings(MxfSettings mxfSettings) {
            this.mxfSettings = mxfSettings;
            return this;
        }

        public ContainerSettings build() {
            return new ContainerSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerSettings> {
        public Builder cmfcSettings(CmfcSettings var1);

        default public Builder cmfcSettings(Consumer<CmfcSettings.Builder> cmfcSettings) {
            return this.cmfcSettings((CmfcSettings)((CmfcSettings.Builder)CmfcSettings.builder().applyMutation(cmfcSettings)).build());
        }

        public Builder container(String var1);

        public Builder container(ContainerType var1);

        public Builder f4vSettings(F4vSettings var1);

        default public Builder f4vSettings(Consumer<F4vSettings.Builder> f4vSettings) {
            return this.f4vSettings((F4vSettings)((F4vSettings.Builder)F4vSettings.builder().applyMutation(f4vSettings)).build());
        }

        public Builder m2tsSettings(M2tsSettings var1);

        default public Builder m2tsSettings(Consumer<M2tsSettings.Builder> m2tsSettings) {
            return this.m2tsSettings((M2tsSettings)((M2tsSettings.Builder)M2tsSettings.builder().applyMutation(m2tsSettings)).build());
        }

        public Builder m3u8Settings(M3u8Settings var1);

        default public Builder m3u8Settings(Consumer<M3u8Settings.Builder> m3u8Settings) {
            return this.m3u8Settings((M3u8Settings)((M3u8Settings.Builder)M3u8Settings.builder().applyMutation(m3u8Settings)).build());
        }

        public Builder movSettings(MovSettings var1);

        default public Builder movSettings(Consumer<MovSettings.Builder> movSettings) {
            return this.movSettings((MovSettings)((MovSettings.Builder)MovSettings.builder().applyMutation(movSettings)).build());
        }

        public Builder mp4Settings(Mp4Settings var1);

        default public Builder mp4Settings(Consumer<Mp4Settings.Builder> mp4Settings) {
            return this.mp4Settings((Mp4Settings)((Mp4Settings.Builder)Mp4Settings.builder().applyMutation(mp4Settings)).build());
        }

        public Builder mpdSettings(MpdSettings var1);

        default public Builder mpdSettings(Consumer<MpdSettings.Builder> mpdSettings) {
            return this.mpdSettings((MpdSettings)((MpdSettings.Builder)MpdSettings.builder().applyMutation(mpdSettings)).build());
        }

        public Builder mxfSettings(MxfSettings var1);

        default public Builder mxfSettings(Consumer<MxfSettings.Builder> mxfSettings) {
            return this.mxfSettings((MxfSettings)((MxfSettings.Builder)MxfSettings.builder().applyMutation(mxfSettings)).build());
        }
    }
}

