/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H265FlickerAdaptiveQuantization {
    DISABLED("DISABLED"),
    ENABLED("ENABLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H265FlickerAdaptiveQuantization> VALUE_MAP;
    private final String value;

    private H265FlickerAdaptiveQuantization(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H265FlickerAdaptiveQuantization fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H265FlickerAdaptiveQuantization> knownValues() {
        EnumSet<H265FlickerAdaptiveQuantization> knownValues = EnumSet.allOf(H265FlickerAdaptiveQuantization.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H265FlickerAdaptiveQuantization.class, H265FlickerAdaptiveQuantization::toString);
    }
}

