/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputTimecodeSource {
    EMBEDDED("EMBEDDED"),
    ZEROBASED("ZEROBASED"),
    SPECIFIEDSTART("SPECIFIEDSTART"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputTimecodeSource> VALUE_MAP;
    private final String value;

    private InputTimecodeSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputTimecodeSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputTimecodeSource> knownValues() {
        EnumSet<InputTimecodeSource> knownValues = EnumSet.allOf(InputTimecodeSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputTimecodeSource.class, InputTimecodeSource::toString);
    }
}

