/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconvert.model.AccelerationSettings;
import software.amazon.awssdk.services.mediaconvert.model.BillingTagsSource;
import software.amazon.awssdk.services.mediaconvert.model.HopDestination;
import software.amazon.awssdk.services.mediaconvert.model.JobSettings;
import software.amazon.awssdk.services.mediaconvert.model.MediaConvertRequest;
import software.amazon.awssdk.services.mediaconvert.model.SimulateReservedQueue;
import software.amazon.awssdk.services.mediaconvert.model.StatusUpdateInterval;
import software.amazon.awssdk.services.mediaconvert.model.___listOfHopDestinationCopier;
import software.amazon.awssdk.services.mediaconvert.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJobRequest
extends MediaConvertRequest
implements ToCopyableBuilder<Builder, CreateJobRequest> {
    private static final SdkField<AccelerationSettings> ACCELERATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccelerationSettings").getter(CreateJobRequest.getter(CreateJobRequest::accelerationSettings)).setter(CreateJobRequest.setter(Builder::accelerationSettings)).constructor(AccelerationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerationSettings").build()}).build();
    private static final SdkField<String> BILLING_TAGS_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingTagsSource").getter(CreateJobRequest.getter(CreateJobRequest::billingTagsSourceAsString)).setter(CreateJobRequest.setter(Builder::billingTagsSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingTagsSource").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateJobRequest.getter(CreateJobRequest::clientRequestToken)).setter(CreateJobRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<HopDestination>> HOP_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HopDestinations").getter(CreateJobRequest.getter(CreateJobRequest::hopDestinations)).setter(CreateJobRequest.setter(Builder::hopDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hopDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HopDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> JOB_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobTemplate").getter(CreateJobRequest.getter(CreateJobRequest::jobTemplate)).setter(CreateJobRequest.setter(Builder::jobTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplate").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(CreateJobRequest.getter(CreateJobRequest::priority)).setter(CreateJobRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<String> QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Queue").getter(CreateJobRequest.getter(CreateJobRequest::queue)).setter(CreateJobRequest.setter(Builder::queue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queue").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(CreateJobRequest.getter(CreateJobRequest::role)).setter(CreateJobRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<JobSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(CreateJobRequest.getter(CreateJobRequest::settings)).setter(CreateJobRequest.setter(Builder::settings)).constructor(JobSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()}).build();
    private static final SdkField<String> SIMULATE_RESERVED_QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SimulateReservedQueue").getter(CreateJobRequest.getter(CreateJobRequest::simulateReservedQueueAsString)).setter(CreateJobRequest.setter(Builder::simulateReservedQueue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulateReservedQueue").build()}).build();
    private static final SdkField<String> STATUS_UPDATE_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusUpdateInterval").getter(CreateJobRequest.getter(CreateJobRequest::statusUpdateIntervalAsString)).setter(CreateJobRequest.setter(Builder::statusUpdateInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusUpdateInterval").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateJobRequest.getter(CreateJobRequest::tags)).setter(CreateJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> USER_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("UserMetadata").getter(CreateJobRequest.getter(CreateJobRequest::userMetadata)).setter(CreateJobRequest.setter(Builder::userMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATION_SETTINGS_FIELD, BILLING_TAGS_SOURCE_FIELD, CLIENT_REQUEST_TOKEN_FIELD, HOP_DESTINATIONS_FIELD, JOB_TEMPLATE_FIELD, PRIORITY_FIELD, QUEUE_FIELD, ROLE_FIELD, SETTINGS_FIELD, SIMULATE_RESERVED_QUEUE_FIELD, STATUS_UPDATE_INTERVAL_FIELD, TAGS_FIELD, USER_METADATA_FIELD));
    private final AccelerationSettings accelerationSettings;
    private final String billingTagsSource;
    private final String clientRequestToken;
    private final List<HopDestination> hopDestinations;
    private final String jobTemplate;
    private final Integer priority;
    private final String queue;
    private final String role;
    private final JobSettings settings;
    private final String simulateReservedQueue;
    private final String statusUpdateInterval;
    private final Map<String, String> tags;
    private final Map<String, String> userMetadata;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.accelerationSettings = builder.accelerationSettings;
        this.billingTagsSource = builder.billingTagsSource;
        this.clientRequestToken = builder.clientRequestToken;
        this.hopDestinations = builder.hopDestinations;
        this.jobTemplate = builder.jobTemplate;
        this.priority = builder.priority;
        this.queue = builder.queue;
        this.role = builder.role;
        this.settings = builder.settings;
        this.simulateReservedQueue = builder.simulateReservedQueue;
        this.statusUpdateInterval = builder.statusUpdateInterval;
        this.tags = builder.tags;
        this.userMetadata = builder.userMetadata;
    }

    public final AccelerationSettings accelerationSettings() {
        return this.accelerationSettings;
    }

    public final BillingTagsSource billingTagsSource() {
        return BillingTagsSource.fromValue(this.billingTagsSource);
    }

    public final String billingTagsSourceAsString() {
        return this.billingTagsSource;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasHopDestinations() {
        return this.hopDestinations != null && !(this.hopDestinations instanceof SdkAutoConstructList);
    }

    public final List<HopDestination> hopDestinations() {
        return this.hopDestinations;
    }

    public final String jobTemplate() {
        return this.jobTemplate;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final String queue() {
        return this.queue;
    }

    public final String role() {
        return this.role;
    }

    public final JobSettings settings() {
        return this.settings;
    }

    public final SimulateReservedQueue simulateReservedQueue() {
        return SimulateReservedQueue.fromValue(this.simulateReservedQueue);
    }

    public final String simulateReservedQueueAsString() {
        return this.simulateReservedQueue;
    }

    public final StatusUpdateInterval statusUpdateInterval() {
        return StatusUpdateInterval.fromValue(this.statusUpdateInterval);
    }

    public final String statusUpdateIntervalAsString() {
        return this.statusUpdateInterval;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasUserMetadata() {
        return this.userMetadata != null && !(this.userMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> userMetadata() {
        return this.userMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accelerationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingTagsSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHopDestinations() ? this.hopDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.queue());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.simulateReservedQueueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusUpdateIntervalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserMetadata() ? this.userMetadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest)((Object)obj);
        return Objects.equals(this.accelerationSettings(), other.accelerationSettings()) && Objects.equals(this.billingTagsSourceAsString(), other.billingTagsSourceAsString()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasHopDestinations() == other.hasHopDestinations() && Objects.equals(this.hopDestinations(), other.hopDestinations()) && Objects.equals(this.jobTemplate(), other.jobTemplate()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.queue(), other.queue()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.simulateReservedQueueAsString(), other.simulateReservedQueueAsString()) && Objects.equals(this.statusUpdateIntervalAsString(), other.statusUpdateIntervalAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasUserMetadata() == other.hasUserMetadata() && Objects.equals(this.userMetadata(), other.userMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"CreateJobRequest").add("AccelerationSettings", (Object)this.accelerationSettings()).add("BillingTagsSource", (Object)this.billingTagsSourceAsString()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("HopDestinations", this.hasHopDestinations() ? this.hopDestinations() : null).add("JobTemplate", (Object)this.jobTemplate()).add("Priority", (Object)this.priority()).add("Queue", (Object)this.queue()).add("Role", (Object)this.role()).add("Settings", (Object)this.settings()).add("SimulateReservedQueue", (Object)this.simulateReservedQueueAsString()).add("StatusUpdateInterval", (Object)this.statusUpdateIntervalAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("UserMetadata", this.hasUserMetadata() ? this.userMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccelerationSettings": {
                return Optional.ofNullable(clazz.cast(this.accelerationSettings()));
            }
            case "BillingTagsSource": {
                return Optional.ofNullable(clazz.cast(this.billingTagsSourceAsString()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "HopDestinations": {
                return Optional.ofNullable(clazz.cast(this.hopDestinations()));
            }
            case "JobTemplate": {
                return Optional.ofNullable(clazz.cast(this.jobTemplate()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Queue": {
                return Optional.ofNullable(clazz.cast(this.queue()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "SimulateReservedQueue": {
                return Optional.ofNullable(clazz.cast(this.simulateReservedQueueAsString()));
            }
            case "StatusUpdateInterval": {
                return Optional.ofNullable(clazz.cast(this.statusUpdateIntervalAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UserMetadata": {
                return Optional.ofNullable(clazz.cast(this.userMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobRequest, T> g) {
        return obj -> g.apply((CreateJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConvertRequest.BuilderImpl
    implements Builder {
        private AccelerationSettings accelerationSettings;
        private String billingTagsSource;
        private String clientRequestToken;
        private List<HopDestination> hopDestinations = DefaultSdkAutoConstructList.getInstance();
        private String jobTemplate;
        private Integer priority;
        private String queue;
        private String role;
        private JobSettings settings;
        private String simulateReservedQueue;
        private String statusUpdateInterval;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> userMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            this.accelerationSettings(model.accelerationSettings);
            this.billingTagsSource(model.billingTagsSource);
            this.clientRequestToken(model.clientRequestToken);
            this.hopDestinations(model.hopDestinations);
            this.jobTemplate(model.jobTemplate);
            this.priority(model.priority);
            this.queue(model.queue);
            this.role(model.role);
            this.settings(model.settings);
            this.simulateReservedQueue(model.simulateReservedQueue);
            this.statusUpdateInterval(model.statusUpdateInterval);
            this.tags(model.tags);
            this.userMetadata(model.userMetadata);
        }

        public final AccelerationSettings.Builder getAccelerationSettings() {
            return this.accelerationSettings != null ? this.accelerationSettings.toBuilder() : null;
        }

        @Override
        public final Builder accelerationSettings(AccelerationSettings accelerationSettings) {
            this.accelerationSettings = accelerationSettings;
            return this;
        }

        public final void setAccelerationSettings(AccelerationSettings.BuilderImpl accelerationSettings) {
            this.accelerationSettings = accelerationSettings != null ? accelerationSettings.build() : null;
        }

        public final String getBillingTagsSource() {
            return this.billingTagsSource;
        }

        @Override
        public final Builder billingTagsSource(String billingTagsSource) {
            this.billingTagsSource = billingTagsSource;
            return this;
        }

        @Override
        public final Builder billingTagsSource(BillingTagsSource billingTagsSource) {
            this.billingTagsSource(billingTagsSource == null ? null : billingTagsSource.toString());
            return this;
        }

        public final void setBillingTagsSource(String billingTagsSource) {
            this.billingTagsSource = billingTagsSource;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final List<HopDestination.Builder> getHopDestinations() {
            List<HopDestination.Builder> result = ___listOfHopDestinationCopier.copyToBuilder(this.hopDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder hopDestinations(Collection<HopDestination> hopDestinations) {
            this.hopDestinations = ___listOfHopDestinationCopier.copy(hopDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hopDestinations(HopDestination ... hopDestinations) {
            this.hopDestinations(Arrays.asList(hopDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hopDestinations(Consumer<HopDestination.Builder> ... hopDestinations) {
            this.hopDestinations(Stream.of(hopDestinations).map(c -> (HopDestination)((HopDestination.Builder)HopDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHopDestinations(Collection<HopDestination.BuilderImpl> hopDestinations) {
            this.hopDestinations = ___listOfHopDestinationCopier.copyFromBuilder(hopDestinations);
        }

        public final String getJobTemplate() {
            return this.jobTemplate;
        }

        @Override
        public final Builder jobTemplate(String jobTemplate) {
            this.jobTemplate = jobTemplate;
            return this;
        }

        public final void setJobTemplate(String jobTemplate) {
            this.jobTemplate = jobTemplate;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getQueue() {
            return this.queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final JobSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(JobSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(JobSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final String getSimulateReservedQueue() {
            return this.simulateReservedQueue;
        }

        @Override
        public final Builder simulateReservedQueue(String simulateReservedQueue) {
            this.simulateReservedQueue = simulateReservedQueue;
            return this;
        }

        @Override
        public final Builder simulateReservedQueue(SimulateReservedQueue simulateReservedQueue) {
            this.simulateReservedQueue(simulateReservedQueue == null ? null : simulateReservedQueue.toString());
            return this;
        }

        public final void setSimulateReservedQueue(String simulateReservedQueue) {
            this.simulateReservedQueue = simulateReservedQueue;
        }

        public final String getStatusUpdateInterval() {
            return this.statusUpdateInterval;
        }

        @Override
        public final Builder statusUpdateInterval(String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
            return this;
        }

        @Override
        public final Builder statusUpdateInterval(StatusUpdateInterval statusUpdateInterval) {
            this.statusUpdateInterval(statusUpdateInterval == null ? null : statusUpdateInterval.toString());
            return this;
        }

        public final void setStatusUpdateInterval(String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        public final Map<String, String> getUserMetadata() {
            if (this.userMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.userMetadata;
        }

        @Override
        public final Builder userMetadata(Map<String, String> userMetadata) {
            this.userMetadata = ___mapOf__stringCopier.copy(userMetadata);
            return this;
        }

        public final void setUserMetadata(Map<String, String> userMetadata) {
            this.userMetadata = ___mapOf__stringCopier.copy(userMetadata);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConvertRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateJobRequest> {
        public Builder accelerationSettings(AccelerationSettings var1);

        default public Builder accelerationSettings(Consumer<AccelerationSettings.Builder> accelerationSettings) {
            return this.accelerationSettings((AccelerationSettings)((AccelerationSettings.Builder)AccelerationSettings.builder().applyMutation(accelerationSettings)).build());
        }

        public Builder billingTagsSource(String var1);

        public Builder billingTagsSource(BillingTagsSource var1);

        public Builder clientRequestToken(String var1);

        public Builder hopDestinations(Collection<HopDestination> var1);

        public Builder hopDestinations(HopDestination ... var1);

        public Builder hopDestinations(Consumer<HopDestination.Builder> ... var1);

        public Builder jobTemplate(String var1);

        public Builder priority(Integer var1);

        public Builder queue(String var1);

        public Builder role(String var1);

        public Builder settings(JobSettings var1);

        default public Builder settings(Consumer<JobSettings.Builder> settings) {
            return this.settings((JobSettings)((JobSettings.Builder)JobSettings.builder().applyMutation(settings)).build());
        }

        public Builder simulateReservedQueue(String var1);

        public Builder simulateReservedQueue(SimulateReservedQueue var1);

        public Builder statusUpdateInterval(String var1);

        public Builder statusUpdateInterval(StatusUpdateInterval var1);

        public Builder tags(Map<String, String> var1);

        public Builder userMetadata(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

