/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input frame rate is
 * identical to the output frame rate. To include timecodes in this output, set Timecode insertion
 * (VideoTimecodeInsertion) to PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the
 * service inserts timecodes in an output, by default, it uses any embedded timecodes from the input. If none are
 * present, the service will set the timecode for the first output frame to zero. To change this default behavior,
 * adjust the settings under Timecode configuration (TimecodeConfig). In the console, these settings are located under
 * Job > Job settings > Timecode configuration. Note - Timecode source under input settings (InputTimecodeSource) does
 * not affect the timecodes that are inserted in the output. Source under Job settings > Timecode configuration
 * (TimecodeSource) does.
 */
@Generated("software.amazon.awssdk:codegen")
public enum VideoTimecodeInsertion {
    DISABLED("DISABLED"),

    PIC_TIMING_SEI("PIC_TIMING_SEI"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private VideoTimecodeInsertion(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return VideoTimecodeInsertion corresponding to the value
     */
    public static VideoTimecodeInsertion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(VideoTimecodeInsertion.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link VideoTimecodeInsertion}s
     */
    public static Set<VideoTimecodeInsertion> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
