/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQueuesRequest extends MediaConvertRequest implements
        ToCopyableBuilder<ListQueuesRequest.Builder, ListQueuesRequest> {
    private static final SdkField<String> LIST_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ListBy")
            .getter(getter(ListQueuesRequest::listByAsString)).setter(setter(Builder::listBy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("listBy").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListQueuesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListQueuesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Order")
            .getter(getter(ListQueuesRequest::orderAsString)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("order").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_BY_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORDER_FIELD));

    private final String listBy;

    private final Integer maxResults;

    private final String nextToken;

    private final String order;

    private ListQueuesRequest(BuilderImpl builder) {
        super(builder);
        this.listBy = builder.listBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.order = builder.order;
    }

    /**
     * Optional. When you request a list of queues, you can choose to list them alphabetically by NAME or
     * chronologically by CREATION_DATE. If you don't specify, the service will list them by creation date.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #listBy} will
     * return {@link QueueListBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #listByAsString}.
     * </p>
     * 
     * @return Optional. When you request a list of queues, you can choose to list them alphabetically by NAME or
     *         chronologically by CREATION_DATE. If you don't specify, the service will list them by creation date.
     * @see QueueListBy
     */
    public final QueueListBy listBy() {
        return QueueListBy.fromValue(listBy);
    }

    /**
     * Optional. When you request a list of queues, you can choose to list them alphabetically by NAME or
     * chronologically by CREATION_DATE. If you don't specify, the service will list them by creation date.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #listBy} will
     * return {@link QueueListBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #listByAsString}.
     * </p>
     * 
     * @return Optional. When you request a list of queues, you can choose to list them alphabetically by NAME or
     *         chronologically by CREATION_DATE. If you don't specify, the service will list them by creation date.
     * @see QueueListBy
     */
    public final String listByAsString() {
        return listBy;
    }

    /**
     * Optional. Number of queues, up to twenty, that will be returned at one time.
     * 
     * @return Optional. Number of queues, up to twenty, that will be returned at one time.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Use this string, provided with the response to a previous request, to request the next batch of queues.
     * 
     * @return Use this string, provided with the response to a previous request, to request the next batch of queues.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING
     * order. Default varies by resource.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link Order#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or
     *         DESCENDING order. Default varies by resource.
     * @see Order
     */
    public final Order order() {
        return Order.fromValue(order);
    }

    /**
     * Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING
     * order. Default varies by resource.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link Order#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or
     *         DESCENDING order. Default varies by resource.
     * @see Order
     */
    public final String orderAsString() {
        return order;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(listByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(orderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesRequest)) {
            return false;
        }
        ListQueuesRequest other = (ListQueuesRequest) obj;
        return Objects.equals(listByAsString(), other.listByAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(orderAsString(), other.orderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListQueuesRequest").add("ListBy", listByAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("Order", orderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListBy":
            return Optional.ofNullable(clazz.cast(listByAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Order":
            return Optional.ofNullable(clazz.cast(orderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQueuesRequest, T> g) {
        return obj -> g.apply((ListQueuesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConvertRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListQueuesRequest> {
        /**
         * Optional. When you request a list of queues, you can choose to list them alphabetically by NAME or
         * chronologically by CREATION_DATE. If you don't specify, the service will list them by creation date.
         * 
         * @param listBy
         *        Optional. When you request a list of queues, you can choose to list them alphabetically by NAME or
         *        chronologically by CREATION_DATE. If you don't specify, the service will list them by creation date.
         * @see QueueListBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueListBy
         */
        Builder listBy(String listBy);

        /**
         * Optional. When you request a list of queues, you can choose to list them alphabetically by NAME or
         * chronologically by CREATION_DATE. If you don't specify, the service will list them by creation date.
         * 
         * @param listBy
         *        Optional. When you request a list of queues, you can choose to list them alphabetically by NAME or
         *        chronologically by CREATION_DATE. If you don't specify, the service will list them by creation date.
         * @see QueueListBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueListBy
         */
        Builder listBy(QueueListBy listBy);

        /**
         * Optional. Number of queues, up to twenty, that will be returned at one time.
         * 
         * @param maxResults
         *        Optional. Number of queues, up to twenty, that will be returned at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Use this string, provided with the response to a previous request, to request the next batch of queues.
         * 
         * @param nextToken
         *        Use this string, provided with the response to a previous request, to request the next batch of
         *        queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or
         * DESCENDING order. Default varies by resource.
         * 
         * @param order
         *        Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or
         *        DESCENDING order. Default varies by resource.
         * @see Order
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Order
         */
        Builder order(String order);

        /**
         * Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or
         * DESCENDING order. Default varies by resource.
         * 
         * @param order
         *        Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or
         *        DESCENDING order. Default varies by resource.
         * @see Order
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Order
         */
        Builder order(Order order);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConvertRequest.BuilderImpl implements Builder {
        private String listBy;

        private Integer maxResults;

        private String nextToken;

        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesRequest model) {
            super(model);
            listBy(model.listBy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            order(model.order);
        }

        public final String getListBy() {
            return listBy;
        }

        @Override
        public final Builder listBy(String listBy) {
            this.listBy = listBy;
            return this;
        }

        @Override
        public final Builder listBy(QueueListBy listBy) {
            this.listBy(listBy == null ? null : listBy.toString());
            return this;
        }

        public final void setListBy(String listBy) {
            this.listBy = listBy;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getOrder() {
            return order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(Order order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListQueuesRequest build() {
            return new ListQueuesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
