/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * To insert ID3 tags in your output, specify two values. Use ID3 tag (Id3) to specify the base 64 encoded string and
 * use Timecode (TimeCode) to specify the time when the tag should be inserted. To insert multiple ID3 tags in your
 * output, create multiple instances of ID3 insertion (Id3Insertion).
 */
@Generated("software.amazon.awssdk:codegen")
public final class Id3Insertion implements SdkPojo, Serializable, ToCopyableBuilder<Id3Insertion.Builder, Id3Insertion> {
    private static final SdkField<String> ID3_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id3")
            .getter(getter(Id3Insertion::id3)).setter(setter(Builder::id3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id3").build()).build();

    private static final SdkField<String> TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timecode").getter(getter(Id3Insertion::timecode)).setter(setter(Builder::timecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID3_FIELD, TIMECODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id3;

    private final String timecode;

    private Id3Insertion(BuilderImpl builder) {
        this.id3 = builder.id3;
        this.timecode = builder.timecode;
    }

    /**
     * Use ID3 tag (Id3) to provide a tag value in base64-encode format.
     * 
     * @return Use ID3 tag (Id3) to provide a tag value in base64-encode format.
     */
    public final String id3() {
        return id3;
    }

    /**
     * Provide a Timecode (TimeCode) in HH:MM:SS:FF or HH:MM:SS;FF format.
     * 
     * @return Provide a Timecode (TimeCode) in HH:MM:SS:FF or HH:MM:SS;FF format.
     */
    public final String timecode() {
        return timecode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id3());
        hashCode = 31 * hashCode + Objects.hashCode(timecode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Id3Insertion)) {
            return false;
        }
        Id3Insertion other = (Id3Insertion) obj;
        return Objects.equals(id3(), other.id3()) && Objects.equals(timecode(), other.timecode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Id3Insertion").add("Id3", id3()).add("Timecode", timecode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id3":
            return Optional.ofNullable(clazz.cast(id3()));
        case "Timecode":
            return Optional.ofNullable(clazz.cast(timecode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Id3Insertion, T> g) {
        return obj -> g.apply((Id3Insertion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Id3Insertion> {
        /**
         * Use ID3 tag (Id3) to provide a tag value in base64-encode format.
         * 
         * @param id3
         *        Use ID3 tag (Id3) to provide a tag value in base64-encode format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id3(String id3);

        /**
         * Provide a Timecode (TimeCode) in HH:MM:SS:FF or HH:MM:SS;FF format.
         * 
         * @param timecode
         *        Provide a Timecode (TimeCode) in HH:MM:SS:FF or HH:MM:SS;FF format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timecode(String timecode);
    }

    static final class BuilderImpl implements Builder {
        private String id3;

        private String timecode;

        private BuilderImpl() {
        }

        private BuilderImpl(Id3Insertion model) {
            id3(model.id3);
            timecode(model.timecode);
        }

        public final String getId3() {
            return id3;
        }

        @Override
        public final Builder id3(String id3) {
            this.id3 = id3;
            return this;
        }

        public final void setId3(String id3) {
            this.id3 = id3;
        }

        public final String getTimecode() {
            return timecode;
        }

        @Override
        public final Builder timecode(String timecode) {
            this.timecode = timecode;
            return this;
        }

        public final void setTimecode(String timecode) {
            this.timecode = timecode;
        }

        @Override
        public Id3Insertion build() {
            return new Id3Insertion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
