/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Only use this setting when you change the default value, Auto (AUTO), for the setting H264AdaptiveQuantization. When
 * you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job
 * specification, MediaConvert automatically applies the best types of quantization for your video content. When you set
 * H264AdaptiveQuantization to a value other than AUTO, the default value for H264SpatialAdaptiveQuantization is Enabled
 * (ENABLED). Keep this default value to adjust quantization within each frame based on spatial variation of content
 * complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with
 * no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For
 * example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits.
 * Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take
 * into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a
 * part of the screen with a lot of complex texture, you might choose to set H264SpatialAdaptiveQuantization to Disabled
 * (DISABLED). Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization
 * (H264AdaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set
 * it to Low. For content with a wider variety of textures, set it to High or Higher. To manually enable or disable
 * H264SpatialAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than
 * AUTO.
 */
@Generated("software.amazon.awssdk:codegen")
public enum H264SpatialAdaptiveQuantization {
    DISABLED("DISABLED"),

    ENABLED("ENABLED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private H264SpatialAdaptiveQuantization(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return H264SpatialAdaptiveQuantization corresponding to the value
     */
    public static H264SpatialAdaptiveQuantization fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(H264SpatialAdaptiveQuantization.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link H264SpatialAdaptiveQuantization}s
     */
    public static Set<H264SpatialAdaptiveQuantization> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
