/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive
 * output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first
 * (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top
 * (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as
 * the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output.
 * Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the
 * same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field
 * first, depending on which of the Follow options you choose.
 */
@Generated("software.amazon.awssdk:codegen")
public enum H264InterlaceMode {
    PROGRESSIVE("PROGRESSIVE"),

    TOP_FIELD("TOP_FIELD"),

    BOTTOM_FIELD("BOTTOM_FIELD"),

    FOLLOW_TOP_FIELD("FOLLOW_TOP_FIELD"),

    FOLLOW_BOTTOM_FIELD("FOLLOW_BOTTOM_FIELD"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private H264InterlaceMode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return H264InterlaceMode corresponding to the value
     */
    public static H264InterlaceMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(H264InterlaceMode.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link H264InterlaceMode}s
     */
    public static Set<H264InterlaceMode> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
