/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * If your input captions are SCC, SMI, SRT, STL, TTML, or IMSC 1.1 in an xml file, specify the URI of the input caption
 * source file. If your caption source is IMSC in an IMF package, use TrackSourceSettings instead of FileSoureSettings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileSourceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<FileSourceSettings.Builder, FileSourceSettings> {
    private static final SdkField<String> CONVERT608_TO708_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Convert608To708").getter(getter(FileSourceSettings::convert608To708AsString))
            .setter(setter(Builder::convert608To708))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("convert608To708").build()).build();

    private static final SdkField<CaptionSourceFramerate> FRAMERATE_FIELD = SdkField
            .<CaptionSourceFramerate> builder(MarshallingType.SDK_POJO).memberName("Framerate")
            .getter(getter(FileSourceSettings::framerate)).setter(setter(Builder::framerate))
            .constructor(CaptionSourceFramerate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerate").build()).build();

    private static final SdkField<String> SOURCE_FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceFile").getter(getter(FileSourceSettings::sourceFile)).setter(setter(Builder::sourceFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFile").build()).build();

    private static final SdkField<Integer> TIME_DELTA_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeDelta").getter(getter(FileSourceSettings::timeDelta)).setter(setter(Builder::timeDelta))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeDelta").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERT608_TO708_FIELD,
            FRAMERATE_FIELD, SOURCE_FILE_FIELD, TIME_DELTA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String convert608To708;

    private final CaptionSourceFramerate framerate;

    private final String sourceFile;

    private final Integer timeDelta;

    private FileSourceSettings(BuilderImpl builder) {
        this.convert608To708 = builder.convert608To708;
        this.framerate = builder.framerate;
        this.sourceFile = builder.sourceFile;
        this.timeDelta = builder.timeDelta;
    }

    /**
     * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose
     * Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through using
     * the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #convert608To708}
     * will return {@link FileSourceConvert608To708#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #convert608To708AsString}.
     * </p>
     * 
     * @return Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you
     *         choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data
     *         through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data
     *         into 708.
     * @see FileSourceConvert608To708
     */
    public final FileSourceConvert608To708 convert608To708() {
        return FileSourceConvert608To708.fromValue(convert608To708);
    }

    /**
     * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose
     * Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through using
     * the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #convert608To708}
     * will return {@link FileSourceConvert608To708#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #convert608To708AsString}.
     * </p>
     * 
     * @return Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you
     *         choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data
     *         through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data
     *         into 708.
     * @see FileSourceConvert608To708
     */
    public final String convert608To708AsString() {
        return convert608To708;
    }

    /**
     * Ignore this setting unless your input captions format is SCC. To have the service compensate for differing frame
     * rates between your input captions and input video, specify the frame rate of the captions file. Specify this
     * value as a fraction, using the settings Framerate numerator (framerateNumerator) and Framerate denominator
     * (framerateDenominator). For example, you might specify 24 / 1 for 24 fps, 25 / 1 for 25 fps, 24000 / 1001 for
     * 23.976 fps, or 30000 / 1001 for 29.97 fps.
     * 
     * @return Ignore this setting unless your input captions format is SCC. To have the service compensate for
     *         differing frame rates between your input captions and input video, specify the frame rate of the captions
     *         file. Specify this value as a fraction, using the settings Framerate numerator (framerateNumerator) and
     *         Framerate denominator (framerateDenominator). For example, you might specify 24 / 1 for 24 fps, 25 / 1
     *         for 25 fps, 24000 / 1001 for 23.976 fps, or 30000 / 1001 for 29.97 fps.
     */
    public final CaptionSourceFramerate framerate() {
        return framerate;
    }

    /**
     * External caption file used for loading captions. Accepted file extensions are 'scc', 'ttml', 'dfxp', 'stl',
     * 'srt', 'xml', and 'smi'.
     * 
     * @return External caption file used for loading captions. Accepted file extensions are 'scc', 'ttml', 'dfxp',
     *         'stl', 'srt', 'xml', and 'smi'.
     */
    public final String sourceFile() {
        return sourceFile;
    }

    /**
     * Specifies a time delta in seconds to offset the captions from the source file.
     * 
     * @return Specifies a time delta in seconds to offset the captions from the source file.
     */
    public final Integer timeDelta() {
        return timeDelta;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(convert608To708AsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerate());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFile());
        hashCode = 31 * hashCode + Objects.hashCode(timeDelta());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSourceSettings)) {
            return false;
        }
        FileSourceSettings other = (FileSourceSettings) obj;
        return Objects.equals(convert608To708AsString(), other.convert608To708AsString())
                && Objects.equals(framerate(), other.framerate()) && Objects.equals(sourceFile(), other.sourceFile())
                && Objects.equals(timeDelta(), other.timeDelta());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileSourceSettings").add("Convert608To708", convert608To708AsString())
                .add("Framerate", framerate()).add("SourceFile", sourceFile()).add("TimeDelta", timeDelta()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Convert608To708":
            return Optional.ofNullable(clazz.cast(convert608To708AsString()));
        case "Framerate":
            return Optional.ofNullable(clazz.cast(framerate()));
        case "SourceFile":
            return Optional.ofNullable(clazz.cast(sourceFile()));
        case "TimeDelta":
            return Optional.ofNullable(clazz.cast(timeDelta()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileSourceSettings, T> g) {
        return obj -> g.apply((FileSourceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileSourceSettings> {
        /**
         * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose
         * Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through
         * using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
         * 
         * @param convert608To708
         *        Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you
         *        choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608
         *        data through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the
         *        608 data into 708.
         * @see FileSourceConvert608To708
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSourceConvert608To708
         */
        Builder convert608To708(String convert608To708);

        /**
         * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose
         * Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through
         * using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
         * 
         * @param convert608To708
         *        Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you
         *        choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608
         *        data through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the
         *        608 data into 708.
         * @see FileSourceConvert608To708
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSourceConvert608To708
         */
        Builder convert608To708(FileSourceConvert608To708 convert608To708);

        /**
         * Ignore this setting unless your input captions format is SCC. To have the service compensate for differing
         * frame rates between your input captions and input video, specify the frame rate of the captions file. Specify
         * this value as a fraction, using the settings Framerate numerator (framerateNumerator) and Framerate
         * denominator (framerateDenominator). For example, you might specify 24 / 1 for 24 fps, 25 / 1 for 25 fps,
         * 24000 / 1001 for 23.976 fps, or 30000 / 1001 for 29.97 fps.
         * 
         * @param framerate
         *        Ignore this setting unless your input captions format is SCC. To have the service compensate for
         *        differing frame rates between your input captions and input video, specify the frame rate of the
         *        captions file. Specify this value as a fraction, using the settings Framerate numerator
         *        (framerateNumerator) and Framerate denominator (framerateDenominator). For example, you might specify
         *        24 / 1 for 24 fps, 25 / 1 for 25 fps, 24000 / 1001 for 23.976 fps, or 30000 / 1001 for 29.97 fps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerate(CaptionSourceFramerate framerate);

        /**
         * Ignore this setting unless your input captions format is SCC. To have the service compensate for differing
         * frame rates between your input captions and input video, specify the frame rate of the captions file. Specify
         * this value as a fraction, using the settings Framerate numerator (framerateNumerator) and Framerate
         * denominator (framerateDenominator). For example, you might specify 24 / 1 for 24 fps, 25 / 1 for 25 fps,
         * 24000 / 1001 for 23.976 fps, or 30000 / 1001 for 29.97 fps. This is a convenience that creates an instance of
         * the {@link CaptionSourceFramerate.Builder} avoiding the need to create one manually via
         * {@link CaptionSourceFramerate#builder()}.
         *
         * When the {@link Consumer} completes, {@link CaptionSourceFramerate.Builder#build()} is called immediately and
         * its result is passed to {@link #framerate(CaptionSourceFramerate)}.
         * 
         * @param framerate
         *        a consumer that will call methods on {@link CaptionSourceFramerate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #framerate(CaptionSourceFramerate)
         */
        default Builder framerate(Consumer<CaptionSourceFramerate.Builder> framerate) {
            return framerate(CaptionSourceFramerate.builder().applyMutation(framerate).build());
        }

        /**
         * External caption file used for loading captions. Accepted file extensions are 'scc', 'ttml', 'dfxp', 'stl',
         * 'srt', 'xml', and 'smi'.
         * 
         * @param sourceFile
         *        External caption file used for loading captions. Accepted file extensions are 'scc', 'ttml', 'dfxp',
         *        'stl', 'srt', 'xml', and 'smi'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFile(String sourceFile);

        /**
         * Specifies a time delta in seconds to offset the captions from the source file.
         * 
         * @param timeDelta
         *        Specifies a time delta in seconds to offset the captions from the source file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeDelta(Integer timeDelta);
    }

    static final class BuilderImpl implements Builder {
        private String convert608To708;

        private CaptionSourceFramerate framerate;

        private String sourceFile;

        private Integer timeDelta;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSourceSettings model) {
            convert608To708(model.convert608To708);
            framerate(model.framerate);
            sourceFile(model.sourceFile);
            timeDelta(model.timeDelta);
        }

        public final String getConvert608To708() {
            return convert608To708;
        }

        @Override
        public final Builder convert608To708(String convert608To708) {
            this.convert608To708 = convert608To708;
            return this;
        }

        @Override
        public final Builder convert608To708(FileSourceConvert608To708 convert608To708) {
            this.convert608To708(convert608To708 == null ? null : convert608To708.toString());
            return this;
        }

        public final void setConvert608To708(String convert608To708) {
            this.convert608To708 = convert608To708;
        }

        public final CaptionSourceFramerate.Builder getFramerate() {
            return framerate != null ? framerate.toBuilder() : null;
        }

        @Override
        public final Builder framerate(CaptionSourceFramerate framerate) {
            this.framerate = framerate;
            return this;
        }

        public final void setFramerate(CaptionSourceFramerate.BuilderImpl framerate) {
            this.framerate = framerate != null ? framerate.build() : null;
        }

        public final String getSourceFile() {
            return sourceFile;
        }

        @Override
        public final Builder sourceFile(String sourceFile) {
            this.sourceFile = sourceFile;
            return this;
        }

        public final void setSourceFile(String sourceFile) {
            this.sourceFile = sourceFile;
        }

        public final Integer getTimeDelta() {
            return timeDelta;
        }

        @Override
        public final Builder timeDelta(Integer timeDelta) {
            this.timeDelta = timeDelta;
            return this;
        }

        public final void setTimeDelta(Integer timeDelta) {
            this.timeDelta = timeDelta;
        }

        @Override
        public FileSourceSettings build() {
            return new FileSourceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
