/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for deinterlacer
 */
@Generated("software.amazon.awssdk:codegen")
public final class Deinterlacer implements SdkPojo, Serializable, ToCopyableBuilder<Deinterlacer.Builder, Deinterlacer> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Algorithm").getter(getter(Deinterlacer::algorithmAsString)).setter(setter(Builder::algorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithm").build()).build();

    private static final SdkField<String> CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Control")
            .getter(getter(Deinterlacer::controlAsString)).setter(setter(Builder::control))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(Deinterlacer::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD,
            CONTROL_FIELD, MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String algorithm;

    private final String control;

    private final String mode;

    private Deinterlacer(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.control = builder.control;
        this.mode = builder.mode;
    }

    /**
     * Only applies when you set Deinterlacer (DeinterlaceMode) to Deinterlace (DEINTERLACE) or Adaptive (ADAPTIVE).
     * Motion adaptive interpolate (INTERPOLATE) produces sharper pictures, while blend (BLEND) produces smoother
     * motion. Use (INTERPOLATE_TICKER) OR (BLEND_TICKER) if your source file includes a ticker, such as a scrolling
     * headline at the bottom of the frame.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithm} will
     * return {@link DeinterlaceAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #algorithmAsString}.
     * </p>
     * 
     * @return Only applies when you set Deinterlacer (DeinterlaceMode) to Deinterlace (DEINTERLACE) or Adaptive
     *         (ADAPTIVE). Motion adaptive interpolate (INTERPOLATE) produces sharper pictures, while blend (BLEND)
     *         produces smoother motion. Use (INTERPOLATE_TICKER) OR (BLEND_TICKER) if your source file includes a
     *         ticker, such as a scrolling headline at the bottom of the frame.
     * @see DeinterlaceAlgorithm
     */
    public final DeinterlaceAlgorithm algorithm() {
        return DeinterlaceAlgorithm.fromValue(algorithm);
    }

    /**
     * Only applies when you set Deinterlacer (DeinterlaceMode) to Deinterlace (DEINTERLACE) or Adaptive (ADAPTIVE).
     * Motion adaptive interpolate (INTERPOLATE) produces sharper pictures, while blend (BLEND) produces smoother
     * motion. Use (INTERPOLATE_TICKER) OR (BLEND_TICKER) if your source file includes a ticker, such as a scrolling
     * headline at the bottom of the frame.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithm} will
     * return {@link DeinterlaceAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #algorithmAsString}.
     * </p>
     * 
     * @return Only applies when you set Deinterlacer (DeinterlaceMode) to Deinterlace (DEINTERLACE) or Adaptive
     *         (ADAPTIVE). Motion adaptive interpolate (INTERPOLATE) produces sharper pictures, while blend (BLEND)
     *         produces smoother motion. Use (INTERPOLATE_TICKER) OR (BLEND_TICKER) if your source file includes a
     *         ticker, such as a scrolling headline at the bottom of the frame.
     * @see DeinterlaceAlgorithm
     */
    public final String algorithmAsString() {
        return algorithm;
    }

    /**
     * - When set to NORMAL (default), the deinterlacer does not convert frames that are tagged in metadata as
     * progressive. It will only convert those that are tagged as some other type. - When set to FORCE_ALL_FRAMES, the
     * deinterlacer converts every frame to progressive - even those that are already tagged as progressive. Turn Force
     * mode on only if there is a good chance that the metadata has tagged frames as progressive when they are not
     * progressive. Do not turn on otherwise; processing frames that are already progressive into progressive will
     * probably result in lower quality video.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #control} will
     * return {@link DeinterlacerControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #controlAsString}.
     * </p>
     * 
     * @return - When set to NORMAL (default), the deinterlacer does not convert frames that are tagged in metadata as
     *         progressive. It will only convert those that are tagged as some other type. - When set to
     *         FORCE_ALL_FRAMES, the deinterlacer converts every frame to progressive - even those that are already
     *         tagged as progressive. Turn Force mode on only if there is a good chance that the metadata has tagged
     *         frames as progressive when they are not progressive. Do not turn on otherwise; processing frames that are
     *         already progressive into progressive will probably result in lower quality video.
     * @see DeinterlacerControl
     */
    public final DeinterlacerControl control() {
        return DeinterlacerControl.fromValue(control);
    }

    /**
     * - When set to NORMAL (default), the deinterlacer does not convert frames that are tagged in metadata as
     * progressive. It will only convert those that are tagged as some other type. - When set to FORCE_ALL_FRAMES, the
     * deinterlacer converts every frame to progressive - even those that are already tagged as progressive. Turn Force
     * mode on only if there is a good chance that the metadata has tagged frames as progressive when they are not
     * progressive. Do not turn on otherwise; processing frames that are already progressive into progressive will
     * probably result in lower quality video.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #control} will
     * return {@link DeinterlacerControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #controlAsString}.
     * </p>
     * 
     * @return - When set to NORMAL (default), the deinterlacer does not convert frames that are tagged in metadata as
     *         progressive. It will only convert those that are tagged as some other type. - When set to
     *         FORCE_ALL_FRAMES, the deinterlacer converts every frame to progressive - even those that are already
     *         tagged as progressive. Turn Force mode on only if there is a good chance that the metadata has tagged
     *         frames as progressive when they are not progressive. Do not turn on otherwise; processing frames that are
     *         already progressive into progressive will probably result in lower quality video.
     * @see DeinterlacerControl
     */
    public final String controlAsString() {
        return control;
    }

    /**
     * Use Deinterlacer (DeinterlaceMode) to choose how the service will do deinterlacing. Default is Deinterlace. -
     * Deinterlace converts interlaced to progressive. - Inverse telecine converts Hard Telecine 29.97i to progressive
     * 23.976p. - Adaptive auto-detects and converts to progressive.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link DeinterlacerMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Use Deinterlacer (DeinterlaceMode) to choose how the service will do deinterlacing. Default is
     *         Deinterlace. - Deinterlace converts interlaced to progressive. - Inverse telecine converts Hard Telecine
     *         29.97i to progressive 23.976p. - Adaptive auto-detects and converts to progressive.
     * @see DeinterlacerMode
     */
    public final DeinterlacerMode mode() {
        return DeinterlacerMode.fromValue(mode);
    }

    /**
     * Use Deinterlacer (DeinterlaceMode) to choose how the service will do deinterlacing. Default is Deinterlace. -
     * Deinterlace converts interlaced to progressive. - Inverse telecine converts Hard Telecine 29.97i to progressive
     * 23.976p. - Adaptive auto-detects and converts to progressive.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link DeinterlacerMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Use Deinterlacer (DeinterlaceMode) to choose how the service will do deinterlacing. Default is
     *         Deinterlace. - Deinterlace converts interlaced to progressive. - Inverse telecine converts Hard Telecine
     *         29.97i to progressive 23.976p. - Adaptive auto-detects and converts to progressive.
     * @see DeinterlacerMode
     */
    public final String modeAsString() {
        return mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(controlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deinterlacer)) {
            return false;
        }
        Deinterlacer other = (Deinterlacer) obj;
        return Objects.equals(algorithmAsString(), other.algorithmAsString())
                && Objects.equals(controlAsString(), other.controlAsString())
                && Objects.equals(modeAsString(), other.modeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Deinterlacer").add("Algorithm", algorithmAsString()).add("Control", controlAsString())
                .add("Mode", modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Algorithm":
            return Optional.ofNullable(clazz.cast(algorithmAsString()));
        case "Control":
            return Optional.ofNullable(clazz.cast(controlAsString()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Deinterlacer, T> g) {
        return obj -> g.apply((Deinterlacer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Deinterlacer> {
        /**
         * Only applies when you set Deinterlacer (DeinterlaceMode) to Deinterlace (DEINTERLACE) or Adaptive (ADAPTIVE).
         * Motion adaptive interpolate (INTERPOLATE) produces sharper pictures, while blend (BLEND) produces smoother
         * motion. Use (INTERPOLATE_TICKER) OR (BLEND_TICKER) if your source file includes a ticker, such as a scrolling
         * headline at the bottom of the frame.
         * 
         * @param algorithm
         *        Only applies when you set Deinterlacer (DeinterlaceMode) to Deinterlace (DEINTERLACE) or Adaptive
         *        (ADAPTIVE). Motion adaptive interpolate (INTERPOLATE) produces sharper pictures, while blend (BLEND)
         *        produces smoother motion. Use (INTERPOLATE_TICKER) OR (BLEND_TICKER) if your source file includes a
         *        ticker, such as a scrolling headline at the bottom of the frame.
         * @see DeinterlaceAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeinterlaceAlgorithm
         */
        Builder algorithm(String algorithm);

        /**
         * Only applies when you set Deinterlacer (DeinterlaceMode) to Deinterlace (DEINTERLACE) or Adaptive (ADAPTIVE).
         * Motion adaptive interpolate (INTERPOLATE) produces sharper pictures, while blend (BLEND) produces smoother
         * motion. Use (INTERPOLATE_TICKER) OR (BLEND_TICKER) if your source file includes a ticker, such as a scrolling
         * headline at the bottom of the frame.
         * 
         * @param algorithm
         *        Only applies when you set Deinterlacer (DeinterlaceMode) to Deinterlace (DEINTERLACE) or Adaptive
         *        (ADAPTIVE). Motion adaptive interpolate (INTERPOLATE) produces sharper pictures, while blend (BLEND)
         *        produces smoother motion. Use (INTERPOLATE_TICKER) OR (BLEND_TICKER) if your source file includes a
         *        ticker, such as a scrolling headline at the bottom of the frame.
         * @see DeinterlaceAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeinterlaceAlgorithm
         */
        Builder algorithm(DeinterlaceAlgorithm algorithm);

        /**
         * - When set to NORMAL (default), the deinterlacer does not convert frames that are tagged in metadata as
         * progressive. It will only convert those that are tagged as some other type. - When set to FORCE_ALL_FRAMES,
         * the deinterlacer converts every frame to progressive - even those that are already tagged as progressive.
         * Turn Force mode on only if there is a good chance that the metadata has tagged frames as progressive when
         * they are not progressive. Do not turn on otherwise; processing frames that are already progressive into
         * progressive will probably result in lower quality video.
         * 
         * @param control
         *        - When set to NORMAL (default), the deinterlacer does not convert frames that are tagged in metadata
         *        as progressive. It will only convert those that are tagged as some other type. - When set to
         *        FORCE_ALL_FRAMES, the deinterlacer converts every frame to progressive - even those that are already
         *        tagged as progressive. Turn Force mode on only if there is a good chance that the metadata has tagged
         *        frames as progressive when they are not progressive. Do not turn on otherwise; processing frames that
         *        are already progressive into progressive will probably result in lower quality video.
         * @see DeinterlacerControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeinterlacerControl
         */
        Builder control(String control);

        /**
         * - When set to NORMAL (default), the deinterlacer does not convert frames that are tagged in metadata as
         * progressive. It will only convert those that are tagged as some other type. - When set to FORCE_ALL_FRAMES,
         * the deinterlacer converts every frame to progressive - even those that are already tagged as progressive.
         * Turn Force mode on only if there is a good chance that the metadata has tagged frames as progressive when
         * they are not progressive. Do not turn on otherwise; processing frames that are already progressive into
         * progressive will probably result in lower quality video.
         * 
         * @param control
         *        - When set to NORMAL (default), the deinterlacer does not convert frames that are tagged in metadata
         *        as progressive. It will only convert those that are tagged as some other type. - When set to
         *        FORCE_ALL_FRAMES, the deinterlacer converts every frame to progressive - even those that are already
         *        tagged as progressive. Turn Force mode on only if there is a good chance that the metadata has tagged
         *        frames as progressive when they are not progressive. Do not turn on otherwise; processing frames that
         *        are already progressive into progressive will probably result in lower quality video.
         * @see DeinterlacerControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeinterlacerControl
         */
        Builder control(DeinterlacerControl control);

        /**
         * Use Deinterlacer (DeinterlaceMode) to choose how the service will do deinterlacing. Default is Deinterlace. -
         * Deinterlace converts interlaced to progressive. - Inverse telecine converts Hard Telecine 29.97i to
         * progressive 23.976p. - Adaptive auto-detects and converts to progressive.
         * 
         * @param mode
         *        Use Deinterlacer (DeinterlaceMode) to choose how the service will do deinterlacing. Default is
         *        Deinterlace. - Deinterlace converts interlaced to progressive. - Inverse telecine converts Hard
         *        Telecine 29.97i to progressive 23.976p. - Adaptive auto-detects and converts to progressive.
         * @see DeinterlacerMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeinterlacerMode
         */
        Builder mode(String mode);

        /**
         * Use Deinterlacer (DeinterlaceMode) to choose how the service will do deinterlacing. Default is Deinterlace. -
         * Deinterlace converts interlaced to progressive. - Inverse telecine converts Hard Telecine 29.97i to
         * progressive 23.976p. - Adaptive auto-detects and converts to progressive.
         * 
         * @param mode
         *        Use Deinterlacer (DeinterlaceMode) to choose how the service will do deinterlacing. Default is
         *        Deinterlace. - Deinterlace converts interlaced to progressive. - Inverse telecine converts Hard
         *        Telecine 29.97i to progressive 23.976p. - Adaptive auto-detects and converts to progressive.
         * @see DeinterlacerMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeinterlacerMode
         */
        Builder mode(DeinterlacerMode mode);
    }

    static final class BuilderImpl implements Builder {
        private String algorithm;

        private String control;

        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(Deinterlacer model) {
            algorithm(model.algorithm);
            control(model.control);
            mode(model.mode);
        }

        public final String getAlgorithm() {
            return algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(DeinterlaceAlgorithm algorithm) {
            this.algorithm(algorithm == null ? null : algorithm.toString());
            return this;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public final String getControl() {
            return control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        @Override
        public final Builder control(DeinterlacerControl control) {
            this.control(control == null ? null : control.toString());
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        public final String getMode() {
            return mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(DeinterlacerMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public Deinterlacer build() {
            return new Deinterlacer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
