/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for MP4 segments in CMAF
 */
@Generated("software.amazon.awssdk:codegen")
public final class CmfcSettings implements SdkPojo, Serializable, ToCopyableBuilder<CmfcSettings.Builder, CmfcSettings> {
    private static final SdkField<String> AUDIO_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioDuration").getter(getter(CmfcSettings::audioDurationAsString))
            .setter(setter(Builder::audioDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDuration").build()).build();

    private static final SdkField<String> I_FRAME_ONLY_MANIFEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IFrameOnlyManifest").getter(getter(CmfcSettings::iFrameOnlyManifestAsString))
            .setter(setter(Builder::iFrameOnlyManifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iFrameOnlyManifest").build())
            .build();

    private static final SdkField<String> SCTE35_ESAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Scte35Esam").getter(getter(CmfcSettings::scte35EsamAsString)).setter(setter(Builder::scte35Esam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Esam").build()).build();

    private static final SdkField<String> SCTE35_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Scte35Source").getter(getter(CmfcSettings::scte35SourceAsString)).setter(setter(Builder::scte35Source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_DURATION_FIELD,
            I_FRAME_ONLY_MANIFEST_FIELD, SCTE35_ESAM_FIELD, SCTE35_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String audioDuration;

    private final String iFrameOnlyManifest;

    private final String scte35Esam;

    private final String scte35Source;

    private CmfcSettings(BuilderImpl builder) {
        this.audioDuration = builder.audioDuration;
        this.iFrameOnlyManifest = builder.iFrameOnlyManifest;
        this.scte35Esam = builder.scte35Esam;
        this.scte35Source = builder.scte35Source;
    }

    /**
     * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
     * sensitive to very small duration differences between video and audio. For this situation, choose Match video
     * duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration
     * (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams with
     * silence or trims them to ensure that the total duration of each audio stream is at least as long as the total
     * duration of the video stream. After padding or trimming, the audio stream duration is no more than one frame
     * longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the last segment
     * of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file. When you keep the
     * default value, any minor discrepancies between audio and video duration will depend on your output audio codec.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioDuration}
     * will return {@link CmfcAudioDuration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #audioDurationAsString}.
     * </p>
     * 
     * @return Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
     *         sensitive to very small duration differences between video and audio. For this situation, choose Match
     *         video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration
     *         (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio
     *         streams with silence or trims them to ensure that the total duration of each audio stream is at least as
     *         long as the total duration of the video stream. After padding or trimming, the audio stream duration is
     *         no more than one frame longer than the video stream. MediaConvert applies audio padding or trimming only
     *         to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds padding only to
     *         the end of the file. When you keep the default value, any minor discrepancies between audio and video
     *         duration will depend on your output audio codec.
     * @see CmfcAudioDuration
     */
    public final CmfcAudioDuration audioDuration() {
        return CmfcAudioDuration.fromValue(audioDuration);
    }

    /**
     * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
     * sensitive to very small duration differences between video and audio. For this situation, choose Match video
     * duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration
     * (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams with
     * silence or trims them to ensure that the total duration of each audio stream is at least as long as the total
     * duration of the video stream. After padding or trimming, the audio stream duration is no more than one frame
     * longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the last segment
     * of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file. When you keep the
     * default value, any minor discrepancies between audio and video duration will depend on your output audio codec.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioDuration}
     * will return {@link CmfcAudioDuration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #audioDurationAsString}.
     * </p>
     * 
     * @return Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
     *         sensitive to very small duration differences between video and audio. For this situation, choose Match
     *         video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration
     *         (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio
     *         streams with silence or trims them to ensure that the total duration of each audio stream is at least as
     *         long as the total duration of the video stream. After padding or trimming, the audio stream duration is
     *         no more than one frame longer than the video stream. MediaConvert applies audio padding or trimming only
     *         to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds padding only to
     *         the end of the file. When you keep the default value, any minor discrepancies between audio and video
     *         duration will depend on your output audio codec.
     * @see CmfcAudioDuration
     */
    public final String audioDurationAsString() {
        return audioDuration;
    }

    /**
     * Choose Include (INCLUDE) to have MediaConvert generate an HLS child manifest that lists only the I-frames for
     * this rendition, in addition to your regular manifest for this rendition. You might use this manifest as part of a
     * workflow that creates preview functions for your video. MediaConvert adds both the I-frame only child manifest
     * and the regular child manifest to the parent manifest. When you don't need the I-frame only child manifest, keep
     * the default value Exclude (EXCLUDE).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #iFrameOnlyManifest} will return {@link CmfcIFrameOnlyManifest#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #iFrameOnlyManifestAsString}.
     * </p>
     * 
     * @return Choose Include (INCLUDE) to have MediaConvert generate an HLS child manifest that lists only the I-frames
     *         for this rendition, in addition to your regular manifest for this rendition. You might use this manifest
     *         as part of a workflow that creates preview functions for your video. MediaConvert adds both the I-frame
     *         only child manifest and the regular child manifest to the parent manifest. When you don't need the
     *         I-frame only child manifest, keep the default value Exclude (EXCLUDE).
     * @see CmfcIFrameOnlyManifest
     */
    public final CmfcIFrameOnlyManifest iFrameOnlyManifest() {
        return CmfcIFrameOnlyManifest.fromValue(iFrameOnlyManifest);
    }

    /**
     * Choose Include (INCLUDE) to have MediaConvert generate an HLS child manifest that lists only the I-frames for
     * this rendition, in addition to your regular manifest for this rendition. You might use this manifest as part of a
     * workflow that creates preview functions for your video. MediaConvert adds both the I-frame only child manifest
     * and the regular child manifest to the parent manifest. When you don't need the I-frame only child manifest, keep
     * the default value Exclude (EXCLUDE).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #iFrameOnlyManifest} will return {@link CmfcIFrameOnlyManifest#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #iFrameOnlyManifestAsString}.
     * </p>
     * 
     * @return Choose Include (INCLUDE) to have MediaConvert generate an HLS child manifest that lists only the I-frames
     *         for this rendition, in addition to your regular manifest for this rendition. You might use this manifest
     *         as part of a workflow that creates preview functions for your video. MediaConvert adds both the I-frame
     *         only child manifest and the regular child manifest to the parent manifest. When you don't need the
     *         I-frame only child manifest, keep the default value Exclude (EXCLUDE).
     * @see CmfcIFrameOnlyManifest
     */
    public final String iFrameOnlyManifestAsString() {
        return iFrameOnlyManifest;
    }

    /**
     * Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in this
     * output at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC
     * XML (sccXml).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Esam} will
     * return {@link CmfcScte35Esam#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scte35EsamAsString}.
     * </p>
     * 
     * @return Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in
     *         this output at the insertion points that you specify in an ESAM XML document. Provide the document in the
     *         setting SCC XML (sccXml).
     * @see CmfcScte35Esam
     */
    public final CmfcScte35Esam scte35Esam() {
        return CmfcScte35Esam.fromValue(scte35Esam);
    }

    /**
     * Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in this
     * output at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC
     * XML (sccXml).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Esam} will
     * return {@link CmfcScte35Esam#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scte35EsamAsString}.
     * </p>
     * 
     * @return Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in
     *         this output at the insertion points that you specify in an ESAM XML document. Provide the document in the
     *         setting SCC XML (sccXml).
     * @see CmfcScte35Esam
     */
    public final String scte35EsamAsString() {
        return scte35Esam;
    }

    /**
     * Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough (PASSTHROUGH) if
     * you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don't
     * want those SCTE-35 markers in this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Source} will
     * return {@link CmfcScte35Source#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scte35SourceAsString}.
     * </p>
     * 
     * @return Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
     *         (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose
     *         None (NONE) if you don't want those SCTE-35 markers in this output.
     * @see CmfcScte35Source
     */
    public final CmfcScte35Source scte35Source() {
        return CmfcScte35Source.fromValue(scte35Source);
    }

    /**
     * Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough (PASSTHROUGH) if
     * you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don't
     * want those SCTE-35 markers in this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Source} will
     * return {@link CmfcScte35Source#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scte35SourceAsString}.
     * </p>
     * 
     * @return Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
     *         (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose
     *         None (NONE) if you don't want those SCTE-35 markers in this output.
     * @see CmfcScte35Source
     */
    public final String scte35SourceAsString() {
        return scte35Source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iFrameOnlyManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scte35EsamAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scte35SourceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmfcSettings)) {
            return false;
        }
        CmfcSettings other = (CmfcSettings) obj;
        return Objects.equals(audioDurationAsString(), other.audioDurationAsString())
                && Objects.equals(iFrameOnlyManifestAsString(), other.iFrameOnlyManifestAsString())
                && Objects.equals(scte35EsamAsString(), other.scte35EsamAsString())
                && Objects.equals(scte35SourceAsString(), other.scte35SourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CmfcSettings").add("AudioDuration", audioDurationAsString())
                .add("IFrameOnlyManifest", iFrameOnlyManifestAsString()).add("Scte35Esam", scte35EsamAsString())
                .add("Scte35Source", scte35SourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioDuration":
            return Optional.ofNullable(clazz.cast(audioDurationAsString()));
        case "IFrameOnlyManifest":
            return Optional.ofNullable(clazz.cast(iFrameOnlyManifestAsString()));
        case "Scte35Esam":
            return Optional.ofNullable(clazz.cast(scte35EsamAsString()));
        case "Scte35Source":
            return Optional.ofNullable(clazz.cast(scte35SourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CmfcSettings, T> g) {
        return obj -> g.apply((CmfcSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CmfcSettings> {
        /**
         * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
         * sensitive to very small duration differences between video and audio. For this situation, choose Match video
         * duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration
         * (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams
         * with silence or trims them to ensure that the total duration of each audio stream is at least as long as the
         * total duration of the video stream. After padding or trimming, the audio stream duration is no more than one
         * frame longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the
         * last segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file.
         * When you keep the default value, any minor discrepancies between audio and video duration will depend on your
         * output audio codec.
         * 
         * @param audioDuration
         *        Specify this setting only when your output will be consumed by a downstream repackaging workflow that
         *        is sensitive to very small duration differences between video and audio. For this situation, choose
         *        Match video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec
         *        duration (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output
         *        audio streams with silence or trims them to ensure that the total duration of each audio stream is at
         *        least as long as the total duration of the video stream. After padding or trimming, the audio stream
         *        duration is no more than one frame longer than the video stream. MediaConvert applies audio padding or
         *        trimming only to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds
         *        padding only to the end of the file. When you keep the default value, any minor discrepancies between
         *        audio and video duration will depend on your output audio codec.
         * @see CmfcAudioDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmfcAudioDuration
         */
        Builder audioDuration(String audioDuration);

        /**
         * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
         * sensitive to very small duration differences between video and audio. For this situation, choose Match video
         * duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration
         * (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams
         * with silence or trims them to ensure that the total duration of each audio stream is at least as long as the
         * total duration of the video stream. After padding or trimming, the audio stream duration is no more than one
         * frame longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the
         * last segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file.
         * When you keep the default value, any minor discrepancies between audio and video duration will depend on your
         * output audio codec.
         * 
         * @param audioDuration
         *        Specify this setting only when your output will be consumed by a downstream repackaging workflow that
         *        is sensitive to very small duration differences between video and audio. For this situation, choose
         *        Match video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec
         *        duration (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output
         *        audio streams with silence or trims them to ensure that the total duration of each audio stream is at
         *        least as long as the total duration of the video stream. After padding or trimming, the audio stream
         *        duration is no more than one frame longer than the video stream. MediaConvert applies audio padding or
         *        trimming only to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds
         *        padding only to the end of the file. When you keep the default value, any minor discrepancies between
         *        audio and video duration will depend on your output audio codec.
         * @see CmfcAudioDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmfcAudioDuration
         */
        Builder audioDuration(CmfcAudioDuration audioDuration);

        /**
         * Choose Include (INCLUDE) to have MediaConvert generate an HLS child manifest that lists only the I-frames for
         * this rendition, in addition to your regular manifest for this rendition. You might use this manifest as part
         * of a workflow that creates preview functions for your video. MediaConvert adds both the I-frame only child
         * manifest and the regular child manifest to the parent manifest. When you don't need the I-frame only child
         * manifest, keep the default value Exclude (EXCLUDE).
         * 
         * @param iFrameOnlyManifest
         *        Choose Include (INCLUDE) to have MediaConvert generate an HLS child manifest that lists only the
         *        I-frames for this rendition, in addition to your regular manifest for this rendition. You might use
         *        this manifest as part of a workflow that creates preview functions for your video. MediaConvert adds
         *        both the I-frame only child manifest and the regular child manifest to the parent manifest. When you
         *        don't need the I-frame only child manifest, keep the default value Exclude (EXCLUDE).
         * @see CmfcIFrameOnlyManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmfcIFrameOnlyManifest
         */
        Builder iFrameOnlyManifest(String iFrameOnlyManifest);

        /**
         * Choose Include (INCLUDE) to have MediaConvert generate an HLS child manifest that lists only the I-frames for
         * this rendition, in addition to your regular manifest for this rendition. You might use this manifest as part
         * of a workflow that creates preview functions for your video. MediaConvert adds both the I-frame only child
         * manifest and the regular child manifest to the parent manifest. When you don't need the I-frame only child
         * manifest, keep the default value Exclude (EXCLUDE).
         * 
         * @param iFrameOnlyManifest
         *        Choose Include (INCLUDE) to have MediaConvert generate an HLS child manifest that lists only the
         *        I-frames for this rendition, in addition to your regular manifest for this rendition. You might use
         *        this manifest as part of a workflow that creates preview functions for your video. MediaConvert adds
         *        both the I-frame only child manifest and the regular child manifest to the parent manifest. When you
         *        don't need the I-frame only child manifest, keep the default value Exclude (EXCLUDE).
         * @see CmfcIFrameOnlyManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmfcIFrameOnlyManifest
         */
        Builder iFrameOnlyManifest(CmfcIFrameOnlyManifest iFrameOnlyManifest);

        /**
         * Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in
         * this output at the insertion points that you specify in an ESAM XML document. Provide the document in the
         * setting SCC XML (sccXml).
         * 
         * @param scte35Esam
         *        Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers
         *        in this output at the insertion points that you specify in an ESAM XML document. Provide the document
         *        in the setting SCC XML (sccXml).
         * @see CmfcScte35Esam
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmfcScte35Esam
         */
        Builder scte35Esam(String scte35Esam);

        /**
         * Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in
         * this output at the insertion points that you specify in an ESAM XML document. Provide the document in the
         * setting SCC XML (sccXml).
         * 
         * @param scte35Esam
         *        Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers
         *        in this output at the insertion points that you specify in an ESAM XML document. Provide the document
         *        in the setting SCC XML (sccXml).
         * @see CmfcScte35Esam
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmfcScte35Esam
         */
        Builder scte35Esam(CmfcScte35Esam scte35Esam);

        /**
         * Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
         * (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose
         * None (NONE) if you don't want those SCTE-35 markers in this output.
         * 
         * @param scte35Source
         *        Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
         *        (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output.
         *        Choose None (NONE) if you don't want those SCTE-35 markers in this output.
         * @see CmfcScte35Source
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmfcScte35Source
         */
        Builder scte35Source(String scte35Source);

        /**
         * Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
         * (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose
         * None (NONE) if you don't want those SCTE-35 markers in this output.
         * 
         * @param scte35Source
         *        Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
         *        (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output.
         *        Choose None (NONE) if you don't want those SCTE-35 markers in this output.
         * @see CmfcScte35Source
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmfcScte35Source
         */
        Builder scte35Source(CmfcScte35Source scte35Source);
    }

    static final class BuilderImpl implements Builder {
        private String audioDuration;

        private String iFrameOnlyManifest;

        private String scte35Esam;

        private String scte35Source;

        private BuilderImpl() {
        }

        private BuilderImpl(CmfcSettings model) {
            audioDuration(model.audioDuration);
            iFrameOnlyManifest(model.iFrameOnlyManifest);
            scte35Esam(model.scte35Esam);
            scte35Source(model.scte35Source);
        }

        public final String getAudioDuration() {
            return audioDuration;
        }

        @Override
        public final Builder audioDuration(String audioDuration) {
            this.audioDuration = audioDuration;
            return this;
        }

        @Override
        public final Builder audioDuration(CmfcAudioDuration audioDuration) {
            this.audioDuration(audioDuration == null ? null : audioDuration.toString());
            return this;
        }

        public final void setAudioDuration(String audioDuration) {
            this.audioDuration = audioDuration;
        }

        public final String getIFrameOnlyManifest() {
            return iFrameOnlyManifest;
        }

        @Override
        public final Builder iFrameOnlyManifest(String iFrameOnlyManifest) {
            this.iFrameOnlyManifest = iFrameOnlyManifest;
            return this;
        }

        @Override
        public final Builder iFrameOnlyManifest(CmfcIFrameOnlyManifest iFrameOnlyManifest) {
            this.iFrameOnlyManifest(iFrameOnlyManifest == null ? null : iFrameOnlyManifest.toString());
            return this;
        }

        public final void setIFrameOnlyManifest(String iFrameOnlyManifest) {
            this.iFrameOnlyManifest = iFrameOnlyManifest;
        }

        public final String getScte35Esam() {
            return scte35Esam;
        }

        @Override
        public final Builder scte35Esam(String scte35Esam) {
            this.scte35Esam = scte35Esam;
            return this;
        }

        @Override
        public final Builder scte35Esam(CmfcScte35Esam scte35Esam) {
            this.scte35Esam(scte35Esam == null ? null : scte35Esam.toString());
            return this;
        }

        public final void setScte35Esam(String scte35Esam) {
            this.scte35Esam = scte35Esam;
        }

        public final String getScte35Source() {
            return scte35Source;
        }

        @Override
        public final Builder scte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
            return this;
        }

        @Override
        public final Builder scte35Source(CmfcScte35Source scte35Source) {
            this.scte35Source(scte35Source == null ? null : scte35Source.toString());
            return this;
        }

        public final void setScte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
        }

        @Override
        public CmfcSettings build() {
            return new CmfcSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
