/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.LanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebvttHlsSourceSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebvttHlsSourceSettings> {
    private static final SdkField<String> RENDITION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenditionGroupId").getter(WebvttHlsSourceSettings.getter(WebvttHlsSourceSettings::renditionGroupId)).setter(WebvttHlsSourceSettings.setter(Builder::renditionGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renditionGroupId").build()}).build();
    private static final SdkField<String> RENDITION_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenditionLanguageCode").getter(WebvttHlsSourceSettings.getter(WebvttHlsSourceSettings::renditionLanguageCodeAsString)).setter(WebvttHlsSourceSettings.setter(Builder::renditionLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renditionLanguageCode").build()}).build();
    private static final SdkField<String> RENDITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenditionName").getter(WebvttHlsSourceSettings.getter(WebvttHlsSourceSettings::renditionName)).setter(WebvttHlsSourceSettings.setter(Builder::renditionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renditionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENDITION_GROUP_ID_FIELD, RENDITION_LANGUAGE_CODE_FIELD, RENDITION_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String renditionGroupId;
    private final String renditionLanguageCode;
    private final String renditionName;

    private WebvttHlsSourceSettings(BuilderImpl builder) {
        this.renditionGroupId = builder.renditionGroupId;
        this.renditionLanguageCode = builder.renditionLanguageCode;
        this.renditionName = builder.renditionName;
    }

    public final String renditionGroupId() {
        return this.renditionGroupId;
    }

    public final LanguageCode renditionLanguageCode() {
        return LanguageCode.fromValue(this.renditionLanguageCode);
    }

    public final String renditionLanguageCodeAsString() {
        return this.renditionLanguageCode;
    }

    public final String renditionName() {
        return this.renditionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.renditionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.renditionLanguageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.renditionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebvttHlsSourceSettings)) {
            return false;
        }
        WebvttHlsSourceSettings other = (WebvttHlsSourceSettings)obj;
        return Objects.equals(this.renditionGroupId(), other.renditionGroupId()) && Objects.equals(this.renditionLanguageCodeAsString(), other.renditionLanguageCodeAsString()) && Objects.equals(this.renditionName(), other.renditionName());
    }

    public final String toString() {
        return ToString.builder((String)"WebvttHlsSourceSettings").add("RenditionGroupId", (Object)this.renditionGroupId()).add("RenditionLanguageCode", (Object)this.renditionLanguageCodeAsString()).add("RenditionName", (Object)this.renditionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RenditionGroupId": {
                return Optional.ofNullable(clazz.cast(this.renditionGroupId()));
            }
            case "RenditionLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.renditionLanguageCodeAsString()));
            }
            case "RenditionName": {
                return Optional.ofNullable(clazz.cast(this.renditionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebvttHlsSourceSettings, T> g) {
        return obj -> g.apply((WebvttHlsSourceSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String renditionGroupId;
        private String renditionLanguageCode;
        private String renditionName;

        private BuilderImpl() {
        }

        private BuilderImpl(WebvttHlsSourceSettings model) {
            this.renditionGroupId(model.renditionGroupId);
            this.renditionLanguageCode(model.renditionLanguageCode);
            this.renditionName(model.renditionName);
        }

        public final String getRenditionGroupId() {
            return this.renditionGroupId;
        }

        @Override
        public final Builder renditionGroupId(String renditionGroupId) {
            this.renditionGroupId = renditionGroupId;
            return this;
        }

        public final void setRenditionGroupId(String renditionGroupId) {
            this.renditionGroupId = renditionGroupId;
        }

        public final String getRenditionLanguageCode() {
            return this.renditionLanguageCode;
        }

        @Override
        public final Builder renditionLanguageCode(String renditionLanguageCode) {
            this.renditionLanguageCode = renditionLanguageCode;
            return this;
        }

        @Override
        public final Builder renditionLanguageCode(LanguageCode renditionLanguageCode) {
            this.renditionLanguageCode(renditionLanguageCode == null ? null : renditionLanguageCode.toString());
            return this;
        }

        public final void setRenditionLanguageCode(String renditionLanguageCode) {
            this.renditionLanguageCode = renditionLanguageCode;
        }

        public final String getRenditionName() {
            return this.renditionName;
        }

        @Override
        public final Builder renditionName(String renditionName) {
            this.renditionName = renditionName;
            return this;
        }

        public final void setRenditionName(String renditionName) {
            this.renditionName = renditionName;
        }

        public WebvttHlsSourceSettings build() {
            return new WebvttHlsSourceSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebvttHlsSourceSettings> {
        public Builder renditionGroupId(String var1);

        public Builder renditionLanguageCode(String var1);

        public Builder renditionLanguageCode(LanguageCode var1);

        public Builder renditionName(String var1);
    }
}

