/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.MotionImageInsertionFramerate;
import software.amazon.awssdk.services.mediaconvert.model.MotionImageInsertionMode;
import software.amazon.awssdk.services.mediaconvert.model.MotionImageInsertionOffset;
import software.amazon.awssdk.services.mediaconvert.model.MotionImagePlayback;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MotionImageInserter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MotionImageInserter> {
    private static final SdkField<MotionImageInsertionFramerate> FRAMERATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Framerate").getter(MotionImageInserter.getter(MotionImageInserter::framerate)).setter(MotionImageInserter.setter(Builder::framerate)).constructor(MotionImageInsertionFramerate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerate").build()}).build();
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Input").getter(MotionImageInserter.getter(MotionImageInserter::input)).setter(MotionImageInserter.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<String> INSERTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InsertionMode").getter(MotionImageInserter.getter(MotionImageInserter::insertionModeAsString)).setter(MotionImageInserter.setter(Builder::insertionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insertionMode").build()}).build();
    private static final SdkField<MotionImageInsertionOffset> OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Offset").getter(MotionImageInserter.getter(MotionImageInserter::offset)).setter(MotionImageInserter.setter(Builder::offset)).constructor(MotionImageInsertionOffset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offset").build()}).build();
    private static final SdkField<String> PLAYBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Playback").getter(MotionImageInserter.getter(MotionImageInserter::playbackAsString)).setter(MotionImageInserter.setter(Builder::playback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playback").build()}).build();
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartTime").getter(MotionImageInserter.getter(MotionImageInserter::startTime)).setter(MotionImageInserter.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMERATE_FIELD, INPUT_FIELD, INSERTION_MODE_FIELD, OFFSET_FIELD, PLAYBACK_FIELD, START_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final MotionImageInsertionFramerate framerate;
    private final String input;
    private final String insertionMode;
    private final MotionImageInsertionOffset offset;
    private final String playback;
    private final String startTime;

    private MotionImageInserter(BuilderImpl builder) {
        this.framerate = builder.framerate;
        this.input = builder.input;
        this.insertionMode = builder.insertionMode;
        this.offset = builder.offset;
        this.playback = builder.playback;
        this.startTime = builder.startTime;
    }

    public final MotionImageInsertionFramerate framerate() {
        return this.framerate;
    }

    public final String input() {
        return this.input;
    }

    public final MotionImageInsertionMode insertionMode() {
        return MotionImageInsertionMode.fromValue(this.insertionMode);
    }

    public final String insertionModeAsString() {
        return this.insertionMode;
    }

    public final MotionImageInsertionOffset offset() {
        return this.offset;
    }

    public final MotionImagePlayback playback() {
        return MotionImagePlayback.fromValue(this.playback);
    }

    public final String playbackAsString() {
        return this.playback;
    }

    public final String startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.framerate());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.insertionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offset());
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MotionImageInserter)) {
            return false;
        }
        MotionImageInserter other = (MotionImageInserter)obj;
        return Objects.equals(this.framerate(), other.framerate()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.insertionModeAsString(), other.insertionModeAsString()) && Objects.equals(this.offset(), other.offset()) && Objects.equals(this.playbackAsString(), other.playbackAsString()) && Objects.equals(this.startTime(), other.startTime());
    }

    public final String toString() {
        return ToString.builder((String)"MotionImageInserter").add("Framerate", (Object)this.framerate()).add("Input", (Object)this.input()).add("InsertionMode", (Object)this.insertionModeAsString()).add("Offset", (Object)this.offset()).add("Playback", (Object)this.playbackAsString()).add("StartTime", (Object)this.startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Framerate": {
                return Optional.ofNullable(clazz.cast(this.framerate()));
            }
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "InsertionMode": {
                return Optional.ofNullable(clazz.cast(this.insertionModeAsString()));
            }
            case "Offset": {
                return Optional.ofNullable(clazz.cast(this.offset()));
            }
            case "Playback": {
                return Optional.ofNullable(clazz.cast(this.playbackAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MotionImageInserter, T> g) {
        return obj -> g.apply((MotionImageInserter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MotionImageInsertionFramerate framerate;
        private String input;
        private String insertionMode;
        private MotionImageInsertionOffset offset;
        private String playback;
        private String startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MotionImageInserter model) {
            this.framerate(model.framerate);
            this.input(model.input);
            this.insertionMode(model.insertionMode);
            this.offset(model.offset);
            this.playback(model.playback);
            this.startTime(model.startTime);
        }

        public final MotionImageInsertionFramerate.Builder getFramerate() {
            return this.framerate != null ? this.framerate.toBuilder() : null;
        }

        @Override
        public final Builder framerate(MotionImageInsertionFramerate framerate) {
            this.framerate = framerate;
            return this;
        }

        public final void setFramerate(MotionImageInsertionFramerate.BuilderImpl framerate) {
            this.framerate = framerate != null ? framerate.build() : null;
        }

        public final String getInput() {
            return this.input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getInsertionMode() {
            return this.insertionMode;
        }

        @Override
        public final Builder insertionMode(String insertionMode) {
            this.insertionMode = insertionMode;
            return this;
        }

        @Override
        public final Builder insertionMode(MotionImageInsertionMode insertionMode) {
            this.insertionMode(insertionMode == null ? null : insertionMode.toString());
            return this;
        }

        public final void setInsertionMode(String insertionMode) {
            this.insertionMode = insertionMode;
        }

        public final MotionImageInsertionOffset.Builder getOffset() {
            return this.offset != null ? this.offset.toBuilder() : null;
        }

        @Override
        public final Builder offset(MotionImageInsertionOffset offset) {
            this.offset = offset;
            return this;
        }

        public final void setOffset(MotionImageInsertionOffset.BuilderImpl offset) {
            this.offset = offset != null ? offset.build() : null;
        }

        public final String getPlayback() {
            return this.playback;
        }

        @Override
        public final Builder playback(String playback) {
            this.playback = playback;
            return this;
        }

        @Override
        public final Builder playback(MotionImagePlayback playback) {
            this.playback(playback == null ? null : playback.toString());
            return this;
        }

        public final void setPlayback(String playback) {
            this.playback = playback;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public MotionImageInserter build() {
            return new MotionImageInserter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MotionImageInserter> {
        public Builder framerate(MotionImageInsertionFramerate var1);

        default public Builder framerate(Consumer<MotionImageInsertionFramerate.Builder> framerate) {
            return this.framerate((MotionImageInsertionFramerate)((MotionImageInsertionFramerate.Builder)MotionImageInsertionFramerate.builder().applyMutation(framerate)).build());
        }

        public Builder input(String var1);

        public Builder insertionMode(String var1);

        public Builder insertionMode(MotionImageInsertionMode var1);

        public Builder offset(MotionImageInsertionOffset var1);

        default public Builder offset(Consumer<MotionImageInsertionOffset.Builder> offset) {
            return this.offset((MotionImageInsertionOffset)((MotionImageInsertionOffset.Builder)MotionImageInsertionOffset.builder().applyMutation(offset)).build());
        }

        public Builder playback(String var1);

        public Builder playback(MotionImagePlayback var1);

        public Builder startTime(String var1);
    }
}

