/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.DolbyVisionLevel6Metadata;
import software.amazon.awssdk.services.mediaconvert.model.DolbyVisionLevel6Mode;
import software.amazon.awssdk.services.mediaconvert.model.DolbyVisionProfile;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DolbyVision
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DolbyVision> {
    private static final SdkField<DolbyVisionLevel6Metadata> L6_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("L6Metadata").getter(DolbyVision.getter(DolbyVision::l6Metadata)).setter(DolbyVision.setter(Builder::l6Metadata)).constructor(DolbyVisionLevel6Metadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("l6Metadata").build()}).build();
    private static final SdkField<String> L6_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("L6Mode").getter(DolbyVision.getter(DolbyVision::l6ModeAsString)).setter(DolbyVision.setter(Builder::l6Mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("l6Mode").build()}).build();
    private static final SdkField<String> PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Profile").getter(DolbyVision.getter(DolbyVision::profileAsString)).setter(DolbyVision.setter(Builder::profile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(L6_METADATA_FIELD, L6_MODE_FIELD, PROFILE_FIELD));
    private static final long serialVersionUID = 1L;
    private final DolbyVisionLevel6Metadata l6Metadata;
    private final String l6Mode;
    private final String profile;

    private DolbyVision(BuilderImpl builder) {
        this.l6Metadata = builder.l6Metadata;
        this.l6Mode = builder.l6Mode;
        this.profile = builder.profile;
    }

    public final DolbyVisionLevel6Metadata l6Metadata() {
        return this.l6Metadata;
    }

    public final DolbyVisionLevel6Mode l6Mode() {
        return DolbyVisionLevel6Mode.fromValue(this.l6Mode);
    }

    public final String l6ModeAsString() {
        return this.l6Mode;
    }

    public final DolbyVisionProfile profile() {
        return DolbyVisionProfile.fromValue(this.profile);
    }

    public final String profileAsString() {
        return this.profile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.l6Metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.l6ModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DolbyVision)) {
            return false;
        }
        DolbyVision other = (DolbyVision)obj;
        return Objects.equals(this.l6Metadata(), other.l6Metadata()) && Objects.equals(this.l6ModeAsString(), other.l6ModeAsString()) && Objects.equals(this.profileAsString(), other.profileAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DolbyVision").add("L6Metadata", (Object)this.l6Metadata()).add("L6Mode", (Object)this.l6ModeAsString()).add("Profile", (Object)this.profileAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "L6Metadata": {
                return Optional.ofNullable(clazz.cast(this.l6Metadata()));
            }
            case "L6Mode": {
                return Optional.ofNullable(clazz.cast(this.l6ModeAsString()));
            }
            case "Profile": {
                return Optional.ofNullable(clazz.cast(this.profileAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DolbyVision, T> g) {
        return obj -> g.apply((DolbyVision)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DolbyVisionLevel6Metadata l6Metadata;
        private String l6Mode;
        private String profile;

        private BuilderImpl() {
        }

        private BuilderImpl(DolbyVision model) {
            this.l6Metadata(model.l6Metadata);
            this.l6Mode(model.l6Mode);
            this.profile(model.profile);
        }

        public final DolbyVisionLevel6Metadata.Builder getL6Metadata() {
            return this.l6Metadata != null ? this.l6Metadata.toBuilder() : null;
        }

        @Override
        public final Builder l6Metadata(DolbyVisionLevel6Metadata l6Metadata) {
            this.l6Metadata = l6Metadata;
            return this;
        }

        public final void setL6Metadata(DolbyVisionLevel6Metadata.BuilderImpl l6Metadata) {
            this.l6Metadata = l6Metadata != null ? l6Metadata.build() : null;
        }

        public final String getL6Mode() {
            return this.l6Mode;
        }

        @Override
        public final Builder l6Mode(String l6Mode) {
            this.l6Mode = l6Mode;
            return this;
        }

        @Override
        public final Builder l6Mode(DolbyVisionLevel6Mode l6Mode) {
            this.l6Mode(l6Mode == null ? null : l6Mode.toString());
            return this;
        }

        public final void setL6Mode(String l6Mode) {
            this.l6Mode = l6Mode;
        }

        public final String getProfile() {
            return this.profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(DolbyVisionProfile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        public DolbyVision build() {
            return new DolbyVision(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DolbyVision> {
        public Builder l6Metadata(DolbyVisionLevel6Metadata var1);

        default public Builder l6Metadata(Consumer<DolbyVisionLevel6Metadata.Builder> l6Metadata) {
            return this.l6Metadata((DolbyVisionLevel6Metadata)((DolbyVisionLevel6Metadata.Builder)DolbyVisionLevel6Metadata.builder().applyMutation(l6Metadata)).build());
        }

        public Builder l6Mode(String var1);

        public Builder l6Mode(DolbyVisionLevel6Mode var1);

        public Builder profile(String var1);

        public Builder profile(DolbyVisionProfile var1);
    }
}

