/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.CmafEncryptionType;
import software.amazon.awssdk.services.mediaconvert.model.CmafInitializationVectorInManifest;
import software.amazon.awssdk.services.mediaconvert.model.CmafKeyProviderType;
import software.amazon.awssdk.services.mediaconvert.model.SpekeKeyProviderCmaf;
import software.amazon.awssdk.services.mediaconvert.model.StaticKeyProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CmafEncryptionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CmafEncryptionSettings> {
    private static final SdkField<String> CONSTANT_INITIALIZATION_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConstantInitializationVector").getter(CmafEncryptionSettings.getter(CmafEncryptionSettings::constantInitializationVector)).setter(CmafEncryptionSettings.setter(Builder::constantInitializationVector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constantInitializationVector").build()}).build();
    private static final SdkField<String> ENCRYPTION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionMethod").getter(CmafEncryptionSettings.getter(CmafEncryptionSettings::encryptionMethodAsString)).setter(CmafEncryptionSettings.setter(Builder::encryptionMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionMethod").build()}).build();
    private static final SdkField<String> INITIALIZATION_VECTOR_IN_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitializationVectorInManifest").getter(CmafEncryptionSettings.getter(CmafEncryptionSettings::initializationVectorInManifestAsString)).setter(CmafEncryptionSettings.setter(Builder::initializationVectorInManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationVectorInManifest").build()}).build();
    private static final SdkField<SpekeKeyProviderCmaf> SPEKE_KEY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpekeKeyProvider").getter(CmafEncryptionSettings.getter(CmafEncryptionSettings::spekeKeyProvider)).setter(CmafEncryptionSettings.setter(Builder::spekeKeyProvider)).constructor(SpekeKeyProviderCmaf::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spekeKeyProvider").build()}).build();
    private static final SdkField<StaticKeyProvider> STATIC_KEY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StaticKeyProvider").getter(CmafEncryptionSettings.getter(CmafEncryptionSettings::staticKeyProvider)).setter(CmafEncryptionSettings.setter(Builder::staticKeyProvider)).constructor(StaticKeyProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticKeyProvider").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CmafEncryptionSettings.getter(CmafEncryptionSettings::typeAsString)).setter(CmafEncryptionSettings.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTANT_INITIALIZATION_VECTOR_FIELD, ENCRYPTION_METHOD_FIELD, INITIALIZATION_VECTOR_IN_MANIFEST_FIELD, SPEKE_KEY_PROVIDER_FIELD, STATIC_KEY_PROVIDER_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String constantInitializationVector;
    private final String encryptionMethod;
    private final String initializationVectorInManifest;
    private final SpekeKeyProviderCmaf spekeKeyProvider;
    private final StaticKeyProvider staticKeyProvider;
    private final String type;

    private CmafEncryptionSettings(BuilderImpl builder) {
        this.constantInitializationVector = builder.constantInitializationVector;
        this.encryptionMethod = builder.encryptionMethod;
        this.initializationVectorInManifest = builder.initializationVectorInManifest;
        this.spekeKeyProvider = builder.spekeKeyProvider;
        this.staticKeyProvider = builder.staticKeyProvider;
        this.type = builder.type;
    }

    public final String constantInitializationVector() {
        return this.constantInitializationVector;
    }

    public final CmafEncryptionType encryptionMethod() {
        return CmafEncryptionType.fromValue(this.encryptionMethod);
    }

    public final String encryptionMethodAsString() {
        return this.encryptionMethod;
    }

    public final CmafInitializationVectorInManifest initializationVectorInManifest() {
        return CmafInitializationVectorInManifest.fromValue(this.initializationVectorInManifest);
    }

    public final String initializationVectorInManifestAsString() {
        return this.initializationVectorInManifest;
    }

    public final SpekeKeyProviderCmaf spekeKeyProvider() {
        return this.spekeKeyProvider;
    }

    public final StaticKeyProvider staticKeyProvider() {
        return this.staticKeyProvider;
    }

    public final CmafKeyProviderType type() {
        return CmafKeyProviderType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.constantInitializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.initializationVectorInManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spekeKeyProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticKeyProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafEncryptionSettings)) {
            return false;
        }
        CmafEncryptionSettings other = (CmafEncryptionSettings)obj;
        return Objects.equals(this.constantInitializationVector(), other.constantInitializationVector()) && Objects.equals(this.encryptionMethodAsString(), other.encryptionMethodAsString()) && Objects.equals(this.initializationVectorInManifestAsString(), other.initializationVectorInManifestAsString()) && Objects.equals(this.spekeKeyProvider(), other.spekeKeyProvider()) && Objects.equals(this.staticKeyProvider(), other.staticKeyProvider()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CmafEncryptionSettings").add("ConstantInitializationVector", (Object)this.constantInitializationVector()).add("EncryptionMethod", (Object)this.encryptionMethodAsString()).add("InitializationVectorInManifest", (Object)this.initializationVectorInManifestAsString()).add("SpekeKeyProvider", (Object)this.spekeKeyProvider()).add("StaticKeyProvider", (Object)this.staticKeyProvider()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConstantInitializationVector": {
                return Optional.ofNullable(clazz.cast(this.constantInitializationVector()));
            }
            case "EncryptionMethod": {
                return Optional.ofNullable(clazz.cast(this.encryptionMethodAsString()));
            }
            case "InitializationVectorInManifest": {
                return Optional.ofNullable(clazz.cast(this.initializationVectorInManifestAsString()));
            }
            case "SpekeKeyProvider": {
                return Optional.ofNullable(clazz.cast(this.spekeKeyProvider()));
            }
            case "StaticKeyProvider": {
                return Optional.ofNullable(clazz.cast(this.staticKeyProvider()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CmafEncryptionSettings, T> g) {
        return obj -> g.apply((CmafEncryptionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String constantInitializationVector;
        private String encryptionMethod;
        private String initializationVectorInManifest;
        private SpekeKeyProviderCmaf spekeKeyProvider;
        private StaticKeyProvider staticKeyProvider;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafEncryptionSettings model) {
            this.constantInitializationVector(model.constantInitializationVector);
            this.encryptionMethod(model.encryptionMethod);
            this.initializationVectorInManifest(model.initializationVectorInManifest);
            this.spekeKeyProvider(model.spekeKeyProvider);
            this.staticKeyProvider(model.staticKeyProvider);
            this.type(model.type);
        }

        public final String getConstantInitializationVector() {
            return this.constantInitializationVector;
        }

        @Override
        public final Builder constantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
            return this;
        }

        public final void setConstantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
        }

        public final String getEncryptionMethod() {
            return this.encryptionMethod;
        }

        @Override
        public final Builder encryptionMethod(String encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
            return this;
        }

        @Override
        public final Builder encryptionMethod(CmafEncryptionType encryptionMethod) {
            this.encryptionMethod(encryptionMethod == null ? null : encryptionMethod.toString());
            return this;
        }

        public final void setEncryptionMethod(String encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
        }

        public final String getInitializationVectorInManifest() {
            return this.initializationVectorInManifest;
        }

        @Override
        public final Builder initializationVectorInManifest(String initializationVectorInManifest) {
            this.initializationVectorInManifest = initializationVectorInManifest;
            return this;
        }

        @Override
        public final Builder initializationVectorInManifest(CmafInitializationVectorInManifest initializationVectorInManifest) {
            this.initializationVectorInManifest(initializationVectorInManifest == null ? null : initializationVectorInManifest.toString());
            return this;
        }

        public final void setInitializationVectorInManifest(String initializationVectorInManifest) {
            this.initializationVectorInManifest = initializationVectorInManifest;
        }

        public final SpekeKeyProviderCmaf.Builder getSpekeKeyProvider() {
            return this.spekeKeyProvider != null ? this.spekeKeyProvider.toBuilder() : null;
        }

        @Override
        public final Builder spekeKeyProvider(SpekeKeyProviderCmaf spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider;
            return this;
        }

        public final void setSpekeKeyProvider(SpekeKeyProviderCmaf.BuilderImpl spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider != null ? spekeKeyProvider.build() : null;
        }

        public final StaticKeyProvider.Builder getStaticKeyProvider() {
            return this.staticKeyProvider != null ? this.staticKeyProvider.toBuilder() : null;
        }

        @Override
        public final Builder staticKeyProvider(StaticKeyProvider staticKeyProvider) {
            this.staticKeyProvider = staticKeyProvider;
            return this;
        }

        public final void setStaticKeyProvider(StaticKeyProvider.BuilderImpl staticKeyProvider) {
            this.staticKeyProvider = staticKeyProvider != null ? staticKeyProvider.build() : null;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CmafKeyProviderType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public CmafEncryptionSettings build() {
            return new CmafEncryptionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CmafEncryptionSettings> {
        public Builder constantInitializationVector(String var1);

        public Builder encryptionMethod(String var1);

        public Builder encryptionMethod(CmafEncryptionType var1);

        public Builder initializationVectorInManifest(String var1);

        public Builder initializationVectorInManifest(CmafInitializationVectorInManifest var1);

        public Builder spekeKeyProvider(SpekeKeyProviderCmaf var1);

        default public Builder spekeKeyProvider(Consumer<SpekeKeyProviderCmaf.Builder> spekeKeyProvider) {
            return this.spekeKeyProvider((SpekeKeyProviderCmaf)((SpekeKeyProviderCmaf.Builder)SpekeKeyProviderCmaf.builder().applyMutation(spekeKeyProvider)).build());
        }

        public Builder staticKeyProvider(StaticKeyProvider var1);

        default public Builder staticKeyProvider(Consumer<StaticKeyProvider.Builder> staticKeyProvider) {
            return this.staticKeyProvider((StaticKeyProvider)((StaticKeyProvider.Builder)StaticKeyProvider.builder().applyMutation(staticKeyProvider)).build());
        }

        public Builder type(String var1);

        public Builder type(CmafKeyProviderType var1);
    }
}

