/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InputScanType {
    AUTO("AUTO"),
    PSF("PSF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InputScanType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputScanType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InputScanType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputScanType> knownValues() {
        return Stream.of(InputScanType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

