/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.Vc3Class;
import software.amazon.awssdk.services.mediaconvert.model.Vc3FramerateControl;
import software.amazon.awssdk.services.mediaconvert.model.Vc3FramerateConversionAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.Vc3InterlaceMode;
import software.amazon.awssdk.services.mediaconvert.model.Vc3SlowPal;
import software.amazon.awssdk.services.mediaconvert.model.Vc3Telecine;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Vc3Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Vc3Settings> {
    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateControl").getter(Vc3Settings.getter(Vc3Settings::framerateControlAsString)).setter(Vc3Settings.setter(Builder::framerateControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()}).build();
    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateConversionAlgorithm").getter(Vc3Settings.getter(Vc3Settings::framerateConversionAlgorithmAsString)).setter(Vc3Settings.setter(Builder::framerateConversionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm").build()}).build();
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateDenominator").getter(Vc3Settings.getter(Vc3Settings::framerateDenominator)).setter(Vc3Settings.setter(Builder::framerateDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build()}).build();
    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateNumerator").getter(Vc3Settings.getter(Vc3Settings::framerateNumerator)).setter(Vc3Settings.setter(Builder::framerateNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build()}).build();
    private static final SdkField<String> INTERLACE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterlaceMode").getter(Vc3Settings.getter(Vc3Settings::interlaceModeAsString)).setter(Vc3Settings.setter(Builder::interlaceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interlaceMode").build()}).build();
    private static final SdkField<String> SLOW_PAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlowPal").getter(Vc3Settings.getter(Vc3Settings::slowPalAsString)).setter(Vc3Settings.setter(Builder::slowPal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slowPal").build()}).build();
    private static final SdkField<String> TELECINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Telecine").getter(Vc3Settings.getter(Vc3Settings::telecineAsString)).setter(Vc3Settings.setter(Builder::telecine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telecine").build()}).build();
    private static final SdkField<String> VC3_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Vc3Class").getter(Vc3Settings.getter(Vc3Settings::vc3ClassAsString)).setter(Vc3Settings.setter(Builder::vc3Class)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vc3Class").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMERATE_CONTROL_FIELD, FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, INTERLACE_MODE_FIELD, SLOW_PAL_FIELD, TELECINE_FIELD, VC3_CLASS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String framerateControl;
    private final String framerateConversionAlgorithm;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final String interlaceMode;
    private final String slowPal;
    private final String telecine;
    private final String vc3Class;

    private Vc3Settings(BuilderImpl builder) {
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.interlaceMode = builder.interlaceMode;
        this.slowPal = builder.slowPal;
        this.telecine = builder.telecine;
        this.vc3Class = builder.vc3Class;
    }

    public Vc3FramerateControl framerateControl() {
        return Vc3FramerateControl.fromValue(this.framerateControl);
    }

    public String framerateControlAsString() {
        return this.framerateControl;
    }

    public Vc3FramerateConversionAlgorithm framerateConversionAlgorithm() {
        return Vc3FramerateConversionAlgorithm.fromValue(this.framerateConversionAlgorithm);
    }

    public String framerateConversionAlgorithmAsString() {
        return this.framerateConversionAlgorithm;
    }

    public Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public Vc3InterlaceMode interlaceMode() {
        return Vc3InterlaceMode.fromValue(this.interlaceMode);
    }

    public String interlaceModeAsString() {
        return this.interlaceMode;
    }

    public Vc3SlowPal slowPal() {
        return Vc3SlowPal.fromValue(this.slowPal);
    }

    public String slowPalAsString() {
        return this.slowPal;
    }

    public Vc3Telecine telecine() {
        return Vc3Telecine.fromValue(this.telecine);
    }

    public String telecineAsString() {
        return this.telecine;
    }

    public Vc3Class vc3Class() {
        return Vc3Class.fromValue(this.vc3Class);
    }

    public String vc3ClassAsString() {
        return this.vc3Class;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.telecineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vc3ClassAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vc3Settings)) {
            return false;
        }
        Vc3Settings other = (Vc3Settings)obj;
        return Objects.equals(this.framerateControlAsString(), other.framerateControlAsString()) && Objects.equals(this.framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.interlaceModeAsString(), other.interlaceModeAsString()) && Objects.equals(this.slowPalAsString(), other.slowPalAsString()) && Objects.equals(this.telecineAsString(), other.telecineAsString()) && Objects.equals(this.vc3ClassAsString(), other.vc3ClassAsString());
    }

    public String toString() {
        return ToString.builder((String)"Vc3Settings").add("FramerateControl", (Object)this.framerateControlAsString()).add("FramerateConversionAlgorithm", (Object)this.framerateConversionAlgorithmAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("InterlaceMode", (Object)this.interlaceModeAsString()).add("SlowPal", (Object)this.slowPalAsString()).add("Telecine", (Object)this.telecineAsString()).add("Vc3Class", (Object)this.vc3ClassAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FramerateControl": {
                return Optional.ofNullable(clazz.cast(this.framerateControlAsString()));
            }
            case "FramerateConversionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.framerateConversionAlgorithmAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "InterlaceMode": {
                return Optional.ofNullable(clazz.cast(this.interlaceModeAsString()));
            }
            case "SlowPal": {
                return Optional.ofNullable(clazz.cast(this.slowPalAsString()));
            }
            case "Telecine": {
                return Optional.ofNullable(clazz.cast(this.telecineAsString()));
            }
            case "Vc3Class": {
                return Optional.ofNullable(clazz.cast(this.vc3ClassAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Vc3Settings, T> g) {
        return obj -> g.apply((Vc3Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String framerateControl;
        private String framerateConversionAlgorithm;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private String interlaceMode;
        private String slowPal;
        private String telecine;
        private String vc3Class;

        private BuilderImpl() {
        }

        private BuilderImpl(Vc3Settings model) {
            this.framerateControl(model.framerateControl);
            this.framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.interlaceMode(model.interlaceMode);
            this.slowPal(model.slowPal);
            this.telecine(model.telecine);
            this.vc3Class(model.vc3Class);
        }

        public final String getFramerateControl() {
            return this.framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(Vc3FramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final String getFramerateConversionAlgorithm() {
            return this.framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(Vc3FramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm.toString());
            return this;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final String getInterlaceMode() {
            return this.interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(Vc3InterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode == null ? null : interlaceMode.toString());
            return this;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        public final String getSlowPal() {
            return this.slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(Vc3SlowPal slowPal) {
            this.slowPal(slowPal == null ? null : slowPal.toString());
            return this;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        public final String getTelecine() {
            return this.telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(Vc3Telecine telecine) {
            this.telecine(telecine == null ? null : telecine.toString());
            return this;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        public final String getVc3Class() {
            return this.vc3Class;
        }

        @Override
        public final Builder vc3Class(String vc3Class) {
            this.vc3Class = vc3Class;
            return this;
        }

        @Override
        public final Builder vc3Class(Vc3Class vc3Class) {
            this.vc3Class(vc3Class == null ? null : vc3Class.toString());
            return this;
        }

        public final void setVc3Class(String vc3Class) {
            this.vc3Class = vc3Class;
        }

        public Vc3Settings build() {
            return new Vc3Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Vc3Settings> {
        public Builder framerateControl(String var1);

        public Builder framerateControl(Vc3FramerateControl var1);

        public Builder framerateConversionAlgorithm(String var1);

        public Builder framerateConversionAlgorithm(Vc3FramerateConversionAlgorithm var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder interlaceMode(String var1);

        public Builder interlaceMode(Vc3InterlaceMode var1);

        public Builder slowPal(String var1);

        public Builder slowPal(Vc3SlowPal var1);

        public Builder telecine(String var1);

        public Builder telecine(Vc3Telecine var1);

        public Builder vc3Class(String var1);

        public Builder vc3Class(Vc3Class var1);
    }
}

