/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.AudioDescription;
import software.amazon.awssdk.services.mediaconvert.model.CaptionDescription;
import software.amazon.awssdk.services.mediaconvert.model.ContainerSettings;
import software.amazon.awssdk.services.mediaconvert.model.OutputSettings;
import software.amazon.awssdk.services.mediaconvert.model.VideoDescription;
import software.amazon.awssdk.services.mediaconvert.model.___listOfAudioDescriptionCopier;
import software.amazon.awssdk.services.mediaconvert.model.___listOfCaptionDescriptionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Output
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Output> {
    private static final SdkField<List<AudioDescription>> AUDIO_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AudioDescriptions").getter(Output.getter(Output::audioDescriptions)).setter(Output.setter(Builder::audioDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudioDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CaptionDescription>> CAPTION_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CaptionDescriptions").getter(Output.getter(Output::captionDescriptions)).setter(Output.setter(Builder::captionDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaptionDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ContainerSettings> CONTAINER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContainerSettings").getter(Output.getter(Output::containerSettings)).setter(Output.setter(Builder::containerSettings)).constructor(ContainerSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerSettings").build()}).build();
    private static final SdkField<String> EXTENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Extension").getter(Output.getter(Output::extension)).setter(Output.setter(Builder::extension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extension").build()}).build();
    private static final SdkField<String> NAME_MODIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NameModifier").getter(Output.getter(Output::nameModifier)).setter(Output.setter(Builder::nameModifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nameModifier").build()}).build();
    private static final SdkField<OutputSettings> OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputSettings").getter(Output.getter(Output::outputSettings)).setter(Output.setter(Builder::outputSettings)).constructor(OutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSettings").build()}).build();
    private static final SdkField<String> PRESET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Preset").getter(Output.getter(Output::preset)).setter(Output.setter(Builder::preset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preset").build()}).build();
    private static final SdkField<VideoDescription> VIDEO_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VideoDescription").getter(Output.getter(Output::videoDescription)).setter(Output.setter(Builder::videoDescription)).constructor(VideoDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_DESCRIPTIONS_FIELD, CAPTION_DESCRIPTIONS_FIELD, CONTAINER_SETTINGS_FIELD, EXTENSION_FIELD, NAME_MODIFIER_FIELD, OUTPUT_SETTINGS_FIELD, PRESET_FIELD, VIDEO_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AudioDescription> audioDescriptions;
    private final List<CaptionDescription> captionDescriptions;
    private final ContainerSettings containerSettings;
    private final String extension;
    private final String nameModifier;
    private final OutputSettings outputSettings;
    private final String preset;
    private final VideoDescription videoDescription;

    private Output(BuilderImpl builder) {
        this.audioDescriptions = builder.audioDescriptions;
        this.captionDescriptions = builder.captionDescriptions;
        this.containerSettings = builder.containerSettings;
        this.extension = builder.extension;
        this.nameModifier = builder.nameModifier;
        this.outputSettings = builder.outputSettings;
        this.preset = builder.preset;
        this.videoDescription = builder.videoDescription;
    }

    public boolean hasAudioDescriptions() {
        return this.audioDescriptions != null && !(this.audioDescriptions instanceof SdkAutoConstructList);
    }

    public List<AudioDescription> audioDescriptions() {
        return this.audioDescriptions;
    }

    public boolean hasCaptionDescriptions() {
        return this.captionDescriptions != null && !(this.captionDescriptions instanceof SdkAutoConstructList);
    }

    public List<CaptionDescription> captionDescriptions() {
        return this.captionDescriptions;
    }

    public ContainerSettings containerSettings() {
        return this.containerSettings;
    }

    public String extension() {
        return this.extension;
    }

    public String nameModifier() {
        return this.nameModifier;
    }

    public OutputSettings outputSettings() {
        return this.outputSettings;
    }

    public String preset() {
        return this.preset;
    }

    public VideoDescription videoDescription() {
        return this.videoDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.extension());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameModifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.preset());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output)obj;
        return Objects.equals(this.audioDescriptions(), other.audioDescriptions()) && Objects.equals(this.captionDescriptions(), other.captionDescriptions()) && Objects.equals(this.containerSettings(), other.containerSettings()) && Objects.equals(this.extension(), other.extension()) && Objects.equals(this.nameModifier(), other.nameModifier()) && Objects.equals(this.outputSettings(), other.outputSettings()) && Objects.equals(this.preset(), other.preset()) && Objects.equals(this.videoDescription(), other.videoDescription());
    }

    public String toString() {
        return ToString.builder((String)"Output").add("AudioDescriptions", this.audioDescriptions()).add("CaptionDescriptions", this.captionDescriptions()).add("ContainerSettings", (Object)this.containerSettings()).add("Extension", (Object)this.extension()).add("NameModifier", (Object)this.nameModifier()).add("OutputSettings", (Object)this.outputSettings()).add("Preset", (Object)this.preset()).add("VideoDescription", (Object)this.videoDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioDescriptions": {
                return Optional.ofNullable(clazz.cast(this.audioDescriptions()));
            }
            case "CaptionDescriptions": {
                return Optional.ofNullable(clazz.cast(this.captionDescriptions()));
            }
            case "ContainerSettings": {
                return Optional.ofNullable(clazz.cast(this.containerSettings()));
            }
            case "Extension": {
                return Optional.ofNullable(clazz.cast(this.extension()));
            }
            case "NameModifier": {
                return Optional.ofNullable(clazz.cast(this.nameModifier()));
            }
            case "OutputSettings": {
                return Optional.ofNullable(clazz.cast(this.outputSettings()));
            }
            case "Preset": {
                return Optional.ofNullable(clazz.cast(this.preset()));
            }
            case "VideoDescription": {
                return Optional.ofNullable(clazz.cast(this.videoDescription()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Output, T> g) {
        return obj -> g.apply((Output)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AudioDescription> audioDescriptions = DefaultSdkAutoConstructList.getInstance();
        private List<CaptionDescription> captionDescriptions = DefaultSdkAutoConstructList.getInstance();
        private ContainerSettings containerSettings;
        private String extension;
        private String nameModifier;
        private OutputSettings outputSettings;
        private String preset;
        private VideoDescription videoDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            this.audioDescriptions(model.audioDescriptions);
            this.captionDescriptions(model.captionDescriptions);
            this.containerSettings(model.containerSettings);
            this.extension(model.extension);
            this.nameModifier(model.nameModifier);
            this.outputSettings(model.outputSettings);
            this.preset(model.preset);
            this.videoDescription(model.videoDescription);
        }

        public final Collection<AudioDescription.Builder> getAudioDescriptions() {
            return this.audioDescriptions != null ? (Collection)this.audioDescriptions.stream().map(AudioDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder audioDescriptions(Collection<AudioDescription> audioDescriptions) {
            this.audioDescriptions = ___listOfAudioDescriptionCopier.copy(audioDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptions(AudioDescription ... audioDescriptions) {
            this.audioDescriptions(Arrays.asList(audioDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptions(Consumer<AudioDescription.Builder> ... audioDescriptions) {
            this.audioDescriptions(Stream.of(audioDescriptions).map(c -> (AudioDescription)((AudioDescription.Builder)AudioDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAudioDescriptions(Collection<AudioDescription.BuilderImpl> audioDescriptions) {
            this.audioDescriptions = ___listOfAudioDescriptionCopier.copyFromBuilder(audioDescriptions);
        }

        public final Collection<CaptionDescription.Builder> getCaptionDescriptions() {
            return this.captionDescriptions != null ? (Collection)this.captionDescriptions.stream().map(CaptionDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder captionDescriptions(Collection<CaptionDescription> captionDescriptions) {
            this.captionDescriptions = ___listOfCaptionDescriptionCopier.copy(captionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptions(CaptionDescription ... captionDescriptions) {
            this.captionDescriptions(Arrays.asList(captionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptions(Consumer<CaptionDescription.Builder> ... captionDescriptions) {
            this.captionDescriptions(Stream.of(captionDescriptions).map(c -> (CaptionDescription)((CaptionDescription.Builder)CaptionDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCaptionDescriptions(Collection<CaptionDescription.BuilderImpl> captionDescriptions) {
            this.captionDescriptions = ___listOfCaptionDescriptionCopier.copyFromBuilder(captionDescriptions);
        }

        public final ContainerSettings.Builder getContainerSettings() {
            return this.containerSettings != null ? this.containerSettings.toBuilder() : null;
        }

        @Override
        public final Builder containerSettings(ContainerSettings containerSettings) {
            this.containerSettings = containerSettings;
            return this;
        }

        public final void setContainerSettings(ContainerSettings.BuilderImpl containerSettings) {
            this.containerSettings = containerSettings != null ? containerSettings.build() : null;
        }

        public final String getExtension() {
            return this.extension;
        }

        @Override
        public final Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public final void setExtension(String extension) {
            this.extension = extension;
        }

        public final String getNameModifier() {
            return this.nameModifier;
        }

        @Override
        public final Builder nameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
            return this;
        }

        public final void setNameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
        }

        public final OutputSettings.Builder getOutputSettings() {
            return this.outputSettings != null ? this.outputSettings.toBuilder() : null;
        }

        @Override
        public final Builder outputSettings(OutputSettings outputSettings) {
            this.outputSettings = outputSettings;
            return this;
        }

        public final void setOutputSettings(OutputSettings.BuilderImpl outputSettings) {
            this.outputSettings = outputSettings != null ? outputSettings.build() : null;
        }

        public final String getPreset() {
            return this.preset;
        }

        @Override
        public final Builder preset(String preset) {
            this.preset = preset;
            return this;
        }

        public final void setPreset(String preset) {
            this.preset = preset;
        }

        public final VideoDescription.Builder getVideoDescription() {
            return this.videoDescription != null ? this.videoDescription.toBuilder() : null;
        }

        @Override
        public final Builder videoDescription(VideoDescription videoDescription) {
            this.videoDescription = videoDescription;
            return this;
        }

        public final void setVideoDescription(VideoDescription.BuilderImpl videoDescription) {
            this.videoDescription = videoDescription != null ? videoDescription.build() : null;
        }

        public Output build() {
            return new Output(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Output> {
        public Builder audioDescriptions(Collection<AudioDescription> var1);

        public Builder audioDescriptions(AudioDescription ... var1);

        public Builder audioDescriptions(Consumer<AudioDescription.Builder> ... var1);

        public Builder captionDescriptions(Collection<CaptionDescription> var1);

        public Builder captionDescriptions(CaptionDescription ... var1);

        public Builder captionDescriptions(Consumer<CaptionDescription.Builder> ... var1);

        public Builder containerSettings(ContainerSettings var1);

        default public Builder containerSettings(Consumer<ContainerSettings.Builder> containerSettings) {
            return this.containerSettings((ContainerSettings)((ContainerSettings.Builder)ContainerSettings.builder().applyMutation(containerSettings)).build());
        }

        public Builder extension(String var1);

        public Builder nameModifier(String var1);

        public Builder outputSettings(OutputSettings var1);

        default public Builder outputSettings(Consumer<OutputSettings.Builder> outputSettings) {
            return this.outputSettings((OutputSettings)((OutputSettings.Builder)OutputSettings.builder().applyMutation(outputSettings)).build());
        }

        public Builder preset(String var1);

        public Builder videoDescription(VideoDescription var1);

        default public Builder videoDescription(Consumer<VideoDescription.Builder> videoDescription) {
            return this.videoDescription((VideoDescription)((VideoDescription.Builder)VideoDescription.builder().applyMutation(videoDescription)).build());
        }
    }
}

