/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.CmfcScte35Esam;
import software.amazon.awssdk.services.mediaconvert.model.CmfcScte35Source;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CmfcSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CmfcSettings> {
    private static final SdkField<String> SCTE35_ESAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scte35Esam").getter(CmfcSettings.getter(CmfcSettings::scte35EsamAsString)).setter(CmfcSettings.setter(Builder::scte35Esam)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Esam").build()}).build();
    private static final SdkField<String> SCTE35_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scte35Source").getter(CmfcSettings.getter(CmfcSettings::scte35SourceAsString)).setter(CmfcSettings.setter(Builder::scte35Source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Source").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCTE35_ESAM_FIELD, SCTE35_SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String scte35Esam;
    private final String scte35Source;

    private CmfcSettings(BuilderImpl builder) {
        this.scte35Esam = builder.scte35Esam;
        this.scte35Source = builder.scte35Source;
    }

    public CmfcScte35Esam scte35Esam() {
        return CmfcScte35Esam.fromValue(this.scte35Esam);
    }

    public String scte35EsamAsString() {
        return this.scte35Esam;
    }

    public CmfcScte35Source scte35Source() {
        return CmfcScte35Source.fromValue(this.scte35Source);
    }

    public String scte35SourceAsString() {
        return this.scte35Source;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35EsamAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35SourceAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmfcSettings)) {
            return false;
        }
        CmfcSettings other = (CmfcSettings)obj;
        return Objects.equals(this.scte35EsamAsString(), other.scte35EsamAsString()) && Objects.equals(this.scte35SourceAsString(), other.scte35SourceAsString());
    }

    public String toString() {
        return ToString.builder((String)"CmfcSettings").add("Scte35Esam", (Object)this.scte35EsamAsString()).add("Scte35Source", (Object)this.scte35SourceAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Scte35Esam": {
                return Optional.ofNullable(clazz.cast(this.scte35EsamAsString()));
            }
            case "Scte35Source": {
                return Optional.ofNullable(clazz.cast(this.scte35SourceAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CmfcSettings, T> g) {
        return obj -> g.apply((CmfcSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scte35Esam;
        private String scte35Source;

        private BuilderImpl() {
        }

        private BuilderImpl(CmfcSettings model) {
            this.scte35Esam(model.scte35Esam);
            this.scte35Source(model.scte35Source);
        }

        public final String getScte35Esam() {
            return this.scte35Esam;
        }

        @Override
        public final Builder scte35Esam(String scte35Esam) {
            this.scte35Esam = scte35Esam;
            return this;
        }

        @Override
        public final Builder scte35Esam(CmfcScte35Esam scte35Esam) {
            this.scte35Esam(scte35Esam == null ? null : scte35Esam.toString());
            return this;
        }

        public final void setScte35Esam(String scte35Esam) {
            this.scte35Esam = scte35Esam;
        }

        public final String getScte35Source() {
            return this.scte35Source;
        }

        @Override
        public final Builder scte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
            return this;
        }

        @Override
        public final Builder scte35Source(CmfcScte35Source scte35Source) {
            this.scte35Source(scte35Source == null ? null : scte35Source.toString());
            return this;
        }

        public final void setScte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
        }

        public CmfcSettings build() {
            return new CmfcSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CmfcSettings> {
        public Builder scte35Esam(String var1);

        public Builder scte35Esam(CmfcScte35Esam var1);

        public Builder scte35Source(String var1);

        public Builder scte35Source(CmfcScte35Source var1);
    }
}

