/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.WavFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WavSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WavSettings> {
    private static final SdkField<Integer> BIT_DEPTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BitDepth").getter(WavSettings.getter(WavSettings::bitDepth)).setter(WavSettings.setter(Builder::bitDepth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitDepth").build()}).build();
    private static final SdkField<Integer> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Channels").getter(WavSettings.getter(WavSettings::channels)).setter(WavSettings.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(WavSettings.getter(WavSettings::formatAsString)).setter(WavSettings.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SampleRate").getter(WavSettings.getter(WavSettings::sampleRate)).setter(WavSettings.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIT_DEPTH_FIELD, CHANNELS_FIELD, FORMAT_FIELD, SAMPLE_RATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer bitDepth;
    private final Integer channels;
    private final String format;
    private final Integer sampleRate;

    private WavSettings(BuilderImpl builder) {
        this.bitDepth = builder.bitDepth;
        this.channels = builder.channels;
        this.format = builder.format;
        this.sampleRate = builder.sampleRate;
    }

    public Integer bitDepth() {
        return this.bitDepth;
    }

    public Integer channels() {
        return this.channels;
    }

    public WavFormat format() {
        return WavFormat.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public Integer sampleRate() {
        return this.sampleRate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.channels());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WavSettings)) {
            return false;
        }
        WavSettings other = (WavSettings)obj;
        return Objects.equals(this.bitDepth(), other.bitDepth()) && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.sampleRate(), other.sampleRate());
    }

    public String toString() {
        return ToString.builder((String)"WavSettings").add("BitDepth", (Object)this.bitDepth()).add("Channels", (Object)this.channels()).add("Format", (Object)this.formatAsString()).add("SampleRate", (Object)this.sampleRate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BitDepth": {
                return Optional.ofNullable(clazz.cast(this.bitDepth()));
            }
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WavSettings, T> g) {
        return obj -> g.apply((WavSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bitDepth;
        private Integer channels;
        private String format;
        private Integer sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(WavSettings model) {
            this.bitDepth(model.bitDepth);
            this.channels(model.channels);
            this.format(model.format);
            this.sampleRate(model.sampleRate);
        }

        public final Integer getBitDepth() {
            return this.bitDepth;
        }

        @Override
        public final Builder bitDepth(Integer bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        public final void setBitDepth(Integer bitDepth) {
            this.bitDepth = bitDepth;
        }

        public final Integer getChannels() {
            return this.channels;
        }

        @Override
        public final Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public final void setChannels(Integer channels) {
            this.channels = channels;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(WavFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final Integer getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        public WavSettings build() {
            return new WavSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WavSettings> {
        public Builder bitDepth(Integer var1);

        public Builder channels(Integer var1);

        public Builder format(String var1);

        public Builder format(WavFormat var1);

        public Builder sampleRate(Integer var1);
    }
}

