/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.Mp3RateControlMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Mp3Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Mp3Settings> {
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Mp3Settings.getter(Mp3Settings::bitrate)).setter(Mp3Settings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<Integer> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Mp3Settings.getter(Mp3Settings::channels)).setter(Mp3Settings.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build()}).build();
    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Mp3Settings.getter(Mp3Settings::rateControlModeAsString)).setter(Mp3Settings.setter(Builder::rateControlMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()}).build();
    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Mp3Settings.getter(Mp3Settings::sampleRate)).setter(Mp3Settings.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()}).build();
    private static final SdkField<Integer> VBR_QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Mp3Settings.getter(Mp3Settings::vbrQuality)).setter(Mp3Settings.setter(Builder::vbrQuality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vbrQuality").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD, CHANNELS_FIELD, RATE_CONTROL_MODE_FIELD, SAMPLE_RATE_FIELD, VBR_QUALITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer bitrate;
    private final Integer channels;
    private final String rateControlMode;
    private final Integer sampleRate;
    private final Integer vbrQuality;

    private Mp3Settings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.channels = builder.channels;
        this.rateControlMode = builder.rateControlMode;
        this.sampleRate = builder.sampleRate;
        this.vbrQuality = builder.vbrQuality;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public Integer channels() {
        return this.channels;
    }

    public Mp3RateControlMode rateControlMode() {
        return Mp3RateControlMode.fromValue(this.rateControlMode);
    }

    public String rateControlModeAsString() {
        return this.rateControlMode;
    }

    public Integer sampleRate() {
        return this.sampleRate;
    }

    public Integer vbrQuality() {
        return this.vbrQuality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.channels());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.vbrQuality());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mp3Settings)) {
            return false;
        }
        Mp3Settings other = (Mp3Settings)obj;
        return Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.rateControlModeAsString(), other.rateControlModeAsString()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.vbrQuality(), other.vbrQuality());
    }

    public String toString() {
        return ToString.builder((String)"Mp3Settings").add("Bitrate", (Object)this.bitrate()).add("Channels", (Object)this.channels()).add("RateControlMode", (Object)this.rateControlModeAsString()).add("SampleRate", (Object)this.sampleRate()).add("VbrQuality", (Object)this.vbrQuality()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "RateControlMode": {
                return Optional.ofNullable(clazz.cast(this.rateControlModeAsString()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
            case "VbrQuality": {
                return Optional.ofNullable(clazz.cast(this.vbrQuality()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Mp3Settings, T> g) {
        return obj -> g.apply((Mp3Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bitrate;
        private Integer channels;
        private String rateControlMode;
        private Integer sampleRate;
        private Integer vbrQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(Mp3Settings model) {
            this.bitrate(model.bitrate);
            this.channels(model.channels);
            this.rateControlMode(model.rateControlMode);
            this.sampleRate(model.sampleRate);
            this.vbrQuality(model.vbrQuality);
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final Integer getChannels() {
            return this.channels;
        }

        @Override
        public final Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public final void setChannels(Integer channels) {
            this.channels = channels;
        }

        public final String getRateControlMode() {
            return this.rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(Mp3RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final Integer getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final Integer getVbrQuality() {
            return this.vbrQuality;
        }

        @Override
        public final Builder vbrQuality(Integer vbrQuality) {
            this.vbrQuality = vbrQuality;
            return this;
        }

        public final void setVbrQuality(Integer vbrQuality) {
            this.vbrQuality = vbrQuality;
        }

        public Mp3Settings build() {
            return new Mp3Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Mp3Settings> {
        public Builder bitrate(Integer var1);

        public Builder channels(Integer var1);

        public Builder rateControlMode(String var1);

        public Builder rateControlMode(Mp3RateControlMode var1);

        public Builder sampleRate(Integer var1);

        public Builder vbrQuality(Integer var1);
    }
}

