/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.MxfAfdSignaling;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MxfSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MxfSettings> {
    private static final SdkField<String> AFD_SIGNALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MxfSettings.getter(MxfSettings::afdSignalingAsString)).setter(MxfSettings.setter(Builder::afdSignaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afdSignaling").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFD_SIGNALING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String afdSignaling;

    private MxfSettings(BuilderImpl builder) {
        this.afdSignaling = builder.afdSignaling;
    }

    public MxfAfdSignaling afdSignaling() {
        return MxfAfdSignaling.fromValue(this.afdSignaling);
    }

    public String afdSignalingAsString() {
        return this.afdSignaling;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.afdSignalingAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MxfSettings)) {
            return false;
        }
        MxfSettings other = (MxfSettings)obj;
        return Objects.equals(this.afdSignalingAsString(), other.afdSignalingAsString());
    }

    public String toString() {
        return ToString.builder((String)"MxfSettings").add("AfdSignaling", (Object)this.afdSignalingAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AfdSignaling": {
                return Optional.ofNullable(clazz.cast(this.afdSignalingAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MxfSettings, T> g) {
        return obj -> g.apply((MxfSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String afdSignaling;

        private BuilderImpl() {
        }

        private BuilderImpl(MxfSettings model) {
            this.afdSignaling(model.afdSignaling);
        }

        public final String getAfdSignaling() {
            return this.afdSignaling;
        }

        @Override
        public final Builder afdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
            return this;
        }

        @Override
        public final Builder afdSignaling(MxfAfdSignaling afdSignaling) {
            this.afdSignaling(afdSignaling == null ? null : afdSignaling.toString());
            return this;
        }

        public final void setAfdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
        }

        public MxfSettings build() {
            return new MxfSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MxfSettings> {
        public Builder afdSignaling(String var1);

        public Builder afdSignaling(MxfAfdSignaling var1);
    }
}

