/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateJobTemplateResponse extends MediaConvertResponse implements
        ToCopyableBuilder<UpdateJobTemplateResponse.Builder, UpdateJobTemplateResponse> {
    private static final SdkField<JobTemplate> JOB_TEMPLATE_FIELD = SdkField.<JobTemplate> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateJobTemplateResponse::jobTemplate)).setter(setter(Builder::jobTemplate))
            .constructor(JobTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_TEMPLATE_FIELD));

    private final JobTemplate jobTemplate;

    private UpdateJobTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.jobTemplate = builder.jobTemplate;
    }

    /**
     * A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
     * 
     * @return A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
     */
    public JobTemplate jobTemplate() {
        return jobTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobTemplate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobTemplateResponse)) {
            return false;
        }
        UpdateJobTemplateResponse other = (UpdateJobTemplateResponse) obj;
        return Objects.equals(jobTemplate(), other.jobTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateJobTemplateResponse").add("JobTemplate", jobTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobTemplate":
            return Optional.ofNullable(clazz.cast(jobTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobTemplateResponse, T> g) {
        return obj -> g.apply((UpdateJobTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConvertResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateJobTemplateResponse> {
        /**
         * A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
         * 
         * @param jobTemplate
         *        A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTemplate(JobTemplate jobTemplate);

        /**
         * A job template is a pre-made set of encoding instructions that you can use to quickly create a job. This is a
         * convenience that creates an instance of the {@link JobTemplate.Builder} avoiding the need to create one
         * manually via {@link JobTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobTemplate.Builder#build()} is called immediately and its result
         * is passed to {@link #jobTemplate(JobTemplate)}.
         * 
         * @param jobTemplate
         *        a consumer that will call methods on {@link JobTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobTemplate(JobTemplate)
         */
        default Builder jobTemplate(Consumer<JobTemplate.Builder> jobTemplate) {
            return jobTemplate(JobTemplate.builder().applyMutation(jobTemplate).build());
        }
    }

    static final class BuilderImpl extends MediaConvertResponse.BuilderImpl implements Builder {
        private JobTemplate jobTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobTemplateResponse model) {
            super(model);
            jobTemplate(model.jobTemplate);
        }

        public final JobTemplate.Builder getJobTemplate() {
            return jobTemplate != null ? jobTemplate.toBuilder() : null;
        }

        @Override
        public final Builder jobTemplate(JobTemplate jobTemplate) {
            this.jobTemplate = jobTemplate;
            return this;
        }

        public final void setJobTemplate(JobTemplate.BuilderImpl jobTemplate) {
            this.jobTemplate = jobTemplate != null ? jobTemplate.build() : null;
        }

        @Override
        public UpdateJobTemplateResponse build() {
            return new UpdateJobTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
