/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about when jobs are submitted, started, and finished is specified in Unix epoch format in seconds.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Timing implements SdkPojo, Serializable, ToCopyableBuilder<Timing.Builder, Timing> {
    private static final SdkField<Instant> FINISH_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Timing::finishTime))
            .setter(setter(Builder::finishTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finishTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Timing::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Timing::submitTime))
            .setter(setter(Builder::submitTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submitTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINISH_TIME_FIELD,
            START_TIME_FIELD, SUBMIT_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant finishTime;

    private final Instant startTime;

    private final Instant submitTime;

    private Timing(BuilderImpl builder) {
        this.finishTime = builder.finishTime;
        this.startTime = builder.startTime;
        this.submitTime = builder.submitTime;
    }

    /**
     * The time, in Unix epoch format, that the transcoding job finished
     * 
     * @return The time, in Unix epoch format, that the transcoding job finished
     */
    public Instant finishTime() {
        return finishTime;
    }

    /**
     * The time, in Unix epoch format, that transcoding for the job began.
     * 
     * @return The time, in Unix epoch format, that transcoding for the job began.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * The time, in Unix epoch format, that you submitted the job.
     * 
     * @return The time, in Unix epoch format, that you submitted the job.
     */
    public Instant submitTime() {
        return submitTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(finishTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(submitTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Timing)) {
            return false;
        }
        Timing other = (Timing) obj;
        return Objects.equals(finishTime(), other.finishTime()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(submitTime(), other.submitTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Timing").add("FinishTime", finishTime()).add("StartTime", startTime())
                .add("SubmitTime", submitTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FinishTime":
            return Optional.ofNullable(clazz.cast(finishTime()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "SubmitTime":
            return Optional.ofNullable(clazz.cast(submitTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Timing, T> g) {
        return obj -> g.apply((Timing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Timing> {
        /**
         * The time, in Unix epoch format, that the transcoding job finished
         * 
         * @param finishTime
         *        The time, in Unix epoch format, that the transcoding job finished
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finishTime(Instant finishTime);

        /**
         * The time, in Unix epoch format, that transcoding for the job began.
         * 
         * @param startTime
         *        The time, in Unix epoch format, that transcoding for the job began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * The time, in Unix epoch format, that you submitted the job.
         * 
         * @param submitTime
         *        The time, in Unix epoch format, that you submitted the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTime(Instant submitTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant finishTime;

        private Instant startTime;

        private Instant submitTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Timing model) {
            finishTime(model.finishTime);
            startTime(model.startTime);
            submitTime(model.submitTime);
        }

        public final Instant getFinishTime() {
            return finishTime;
        }

        @Override
        public final Builder finishTime(Instant finishTime) {
            this.finishTime = finishTime;
            return this;
        }

        public final void setFinishTime(Instant finishTime) {
            this.finishTime = finishTime;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getSubmitTime() {
            return submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        public Timing build() {
            return new Timing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
