/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use these settings to set up encryption with a static key provider.
 */
@Generated("software.amazon.awssdk:codegen")
public final class StaticKeyProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<StaticKeyProvider.Builder, StaticKeyProvider> {
    private static final SdkField<String> KEY_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StaticKeyProvider::keyFormat)).setter(setter(Builder::keyFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyFormat").build()).build();

    private static final SdkField<String> KEY_FORMAT_VERSIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StaticKeyProvider::keyFormatVersions)).setter(setter(Builder::keyFormatVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyFormatVersions").build()).build();

    private static final SdkField<String> STATIC_KEY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StaticKeyProvider::staticKeyValue)).setter(setter(Builder::staticKeyValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticKeyValue").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StaticKeyProvider::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FORMAT_FIELD,
            KEY_FORMAT_VERSIONS_FIELD, STATIC_KEY_VALUE_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String keyFormat;

    private final String keyFormatVersions;

    private final String staticKeyValue;

    private final String url;

    private StaticKeyProvider(BuilderImpl builder) {
        this.keyFormat = builder.keyFormat;
        this.keyFormatVersions = builder.keyFormatVersions;
        this.staticKeyValue = builder.staticKeyValue;
        this.url = builder.url;
    }

    /**
     * Relates to DRM implementation. Sets the value of the KEYFORMAT attribute. Must be 'identity' or a reverse DNS
     * string. May be omitted to indicate an implicit value of 'identity'.
     * 
     * @return Relates to DRM implementation. Sets the value of the KEYFORMAT attribute. Must be 'identity' or a reverse
     *         DNS string. May be omitted to indicate an implicit value of 'identity'.
     */
    public String keyFormat() {
        return keyFormat;
    }

    /**
     * Relates to DRM implementation. Either a single positive integer version value or a slash delimited list of
     * version values (1/2/3).
     * 
     * @return Relates to DRM implementation. Either a single positive integer version value or a slash delimited list
     *         of version values (1/2/3).
     */
    public String keyFormatVersions() {
        return keyFormatVersions;
    }

    /**
     * Relates to DRM implementation. Use a 32-character hexidecimal string to specify Key Value (StaticKeyValue).
     * 
     * @return Relates to DRM implementation. Use a 32-character hexidecimal string to specify Key Value
     *         (StaticKeyValue).
     */
    public String staticKeyValue() {
        return staticKeyValue;
    }

    /**
     * Relates to DRM implementation. The location of the license server used for protecting content.
     * 
     * @return Relates to DRM implementation. The location of the license server used for protecting content.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyFormat());
        hashCode = 31 * hashCode + Objects.hashCode(keyFormatVersions());
        hashCode = 31 * hashCode + Objects.hashCode(staticKeyValue());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticKeyProvider)) {
            return false;
        }
        StaticKeyProvider other = (StaticKeyProvider) obj;
        return Objects.equals(keyFormat(), other.keyFormat()) && Objects.equals(keyFormatVersions(), other.keyFormatVersions())
                && Objects.equals(staticKeyValue(), other.staticKeyValue()) && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StaticKeyProvider").add("KeyFormat", keyFormat()).add("KeyFormatVersions", keyFormatVersions())
                .add("StaticKeyValue", staticKeyValue()).add("Url", url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyFormat":
            return Optional.ofNullable(clazz.cast(keyFormat()));
        case "KeyFormatVersions":
            return Optional.ofNullable(clazz.cast(keyFormatVersions()));
        case "StaticKeyValue":
            return Optional.ofNullable(clazz.cast(staticKeyValue()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StaticKeyProvider, T> g) {
        return obj -> g.apply((StaticKeyProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StaticKeyProvider> {
        /**
         * Relates to DRM implementation. Sets the value of the KEYFORMAT attribute. Must be 'identity' or a reverse DNS
         * string. May be omitted to indicate an implicit value of 'identity'.
         * 
         * @param keyFormat
         *        Relates to DRM implementation. Sets the value of the KEYFORMAT attribute. Must be 'identity' or a
         *        reverse DNS string. May be omitted to indicate an implicit value of 'identity'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyFormat(String keyFormat);

        /**
         * Relates to DRM implementation. Either a single positive integer version value or a slash delimited list of
         * version values (1/2/3).
         * 
         * @param keyFormatVersions
         *        Relates to DRM implementation. Either a single positive integer version value or a slash delimited
         *        list of version values (1/2/3).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyFormatVersions(String keyFormatVersions);

        /**
         * Relates to DRM implementation. Use a 32-character hexidecimal string to specify Key Value (StaticKeyValue).
         * 
         * @param staticKeyValue
         *        Relates to DRM implementation. Use a 32-character hexidecimal string to specify Key Value
         *        (StaticKeyValue).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticKeyValue(String staticKeyValue);

        /**
         * Relates to DRM implementation. The location of the license server used for protecting content.
         * 
         * @param url
         *        Relates to DRM implementation. The location of the license server used for protecting content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String keyFormat;

        private String keyFormatVersions;

        private String staticKeyValue;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticKeyProvider model) {
            keyFormat(model.keyFormat);
            keyFormatVersions(model.keyFormatVersions);
            staticKeyValue(model.staticKeyValue);
            url(model.url);
        }

        public final String getKeyFormat() {
            return keyFormat;
        }

        @Override
        public final Builder keyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
            return this;
        }

        public final void setKeyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
        }

        public final String getKeyFormatVersions() {
            return keyFormatVersions;
        }

        @Override
        public final Builder keyFormatVersions(String keyFormatVersions) {
            this.keyFormatVersions = keyFormatVersions;
            return this;
        }

        public final void setKeyFormatVersions(String keyFormatVersions) {
            this.keyFormatVersions = keyFormatVersions;
        }

        public final String getStaticKeyValue() {
            return staticKeyValue;
        }

        @Override
        public final Builder staticKeyValue(String staticKeyValue) {
            this.staticKeyValue = staticKeyValue;
            return this;
        }

        public final void setStaticKeyValue(String staticKeyValue) {
            this.staticKeyValue = staticKeyValue;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public StaticKeyProvider build() {
            return new StaticKeyProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
