/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Description of the source and destination queues between which the job has moved, along with the timestamp of the
 * move
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueueTransition implements SdkPojo, Serializable, ToCopyableBuilder<QueueTransition.Builder, QueueTransition> {
    private static final SdkField<String> DESTINATION_QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueueTransition::destinationQueue)).setter(setter(Builder::destinationQueue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationQueue").build()).build();

    private static final SdkField<String> SOURCE_QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueueTransition::sourceQueue)).setter(setter(Builder::sourceQueue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceQueue").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(QueueTransition::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_QUEUE_FIELD,
            SOURCE_QUEUE_FIELD, TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationQueue;

    private final String sourceQueue;

    private final Instant timestamp;

    private QueueTransition(BuilderImpl builder) {
        this.destinationQueue = builder.destinationQueue;
        this.sourceQueue = builder.sourceQueue;
        this.timestamp = builder.timestamp;
    }

    /**
     * The queue that the job was on after the transition.
     * 
     * @return The queue that the job was on after the transition.
     */
    public String destinationQueue() {
        return destinationQueue;
    }

    /**
     * The queue that the job was on before the transition.
     * 
     * @return The queue that the job was on before the transition.
     */
    public String sourceQueue() {
        return sourceQueue;
    }

    /**
     * The time, in Unix epoch format, that the job moved from the source queue to the destination queue.
     * 
     * @return The time, in Unix epoch format, that the job moved from the source queue to the destination queue.
     */
    public Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationQueue());
        hashCode = 31 * hashCode + Objects.hashCode(sourceQueue());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueTransition)) {
            return false;
        }
        QueueTransition other = (QueueTransition) obj;
        return Objects.equals(destinationQueue(), other.destinationQueue()) && Objects.equals(sourceQueue(), other.sourceQueue())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QueueTransition").add("DestinationQueue", destinationQueue()).add("SourceQueue", sourceQueue())
                .add("Timestamp", timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationQueue":
            return Optional.ofNullable(clazz.cast(destinationQueue()));
        case "SourceQueue":
            return Optional.ofNullable(clazz.cast(sourceQueue()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueueTransition, T> g) {
        return obj -> g.apply((QueueTransition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueueTransition> {
        /**
         * The queue that the job was on after the transition.
         * 
         * @param destinationQueue
         *        The queue that the job was on after the transition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationQueue(String destinationQueue);

        /**
         * The queue that the job was on before the transition.
         * 
         * @param sourceQueue
         *        The queue that the job was on before the transition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceQueue(String sourceQueue);

        /**
         * The time, in Unix epoch format, that the job moved from the source queue to the destination queue.
         * 
         * @param timestamp
         *        The time, in Unix epoch format, that the job moved from the source queue to the destination queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String destinationQueue;

        private String sourceQueue;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueTransition model) {
            destinationQueue(model.destinationQueue);
            sourceQueue(model.sourceQueue);
            timestamp(model.timestamp);
        }

        public final String getDestinationQueue() {
            return destinationQueue;
        }

        @Override
        public final Builder destinationQueue(String destinationQueue) {
            this.destinationQueue = destinationQueue;
            return this;
        }

        public final void setDestinationQueue(String destinationQueue) {
            this.destinationQueue = destinationQueue;
        }

        public final String getSourceQueue() {
            return sourceQueue;
        }

        @Override
        public final Builder sourceQueue(String sourceQueue) {
            this.sourceQueue = sourceQueue;
            return this;
        }

        public final void setSourceQueue(String sourceQueue) {
            this.sourceQueue = sourceQueue;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public QueueTransition build() {
            return new QueueTransition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
