/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * OutputChannel mapping settings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputChannelMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputChannelMapping.Builder, OutputChannelMapping> {
    private static final SdkField<List<Integer>> INPUT_CHANNELS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .getter(getter(OutputChannelMapping::inputChannels))
            .setter(setter(Builder::inputChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputChannels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_CHANNELS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Integer> inputChannels;

    private OutputChannelMapping(BuilderImpl builder) {
        this.inputChannels = builder.inputChannels;
    }

    /**
     * Returns true if the InputChannels property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInputChannels() {
        return inputChannels != null && !(inputChannels instanceof SdkAutoConstructList);
    }

    /**
     * List of input channels
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputChannels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of input channels
     */
    public List<Integer> inputChannels() {
        return inputChannels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputChannels());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputChannelMapping)) {
            return false;
        }
        OutputChannelMapping other = (OutputChannelMapping) obj;
        return Objects.equals(inputChannels(), other.inputChannels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OutputChannelMapping").add("InputChannels", inputChannels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputChannels":
            return Optional.ofNullable(clazz.cast(inputChannels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputChannelMapping, T> g) {
        return obj -> g.apply((OutputChannelMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputChannelMapping> {
        /**
         * List of input channels
         * 
         * @param inputChannels
         *        List of input channels
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputChannels(Collection<Integer> inputChannels);

        /**
         * List of input channels
         * 
         * @param inputChannels
         *        List of input channels
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputChannels(Integer... inputChannels);
    }

    static final class BuilderImpl implements Builder {
        private List<Integer> inputChannels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OutputChannelMapping model) {
            inputChannels(model.inputChannels);
        }

        public final Collection<Integer> getInputChannels() {
            return inputChannels;
        }

        @Override
        public final Builder inputChannels(Collection<Integer> inputChannels) {
            this.inputChannels = ___listOf__integerMinNegative60Max6Copier.copy(inputChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputChannels(Integer... inputChannels) {
            inputChannels(Arrays.asList(inputChannels));
            return this;
        }

        public final void setInputChannels(Collection<Integer> inputChannels) {
            this.inputChannels = ___listOf__integerMinNegative60Max6Copier.copy(inputChannels);
        }

        @Override
        public OutputChannelMapping build() {
            return new OutputChannelMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
