/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * MXF settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class MxfSettings implements SdkPojo, Serializable, ToCopyableBuilder<MxfSettings.Builder, MxfSettings> {
    private static final SdkField<String> AFD_SIGNALING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MxfSettings::afdSignalingAsString)).setter(setter(Builder::afdSignaling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afdSignaling").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFD_SIGNALING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String afdSignaling;

    private MxfSettings(BuilderImpl builder) {
        this.afdSignaling = builder.afdSignaling;
    }

    /**
     * Optional. When you have AFD signaling set up in your output video stream, use this setting to choose whether to
     * also include it in the MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling from the MXF wrapper.
     * Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the video stream for this output to
     * the MXF wrapper. Regardless of which option you choose, the AFD values remain in the video stream. Related
     * settings: To set up your output to include or exclude AFD values, see AfdSignaling, under VideoDescription. On
     * the console, find AFD signaling under the output's video encoding settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #afdSignaling} will
     * return {@link MxfAfdSignaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #afdSignalingAsString}.
     * </p>
     * 
     * @return Optional. When you have AFD signaling set up in your output video stream, use this setting to choose
     *         whether to also include it in the MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling from
     *         the MXF wrapper. Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the video
     *         stream for this output to the MXF wrapper. Regardless of which option you choose, the AFD values remain
     *         in the video stream. Related settings: To set up your output to include or exclude AFD values, see
     *         AfdSignaling, under VideoDescription. On the console, find AFD signaling under the output's video
     *         encoding settings.
     * @see MxfAfdSignaling
     */
    public MxfAfdSignaling afdSignaling() {
        return MxfAfdSignaling.fromValue(afdSignaling);
    }

    /**
     * Optional. When you have AFD signaling set up in your output video stream, use this setting to choose whether to
     * also include it in the MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling from the MXF wrapper.
     * Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the video stream for this output to
     * the MXF wrapper. Regardless of which option you choose, the AFD values remain in the video stream. Related
     * settings: To set up your output to include or exclude AFD values, see AfdSignaling, under VideoDescription. On
     * the console, find AFD signaling under the output's video encoding settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #afdSignaling} will
     * return {@link MxfAfdSignaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #afdSignalingAsString}.
     * </p>
     * 
     * @return Optional. When you have AFD signaling set up in your output video stream, use this setting to choose
     *         whether to also include it in the MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling from
     *         the MXF wrapper. Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the video
     *         stream for this output to the MXF wrapper. Regardless of which option you choose, the AFD values remain
     *         in the video stream. Related settings: To set up your output to include or exclude AFD values, see
     *         AfdSignaling, under VideoDescription. On the console, find AFD signaling under the output's video
     *         encoding settings.
     * @see MxfAfdSignaling
     */
    public String afdSignalingAsString() {
        return afdSignaling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(afdSignalingAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MxfSettings)) {
            return false;
        }
        MxfSettings other = (MxfSettings) obj;
        return Objects.equals(afdSignalingAsString(), other.afdSignalingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MxfSettings").add("AfdSignaling", afdSignalingAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AfdSignaling":
            return Optional.ofNullable(clazz.cast(afdSignalingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MxfSettings, T> g) {
        return obj -> g.apply((MxfSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MxfSettings> {
        /**
         * Optional. When you have AFD signaling set up in your output video stream, use this setting to choose whether
         * to also include it in the MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling from the MXF
         * wrapper. Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the video stream for
         * this output to the MXF wrapper. Regardless of which option you choose, the AFD values remain in the video
         * stream. Related settings: To set up your output to include or exclude AFD values, see AfdSignaling, under
         * VideoDescription. On the console, find AFD signaling under the output's video encoding settings.
         * 
         * @param afdSignaling
         *        Optional. When you have AFD signaling set up in your output video stream, use this setting to choose
         *        whether to also include it in the MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling
         *        from the MXF wrapper. Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the
         *        video stream for this output to the MXF wrapper. Regardless of which option you choose, the AFD values
         *        remain in the video stream. Related settings: To set up your output to include or exclude AFD values,
         *        see AfdSignaling, under VideoDescription. On the console, find AFD signaling under the output's video
         *        encoding settings.
         * @see MxfAfdSignaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MxfAfdSignaling
         */
        Builder afdSignaling(String afdSignaling);

        /**
         * Optional. When you have AFD signaling set up in your output video stream, use this setting to choose whether
         * to also include it in the MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling from the MXF
         * wrapper. Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the video stream for
         * this output to the MXF wrapper. Regardless of which option you choose, the AFD values remain in the video
         * stream. Related settings: To set up your output to include or exclude AFD values, see AfdSignaling, under
         * VideoDescription. On the console, find AFD signaling under the output's video encoding settings.
         * 
         * @param afdSignaling
         *        Optional. When you have AFD signaling set up in your output video stream, use this setting to choose
         *        whether to also include it in the MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling
         *        from the MXF wrapper. Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the
         *        video stream for this output to the MXF wrapper. Regardless of which option you choose, the AFD values
         *        remain in the video stream. Related settings: To set up your output to include or exclude AFD values,
         *        see AfdSignaling, under VideoDescription. On the console, find AFD signaling under the output's video
         *        encoding settings.
         * @see MxfAfdSignaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MxfAfdSignaling
         */
        Builder afdSignaling(MxfAfdSignaling afdSignaling);
    }

    static final class BuilderImpl implements Builder {
        private String afdSignaling;

        private BuilderImpl() {
        }

        private BuilderImpl(MxfSettings model) {
            afdSignaling(model.afdSignaling);
        }

        public final String getAfdSignaling() {
            return afdSignaling;
        }

        @Override
        public final Builder afdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
            return this;
        }

        @Override
        public final Builder afdSignaling(MxfAfdSignaling afdSignaling) {
            this.afdSignaling(afdSignaling == null ? null : afdSignaling.toString());
            return this;
        }

        public final void setAfdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
        }

        @Override
        public MxfSettings build() {
            return new MxfSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
