/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for MOV Container.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MovSettings implements SdkPojo, Serializable, ToCopyableBuilder<MovSettings.Builder, MovSettings> {
    private static final SdkField<String> CLAP_ATOM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MovSettings::clapAtomAsString)).setter(setter(Builder::clapAtom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clapAtom").build()).build();

    private static final SdkField<String> CSLG_ATOM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MovSettings::cslgAtomAsString)).setter(setter(Builder::cslgAtom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cslgAtom").build()).build();

    private static final SdkField<String> MPEG2_FOUR_CC_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MovSettings::mpeg2FourCCControlAsString)).setter(setter(Builder::mpeg2FourCCControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpeg2FourCCControl").build())
            .build();

    private static final SdkField<String> PADDING_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MovSettings::paddingControlAsString)).setter(setter(Builder::paddingControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paddingControl").build()).build();

    private static final SdkField<String> REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MovSettings::referenceAsString)).setter(setter(Builder::reference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLAP_ATOM_FIELD,
            CSLG_ATOM_FIELD, MPEG2_FOUR_CC_CONTROL_FIELD, PADDING_CONTROL_FIELD, REFERENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clapAtom;

    private final String cslgAtom;

    private final String mpeg2FourCCControl;

    private final String paddingControl;

    private final String reference;

    private MovSettings(BuilderImpl builder) {
        this.clapAtom = builder.clapAtom;
        this.cslgAtom = builder.cslgAtom;
        this.mpeg2FourCCControl = builder.mpeg2FourCCControl;
        this.paddingControl = builder.paddingControl;
        this.reference = builder.reference;
    }

    /**
     * When enabled, include 'clap' atom if appropriate for the video output settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clapAtom} will
     * return {@link MovClapAtom#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clapAtomAsString}.
     * </p>
     * 
     * @return When enabled, include 'clap' atom if appropriate for the video output settings.
     * @see MovClapAtom
     */
    public MovClapAtom clapAtom() {
        return MovClapAtom.fromValue(clapAtom);
    }

    /**
     * When enabled, include 'clap' atom if appropriate for the video output settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clapAtom} will
     * return {@link MovClapAtom#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clapAtomAsString}.
     * </p>
     * 
     * @return When enabled, include 'clap' atom if appropriate for the video output settings.
     * @see MovClapAtom
     */
    public String clapAtomAsString() {
        return clapAtom;
    }

    /**
     * When enabled, file composition times will start at zero, composition times in the 'ctts' (composition time to
     * sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box will be included
     * per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cslgAtom} will
     * return {@link MovCslgAtom#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cslgAtomAsString}.
     * </p>
     * 
     * @return When enabled, file composition times will start at zero, composition times in the 'ctts' (composition
     *         time to sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box
     *         will be included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
     * @see MovCslgAtom
     */
    public MovCslgAtom cslgAtom() {
        return MovCslgAtom.fromValue(cslgAtom);
    }

    /**
     * When enabled, file composition times will start at zero, composition times in the 'ctts' (composition time to
     * sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box will be included
     * per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cslgAtom} will
     * return {@link MovCslgAtom#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cslgAtomAsString}.
     * </p>
     * 
     * @return When enabled, file composition times will start at zero, composition times in the 'ctts' (composition
     *         time to sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box
     *         will be included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
     * @see MovCslgAtom
     */
    public String cslgAtomAsString() {
        return cslgAtom;
    }

    /**
     * When set to XDCAM, writes MPEG2 video streams into the QuickTime file using XDCAM fourcc codes. This increases
     * compatibility with Apple editors and players, but may decrease compatibility with other players. Only applicable
     * when the video codec is MPEG2.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mpeg2FourCCControl} will return {@link MovMpeg2FourCCControl#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mpeg2FourCCControlAsString}.
     * </p>
     * 
     * @return When set to XDCAM, writes MPEG2 video streams into the QuickTime file using XDCAM fourcc codes. This
     *         increases compatibility with Apple editors and players, but may decrease compatibility with other
     *         players. Only applicable when the video codec is MPEG2.
     * @see MovMpeg2FourCCControl
     */
    public MovMpeg2FourCCControl mpeg2FourCCControl() {
        return MovMpeg2FourCCControl.fromValue(mpeg2FourCCControl);
    }

    /**
     * When set to XDCAM, writes MPEG2 video streams into the QuickTime file using XDCAM fourcc codes. This increases
     * compatibility with Apple editors and players, but may decrease compatibility with other players. Only applicable
     * when the video codec is MPEG2.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mpeg2FourCCControl} will return {@link MovMpeg2FourCCControl#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mpeg2FourCCControlAsString}.
     * </p>
     * 
     * @return When set to XDCAM, writes MPEG2 video streams into the QuickTime file using XDCAM fourcc codes. This
     *         increases compatibility with Apple editors and players, but may decrease compatibility with other
     *         players. Only applicable when the video codec is MPEG2.
     * @see MovMpeg2FourCCControl
     */
    public String mpeg2FourCCControlAsString() {
        return mpeg2FourCCControl;
    }

    /**
     * If set to OMNEON, inserts Omneon-compatible padding
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paddingControl}
     * will return {@link MovPaddingControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #paddingControlAsString}.
     * </p>
     * 
     * @return If set to OMNEON, inserts Omneon-compatible padding
     * @see MovPaddingControl
     */
    public MovPaddingControl paddingControl() {
        return MovPaddingControl.fromValue(paddingControl);
    }

    /**
     * If set to OMNEON, inserts Omneon-compatible padding
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paddingControl}
     * will return {@link MovPaddingControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #paddingControlAsString}.
     * </p>
     * 
     * @return If set to OMNEON, inserts Omneon-compatible padding
     * @see MovPaddingControl
     */
    public String paddingControlAsString() {
        return paddingControl;
    }

    /**
     * Always keep the default value (SELF_CONTAINED) for this setting.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reference} will
     * return {@link MovReference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #referenceAsString}.
     * </p>
     * 
     * @return Always keep the default value (SELF_CONTAINED) for this setting.
     * @see MovReference
     */
    public MovReference reference() {
        return MovReference.fromValue(reference);
    }

    /**
     * Always keep the default value (SELF_CONTAINED) for this setting.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reference} will
     * return {@link MovReference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #referenceAsString}.
     * </p>
     * 
     * @return Always keep the default value (SELF_CONTAINED) for this setting.
     * @see MovReference
     */
    public String referenceAsString() {
        return reference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clapAtomAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cslgAtomAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mpeg2FourCCControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(paddingControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(referenceAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MovSettings)) {
            return false;
        }
        MovSettings other = (MovSettings) obj;
        return Objects.equals(clapAtomAsString(), other.clapAtomAsString())
                && Objects.equals(cslgAtomAsString(), other.cslgAtomAsString())
                && Objects.equals(mpeg2FourCCControlAsString(), other.mpeg2FourCCControlAsString())
                && Objects.equals(paddingControlAsString(), other.paddingControlAsString())
                && Objects.equals(referenceAsString(), other.referenceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MovSettings").add("ClapAtom", clapAtomAsString()).add("CslgAtom", cslgAtomAsString())
                .add("Mpeg2FourCCControl", mpeg2FourCCControlAsString()).add("PaddingControl", paddingControlAsString())
                .add("Reference", referenceAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClapAtom":
            return Optional.ofNullable(clazz.cast(clapAtomAsString()));
        case "CslgAtom":
            return Optional.ofNullable(clazz.cast(cslgAtomAsString()));
        case "Mpeg2FourCCControl":
            return Optional.ofNullable(clazz.cast(mpeg2FourCCControlAsString()));
        case "PaddingControl":
            return Optional.ofNullable(clazz.cast(paddingControlAsString()));
        case "Reference":
            return Optional.ofNullable(clazz.cast(referenceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MovSettings, T> g) {
        return obj -> g.apply((MovSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MovSettings> {
        /**
         * When enabled, include 'clap' atom if appropriate for the video output settings.
         * 
         * @param clapAtom
         *        When enabled, include 'clap' atom if appropriate for the video output settings.
         * @see MovClapAtom
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MovClapAtom
         */
        Builder clapAtom(String clapAtom);

        /**
         * When enabled, include 'clap' atom if appropriate for the video output settings.
         * 
         * @param clapAtom
         *        When enabled, include 'clap' atom if appropriate for the video output settings.
         * @see MovClapAtom
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MovClapAtom
         */
        Builder clapAtom(MovClapAtom clapAtom);

        /**
         * When enabled, file composition times will start at zero, composition times in the 'ctts' (composition time to
         * sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box will be
         * included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
         * 
         * @param cslgAtom
         *        When enabled, file composition times will start at zero, composition times in the 'ctts' (composition
         *        time to sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box
         *        will be included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
         * @see MovCslgAtom
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MovCslgAtom
         */
        Builder cslgAtom(String cslgAtom);

        /**
         * When enabled, file composition times will start at zero, composition times in the 'ctts' (composition time to
         * sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box will be
         * included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
         * 
         * @param cslgAtom
         *        When enabled, file composition times will start at zero, composition times in the 'ctts' (composition
         *        time to sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box
         *        will be included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
         * @see MovCslgAtom
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MovCslgAtom
         */
        Builder cslgAtom(MovCslgAtom cslgAtom);

        /**
         * When set to XDCAM, writes MPEG2 video streams into the QuickTime file using XDCAM fourcc codes. This
         * increases compatibility with Apple editors and players, but may decrease compatibility with other players.
         * Only applicable when the video codec is MPEG2.
         * 
         * @param mpeg2FourCCControl
         *        When set to XDCAM, writes MPEG2 video streams into the QuickTime file using XDCAM fourcc codes. This
         *        increases compatibility with Apple editors and players, but may decrease compatibility with other
         *        players. Only applicable when the video codec is MPEG2.
         * @see MovMpeg2FourCCControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MovMpeg2FourCCControl
         */
        Builder mpeg2FourCCControl(String mpeg2FourCCControl);

        /**
         * When set to XDCAM, writes MPEG2 video streams into the QuickTime file using XDCAM fourcc codes. This
         * increases compatibility with Apple editors and players, but may decrease compatibility with other players.
         * Only applicable when the video codec is MPEG2.
         * 
         * @param mpeg2FourCCControl
         *        When set to XDCAM, writes MPEG2 video streams into the QuickTime file using XDCAM fourcc codes. This
         *        increases compatibility with Apple editors and players, but may decrease compatibility with other
         *        players. Only applicable when the video codec is MPEG2.
         * @see MovMpeg2FourCCControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MovMpeg2FourCCControl
         */
        Builder mpeg2FourCCControl(MovMpeg2FourCCControl mpeg2FourCCControl);

        /**
         * If set to OMNEON, inserts Omneon-compatible padding
         * 
         * @param paddingControl
         *        If set to OMNEON, inserts Omneon-compatible padding
         * @see MovPaddingControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MovPaddingControl
         */
        Builder paddingControl(String paddingControl);

        /**
         * If set to OMNEON, inserts Omneon-compatible padding
         * 
         * @param paddingControl
         *        If set to OMNEON, inserts Omneon-compatible padding
         * @see MovPaddingControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MovPaddingControl
         */
        Builder paddingControl(MovPaddingControl paddingControl);

        /**
         * Always keep the default value (SELF_CONTAINED) for this setting.
         * 
         * @param reference
         *        Always keep the default value (SELF_CONTAINED) for this setting.
         * @see MovReference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MovReference
         */
        Builder reference(String reference);

        /**
         * Always keep the default value (SELF_CONTAINED) for this setting.
         * 
         * @param reference
         *        Always keep the default value (SELF_CONTAINED) for this setting.
         * @see MovReference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MovReference
         */
        Builder reference(MovReference reference);
    }

    static final class BuilderImpl implements Builder {
        private String clapAtom;

        private String cslgAtom;

        private String mpeg2FourCCControl;

        private String paddingControl;

        private String reference;

        private BuilderImpl() {
        }

        private BuilderImpl(MovSettings model) {
            clapAtom(model.clapAtom);
            cslgAtom(model.cslgAtom);
            mpeg2FourCCControl(model.mpeg2FourCCControl);
            paddingControl(model.paddingControl);
            reference(model.reference);
        }

        public final String getClapAtom() {
            return clapAtom;
        }

        @Override
        public final Builder clapAtom(String clapAtom) {
            this.clapAtom = clapAtom;
            return this;
        }

        @Override
        public final Builder clapAtom(MovClapAtom clapAtom) {
            this.clapAtom(clapAtom == null ? null : clapAtom.toString());
            return this;
        }

        public final void setClapAtom(String clapAtom) {
            this.clapAtom = clapAtom;
        }

        public final String getCslgAtom() {
            return cslgAtom;
        }

        @Override
        public final Builder cslgAtom(String cslgAtom) {
            this.cslgAtom = cslgAtom;
            return this;
        }

        @Override
        public final Builder cslgAtom(MovCslgAtom cslgAtom) {
            this.cslgAtom(cslgAtom == null ? null : cslgAtom.toString());
            return this;
        }

        public final void setCslgAtom(String cslgAtom) {
            this.cslgAtom = cslgAtom;
        }

        public final String getMpeg2FourCCControl() {
            return mpeg2FourCCControl;
        }

        @Override
        public final Builder mpeg2FourCCControl(String mpeg2FourCCControl) {
            this.mpeg2FourCCControl = mpeg2FourCCControl;
            return this;
        }

        @Override
        public final Builder mpeg2FourCCControl(MovMpeg2FourCCControl mpeg2FourCCControl) {
            this.mpeg2FourCCControl(mpeg2FourCCControl == null ? null : mpeg2FourCCControl.toString());
            return this;
        }

        public final void setMpeg2FourCCControl(String mpeg2FourCCControl) {
            this.mpeg2FourCCControl = mpeg2FourCCControl;
        }

        public final String getPaddingControl() {
            return paddingControl;
        }

        @Override
        public final Builder paddingControl(String paddingControl) {
            this.paddingControl = paddingControl;
            return this;
        }

        @Override
        public final Builder paddingControl(MovPaddingControl paddingControl) {
            this.paddingControl(paddingControl == null ? null : paddingControl.toString());
            return this;
        }

        public final void setPaddingControl(String paddingControl) {
            this.paddingControl = paddingControl;
        }

        public final String getReference() {
            return reference;
        }

        @Override
        public final Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public final Builder reference(MovReference reference) {
            this.reference(reference == null ? null : reference.toString());
            return this;
        }

        public final void setReference(String reference) {
            this.reference = reference;
        }

        @Override
        public MovSettings build() {
            return new MovSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
