/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for SCTE-35 signals from ESAM. Include this in your job settings to put SCTE-35 markers in your HLS and
 * transport stream outputs at the insertion points that you specify in an ESAM XML document. Provide the document in
 * the setting SCC XML (sccXml).
 */
@Generated("software.amazon.awssdk:codegen")
public final class M2tsScte35Esam implements SdkPojo, Serializable, ToCopyableBuilder<M2tsScte35Esam.Builder, M2tsScte35Esam> {
    private static final SdkField<Integer> SCTE35_ESAM_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(M2tsScte35Esam::scte35EsamPid)).setter(setter(Builder::scte35EsamPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35EsamPid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCTE35_ESAM_PID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer scte35EsamPid;

    private M2tsScte35Esam(BuilderImpl builder) {
        this.scte35EsamPid = builder.scte35EsamPid;
    }

    /**
     * Packet Identifier (PID) of the SCTE-35 stream in the transport stream generated by ESAM.
     * 
     * @return Packet Identifier (PID) of the SCTE-35 stream in the transport stream generated by ESAM.
     */
    public Integer scte35EsamPid() {
        return scte35EsamPid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scte35EsamPid());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2tsScte35Esam)) {
            return false;
        }
        M2tsScte35Esam other = (M2tsScte35Esam) obj;
        return Objects.equals(scte35EsamPid(), other.scte35EsamPid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("M2tsScte35Esam").add("Scte35EsamPid", scte35EsamPid()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scte35EsamPid":
            return Optional.ofNullable(clazz.cast(scte35EsamPid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<M2tsScte35Esam, T> g) {
        return obj -> g.apply((M2tsScte35Esam) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, M2tsScte35Esam> {
        /**
         * Packet Identifier (PID) of the SCTE-35 stream in the transport stream generated by ESAM.
         * 
         * @param scte35EsamPid
         *        Packet Identifier (PID) of the SCTE-35 stream in the transport stream generated by ESAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte35EsamPid(Integer scte35EsamPid);
    }

    static final class BuilderImpl implements Builder {
        private Integer scte35EsamPid;

        private BuilderImpl() {
        }

        private BuilderImpl(M2tsScte35Esam model) {
            scte35EsamPid(model.scte35EsamPid);
        }

        public final Integer getScte35EsamPid() {
            return scte35EsamPid;
        }

        @Override
        public final Builder scte35EsamPid(Integer scte35EsamPid) {
            this.scte35EsamPid = scte35EsamPid;
            return this;
        }

        public final void setScte35EsamPid(Integer scte35EsamPid) {
            this.scte35EsamPid = scte35EsamPid;
        }

        @Override
        public M2tsScte35Esam build() {
            return new M2tsScte35Esam(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
