/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created
 * from it.
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobTemplateSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<JobTemplateSettings.Builder, JobTemplateSettings> {
    private static final SdkField<Integer> AD_AVAIL_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(JobTemplateSettings::adAvailOffset)).setter(setter(Builder::adAvailOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adAvailOffset").build()).build();

    private static final SdkField<AvailBlanking> AVAIL_BLANKING_FIELD = SdkField
            .<AvailBlanking> builder(MarshallingType.SDK_POJO).getter(getter(JobTemplateSettings::availBlanking))
            .setter(setter(Builder::availBlanking)).constructor(AvailBlanking::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availBlanking").build()).build();

    private static final SdkField<EsamSettings> ESAM_FIELD = SdkField.<EsamSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(JobTemplateSettings::esam)).setter(setter(Builder::esam)).constructor(EsamSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("esam").build()).build();

    private static final SdkField<List<InputTemplate>> INPUTS_FIELD = SdkField
            .<List<InputTemplate>> builder(MarshallingType.LIST)
            .getter(getter(JobTemplateSettings::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputTemplate> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputTemplate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MotionImageInserter> MOTION_IMAGE_INSERTER_FIELD = SdkField
            .<MotionImageInserter> builder(MarshallingType.SDK_POJO).getter(getter(JobTemplateSettings::motionImageInserter))
            .setter(setter(Builder::motionImageInserter)).constructor(MotionImageInserter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("motionImageInserter").build())
            .build();

    private static final SdkField<NielsenConfiguration> NIELSEN_CONFIGURATION_FIELD = SdkField
            .<NielsenConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(JobTemplateSettings::nielsenConfiguration))
            .setter(setter(Builder::nielsenConfiguration)).constructor(NielsenConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenConfiguration").build())
            .build();

    private static final SdkField<List<OutputGroup>> OUTPUT_GROUPS_FIELD = SdkField
            .<List<OutputGroup>> builder(MarshallingType.LIST)
            .getter(getter(JobTemplateSettings::outputGroups))
            .setter(setter(Builder::outputGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TimecodeConfig> TIMECODE_CONFIG_FIELD = SdkField
            .<TimecodeConfig> builder(MarshallingType.SDK_POJO).getter(getter(JobTemplateSettings::timecodeConfig))
            .setter(setter(Builder::timecodeConfig)).constructor(TimecodeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeConfig").build()).build();

    private static final SdkField<TimedMetadataInsertion> TIMED_METADATA_INSERTION_FIELD = SdkField
            .<TimedMetadataInsertion> builder(MarshallingType.SDK_POJO)
            .getter(getter(JobTemplateSettings::timedMetadataInsertion)).setter(setter(Builder::timedMetadataInsertion))
            .constructor(TimedMetadataInsertion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataInsertion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_AVAIL_OFFSET_FIELD,
            AVAIL_BLANKING_FIELD, ESAM_FIELD, INPUTS_FIELD, MOTION_IMAGE_INSERTER_FIELD, NIELSEN_CONFIGURATION_FIELD,
            OUTPUT_GROUPS_FIELD, TIMECODE_CONFIG_FIELD, TIMED_METADATA_INSERTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer adAvailOffset;

    private final AvailBlanking availBlanking;

    private final EsamSettings esam;

    private final List<InputTemplate> inputs;

    private final MotionImageInserter motionImageInserter;

    private final NielsenConfiguration nielsenConfiguration;

    private final List<OutputGroup> outputGroups;

    private final TimecodeConfig timecodeConfig;

    private final TimedMetadataInsertion timedMetadataInsertion;

    private JobTemplateSettings(BuilderImpl builder) {
        this.adAvailOffset = builder.adAvailOffset;
        this.availBlanking = builder.availBlanking;
        this.esam = builder.esam;
        this.inputs = builder.inputs;
        this.motionImageInserter = builder.motionImageInserter;
        this.nielsenConfiguration = builder.nielsenConfiguration;
        this.outputGroups = builder.outputGroups;
        this.timecodeConfig = builder.timecodeConfig;
        this.timedMetadataInsertion = builder.timedMetadataInsertion;
    }

    /**
     * When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time.
     * 
     * @return When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time.
     */
    public Integer adAvailOffset() {
        return adAvailOffset;
    }

    /**
     * Settings for ad avail blanking. Video can be blanked or overlaid with an image, and audio muted during SCTE-35
     * triggered ad avails.
     * 
     * @return Settings for ad avail blanking. Video can be blanked or overlaid with an image, and audio muted during
     *         SCTE-35 triggered ad avails.
     */
    public AvailBlanking availBlanking() {
        return availBlanking;
    }

    /**
     * Settings for Event Signaling And Messaging (ESAM).
     * 
     * @return Settings for Event Signaling And Messaging (ESAM).
     */
    public EsamSettings esam() {
        return esam;
    }

    /**
     * Returns true if the Inputs property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * Use Inputs (inputs) to define the source file used in the transcode job. There can only be one input in a job
     * template. Using the API, you can include multiple inputs when referencing a job template.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Use Inputs (inputs) to define the source file used in the transcode job. There can only be one input in a
     *         job template. Using the API, you can include multiple inputs when referencing a job template.
     */
    public List<InputTemplate> inputs() {
        return inputs;
    }

    /**
     * Overlay motion graphics on top of your video. The motion graphics that you specify here appear on all outputs in
     * all output groups.
     * 
     * @return Overlay motion graphics on top of your video. The motion graphics that you specify here appear on all
     *         outputs in all output groups.
     */
    public MotionImageInserter motionImageInserter() {
        return motionImageInserter;
    }

    /**
     * Settings for your Nielsen configuration. If you don't do Nielsen measurement and analytics, ignore these
     * settings. When you enable Nielsen configuration (nielsenConfiguration), MediaConvert enables PCM to ID3 tagging
     * for all outputs in the job. To enable Nielsen configuration programmatically, include an instance of
     * nielsenConfiguration in your JSON job specification. Even if you don't include any children of
     * nielsenConfiguration, you still enable the setting.
     * 
     * @return Settings for your Nielsen configuration. If you don't do Nielsen measurement and analytics, ignore these
     *         settings. When you enable Nielsen configuration (nielsenConfiguration), MediaConvert enables PCM to ID3
     *         tagging for all outputs in the job. To enable Nielsen configuration programmatically, include an instance
     *         of nielsenConfiguration in your JSON job specification. Even if you don't include any children of
     *         nielsenConfiguration, you still enable the setting.
     */
    public NielsenConfiguration nielsenConfiguration() {
        return nielsenConfiguration;
    }

    /**
     * Returns true if the OutputGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasOutputGroups() {
        return outputGroups != null && !(outputGroups instanceof SdkAutoConstructList);
    }

    /**
     * (OutputGroups) contains one group of settings for each set of outputs that share a common package type. All
     * unpackaged files (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a single output group as
     * well. Required in (OutputGroups) is a group of settings that apply to the whole group. This required object
     * depends on the value you set for (Type) under (OutputGroups)>(OutputGroupSettings). Type, settings object pairs
     * are as follows. * FILE_GROUP_SETTINGS, FileGroupSettings * HLS_GROUP_SETTINGS, HlsGroupSettings *
     * DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings * MS_SMOOTH_GROUP_SETTINGS, MsSmoothGroupSettings *
     * CMAF_GROUP_SETTINGS, CmafGroupSettings
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutputGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (OutputGroups) contains one group of settings for each set of outputs that share a common package type.
     *         All unpackaged files (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a single output
     *         group as well. Required in (OutputGroups) is a group of settings that apply to the whole group. This
     *         required object depends on the value you set for (Type) under (OutputGroups)>(OutputGroupSettings). Type,
     *         settings object pairs are as follows. * FILE_GROUP_SETTINGS, FileGroupSettings * HLS_GROUP_SETTINGS,
     *         HlsGroupSettings * DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings * MS_SMOOTH_GROUP_SETTINGS,
     *         MsSmoothGroupSettings * CMAF_GROUP_SETTINGS, CmafGroupSettings
     */
    public List<OutputGroup> outputGroups() {
        return outputGroups;
    }

    /**
     * Contains settings used to acquire and adjust timecode information from inputs.
     * 
     * @return Contains settings used to acquire and adjust timecode information from inputs.
     */
    public TimecodeConfig timecodeConfig() {
        return timecodeConfig;
    }

    /**
     * Enable Timed metadata insertion (TimedMetadataInsertion) to include ID3 tags in your job. To include timed
     * metadata, you must enable it here, enable it in each output container, and specify tags and timecodes in ID3
     * insertion (Id3Insertion) objects.
     * 
     * @return Enable Timed metadata insertion (TimedMetadataInsertion) to include ID3 tags in your job. To include
     *         timed metadata, you must enable it here, enable it in each output container, and specify tags and
     *         timecodes in ID3 insertion (Id3Insertion) objects.
     */
    public TimedMetadataInsertion timedMetadataInsertion() {
        return timedMetadataInsertion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adAvailOffset());
        hashCode = 31 * hashCode + Objects.hashCode(availBlanking());
        hashCode = 31 * hashCode + Objects.hashCode(esam());
        hashCode = 31 * hashCode + Objects.hashCode(inputs());
        hashCode = 31 * hashCode + Objects.hashCode(motionImageInserter());
        hashCode = 31 * hashCode + Objects.hashCode(nielsenConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(outputGroups());
        hashCode = 31 * hashCode + Objects.hashCode(timecodeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(timedMetadataInsertion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobTemplateSettings)) {
            return false;
        }
        JobTemplateSettings other = (JobTemplateSettings) obj;
        return Objects.equals(adAvailOffset(), other.adAvailOffset()) && Objects.equals(availBlanking(), other.availBlanking())
                && Objects.equals(esam(), other.esam()) && Objects.equals(inputs(), other.inputs())
                && Objects.equals(motionImageInserter(), other.motionImageInserter())
                && Objects.equals(nielsenConfiguration(), other.nielsenConfiguration())
                && Objects.equals(outputGroups(), other.outputGroups())
                && Objects.equals(timecodeConfig(), other.timecodeConfig())
                && Objects.equals(timedMetadataInsertion(), other.timedMetadataInsertion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobTemplateSettings").add("AdAvailOffset", adAvailOffset())
                .add("AvailBlanking", availBlanking()).add("Esam", esam()).add("Inputs", inputs())
                .add("MotionImageInserter", motionImageInserter()).add("NielsenConfiguration", nielsenConfiguration())
                .add("OutputGroups", outputGroups()).add("TimecodeConfig", timecodeConfig())
                .add("TimedMetadataInsertion", timedMetadataInsertion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdAvailOffset":
            return Optional.ofNullable(clazz.cast(adAvailOffset()));
        case "AvailBlanking":
            return Optional.ofNullable(clazz.cast(availBlanking()));
        case "Esam":
            return Optional.ofNullable(clazz.cast(esam()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "MotionImageInserter":
            return Optional.ofNullable(clazz.cast(motionImageInserter()));
        case "NielsenConfiguration":
            return Optional.ofNullable(clazz.cast(nielsenConfiguration()));
        case "OutputGroups":
            return Optional.ofNullable(clazz.cast(outputGroups()));
        case "TimecodeConfig":
            return Optional.ofNullable(clazz.cast(timecodeConfig()));
        case "TimedMetadataInsertion":
            return Optional.ofNullable(clazz.cast(timedMetadataInsertion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobTemplateSettings, T> g) {
        return obj -> g.apply((JobTemplateSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobTemplateSettings> {
        /**
         * When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time.
         * 
         * @param adAvailOffset
         *        When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adAvailOffset(Integer adAvailOffset);

        /**
         * Settings for ad avail blanking. Video can be blanked or overlaid with an image, and audio muted during
         * SCTE-35 triggered ad avails.
         * 
         * @param availBlanking
         *        Settings for ad avail blanking. Video can be blanked or overlaid with an image, and audio muted during
         *        SCTE-35 triggered ad avails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availBlanking(AvailBlanking availBlanking);

        /**
         * Settings for ad avail blanking. Video can be blanked or overlaid with an image, and audio muted during
         * SCTE-35 triggered ad avails. This is a convenience that creates an instance of the
         * {@link AvailBlanking.Builder} avoiding the need to create one manually via {@link AvailBlanking#builder()}.
         *
         * When the {@link Consumer} completes, {@link AvailBlanking.Builder#build()} is called immediately and its
         * result is passed to {@link #availBlanking(AvailBlanking)}.
         * 
         * @param availBlanking
         *        a consumer that will call methods on {@link AvailBlanking.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availBlanking(AvailBlanking)
         */
        default Builder availBlanking(Consumer<AvailBlanking.Builder> availBlanking) {
            return availBlanking(AvailBlanking.builder().applyMutation(availBlanking).build());
        }

        /**
         * Settings for Event Signaling And Messaging (ESAM).
         * 
         * @param esam
         *        Settings for Event Signaling And Messaging (ESAM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder esam(EsamSettings esam);

        /**
         * Settings for Event Signaling And Messaging (ESAM). This is a convenience that creates an instance of the
         * {@link EsamSettings.Builder} avoiding the need to create one manually via {@link EsamSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link EsamSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #esam(EsamSettings)}.
         * 
         * @param esam
         *        a consumer that will call methods on {@link EsamSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #esam(EsamSettings)
         */
        default Builder esam(Consumer<EsamSettings.Builder> esam) {
            return esam(EsamSettings.builder().applyMutation(esam).build());
        }

        /**
         * Use Inputs (inputs) to define the source file used in the transcode job. There can only be one input in a job
         * template. Using the API, you can include multiple inputs when referencing a job template.
         * 
         * @param inputs
         *        Use Inputs (inputs) to define the source file used in the transcode job. There can only be one input
         *        in a job template. Using the API, you can include multiple inputs when referencing a job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<InputTemplate> inputs);

        /**
         * Use Inputs (inputs) to define the source file used in the transcode job. There can only be one input in a job
         * template. Using the API, you can include multiple inputs when referencing a job template.
         * 
         * @param inputs
         *        Use Inputs (inputs) to define the source file used in the transcode job. There can only be one input
         *        in a job template. Using the API, you can include multiple inputs when referencing a job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(InputTemplate... inputs);

        /**
         * Use Inputs (inputs) to define the source file used in the transcode job. There can only be one input in a job
         * template. Using the API, you can include multiple inputs when referencing a job template. This is a
         * convenience that creates an instance of the {@link List<InputTemplate>.Builder} avoiding the need to create
         * one manually via {@link List<InputTemplate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputTemplate>.Builder#build()} is called immediately and
         * its result is passed to {@link #inputs(List<InputTemplate>)}.
         * 
         * @param inputs
         *        a consumer that will call methods on {@link List<InputTemplate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputs(List<InputTemplate>)
         */
        Builder inputs(Consumer<InputTemplate.Builder>... inputs);

        /**
         * Overlay motion graphics on top of your video. The motion graphics that you specify here appear on all outputs
         * in all output groups.
         * 
         * @param motionImageInserter
         *        Overlay motion graphics on top of your video. The motion graphics that you specify here appear on all
         *        outputs in all output groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder motionImageInserter(MotionImageInserter motionImageInserter);

        /**
         * Overlay motion graphics on top of your video. The motion graphics that you specify here appear on all outputs
         * in all output groups. This is a convenience that creates an instance of the
         * {@link MotionImageInserter.Builder} avoiding the need to create one manually via
         * {@link MotionImageInserter#builder()}.
         *
         * When the {@link Consumer} completes, {@link MotionImageInserter.Builder#build()} is called immediately and
         * its result is passed to {@link #motionImageInserter(MotionImageInserter)}.
         * 
         * @param motionImageInserter
         *        a consumer that will call methods on {@link MotionImageInserter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #motionImageInserter(MotionImageInserter)
         */
        default Builder motionImageInserter(Consumer<MotionImageInserter.Builder> motionImageInserter) {
            return motionImageInserter(MotionImageInserter.builder().applyMutation(motionImageInserter).build());
        }

        /**
         * Settings for your Nielsen configuration. If you don't do Nielsen measurement and analytics, ignore these
         * settings. When you enable Nielsen configuration (nielsenConfiguration), MediaConvert enables PCM to ID3
         * tagging for all outputs in the job. To enable Nielsen configuration programmatically, include an instance of
         * nielsenConfiguration in your JSON job specification. Even if you don't include any children of
         * nielsenConfiguration, you still enable the setting.
         * 
         * @param nielsenConfiguration
         *        Settings for your Nielsen configuration. If you don't do Nielsen measurement and analytics, ignore
         *        these settings. When you enable Nielsen configuration (nielsenConfiguration), MediaConvert enables PCM
         *        to ID3 tagging for all outputs in the job. To enable Nielsen configuration programmatically, include
         *        an instance of nielsenConfiguration in your JSON job specification. Even if you don't include any
         *        children of nielsenConfiguration, you still enable the setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nielsenConfiguration(NielsenConfiguration nielsenConfiguration);

        /**
         * Settings for your Nielsen configuration. If you don't do Nielsen measurement and analytics, ignore these
         * settings. When you enable Nielsen configuration (nielsenConfiguration), MediaConvert enables PCM to ID3
         * tagging for all outputs in the job. To enable Nielsen configuration programmatically, include an instance of
         * nielsenConfiguration in your JSON job specification. Even if you don't include any children of
         * nielsenConfiguration, you still enable the setting. This is a convenience that creates an instance of the
         * {@link NielsenConfiguration.Builder} avoiding the need to create one manually via
         * {@link NielsenConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NielsenConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #nielsenConfiguration(NielsenConfiguration)}.
         * 
         * @param nielsenConfiguration
         *        a consumer that will call methods on {@link NielsenConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nielsenConfiguration(NielsenConfiguration)
         */
        default Builder nielsenConfiguration(Consumer<NielsenConfiguration.Builder> nielsenConfiguration) {
            return nielsenConfiguration(NielsenConfiguration.builder().applyMutation(nielsenConfiguration).build());
        }

        /**
         * (OutputGroups) contains one group of settings for each set of outputs that share a common package type. All
         * unpackaged files (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a single output group
         * as well. Required in (OutputGroups) is a group of settings that apply to the whole group. This required
         * object depends on the value you set for (Type) under (OutputGroups)>(OutputGroupSettings). Type, settings
         * object pairs are as follows. * FILE_GROUP_SETTINGS, FileGroupSettings * HLS_GROUP_SETTINGS, HlsGroupSettings
         * * DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings * MS_SMOOTH_GROUP_SETTINGS, MsSmoothGroupSettings *
         * CMAF_GROUP_SETTINGS, CmafGroupSettings
         * 
         * @param outputGroups
         *        (OutputGroups) contains one group of settings for each set of outputs that share a common package
         *        type. All unpackaged files (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a
         *        single output group as well. Required in (OutputGroups) is a group of settings that apply to the whole
         *        group. This required object depends on the value you set for (Type) under
         *        (OutputGroups)>(OutputGroupSettings). Type, settings object pairs are as follows. *
         *        FILE_GROUP_SETTINGS, FileGroupSettings * HLS_GROUP_SETTINGS, HlsGroupSettings *
         *        DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings * MS_SMOOTH_GROUP_SETTINGS, MsSmoothGroupSettings *
         *        CMAF_GROUP_SETTINGS, CmafGroupSettings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputGroups(Collection<OutputGroup> outputGroups);

        /**
         * (OutputGroups) contains one group of settings for each set of outputs that share a common package type. All
         * unpackaged files (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a single output group
         * as well. Required in (OutputGroups) is a group of settings that apply to the whole group. This required
         * object depends on the value you set for (Type) under (OutputGroups)>(OutputGroupSettings). Type, settings
         * object pairs are as follows. * FILE_GROUP_SETTINGS, FileGroupSettings * HLS_GROUP_SETTINGS, HlsGroupSettings
         * * DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings * MS_SMOOTH_GROUP_SETTINGS, MsSmoothGroupSettings *
         * CMAF_GROUP_SETTINGS, CmafGroupSettings
         * 
         * @param outputGroups
         *        (OutputGroups) contains one group of settings for each set of outputs that share a common package
         *        type. All unpackaged files (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a
         *        single output group as well. Required in (OutputGroups) is a group of settings that apply to the whole
         *        group. This required object depends on the value you set for (Type) under
         *        (OutputGroups)>(OutputGroupSettings). Type, settings object pairs are as follows. *
         *        FILE_GROUP_SETTINGS, FileGroupSettings * HLS_GROUP_SETTINGS, HlsGroupSettings *
         *        DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings * MS_SMOOTH_GROUP_SETTINGS, MsSmoothGroupSettings *
         *        CMAF_GROUP_SETTINGS, CmafGroupSettings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputGroups(OutputGroup... outputGroups);

        /**
         * (OutputGroups) contains one group of settings for each set of outputs that share a common package type. All
         * unpackaged files (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a single output group
         * as well. Required in (OutputGroups) is a group of settings that apply to the whole group. This required
         * object depends on the value you set for (Type) under (OutputGroups)>(OutputGroupSettings). Type, settings
         * object pairs are as follows. * FILE_GROUP_SETTINGS, FileGroupSettings * HLS_GROUP_SETTINGS, HlsGroupSettings
         * * DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings * MS_SMOOTH_GROUP_SETTINGS, MsSmoothGroupSettings *
         * CMAF_GROUP_SETTINGS, CmafGroupSettings This is a convenience that creates an instance of the {@link List
         * <OutputGroup>.Builder} avoiding the need to create one manually via {@link List<OutputGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OutputGroup>.Builder#build()} is called immediately and its
         * result is passed to {@link #outputGroups(List<OutputGroup>)}.
         * 
         * @param outputGroups
         *        a consumer that will call methods on {@link List<OutputGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputGroups(List<OutputGroup>)
         */
        Builder outputGroups(Consumer<OutputGroup.Builder>... outputGroups);

        /**
         * Contains settings used to acquire and adjust timecode information from inputs.
         * 
         * @param timecodeConfig
         *        Contains settings used to acquire and adjust timecode information from inputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timecodeConfig(TimecodeConfig timecodeConfig);

        /**
         * Contains settings used to acquire and adjust timecode information from inputs. This is a convenience that
         * creates an instance of the {@link TimecodeConfig.Builder} avoiding the need to create one manually via
         * {@link TimecodeConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimecodeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #timecodeConfig(TimecodeConfig)}.
         * 
         * @param timecodeConfig
         *        a consumer that will call methods on {@link TimecodeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timecodeConfig(TimecodeConfig)
         */
        default Builder timecodeConfig(Consumer<TimecodeConfig.Builder> timecodeConfig) {
            return timecodeConfig(TimecodeConfig.builder().applyMutation(timecodeConfig).build());
        }

        /**
         * Enable Timed metadata insertion (TimedMetadataInsertion) to include ID3 tags in your job. To include timed
         * metadata, you must enable it here, enable it in each output container, and specify tags and timecodes in ID3
         * insertion (Id3Insertion) objects.
         * 
         * @param timedMetadataInsertion
         *        Enable Timed metadata insertion (TimedMetadataInsertion) to include ID3 tags in your job. To include
         *        timed metadata, you must enable it here, enable it in each output container, and specify tags and
         *        timecodes in ID3 insertion (Id3Insertion) objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timedMetadataInsertion(TimedMetadataInsertion timedMetadataInsertion);

        /**
         * Enable Timed metadata insertion (TimedMetadataInsertion) to include ID3 tags in your job. To include timed
         * metadata, you must enable it here, enable it in each output container, and specify tags and timecodes in ID3
         * insertion (Id3Insertion) objects. This is a convenience that creates an instance of the
         * {@link TimedMetadataInsertion.Builder} avoiding the need to create one manually via
         * {@link TimedMetadataInsertion#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimedMetadataInsertion.Builder#build()} is called immediately and
         * its result is passed to {@link #timedMetadataInsertion(TimedMetadataInsertion)}.
         * 
         * @param timedMetadataInsertion
         *        a consumer that will call methods on {@link TimedMetadataInsertion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timedMetadataInsertion(TimedMetadataInsertion)
         */
        default Builder timedMetadataInsertion(Consumer<TimedMetadataInsertion.Builder> timedMetadataInsertion) {
            return timedMetadataInsertion(TimedMetadataInsertion.builder().applyMutation(timedMetadataInsertion).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer adAvailOffset;

        private AvailBlanking availBlanking;

        private EsamSettings esam;

        private List<InputTemplate> inputs = DefaultSdkAutoConstructList.getInstance();

        private MotionImageInserter motionImageInserter;

        private NielsenConfiguration nielsenConfiguration;

        private List<OutputGroup> outputGroups = DefaultSdkAutoConstructList.getInstance();

        private TimecodeConfig timecodeConfig;

        private TimedMetadataInsertion timedMetadataInsertion;

        private BuilderImpl() {
        }

        private BuilderImpl(JobTemplateSettings model) {
            adAvailOffset(model.adAvailOffset);
            availBlanking(model.availBlanking);
            esam(model.esam);
            inputs(model.inputs);
            motionImageInserter(model.motionImageInserter);
            nielsenConfiguration(model.nielsenConfiguration);
            outputGroups(model.outputGroups);
            timecodeConfig(model.timecodeConfig);
            timedMetadataInsertion(model.timedMetadataInsertion);
        }

        public final Integer getAdAvailOffset() {
            return adAvailOffset;
        }

        @Override
        public final Builder adAvailOffset(Integer adAvailOffset) {
            this.adAvailOffset = adAvailOffset;
            return this;
        }

        public final void setAdAvailOffset(Integer adAvailOffset) {
            this.adAvailOffset = adAvailOffset;
        }

        public final AvailBlanking.Builder getAvailBlanking() {
            return availBlanking != null ? availBlanking.toBuilder() : null;
        }

        @Override
        public final Builder availBlanking(AvailBlanking availBlanking) {
            this.availBlanking = availBlanking;
            return this;
        }

        public final void setAvailBlanking(AvailBlanking.BuilderImpl availBlanking) {
            this.availBlanking = availBlanking != null ? availBlanking.build() : null;
        }

        public final EsamSettings.Builder getEsam() {
            return esam != null ? esam.toBuilder() : null;
        }

        @Override
        public final Builder esam(EsamSettings esam) {
            this.esam = esam;
            return this;
        }

        public final void setEsam(EsamSettings.BuilderImpl esam) {
            this.esam = esam != null ? esam.build() : null;
        }

        public final Collection<InputTemplate.Builder> getInputs() {
            return inputs != null ? inputs.stream().map(InputTemplate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputs(Collection<InputTemplate> inputs) {
            this.inputs = ___listOfInputTemplateCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(InputTemplate... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<InputTemplate.Builder>... inputs) {
            inputs(Stream.of(inputs).map(c -> InputTemplate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputs(Collection<InputTemplate.BuilderImpl> inputs) {
            this.inputs = ___listOfInputTemplateCopier.copyFromBuilder(inputs);
        }

        public final MotionImageInserter.Builder getMotionImageInserter() {
            return motionImageInserter != null ? motionImageInserter.toBuilder() : null;
        }

        @Override
        public final Builder motionImageInserter(MotionImageInserter motionImageInserter) {
            this.motionImageInserter = motionImageInserter;
            return this;
        }

        public final void setMotionImageInserter(MotionImageInserter.BuilderImpl motionImageInserter) {
            this.motionImageInserter = motionImageInserter != null ? motionImageInserter.build() : null;
        }

        public final NielsenConfiguration.Builder getNielsenConfiguration() {
            return nielsenConfiguration != null ? nielsenConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder nielsenConfiguration(NielsenConfiguration nielsenConfiguration) {
            this.nielsenConfiguration = nielsenConfiguration;
            return this;
        }

        public final void setNielsenConfiguration(NielsenConfiguration.BuilderImpl nielsenConfiguration) {
            this.nielsenConfiguration = nielsenConfiguration != null ? nielsenConfiguration.build() : null;
        }

        public final Collection<OutputGroup.Builder> getOutputGroups() {
            return outputGroups != null ? outputGroups.stream().map(OutputGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputGroups(Collection<OutputGroup> outputGroups) {
            this.outputGroups = ___listOfOutputGroupCopier.copy(outputGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroups(OutputGroup... outputGroups) {
            outputGroups(Arrays.asList(outputGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroups(Consumer<OutputGroup.Builder>... outputGroups) {
            outputGroups(Stream.of(outputGroups).map(c -> OutputGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOutputGroups(Collection<OutputGroup.BuilderImpl> outputGroups) {
            this.outputGroups = ___listOfOutputGroupCopier.copyFromBuilder(outputGroups);
        }

        public final TimecodeConfig.Builder getTimecodeConfig() {
            return timecodeConfig != null ? timecodeConfig.toBuilder() : null;
        }

        @Override
        public final Builder timecodeConfig(TimecodeConfig timecodeConfig) {
            this.timecodeConfig = timecodeConfig;
            return this;
        }

        public final void setTimecodeConfig(TimecodeConfig.BuilderImpl timecodeConfig) {
            this.timecodeConfig = timecodeConfig != null ? timecodeConfig.build() : null;
        }

        public final TimedMetadataInsertion.Builder getTimedMetadataInsertion() {
            return timedMetadataInsertion != null ? timedMetadataInsertion.toBuilder() : null;
        }

        @Override
        public final Builder timedMetadataInsertion(TimedMetadataInsertion timedMetadataInsertion) {
            this.timedMetadataInsertion = timedMetadataInsertion;
            return this;
        }

        public final void setTimedMetadataInsertion(TimedMetadataInsertion.BuilderImpl timedMetadataInsertion) {
            this.timedMetadataInsertion = timedMetadataInsertion != null ? timedMetadataInsertion.build() : null;
        }

        @Override
        public JobTemplateSettings build() {
            return new JobTemplateSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
