/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Each job converts an input file into an output file or files. For more information, see the User Guide at
 * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
 */
@Generated("software.amazon.awssdk:codegen")
public final class Job implements SdkPojo, Serializable, ToCopyableBuilder<Job.Builder, Job> {
    private static final SdkField<AccelerationSettings> ACCELERATION_SETTINGS_FIELD = SdkField
            .<AccelerationSettings> builder(MarshallingType.SDK_POJO).getter(getter(Job::accelerationSettings))
            .setter(setter(Builder::accelerationSettings)).constructor(AccelerationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerationSettings").build())
            .build();

    private static final SdkField<String> ACCELERATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Job::accelerationStatusAsString)).setter(setter(Builder::accelerationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerationStatus").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).getter(getter(Job::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> BILLING_TAGS_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Job::billingTagsSourceAsString)).setter(setter(Builder::billingTagsSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingTagsSource").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Job::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> CURRENT_PHASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Job::currentPhaseAsString)).setter(setter(Builder::currentPhase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPhase").build()).build();

    private static final SdkField<Integer> ERROR_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Job::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Job::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<List<HopDestination>> HOP_DESTINATIONS_FIELD = SdkField
            .<List<HopDestination>> builder(MarshallingType.LIST)
            .getter(getter(Job::hopDestinations))
            .setter(setter(Builder::hopDestinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hopDestinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HopDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(HopDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).getter(getter(Job::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Integer> JOB_PERCENT_COMPLETE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Job::jobPercentComplete)).setter(setter(Builder::jobPercentComplete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobPercentComplete").build())
            .build();

    private static final SdkField<String> JOB_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Job::jobTemplate)).setter(setter(Builder::jobTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplate").build()).build();

    private static final SdkField<JobMessages> MESSAGES_FIELD = SdkField.<JobMessages> builder(MarshallingType.SDK_POJO)
            .getter(getter(Job::messages)).setter(setter(Builder::messages)).constructor(JobMessages::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build()).build();

    private static final SdkField<List<OutputGroupDetail>> OUTPUT_GROUP_DETAILS_FIELD = SdkField
            .<List<OutputGroupDetail>> builder(MarshallingType.LIST)
            .getter(getter(Job::outputGroupDetails))
            .setter(setter(Builder::outputGroupDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputGroupDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputGroupDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputGroupDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Job::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<String> QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Job::queue)).setter(setter(Builder::queue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queue").build()).build();

    private static final SdkField<List<QueueTransition>> QUEUE_TRANSITIONS_FIELD = SdkField
            .<List<QueueTransition>> builder(MarshallingType.LIST)
            .getter(getter(Job::queueTransitions))
            .setter(setter(Builder::queueTransitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueTransitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueueTransition> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueueTransition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> RETRY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Job::retryCount)).setter(setter(Builder::retryCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryCount").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Job::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final SdkField<JobSettings> SETTINGS_FIELD = SdkField.<JobSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(Job::settings)).setter(setter(Builder::settings)).constructor(JobSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()).build();

    private static final SdkField<String> SIMULATE_RESERVED_QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Job::simulateReservedQueueAsString)).setter(setter(Builder::simulateReservedQueue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulateReservedQueue").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Job::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_UPDATE_INTERVAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Job::statusUpdateIntervalAsString)).setter(setter(Builder::statusUpdateInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusUpdateInterval").build())
            .build();

    private static final SdkField<Timing> TIMING_FIELD = SdkField.<Timing> builder(MarshallingType.SDK_POJO)
            .getter(getter(Job::timing)).setter(setter(Builder::timing)).constructor(Timing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timing").build()).build();

    private static final SdkField<Map<String, String>> USER_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Job::userMetadata))
            .setter(setter(Builder::userMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATION_SETTINGS_FIELD,
            ACCELERATION_STATUS_FIELD, ARN_FIELD, BILLING_TAGS_SOURCE_FIELD, CREATED_AT_FIELD, CURRENT_PHASE_FIELD,
            ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD, HOP_DESTINATIONS_FIELD, ID_FIELD, JOB_PERCENT_COMPLETE_FIELD,
            JOB_TEMPLATE_FIELD, MESSAGES_FIELD, OUTPUT_GROUP_DETAILS_FIELD, PRIORITY_FIELD, QUEUE_FIELD, QUEUE_TRANSITIONS_FIELD,
            RETRY_COUNT_FIELD, ROLE_FIELD, SETTINGS_FIELD, SIMULATE_RESERVED_QUEUE_FIELD, STATUS_FIELD,
            STATUS_UPDATE_INTERVAL_FIELD, TIMING_FIELD, USER_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final AccelerationSettings accelerationSettings;

    private final String accelerationStatus;

    private final String arn;

    private final String billingTagsSource;

    private final Instant createdAt;

    private final String currentPhase;

    private final Integer errorCode;

    private final String errorMessage;

    private final List<HopDestination> hopDestinations;

    private final String id;

    private final Integer jobPercentComplete;

    private final String jobTemplate;

    private final JobMessages messages;

    private final List<OutputGroupDetail> outputGroupDetails;

    private final Integer priority;

    private final String queue;

    private final List<QueueTransition> queueTransitions;

    private final Integer retryCount;

    private final String role;

    private final JobSettings settings;

    private final String simulateReservedQueue;

    private final String status;

    private final String statusUpdateInterval;

    private final Timing timing;

    private final Map<String, String> userMetadata;

    private Job(BuilderImpl builder) {
        this.accelerationSettings = builder.accelerationSettings;
        this.accelerationStatus = builder.accelerationStatus;
        this.arn = builder.arn;
        this.billingTagsSource = builder.billingTagsSource;
        this.createdAt = builder.createdAt;
        this.currentPhase = builder.currentPhase;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.hopDestinations = builder.hopDestinations;
        this.id = builder.id;
        this.jobPercentComplete = builder.jobPercentComplete;
        this.jobTemplate = builder.jobTemplate;
        this.messages = builder.messages;
        this.outputGroupDetails = builder.outputGroupDetails;
        this.priority = builder.priority;
        this.queue = builder.queue;
        this.queueTransitions = builder.queueTransitions;
        this.retryCount = builder.retryCount;
        this.role = builder.role;
        this.settings = builder.settings;
        this.simulateReservedQueue = builder.simulateReservedQueue;
        this.status = builder.status;
        this.statusUpdateInterval = builder.statusUpdateInterval;
        this.timing = builder.timing;
        this.userMetadata = builder.userMetadata;
    }

    /**
     * Accelerated transcoding can significantly speed up jobs with long, visually complex content.
     * 
     * @return Accelerated transcoding can significantly speed up jobs with long, visually complex content.
     */
    public AccelerationSettings accelerationSettings() {
        return accelerationSettings;
    }

    /**
     * Describes whether the current job is running with accelerated transcoding. For jobs that have Acceleration
     * (AccelerationMode) set to DISABLED, AccelerationStatus is always NOT_APPLICABLE. For jobs that have Acceleration
     * (AccelerationMode) set to ENABLED or PREFERRED, AccelerationStatus is one of the other states. AccelerationStatus
     * is IN_PROGRESS initially, while the service determines whether the input files and job settings are compatible
     * with accelerated transcoding. If they are, AcclerationStatus is ACCELERATED. If your input files and job settings
     * aren't compatible with accelerated transcoding, the service either fails your job or runs it without accelerated
     * transcoding, depending on how you set Acceleration (AccelerationMode). When the service runs your job without
     * accelerated transcoding, AccelerationStatus is NOT_ACCELERATED.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #accelerationStatus} will return {@link AccelerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #accelerationStatusAsString}.
     * </p>
     * 
     * @return Describes whether the current job is running with accelerated transcoding. For jobs that have
     *         Acceleration (AccelerationMode) set to DISABLED, AccelerationStatus is always NOT_APPLICABLE. For jobs
     *         that have Acceleration (AccelerationMode) set to ENABLED or PREFERRED, AccelerationStatus is one of the
     *         other states. AccelerationStatus is IN_PROGRESS initially, while the service determines whether the input
     *         files and job settings are compatible with accelerated transcoding. If they are, AcclerationStatus is
     *         ACCELERATED. If your input files and job settings aren't compatible with accelerated transcoding, the
     *         service either fails your job or runs it without accelerated transcoding, depending on how you set
     *         Acceleration (AccelerationMode). When the service runs your job without accelerated transcoding,
     *         AccelerationStatus is NOT_ACCELERATED.
     * @see AccelerationStatus
     */
    public AccelerationStatus accelerationStatus() {
        return AccelerationStatus.fromValue(accelerationStatus);
    }

    /**
     * Describes whether the current job is running with accelerated transcoding. For jobs that have Acceleration
     * (AccelerationMode) set to DISABLED, AccelerationStatus is always NOT_APPLICABLE. For jobs that have Acceleration
     * (AccelerationMode) set to ENABLED or PREFERRED, AccelerationStatus is one of the other states. AccelerationStatus
     * is IN_PROGRESS initially, while the service determines whether the input files and job settings are compatible
     * with accelerated transcoding. If they are, AcclerationStatus is ACCELERATED. If your input files and job settings
     * aren't compatible with accelerated transcoding, the service either fails your job or runs it without accelerated
     * transcoding, depending on how you set Acceleration (AccelerationMode). When the service runs your job without
     * accelerated transcoding, AccelerationStatus is NOT_ACCELERATED.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #accelerationStatus} will return {@link AccelerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #accelerationStatusAsString}.
     * </p>
     * 
     * @return Describes whether the current job is running with accelerated transcoding. For jobs that have
     *         Acceleration (AccelerationMode) set to DISABLED, AccelerationStatus is always NOT_APPLICABLE. For jobs
     *         that have Acceleration (AccelerationMode) set to ENABLED or PREFERRED, AccelerationStatus is one of the
     *         other states. AccelerationStatus is IN_PROGRESS initially, while the service determines whether the input
     *         files and job settings are compatible with accelerated transcoding. If they are, AcclerationStatus is
     *         ACCELERATED. If your input files and job settings aren't compatible with accelerated transcoding, the
     *         service either fails your job or runs it without accelerated transcoding, depending on how you set
     *         Acceleration (AccelerationMode). When the service runs your job without accelerated transcoding,
     *         AccelerationStatus is NOT_ACCELERATED.
     * @see AccelerationStatus
     */
    public String accelerationStatusAsString() {
        return accelerationStatus;
    }

    /**
     * An identifier for this resource that is unique within all of AWS.
     * 
     * @return An identifier for this resource that is unique within all of AWS.
     */
    public String arn() {
        return arn;
    }

    /**
     * The tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert costs on any
     * billing report that you set up.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingTagsSource}
     * will return {@link BillingTagsSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #billingTagsSourceAsString}.
     * </p>
     * 
     * @return The tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert costs
     *         on any billing report that you set up.
     * @see BillingTagsSource
     */
    public BillingTagsSource billingTagsSource() {
        return BillingTagsSource.fromValue(billingTagsSource);
    }

    /**
     * The tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert costs on any
     * billing report that you set up.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingTagsSource}
     * will return {@link BillingTagsSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #billingTagsSourceAsString}.
     * </p>
     * 
     * @return The tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert costs
     *         on any billing report that you set up.
     * @see BillingTagsSource
     */
    public String billingTagsSourceAsString() {
        return billingTagsSource;
    }

    /**
     * The time, in Unix epoch format in seconds, when the job got created.
     * 
     * @return The time, in Unix epoch format in seconds, when the job got created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * A job's phase can be PROBING, TRANSCODING OR UPLOADING
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentPhase} will
     * return {@link JobPhase#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currentPhaseAsString}.
     * </p>
     * 
     * @return A job's phase can be PROBING, TRANSCODING OR UPLOADING
     * @see JobPhase
     */
    public JobPhase currentPhase() {
        return JobPhase.fromValue(currentPhase);
    }

    /**
     * A job's phase can be PROBING, TRANSCODING OR UPLOADING
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentPhase} will
     * return {@link JobPhase#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currentPhaseAsString}.
     * </p>
     * 
     * @return A job's phase can be PROBING, TRANSCODING OR UPLOADING
     * @see JobPhase
     */
    public String currentPhaseAsString() {
        return currentPhase;
    }

    /**
     * Error code for the job
     * 
     * @return Error code for the job
     */
    public Integer errorCode() {
        return errorCode;
    }

    /**
     * Error message of Job
     * 
     * @return Error message of Job
     */
    public String errorMessage() {
        return errorMessage;
    }

    /**
     * Returns true if the HopDestinations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasHopDestinations() {
        return hopDestinations != null && !(hopDestinations instanceof SdkAutoConstructList);
    }

    /**
     * Optional list of hop destinations.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHopDestinations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional list of hop destinations.
     */
    public List<HopDestination> hopDestinations() {
        return hopDestinations;
    }

    /**
     * A portion of the job's ARN, unique within your AWS Elemental MediaConvert resources
     * 
     * @return A portion of the job's ARN, unique within your AWS Elemental MediaConvert resources
     */
    public String id() {
        return id;
    }

    /**
     * An estimate of how far your job has progressed. This estimate is shown as a percentage of the total time from
     * when your job leaves its queue to when your output files appear in your output Amazon S3 bucket. AWS Elemental
     * MediaConvert provides jobPercentComplete in CloudWatch STATUS_UPDATE events and in the response to GetJob and
     * ListJobs requests. The jobPercentComplete estimate is reliable for the following input containers: Quicktime,
     * Transport Stream, MP4, and MXF. For some jobs, the service can't provide information about job progress. In those
     * cases, jobPercentComplete returns a null value.
     * 
     * @return An estimate of how far your job has progressed. This estimate is shown as a percentage of the total time
     *         from when your job leaves its queue to when your output files appear in your output Amazon S3 bucket. AWS
     *         Elemental MediaConvert provides jobPercentComplete in CloudWatch STATUS_UPDATE events and in the response
     *         to GetJob and ListJobs requests. The jobPercentComplete estimate is reliable for the following input
     *         containers: Quicktime, Transport Stream, MP4, and MXF. For some jobs, the service can't provide
     *         information about job progress. In those cases, jobPercentComplete returns a null value.
     */
    public Integer jobPercentComplete() {
        return jobPercentComplete;
    }

    /**
     * The job template that the job is created from, if it is created from a job template.
     * 
     * @return The job template that the job is created from, if it is created from a job template.
     */
    public String jobTemplate() {
        return jobTemplate;
    }

    /**
     * Provides messages from the service about jobs that you have already successfully submitted.
     * 
     * @return Provides messages from the service about jobs that you have already successfully submitted.
     */
    public JobMessages messages() {
        return messages;
    }

    /**
     * Returns true if the OutputGroupDetails property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasOutputGroupDetails() {
        return outputGroupDetails != null && !(outputGroupDetails instanceof SdkAutoConstructList);
    }

    /**
     * List of output group details
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutputGroupDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of output group details
     */
    public List<OutputGroupDetail> outputGroupDetails() {
        return outputGroupDetails;
    }

    /**
     * Relative priority on the job.
     * 
     * @return Relative priority on the job.
     */
    public Integer priority() {
        return priority;
    }

    /**
     * When you create a job, you can specify a queue to send it to. If you don't specify, the job will go to the
     * default queue. For more about queues, see the User Guide topic at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     * 
     * @return When you create a job, you can specify a queue to send it to. If you don't specify, the job will go to
     *         the default queue. For more about queues, see the User Guide topic at
     *         http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    public String queue() {
        return queue;
    }

    /**
     * Returns true if the QueueTransitions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasQueueTransitions() {
        return queueTransitions != null && !(queueTransitions instanceof SdkAutoConstructList);
    }

    /**
     * The job's queue hopping history.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQueueTransitions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The job's queue hopping history.
     */
    public List<QueueTransition> queueTransitions() {
        return queueTransitions;
    }

    /**
     * The number of times that the service automatically attempted to process your job after encountering an error.
     * 
     * @return The number of times that the service automatically attempted to process your job after encountering an
     *         error.
     */
    public Integer retryCount() {
        return retryCount;
    }

    /**
     * The IAM role you use for creating this job. For details about permissions, see the User Guide topic at the User
     * Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html
     * 
     * @return The IAM role you use for creating this job. For details about permissions, see the User Guide topic at
     *         the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html
     */
    public String role() {
        return role;
    }

    /**
     * JobSettings contains all the transcode settings for a job.
     * 
     * @return JobSettings contains all the transcode settings for a job.
     */
    public JobSettings settings() {
        return settings;
    }

    /**
     * Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you need. When
     * this is enabled, MediaConvert runs your job from an on-demand queue with similar performance to what you will see
     * with one RTS in a reserved queue. This setting is disabled by default.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #simulateReservedQueue} will return {@link SimulateReservedQueue#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #simulateReservedQueueAsString}.
     * </p>
     * 
     * @return Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you
     *         need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance
     *         to what you will see with one RTS in a reserved queue. This setting is disabled by default.
     * @see SimulateReservedQueue
     */
    public SimulateReservedQueue simulateReservedQueue() {
        return SimulateReservedQueue.fromValue(simulateReservedQueue);
    }

    /**
     * Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you need. When
     * this is enabled, MediaConvert runs your job from an on-demand queue with similar performance to what you will see
     * with one RTS in a reserved queue. This setting is disabled by default.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #simulateReservedQueue} will return {@link SimulateReservedQueue#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #simulateReservedQueueAsString}.
     * </p>
     * 
     * @return Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you
     *         need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance
     *         to what you will see with one RTS in a reserved queue. This setting is disabled by default.
     * @see SimulateReservedQueue
     */
    public String simulateReservedQueueAsString() {
        return simulateReservedQueue;
    }

    /**
     * A job's status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A job's status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR.
     * @see JobStatus
     */
    public JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * A job's status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A job's status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR.
     * @see JobStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in
     * seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins
     * processing your job to the time it completes the transcode or encounters an error.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #statusUpdateInterval} will return {@link StatusUpdateInterval#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #statusUpdateIntervalAsString}.
     * </p>
     * 
     * @return Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval,
     *         in seconds, between status updates. MediaConvert sends an update at this interval from the time the
     *         service begins processing your job to the time it completes the transcode or encounters an error.
     * @see StatusUpdateInterval
     */
    public StatusUpdateInterval statusUpdateInterval() {
        return StatusUpdateInterval.fromValue(statusUpdateInterval);
    }

    /**
     * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in
     * seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins
     * processing your job to the time it completes the transcode or encounters an error.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #statusUpdateInterval} will return {@link StatusUpdateInterval#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #statusUpdateIntervalAsString}.
     * </p>
     * 
     * @return Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval,
     *         in seconds, between status updates. MediaConvert sends an update at this interval from the time the
     *         service begins processing your job to the time it completes the transcode or encounters an error.
     * @see StatusUpdateInterval
     */
    public String statusUpdateIntervalAsString() {
        return statusUpdateInterval;
    }

    /**
     * Information about when jobs are submitted, started, and finished is specified in Unix epoch format in seconds.
     * 
     * @return Information about when jobs are submitted, started, and finished is specified in Unix epoch format in
     *         seconds.
     */
    public Timing timing() {
        return timing;
    }

    /**
     * Returns true if the UserMetadata property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUserMetadata() {
        return userMetadata != null && !(userMetadata instanceof SdkAutoConstructMap);
    }

    /**
     * User-defined metadata that you want to associate with an MediaConvert job. You specify metadata in key/value
     * pairs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserMetadata()} to see if a value was sent in this field.
     * </p>
     * 
     * @return User-defined metadata that you want to associate with an MediaConvert job. You specify metadata in
     *         key/value pairs.
     */
    public Map<String, String> userMetadata() {
        return userMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accelerationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(accelerationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(billingTagsSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(currentPhaseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hopDestinations());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(jobPercentComplete());
        hashCode = 31 * hashCode + Objects.hashCode(jobTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(messages());
        hashCode = 31 * hashCode + Objects.hashCode(outputGroupDetails());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(queue());
        hashCode = 31 * hashCode + Objects.hashCode(queueTransitions());
        hashCode = 31 * hashCode + Objects.hashCode(retryCount());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(simulateReservedQueueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusUpdateIntervalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timing());
        hashCode = 31 * hashCode + Objects.hashCode(userMetadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job) obj;
        return Objects.equals(accelerationSettings(), other.accelerationSettings())
                && Objects.equals(accelerationStatusAsString(), other.accelerationStatusAsString())
                && Objects.equals(arn(), other.arn())
                && Objects.equals(billingTagsSourceAsString(), other.billingTagsSourceAsString())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(currentPhaseAsString(), other.currentPhaseAsString())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(hopDestinations(), other.hopDestinations()) && Objects.equals(id(), other.id())
                && Objects.equals(jobPercentComplete(), other.jobPercentComplete())
                && Objects.equals(jobTemplate(), other.jobTemplate()) && Objects.equals(messages(), other.messages())
                && Objects.equals(outputGroupDetails(), other.outputGroupDetails())
                && Objects.equals(priority(), other.priority()) && Objects.equals(queue(), other.queue())
                && Objects.equals(queueTransitions(), other.queueTransitions())
                && Objects.equals(retryCount(), other.retryCount()) && Objects.equals(role(), other.role())
                && Objects.equals(settings(), other.settings())
                && Objects.equals(simulateReservedQueueAsString(), other.simulateReservedQueueAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusUpdateIntervalAsString(), other.statusUpdateIntervalAsString())
                && Objects.equals(timing(), other.timing()) && Objects.equals(userMetadata(), other.userMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Job").add("AccelerationSettings", accelerationSettings())
                .add("AccelerationStatus", accelerationStatusAsString()).add("Arn", arn())
                .add("BillingTagsSource", billingTagsSourceAsString()).add("CreatedAt", createdAt())
                .add("CurrentPhase", currentPhaseAsString()).add("ErrorCode", errorCode()).add("ErrorMessage", errorMessage())
                .add("HopDestinations", hopDestinations()).add("Id", id()).add("JobPercentComplete", jobPercentComplete())
                .add("JobTemplate", jobTemplate()).add("Messages", messages()).add("OutputGroupDetails", outputGroupDetails())
                .add("Priority", priority()).add("Queue", queue()).add("QueueTransitions", queueTransitions())
                .add("RetryCount", retryCount()).add("Role", role()).add("Settings", settings())
                .add("SimulateReservedQueue", simulateReservedQueueAsString()).add("Status", statusAsString())
                .add("StatusUpdateInterval", statusUpdateIntervalAsString()).add("Timing", timing())
                .add("UserMetadata", userMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccelerationSettings":
            return Optional.ofNullable(clazz.cast(accelerationSettings()));
        case "AccelerationStatus":
            return Optional.ofNullable(clazz.cast(accelerationStatusAsString()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "BillingTagsSource":
            return Optional.ofNullable(clazz.cast(billingTagsSourceAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "CurrentPhase":
            return Optional.ofNullable(clazz.cast(currentPhaseAsString()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "HopDestinations":
            return Optional.ofNullable(clazz.cast(hopDestinations()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "JobPercentComplete":
            return Optional.ofNullable(clazz.cast(jobPercentComplete()));
        case "JobTemplate":
            return Optional.ofNullable(clazz.cast(jobTemplate()));
        case "Messages":
            return Optional.ofNullable(clazz.cast(messages()));
        case "OutputGroupDetails":
            return Optional.ofNullable(clazz.cast(outputGroupDetails()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Queue":
            return Optional.ofNullable(clazz.cast(queue()));
        case "QueueTransitions":
            return Optional.ofNullable(clazz.cast(queueTransitions()));
        case "RetryCount":
            return Optional.ofNullable(clazz.cast(retryCount()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "SimulateReservedQueue":
            return Optional.ofNullable(clazz.cast(simulateReservedQueueAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusUpdateInterval":
            return Optional.ofNullable(clazz.cast(statusUpdateIntervalAsString()));
        case "Timing":
            return Optional.ofNullable(clazz.cast(timing()));
        case "UserMetadata":
            return Optional.ofNullable(clazz.cast(userMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Job, T> g) {
        return obj -> g.apply((Job) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Job> {
        /**
         * Accelerated transcoding can significantly speed up jobs with long, visually complex content.
         * 
         * @param accelerationSettings
         *        Accelerated transcoding can significantly speed up jobs with long, visually complex content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accelerationSettings(AccelerationSettings accelerationSettings);

        /**
         * Accelerated transcoding can significantly speed up jobs with long, visually complex content. This is a
         * convenience that creates an instance of the {@link AccelerationSettings.Builder} avoiding the need to create
         * one manually via {@link AccelerationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccelerationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #accelerationSettings(AccelerationSettings)}.
         * 
         * @param accelerationSettings
         *        a consumer that will call methods on {@link AccelerationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accelerationSettings(AccelerationSettings)
         */
        default Builder accelerationSettings(Consumer<AccelerationSettings.Builder> accelerationSettings) {
            return accelerationSettings(AccelerationSettings.builder().applyMutation(accelerationSettings).build());
        }

        /**
         * Describes whether the current job is running with accelerated transcoding. For jobs that have Acceleration
         * (AccelerationMode) set to DISABLED, AccelerationStatus is always NOT_APPLICABLE. For jobs that have
         * Acceleration (AccelerationMode) set to ENABLED or PREFERRED, AccelerationStatus is one of the other states.
         * AccelerationStatus is IN_PROGRESS initially, while the service determines whether the input files and job
         * settings are compatible with accelerated transcoding. If they are, AcclerationStatus is ACCELERATED. If your
         * input files and job settings aren't compatible with accelerated transcoding, the service either fails your
         * job or runs it without accelerated transcoding, depending on how you set Acceleration (AccelerationMode).
         * When the service runs your job without accelerated transcoding, AccelerationStatus is NOT_ACCELERATED.
         * 
         * @param accelerationStatus
         *        Describes whether the current job is running with accelerated transcoding. For jobs that have
         *        Acceleration (AccelerationMode) set to DISABLED, AccelerationStatus is always NOT_APPLICABLE. For jobs
         *        that have Acceleration (AccelerationMode) set to ENABLED or PREFERRED, AccelerationStatus is one of
         *        the other states. AccelerationStatus is IN_PROGRESS initially, while the service determines whether
         *        the input files and job settings are compatible with accelerated transcoding. If they are,
         *        AcclerationStatus is ACCELERATED. If your input files and job settings aren't compatible with
         *        accelerated transcoding, the service either fails your job or runs it without accelerated transcoding,
         *        depending on how you set Acceleration (AccelerationMode). When the service runs your job without
         *        accelerated transcoding, AccelerationStatus is NOT_ACCELERATED.
         * @see AccelerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccelerationStatus
         */
        Builder accelerationStatus(String accelerationStatus);

        /**
         * Describes whether the current job is running with accelerated transcoding. For jobs that have Acceleration
         * (AccelerationMode) set to DISABLED, AccelerationStatus is always NOT_APPLICABLE. For jobs that have
         * Acceleration (AccelerationMode) set to ENABLED or PREFERRED, AccelerationStatus is one of the other states.
         * AccelerationStatus is IN_PROGRESS initially, while the service determines whether the input files and job
         * settings are compatible with accelerated transcoding. If they are, AcclerationStatus is ACCELERATED. If your
         * input files and job settings aren't compatible with accelerated transcoding, the service either fails your
         * job or runs it without accelerated transcoding, depending on how you set Acceleration (AccelerationMode).
         * When the service runs your job without accelerated transcoding, AccelerationStatus is NOT_ACCELERATED.
         * 
         * @param accelerationStatus
         *        Describes whether the current job is running with accelerated transcoding. For jobs that have
         *        Acceleration (AccelerationMode) set to DISABLED, AccelerationStatus is always NOT_APPLICABLE. For jobs
         *        that have Acceleration (AccelerationMode) set to ENABLED or PREFERRED, AccelerationStatus is one of
         *        the other states. AccelerationStatus is IN_PROGRESS initially, while the service determines whether
         *        the input files and job settings are compatible with accelerated transcoding. If they are,
         *        AcclerationStatus is ACCELERATED. If your input files and job settings aren't compatible with
         *        accelerated transcoding, the service either fails your job or runs it without accelerated transcoding,
         *        depending on how you set Acceleration (AccelerationMode). When the service runs your job without
         *        accelerated transcoding, AccelerationStatus is NOT_ACCELERATED.
         * @see AccelerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccelerationStatus
         */
        Builder accelerationStatus(AccelerationStatus accelerationStatus);

        /**
         * An identifier for this resource that is unique within all of AWS.
         * 
         * @param arn
         *        An identifier for this resource that is unique within all of AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * The tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert costs on
         * any billing report that you set up.
         * 
         * @param billingTagsSource
         *        The tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert
         *        costs on any billing report that you set up.
         * @see BillingTagsSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingTagsSource
         */
        Builder billingTagsSource(String billingTagsSource);

        /**
         * The tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert costs on
         * any billing report that you set up.
         * 
         * @param billingTagsSource
         *        The tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert
         *        costs on any billing report that you set up.
         * @see BillingTagsSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingTagsSource
         */
        Builder billingTagsSource(BillingTagsSource billingTagsSource);

        /**
         * The time, in Unix epoch format in seconds, when the job got created.
         * 
         * @param createdAt
         *        The time, in Unix epoch format in seconds, when the job got created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * A job's phase can be PROBING, TRANSCODING OR UPLOADING
         * 
         * @param currentPhase
         *        A job's phase can be PROBING, TRANSCODING OR UPLOADING
         * @see JobPhase
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobPhase
         */
        Builder currentPhase(String currentPhase);

        /**
         * A job's phase can be PROBING, TRANSCODING OR UPLOADING
         * 
         * @param currentPhase
         *        A job's phase can be PROBING, TRANSCODING OR UPLOADING
         * @see JobPhase
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobPhase
         */
        Builder currentPhase(JobPhase currentPhase);

        /**
         * Error code for the job
         * 
         * @param errorCode
         *        Error code for the job
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(Integer errorCode);

        /**
         * Error message of Job
         * 
         * @param errorMessage
         *        Error message of Job
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * Optional list of hop destinations.
         * 
         * @param hopDestinations
         *        Optional list of hop destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hopDestinations(Collection<HopDestination> hopDestinations);

        /**
         * Optional list of hop destinations.
         * 
         * @param hopDestinations
         *        Optional list of hop destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hopDestinations(HopDestination... hopDestinations);

        /**
         * Optional list of hop destinations. This is a convenience that creates an instance of the {@link List
         * <HopDestination>.Builder} avoiding the need to create one manually via {@link List<HopDestination>#builder()}
         * .
         *
         * When the {@link Consumer} completes, {@link List<HopDestination>.Builder#build()} is called immediately and
         * its result is passed to {@link #hopDestinations(List<HopDestination>)}.
         * 
         * @param hopDestinations
         *        a consumer that will call methods on {@link List<HopDestination>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hopDestinations(List<HopDestination>)
         */
        Builder hopDestinations(Consumer<HopDestination.Builder>... hopDestinations);

        /**
         * A portion of the job's ARN, unique within your AWS Elemental MediaConvert resources
         * 
         * @param id
         *        A portion of the job's ARN, unique within your AWS Elemental MediaConvert resources
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * An estimate of how far your job has progressed. This estimate is shown as a percentage of the total time from
         * when your job leaves its queue to when your output files appear in your output Amazon S3 bucket. AWS
         * Elemental MediaConvert provides jobPercentComplete in CloudWatch STATUS_UPDATE events and in the response to
         * GetJob and ListJobs requests. The jobPercentComplete estimate is reliable for the following input containers:
         * Quicktime, Transport Stream, MP4, and MXF. For some jobs, the service can't provide information about job
         * progress. In those cases, jobPercentComplete returns a null value.
         * 
         * @param jobPercentComplete
         *        An estimate of how far your job has progressed. This estimate is shown as a percentage of the total
         *        time from when your job leaves its queue to when your output files appear in your output Amazon S3
         *        bucket. AWS Elemental MediaConvert provides jobPercentComplete in CloudWatch STATUS_UPDATE events and
         *        in the response to GetJob and ListJobs requests. The jobPercentComplete estimate is reliable for the
         *        following input containers: Quicktime, Transport Stream, MP4, and MXF. For some jobs, the service
         *        can't provide information about job progress. In those cases, jobPercentComplete returns a null value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobPercentComplete(Integer jobPercentComplete);

        /**
         * The job template that the job is created from, if it is created from a job template.
         * 
         * @param jobTemplate
         *        The job template that the job is created from, if it is created from a job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTemplate(String jobTemplate);

        /**
         * Provides messages from the service about jobs that you have already successfully submitted.
         * 
         * @param messages
         *        Provides messages from the service about jobs that you have already successfully submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(JobMessages messages);

        /**
         * Provides messages from the service about jobs that you have already successfully submitted. This is a
         * convenience that creates an instance of the {@link JobMessages.Builder} avoiding the need to create one
         * manually via {@link JobMessages#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobMessages.Builder#build()} is called immediately and its result
         * is passed to {@link #messages(JobMessages)}.
         * 
         * @param messages
         *        a consumer that will call methods on {@link JobMessages.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(JobMessages)
         */
        default Builder messages(Consumer<JobMessages.Builder> messages) {
            return messages(JobMessages.builder().applyMutation(messages).build());
        }

        /**
         * List of output group details
         * 
         * @param outputGroupDetails
         *        List of output group details
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputGroupDetails(Collection<OutputGroupDetail> outputGroupDetails);

        /**
         * List of output group details
         * 
         * @param outputGroupDetails
         *        List of output group details
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputGroupDetails(OutputGroupDetail... outputGroupDetails);

        /**
         * List of output group details This is a convenience that creates an instance of the {@link List
         * <OutputGroupDetail>.Builder} avoiding the need to create one manually via {@link List
         * <OutputGroupDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OutputGroupDetail>.Builder#build()} is called immediately
         * and its result is passed to {@link #outputGroupDetails(List<OutputGroupDetail>)}.
         * 
         * @param outputGroupDetails
         *        a consumer that will call methods on {@link List<OutputGroupDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputGroupDetails(List<OutputGroupDetail>)
         */
        Builder outputGroupDetails(Consumer<OutputGroupDetail.Builder>... outputGroupDetails);

        /**
         * Relative priority on the job.
         * 
         * @param priority
         *        Relative priority on the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * When you create a job, you can specify a queue to send it to. If you don't specify, the job will go to the
         * default queue. For more about queues, see the User Guide topic at
         * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
         * 
         * @param queue
         *        When you create a job, you can specify a queue to send it to. If you don't specify, the job will go to
         *        the default queue. For more about queues, see the User Guide topic at
         *        http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queue(String queue);

        /**
         * The job's queue hopping history.
         * 
         * @param queueTransitions
         *        The job's queue hopping history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueTransitions(Collection<QueueTransition> queueTransitions);

        /**
         * The job's queue hopping history.
         * 
         * @param queueTransitions
         *        The job's queue hopping history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueTransitions(QueueTransition... queueTransitions);

        /**
         * The job's queue hopping history. This is a convenience that creates an instance of the {@link List
         * <QueueTransition>.Builder} avoiding the need to create one manually via {@link List
         * <QueueTransition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<QueueTransition>.Builder#build()} is called immediately and
         * its result is passed to {@link #queueTransitions(List<QueueTransition>)}.
         * 
         * @param queueTransitions
         *        a consumer that will call methods on {@link List<QueueTransition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueTransitions(List<QueueTransition>)
         */
        Builder queueTransitions(Consumer<QueueTransition.Builder>... queueTransitions);

        /**
         * The number of times that the service automatically attempted to process your job after encountering an error.
         * 
         * @param retryCount
         *        The number of times that the service automatically attempted to process your job after encountering an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryCount(Integer retryCount);

        /**
         * The IAM role you use for creating this job. For details about permissions, see the User Guide topic at the
         * User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html
         * 
         * @param role
         *        The IAM role you use for creating this job. For details about permissions, see the User Guide topic at
         *        the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * JobSettings contains all the transcode settings for a job.
         * 
         * @param settings
         *        JobSettings contains all the transcode settings for a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(JobSettings settings);

        /**
         * JobSettings contains all the transcode settings for a job. This is a convenience that creates an instance of
         * the {@link JobSettings.Builder} avoiding the need to create one manually via {@link JobSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobSettings.Builder#build()} is called immediately and its result
         * is passed to {@link #settings(JobSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link JobSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(JobSettings)
         */
        default Builder settings(Consumer<JobSettings.Builder> settings) {
            return settings(JobSettings.builder().applyMutation(settings).build());
        }

        /**
         * Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you need.
         * When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance to what you
         * will see with one RTS in a reserved queue. This setting is disabled by default.
         * 
         * @param simulateReservedQueue
         *        Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you
         *        need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar
         *        performance to what you will see with one RTS in a reserved queue. This setting is disabled by
         *        default.
         * @see SimulateReservedQueue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulateReservedQueue
         */
        Builder simulateReservedQueue(String simulateReservedQueue);

        /**
         * Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you need.
         * When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance to what you
         * will see with one RTS in a reserved queue. This setting is disabled by default.
         * 
         * @param simulateReservedQueue
         *        Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you
         *        need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar
         *        performance to what you will see with one RTS in a reserved queue. This setting is disabled by
         *        default.
         * @see SimulateReservedQueue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulateReservedQueue
         */
        Builder simulateReservedQueue(SimulateReservedQueue simulateReservedQueue);

        /**
         * A job's status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR.
         * 
         * @param status
         *        A job's status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * A job's status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR.
         * 
         * @param status
         *        A job's status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);

        /**
         * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in
         * seconds, between status updates. MediaConvert sends an update at this interval from the time the service
         * begins processing your job to the time it completes the transcode or encounters an error.
         * 
         * @param statusUpdateInterval
         *        Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the
         *        interval, in seconds, between status updates. MediaConvert sends an update at this interval from the
         *        time the service begins processing your job to the time it completes the transcode or encounters an
         *        error.
         * @see StatusUpdateInterval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusUpdateInterval
         */
        Builder statusUpdateInterval(String statusUpdateInterval);

        /**
         * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in
         * seconds, between status updates. MediaConvert sends an update at this interval from the time the service
         * begins processing your job to the time it completes the transcode or encounters an error.
         * 
         * @param statusUpdateInterval
         *        Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the
         *        interval, in seconds, between status updates. MediaConvert sends an update at this interval from the
         *        time the service begins processing your job to the time it completes the transcode or encounters an
         *        error.
         * @see StatusUpdateInterval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusUpdateInterval
         */
        Builder statusUpdateInterval(StatusUpdateInterval statusUpdateInterval);

        /**
         * Information about when jobs are submitted, started, and finished is specified in Unix epoch format in
         * seconds.
         * 
         * @param timing
         *        Information about when jobs are submitted, started, and finished is specified in Unix epoch format in
         *        seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timing(Timing timing);

        /**
         * Information about when jobs are submitted, started, and finished is specified in Unix epoch format in
         * seconds. This is a convenience that creates an instance of the {@link Timing.Builder} avoiding the need to
         * create one manually via {@link Timing#builder()}.
         *
         * When the {@link Consumer} completes, {@link Timing.Builder#build()} is called immediately and its result is
         * passed to {@link #timing(Timing)}.
         * 
         * @param timing
         *        a consumer that will call methods on {@link Timing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timing(Timing)
         */
        default Builder timing(Consumer<Timing.Builder> timing) {
            return timing(Timing.builder().applyMutation(timing).build());
        }

        /**
         * User-defined metadata that you want to associate with an MediaConvert job. You specify metadata in key/value
         * pairs.
         * 
         * @param userMetadata
         *        User-defined metadata that you want to associate with an MediaConvert job. You specify metadata in
         *        key/value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMetadata(Map<String, String> userMetadata);
    }

    static final class BuilderImpl implements Builder {
        private AccelerationSettings accelerationSettings;

        private String accelerationStatus;

        private String arn;

        private String billingTagsSource;

        private Instant createdAt;

        private String currentPhase;

        private Integer errorCode;

        private String errorMessage;

        private List<HopDestination> hopDestinations = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private Integer jobPercentComplete;

        private String jobTemplate;

        private JobMessages messages;

        private List<OutputGroupDetail> outputGroupDetails = DefaultSdkAutoConstructList.getInstance();

        private Integer priority;

        private String queue;

        private List<QueueTransition> queueTransitions = DefaultSdkAutoConstructList.getInstance();

        private Integer retryCount;

        private String role;

        private JobSettings settings;

        private String simulateReservedQueue;

        private String status;

        private String statusUpdateInterval;

        private Timing timing;

        private Map<String, String> userMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            accelerationSettings(model.accelerationSettings);
            accelerationStatus(model.accelerationStatus);
            arn(model.arn);
            billingTagsSource(model.billingTagsSource);
            createdAt(model.createdAt);
            currentPhase(model.currentPhase);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            hopDestinations(model.hopDestinations);
            id(model.id);
            jobPercentComplete(model.jobPercentComplete);
            jobTemplate(model.jobTemplate);
            messages(model.messages);
            outputGroupDetails(model.outputGroupDetails);
            priority(model.priority);
            queue(model.queue);
            queueTransitions(model.queueTransitions);
            retryCount(model.retryCount);
            role(model.role);
            settings(model.settings);
            simulateReservedQueue(model.simulateReservedQueue);
            status(model.status);
            statusUpdateInterval(model.statusUpdateInterval);
            timing(model.timing);
            userMetadata(model.userMetadata);
        }

        public final AccelerationSettings.Builder getAccelerationSettings() {
            return accelerationSettings != null ? accelerationSettings.toBuilder() : null;
        }

        @Override
        public final Builder accelerationSettings(AccelerationSettings accelerationSettings) {
            this.accelerationSettings = accelerationSettings;
            return this;
        }

        public final void setAccelerationSettings(AccelerationSettings.BuilderImpl accelerationSettings) {
            this.accelerationSettings = accelerationSettings != null ? accelerationSettings.build() : null;
        }

        public final String getAccelerationStatus() {
            return accelerationStatus;
        }

        @Override
        public final Builder accelerationStatus(String accelerationStatus) {
            this.accelerationStatus = accelerationStatus;
            return this;
        }

        @Override
        public final Builder accelerationStatus(AccelerationStatus accelerationStatus) {
            this.accelerationStatus(accelerationStatus == null ? null : accelerationStatus.toString());
            return this;
        }

        public final void setAccelerationStatus(String accelerationStatus) {
            this.accelerationStatus = accelerationStatus;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getBillingTagsSource() {
            return billingTagsSource;
        }

        @Override
        public final Builder billingTagsSource(String billingTagsSource) {
            this.billingTagsSource = billingTagsSource;
            return this;
        }

        @Override
        public final Builder billingTagsSource(BillingTagsSource billingTagsSource) {
            this.billingTagsSource(billingTagsSource == null ? null : billingTagsSource.toString());
            return this;
        }

        public final void setBillingTagsSource(String billingTagsSource) {
            this.billingTagsSource = billingTagsSource;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getCurrentPhase() {
            return currentPhase;
        }

        @Override
        public final Builder currentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
            return this;
        }

        @Override
        public final Builder currentPhase(JobPhase currentPhase) {
            this.currentPhase(currentPhase == null ? null : currentPhase.toString());
            return this;
        }

        public final void setCurrentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
        }

        public final Integer getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(Integer errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Collection<HopDestination.Builder> getHopDestinations() {
            return hopDestinations != null ? hopDestinations.stream().map(HopDestination::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder hopDestinations(Collection<HopDestination> hopDestinations) {
            this.hopDestinations = ___listOfHopDestinationCopier.copy(hopDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hopDestinations(HopDestination... hopDestinations) {
            hopDestinations(Arrays.asList(hopDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hopDestinations(Consumer<HopDestination.Builder>... hopDestinations) {
            hopDestinations(Stream.of(hopDestinations).map(c -> HopDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setHopDestinations(Collection<HopDestination.BuilderImpl> hopDestinations) {
            this.hopDestinations = ___listOfHopDestinationCopier.copyFromBuilder(hopDestinations);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Integer getJobPercentComplete() {
            return jobPercentComplete;
        }

        @Override
        public final Builder jobPercentComplete(Integer jobPercentComplete) {
            this.jobPercentComplete = jobPercentComplete;
            return this;
        }

        public final void setJobPercentComplete(Integer jobPercentComplete) {
            this.jobPercentComplete = jobPercentComplete;
        }

        public final String getJobTemplate() {
            return jobTemplate;
        }

        @Override
        public final Builder jobTemplate(String jobTemplate) {
            this.jobTemplate = jobTemplate;
            return this;
        }

        public final void setJobTemplate(String jobTemplate) {
            this.jobTemplate = jobTemplate;
        }

        public final JobMessages.Builder getMessages() {
            return messages != null ? messages.toBuilder() : null;
        }

        @Override
        public final Builder messages(JobMessages messages) {
            this.messages = messages;
            return this;
        }

        public final void setMessages(JobMessages.BuilderImpl messages) {
            this.messages = messages != null ? messages.build() : null;
        }

        public final Collection<OutputGroupDetail.Builder> getOutputGroupDetails() {
            return outputGroupDetails != null ? outputGroupDetails.stream().map(OutputGroupDetail::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputGroupDetails(Collection<OutputGroupDetail> outputGroupDetails) {
            this.outputGroupDetails = ___listOfOutputGroupDetailCopier.copy(outputGroupDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroupDetails(OutputGroupDetail... outputGroupDetails) {
            outputGroupDetails(Arrays.asList(outputGroupDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroupDetails(Consumer<OutputGroupDetail.Builder>... outputGroupDetails) {
            outputGroupDetails(Stream.of(outputGroupDetails).map(c -> OutputGroupDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOutputGroupDetails(Collection<OutputGroupDetail.BuilderImpl> outputGroupDetails) {
            this.outputGroupDetails = ___listOfOutputGroupDetailCopier.copyFromBuilder(outputGroupDetails);
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getQueue() {
            return queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        public final Collection<QueueTransition.Builder> getQueueTransitions() {
            return queueTransitions != null ? queueTransitions.stream().map(QueueTransition::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queueTransitions(Collection<QueueTransition> queueTransitions) {
            this.queueTransitions = ___listOfQueueTransitionCopier.copy(queueTransitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueTransitions(QueueTransition... queueTransitions) {
            queueTransitions(Arrays.asList(queueTransitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueTransitions(Consumer<QueueTransition.Builder>... queueTransitions) {
            queueTransitions(Stream.of(queueTransitions).map(c -> QueueTransition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setQueueTransitions(Collection<QueueTransition.BuilderImpl> queueTransitions) {
            this.queueTransitions = ___listOfQueueTransitionCopier.copyFromBuilder(queueTransitions);
        }

        public final Integer getRetryCount() {
            return retryCount;
        }

        @Override
        public final Builder retryCount(Integer retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public final void setRetryCount(Integer retryCount) {
            this.retryCount = retryCount;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final JobSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(JobSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(JobSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final String getSimulateReservedQueue() {
            return simulateReservedQueue;
        }

        @Override
        public final Builder simulateReservedQueue(String simulateReservedQueue) {
            this.simulateReservedQueue = simulateReservedQueue;
            return this;
        }

        @Override
        public final Builder simulateReservedQueue(SimulateReservedQueue simulateReservedQueue) {
            this.simulateReservedQueue(simulateReservedQueue == null ? null : simulateReservedQueue.toString());
            return this;
        }

        public final void setSimulateReservedQueue(String simulateReservedQueue) {
            this.simulateReservedQueue = simulateReservedQueue;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusUpdateInterval() {
            return statusUpdateInterval;
        }

        @Override
        public final Builder statusUpdateInterval(String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
            return this;
        }

        @Override
        public final Builder statusUpdateInterval(StatusUpdateInterval statusUpdateInterval) {
            this.statusUpdateInterval(statusUpdateInterval == null ? null : statusUpdateInterval.toString());
            return this;
        }

        public final void setStatusUpdateInterval(String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
        }

        public final Timing.Builder getTiming() {
            return timing != null ? timing.toBuilder() : null;
        }

        @Override
        public final Builder timing(Timing timing) {
            this.timing = timing;
            return this;
        }

        public final void setTiming(Timing.BuilderImpl timing) {
            this.timing = timing != null ? timing.build() : null;
        }

        public final Map<String, String> getUserMetadata() {
            return userMetadata;
        }

        @Override
        public final Builder userMetadata(Map<String, String> userMetadata) {
            this.userMetadata = ___mapOf__stringCopier.copy(userMetadata);
            return this;
        }

        public final void setUserMetadata(Map<String, String> userMetadata) {
            this.userMetadata = ___mapOf__stringCopier.copy(userMetadata);
        }

        @Override
        public Job build() {
            return new Job(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
