/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Use Filter enable (InputFilterEnable) to specify how the transcoding service applies the denoise and deblock filters.
 * You must also enable the filters separately, with Denoise (InputDenoiseFilter) and Deblock (InputDeblockFilter). *
 * Auto - The transcoding service determines whether to apply filtering, depending on input type and quality. * Disable
 * - The input is not filtered. This is true even if you use the API to enable them in (InputDeblockFilter) and
 * (InputDeblockFilter). * Force - The in put is filtered regardless of input type.
 */
@Generated("software.amazon.awssdk:codegen")
public enum InputFilterEnable {
    AUTO("AUTO"),

    DISABLE("DISABLE"),

    FORCE("FORCE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InputFilterEnable(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return InputFilterEnable corresponding to the value
     */
    public static InputFilterEnable fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InputFilterEnable.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link InputFilterEnable}s
     */
    public static Set<InputFilterEnable> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
