/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Specifies media input
 */
@Generated("software.amazon.awssdk:codegen")
public final class Input implements SdkPojo, Serializable, ToCopyableBuilder<Input.Builder, Input> {
    private static final SdkField<Map<String, AudioSelectorGroup>> AUDIO_SELECTOR_GROUPS_FIELD = SdkField
            .<Map<String, AudioSelectorGroup>> builder(MarshallingType.MAP)
            .getter(getter(Input::audioSelectorGroups))
            .setter(setter(Builder::audioSelectorGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSelectorGroups").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AudioSelectorGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudioSelectorGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, AudioSelector>> AUDIO_SELECTORS_FIELD = SdkField
            .<Map<String, AudioSelector>> builder(MarshallingType.MAP)
            .getter(getter(Input::audioSelectors))
            .setter(setter(Builder::audioSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSelectors").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AudioSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudioSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, CaptionSelector>> CAPTION_SELECTORS_FIELD = SdkField
            .<Map<String, CaptionSelector>> builder(MarshallingType.MAP)
            .getter(getter(Input::captionSelectors))
            .setter(setter(Builder::captionSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionSelectors").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CaptionSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(CaptionSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Rectangle> CROP_FIELD = SdkField.<Rectangle> builder(MarshallingType.SDK_POJO)
            .getter(getter(Input::crop)).setter(setter(Builder::crop)).constructor(Rectangle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crop").build()).build();

    private static final SdkField<String> DEBLOCK_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Input::deblockFilterAsString)).setter(setter(Builder::deblockFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deblockFilter").build()).build();

    private static final SdkField<InputDecryptionSettings> DECRYPTION_SETTINGS_FIELD = SdkField
            .<InputDecryptionSettings> builder(MarshallingType.SDK_POJO).getter(getter(Input::decryptionSettings))
            .setter(setter(Builder::decryptionSettings)).constructor(InputDecryptionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryptionSettings").build())
            .build();

    private static final SdkField<String> DENOISE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Input::denoiseFilterAsString)).setter(setter(Builder::denoiseFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("denoiseFilter").build()).build();

    private static final SdkField<String> FILE_INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Input::fileInput)).setter(setter(Builder::fileInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileInput").build()).build();

    private static final SdkField<String> FILTER_ENABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Input::filterEnableAsString)).setter(setter(Builder::filterEnable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterEnable").build()).build();

    private static final SdkField<Integer> FILTER_STRENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Input::filterStrength)).setter(setter(Builder::filterStrength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterStrength").build()).build();

    private static final SdkField<ImageInserter> IMAGE_INSERTER_FIELD = SdkField
            .<ImageInserter> builder(MarshallingType.SDK_POJO).getter(getter(Input::imageInserter))
            .setter(setter(Builder::imageInserter)).constructor(ImageInserter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageInserter").build()).build();

    private static final SdkField<List<InputClipping>> INPUT_CLIPPINGS_FIELD = SdkField
            .<List<InputClipping>> builder(MarshallingType.LIST)
            .getter(getter(Input::inputClippings))
            .setter(setter(Builder::inputClippings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputClippings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputClipping> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputClipping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Rectangle> POSITION_FIELD = SdkField.<Rectangle> builder(MarshallingType.SDK_POJO)
            .getter(getter(Input::position)).setter(setter(Builder::position)).constructor(Rectangle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<Integer> PROGRAM_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Input::programNumber)).setter(setter(Builder::programNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programNumber").build()).build();

    private static final SdkField<String> PSI_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Input::psiControlAsString)).setter(setter(Builder::psiControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("psiControl").build()).build();

    private static final SdkField<List<String>> SUPPLEMENTAL_IMPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Input::supplementalImps))
            .setter(setter(Builder::supplementalImps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supplementalImps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TIMECODE_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Input::timecodeSourceAsString)).setter(setter(Builder::timecodeSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeSource").build()).build();

    private static final SdkField<String> TIMECODE_START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Input::timecodeStart)).setter(setter(Builder::timecodeStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeStart").build()).build();

    private static final SdkField<VideoSelector> VIDEO_SELECTOR_FIELD = SdkField
            .<VideoSelector> builder(MarshallingType.SDK_POJO).getter(getter(Input::videoSelector))
            .setter(setter(Builder::videoSelector)).constructor(VideoSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoSelector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_SELECTOR_GROUPS_FIELD,
            AUDIO_SELECTORS_FIELD, CAPTION_SELECTORS_FIELD, CROP_FIELD, DEBLOCK_FILTER_FIELD, DECRYPTION_SETTINGS_FIELD,
            DENOISE_FILTER_FIELD, FILE_INPUT_FIELD, FILTER_ENABLE_FIELD, FILTER_STRENGTH_FIELD, IMAGE_INSERTER_FIELD,
            INPUT_CLIPPINGS_FIELD, POSITION_FIELD, PROGRAM_NUMBER_FIELD, PSI_CONTROL_FIELD, SUPPLEMENTAL_IMPS_FIELD,
            TIMECODE_SOURCE_FIELD, TIMECODE_START_FIELD, VIDEO_SELECTOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, AudioSelectorGroup> audioSelectorGroups;

    private final Map<String, AudioSelector> audioSelectors;

    private final Map<String, CaptionSelector> captionSelectors;

    private final Rectangle crop;

    private final String deblockFilter;

    private final InputDecryptionSettings decryptionSettings;

    private final String denoiseFilter;

    private final String fileInput;

    private final String filterEnable;

    private final Integer filterStrength;

    private final ImageInserter imageInserter;

    private final List<InputClipping> inputClippings;

    private final Rectangle position;

    private final Integer programNumber;

    private final String psiControl;

    private final List<String> supplementalImps;

    private final String timecodeSource;

    private final String timecodeStart;

    private final VideoSelector videoSelector;

    private Input(BuilderImpl builder) {
        this.audioSelectorGroups = builder.audioSelectorGroups;
        this.audioSelectors = builder.audioSelectors;
        this.captionSelectors = builder.captionSelectors;
        this.crop = builder.crop;
        this.deblockFilter = builder.deblockFilter;
        this.decryptionSettings = builder.decryptionSettings;
        this.denoiseFilter = builder.denoiseFilter;
        this.fileInput = builder.fileInput;
        this.filterEnable = builder.filterEnable;
        this.filterStrength = builder.filterStrength;
        this.imageInserter = builder.imageInserter;
        this.inputClippings = builder.inputClippings;
        this.position = builder.position;
        this.programNumber = builder.programNumber;
        this.psiControl = builder.psiControl;
        this.supplementalImps = builder.supplementalImps;
        this.timecodeSource = builder.timecodeSource;
        this.timecodeStart = builder.timecodeStart;
        this.videoSelector = builder.videoSelector;
    }

    /**
     * Returns true if the AudioSelectorGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAudioSelectorGroups() {
        return audioSelectorGroups != null && !(audioSelectorGroups instanceof SdkAutoConstructMap);
    }

    /**
     * Specifies set of audio selectors within an input to combine. An input may have multiple audio selector groups.
     * See "Audio Selector Group":#inputs-audio_selector_group for more information.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAudioSelectorGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies set of audio selectors within an input to combine. An input may have multiple audio selector
     *         groups. See "Audio Selector Group":#inputs-audio_selector_group for more information.
     */
    public Map<String, AudioSelectorGroup> audioSelectorGroups() {
        return audioSelectorGroups;
    }

    /**
     * Returns true if the AudioSelectors property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAudioSelectors() {
        return audioSelectors != null && !(audioSelectors instanceof SdkAutoConstructMap);
    }

    /**
     * Use Audio selectors (AudioSelectors) to specify a track or set of tracks from the input that you will use in your
     * outputs. You can use multiple Audio selectors per input.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAudioSelectors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Use Audio selectors (AudioSelectors) to specify a track or set of tracks from the input that you will use
     *         in your outputs. You can use multiple Audio selectors per input.
     */
    public Map<String, AudioSelector> audioSelectors() {
        return audioSelectors;
    }

    /**
     * Returns true if the CaptionSelectors property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCaptionSelectors() {
        return captionSelectors != null && !(captionSelectors instanceof SdkAutoConstructMap);
    }

    /**
     * Use Captions selectors (CaptionSelectors) to specify the captions data from the input that you will use in your
     * outputs. You can use multiple captions selectors per input.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCaptionSelectors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Use Captions selectors (CaptionSelectors) to specify the captions data from the input that you will use
     *         in your outputs. You can use multiple captions selectors per input.
     */
    public Map<String, CaptionSelector> captionSelectors() {
        return captionSelectors;
    }

    /**
     * Use Cropping selection (crop) to specify the video area that the service will include in the output video frame.
     * If you specify a value here, it will override any value that you specify in the output setting Cropping selection
     * (crop).
     * 
     * @return Use Cropping selection (crop) to specify the video area that the service will include in the output video
     *         frame. If you specify a value here, it will override any value that you specify in the output setting
     *         Cropping selection (crop).
     */
    public Rectangle crop() {
        return crop;
    }

    /**
     * Enable Deblock (InputDeblockFilter) to produce smoother motion in the output. Default is disabled. Only manually
     * controllable for MPEG2 and uncompressed video inputs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deblockFilter}
     * will return {@link InputDeblockFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deblockFilterAsString}.
     * </p>
     * 
     * @return Enable Deblock (InputDeblockFilter) to produce smoother motion in the output. Default is disabled. Only
     *         manually controllable for MPEG2 and uncompressed video inputs.
     * @see InputDeblockFilter
     */
    public InputDeblockFilter deblockFilter() {
        return InputDeblockFilter.fromValue(deblockFilter);
    }

    /**
     * Enable Deblock (InputDeblockFilter) to produce smoother motion in the output. Default is disabled. Only manually
     * controllable for MPEG2 and uncompressed video inputs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deblockFilter}
     * will return {@link InputDeblockFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deblockFilterAsString}.
     * </p>
     * 
     * @return Enable Deblock (InputDeblockFilter) to produce smoother motion in the output. Default is disabled. Only
     *         manually controllable for MPEG2 and uncompressed video inputs.
     * @see InputDeblockFilter
     */
    public String deblockFilterAsString() {
        return deblockFilter;
    }

    /**
     * Settings for decrypting any input files that you encrypt before you upload them to Amazon S3. MediaConvert can
     * decrypt files only when you use AWS Key Management Service (KMS) to encrypt the data key that you use to encrypt
     * your content.
     * 
     * @return Settings for decrypting any input files that you encrypt before you upload them to Amazon S3.
     *         MediaConvert can decrypt files only when you use AWS Key Management Service (KMS) to encrypt the data key
     *         that you use to encrypt your content.
     */
    public InputDecryptionSettings decryptionSettings() {
        return decryptionSettings;
    }

    /**
     * Enable Denoise (InputDenoiseFilter) to filter noise from the input. Default is disabled. Only applicable to
     * MPEG2, H.264, H.265, and uncompressed video inputs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #denoiseFilter}
     * will return {@link InputDenoiseFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #denoiseFilterAsString}.
     * </p>
     * 
     * @return Enable Denoise (InputDenoiseFilter) to filter noise from the input. Default is disabled. Only applicable
     *         to MPEG2, H.264, H.265, and uncompressed video inputs.
     * @see InputDenoiseFilter
     */
    public InputDenoiseFilter denoiseFilter() {
        return InputDenoiseFilter.fromValue(denoiseFilter);
    }

    /**
     * Enable Denoise (InputDenoiseFilter) to filter noise from the input. Default is disabled. Only applicable to
     * MPEG2, H.264, H.265, and uncompressed video inputs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #denoiseFilter}
     * will return {@link InputDenoiseFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #denoiseFilterAsString}.
     * </p>
     * 
     * @return Enable Denoise (InputDenoiseFilter) to filter noise from the input. Default is disabled. Only applicable
     *         to MPEG2, H.264, H.265, and uncompressed video inputs.
     * @see InputDenoiseFilter
     */
    public String denoiseFilterAsString() {
        return denoiseFilter;
    }

    /**
     * Specify the source file for your transcoding job. You can use multiple inputs in a single job. The service
     * concatenates these inputs, in the order that you specify them in the job, to create the outputs. If your input
     * format is IMF, specify your input by providing the path to your CPL. For example, "s3://bucket/vf/cpl.xml". If
     * the CPL is in an incomplete IMP, make sure to use *Supplemental IMPs* (SupplementalImps) to specify any
     * supplemental IMPs that contain assets referenced by the CPL.
     * 
     * @return Specify the source file for your transcoding job. You can use multiple inputs in a single job. The
     *         service concatenates these inputs, in the order that you specify them in the job, to create the outputs.
     *         If your input format is IMF, specify your input by providing the path to your CPL. For example,
     *         "s3://bucket/vf/cpl.xml". If the CPL is in an incomplete IMP, make sure to use *Supplemental IMPs*
     *         (SupplementalImps) to specify any supplemental IMPs that contain assets referenced by the CPL.
     */
    public String fileInput() {
        return fileInput;
    }

    /**
     * Use Filter enable (InputFilterEnable) to specify how the transcoding service applies the denoise and deblock
     * filters. You must also enable the filters separately, with Denoise (InputDenoiseFilter) and Deblock
     * (InputDeblockFilter). * Auto - The transcoding service determines whether to apply filtering, depending on input
     * type and quality. * Disable - The input is not filtered. This is true even if you use the API to enable them in
     * (InputDeblockFilter) and (InputDeblockFilter). * Force - The in put is filtered regardless of input type.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterEnable} will
     * return {@link InputFilterEnable#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterEnableAsString}.
     * </p>
     * 
     * @return Use Filter enable (InputFilterEnable) to specify how the transcoding service applies the denoise and
     *         deblock filters. You must also enable the filters separately, with Denoise (InputDenoiseFilter) and
     *         Deblock (InputDeblockFilter). * Auto - The transcoding service determines whether to apply filtering,
     *         depending on input type and quality. * Disable - The input is not filtered. This is true even if you use
     *         the API to enable them in (InputDeblockFilter) and (InputDeblockFilter). * Force - The in put is filtered
     *         regardless of input type.
     * @see InputFilterEnable
     */
    public InputFilterEnable filterEnable() {
        return InputFilterEnable.fromValue(filterEnable);
    }

    /**
     * Use Filter enable (InputFilterEnable) to specify how the transcoding service applies the denoise and deblock
     * filters. You must also enable the filters separately, with Denoise (InputDenoiseFilter) and Deblock
     * (InputDeblockFilter). * Auto - The transcoding service determines whether to apply filtering, depending on input
     * type and quality. * Disable - The input is not filtered. This is true even if you use the API to enable them in
     * (InputDeblockFilter) and (InputDeblockFilter). * Force - The in put is filtered regardless of input type.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterEnable} will
     * return {@link InputFilterEnable#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterEnableAsString}.
     * </p>
     * 
     * @return Use Filter enable (InputFilterEnable) to specify how the transcoding service applies the denoise and
     *         deblock filters. You must also enable the filters separately, with Denoise (InputDenoiseFilter) and
     *         Deblock (InputDeblockFilter). * Auto - The transcoding service determines whether to apply filtering,
     *         depending on input type and quality. * Disable - The input is not filtered. This is true even if you use
     *         the API to enable them in (InputDeblockFilter) and (InputDeblockFilter). * Force - The in put is filtered
     *         regardless of input type.
     * @see InputFilterEnable
     */
    public String filterEnableAsString() {
        return filterEnable;
    }

    /**
     * Use Filter strength (FilterStrength) to adjust the magnitude the input filter settings (Deblock and Denoise). The
     * range is -5 to 5. Default is 0.
     * 
     * @return Use Filter strength (FilterStrength) to adjust the magnitude the input filter settings (Deblock and
     *         Denoise). The range is -5 to 5. Default is 0.
     */
    public Integer filterStrength() {
        return filterStrength;
    }

    /**
     * Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this feature for
     * each input individually. This setting is disabled by default.
     * 
     * @return Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this
     *         feature for each input individually. This setting is disabled by default.
     */
    public ImageInserter imageInserter() {
        return imageInserter;
    }

    /**
     * Returns true if the InputClippings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInputClippings() {
        return inputClippings != null && !(inputClippings instanceof SdkAutoConstructList);
    }

    /**
     * (InputClippings) contains sets of start and end times that together specify a portion of the input to be used in
     * the outputs. If you provide only a start time, the clip will be the entire input from that point to the end. If
     * you provide only an end time, it will be the entire input up to that point. When you specify more than one input
     * clip, the transcoding service creates the job outputs by stringing the clips together in the order you specify
     * them.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputClippings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (InputClippings) contains sets of start and end times that together specify a portion of the input to be
     *         used in the outputs. If you provide only a start time, the clip will be the entire input from that point
     *         to the end. If you provide only an end time, it will be the entire input up to that point. When you
     *         specify more than one input clip, the transcoding service creates the job outputs by stringing the clips
     *         together in the order you specify them.
     */
    public List<InputClipping> inputClippings() {
        return inputClippings;
    }

    /**
     * Use Selection placement (position) to define the video area in your output frame. The area outside of the
     * rectangle that you specify here is black. If you specify a value here, it will override any value that you
     * specify in the output setting Selection placement (position). If you specify a value here, this will override any
     * AFD values in your input, even if you set Respond to AFD (RespondToAfd) to Respond (RESPOND). If you specify a
     * value here, this will ignore anything that you specify for the setting Scaling Behavior (scalingBehavior).
     * 
     * @return Use Selection placement (position) to define the video area in your output frame. The area outside of the
     *         rectangle that you specify here is black. If you specify a value here, it will override any value that
     *         you specify in the output setting Selection placement (position). If you specify a value here, this will
     *         override any AFD values in your input, even if you set Respond to AFD (RespondToAfd) to Respond
     *         (RESPOND). If you specify a value here, this will ignore anything that you specify for the setting
     *         Scaling Behavior (scalingBehavior).
     */
    public Rectangle position() {
        return position;
    }

    /**
     * Use Program (programNumber) to select a specific program from within a multi-program transport stream. Note that
     * Quad 4K is not currently supported. Default is the first program within the transport stream. If the program you
     * specify doesn't exist, the transcoding service will use this default.
     * 
     * @return Use Program (programNumber) to select a specific program from within a multi-program transport stream.
     *         Note that Quad 4K is not currently supported. Default is the first program within the transport stream.
     *         If the program you specify doesn't exist, the transcoding service will use this default.
     */
    public Integer programNumber() {
        return programNumber;
    }

    /**
     * Set PSI control (InputPsiControl) for transport stream inputs to specify which data the demux process to scans. *
     * Ignore PSI - Scan all PIDs for audio and video. * Use PSI - Scan only PSI data.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #psiControl} will
     * return {@link InputPsiControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #psiControlAsString}.
     * </p>
     * 
     * @return Set PSI control (InputPsiControl) for transport stream inputs to specify which data the demux process to
     *         scans. * Ignore PSI - Scan all PIDs for audio and video. * Use PSI - Scan only PSI data.
     * @see InputPsiControl
     */
    public InputPsiControl psiControl() {
        return InputPsiControl.fromValue(psiControl);
    }

    /**
     * Set PSI control (InputPsiControl) for transport stream inputs to specify which data the demux process to scans. *
     * Ignore PSI - Scan all PIDs for audio and video. * Use PSI - Scan only PSI data.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #psiControl} will
     * return {@link InputPsiControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #psiControlAsString}.
     * </p>
     * 
     * @return Set PSI control (InputPsiControl) for transport stream inputs to specify which data the demux process to
     *         scans. * Ignore PSI - Scan all PIDs for audio and video. * Use PSI - Scan only PSI data.
     * @see InputPsiControl
     */
    public String psiControlAsString() {
        return psiControl;
    }

    /**
     * Returns true if the SupplementalImps property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSupplementalImps() {
        return supplementalImps != null && !(supplementalImps instanceof SdkAutoConstructList);
    }

    /**
     * Provide a list of any necessary supplemental IMPs. You need supplemental IMPs if the CPL that you're using for
     * your input is in an incomplete IMP. Specify either the supplemental IMP directories with a trailing slash or the
     * ASSETMAP.xml files. For example ["s3://bucket/ov/", "s3://bucket/vf2/ASSETMAP.xml"]. You don't need to specify
     * the IMP that contains your input CPL, because the service automatically detects it.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupplementalImps()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provide a list of any necessary supplemental IMPs. You need supplemental IMPs if the CPL that you're
     *         using for your input is in an incomplete IMP. Specify either the supplemental IMP directories with a
     *         trailing slash or the ASSETMAP.xml files. For example ["s3://bucket/ov/",
     *         "s3://bucket/vf2/ASSETMAP.xml"]. You don't need to specify the IMP that contains your input CPL, because
     *         the service automatically detects it.
     */
    public List<String> supplementalImps() {
        return supplementalImps;
    }

    /**
     * Use this Timecode source setting, located under the input settings (InputTimecodeSource), to specify how the
     * service counts input video frames. This input frame count affects only the behavior of features that apply to a
     * single input at a time, such as input clipping and synchronizing some captions formats. Choose Embedded
     * (EMBEDDED) to use the timecodes in your input video. Choose Start at zero (ZEROBASED) to start the first frame at
     * zero. Choose Specified start (SPECIFIEDSTART) to start the first frame at the timecode that you specify in the
     * setting Start timecode (timecodeStart). If you don't specify a value for Timecode source, the service will use
     * Embedded by default. For more information about timecodes, see
     * https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timecodeSource}
     * will return {@link InputTimecodeSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timecodeSourceAsString}.
     * </p>
     * 
     * @return Use this Timecode source setting, located under the input settings (InputTimecodeSource), to specify how
     *         the service counts input video frames. This input frame count affects only the behavior of features that
     *         apply to a single input at a time, such as input clipping and synchronizing some captions formats. Choose
     *         Embedded (EMBEDDED) to use the timecodes in your input video. Choose Start at zero (ZEROBASED) to start
     *         the first frame at zero. Choose Specified start (SPECIFIEDSTART) to start the first frame at the timecode
     *         that you specify in the setting Start timecode (timecodeStart). If you don't specify a value for Timecode
     *         source, the service will use Embedded by default. For more information about timecodes, see
     *         https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * @see InputTimecodeSource
     */
    public InputTimecodeSource timecodeSource() {
        return InputTimecodeSource.fromValue(timecodeSource);
    }

    /**
     * Use this Timecode source setting, located under the input settings (InputTimecodeSource), to specify how the
     * service counts input video frames. This input frame count affects only the behavior of features that apply to a
     * single input at a time, such as input clipping and synchronizing some captions formats. Choose Embedded
     * (EMBEDDED) to use the timecodes in your input video. Choose Start at zero (ZEROBASED) to start the first frame at
     * zero. Choose Specified start (SPECIFIEDSTART) to start the first frame at the timecode that you specify in the
     * setting Start timecode (timecodeStart). If you don't specify a value for Timecode source, the service will use
     * Embedded by default. For more information about timecodes, see
     * https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timecodeSource}
     * will return {@link InputTimecodeSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timecodeSourceAsString}.
     * </p>
     * 
     * @return Use this Timecode source setting, located under the input settings (InputTimecodeSource), to specify how
     *         the service counts input video frames. This input frame count affects only the behavior of features that
     *         apply to a single input at a time, such as input clipping and synchronizing some captions formats. Choose
     *         Embedded (EMBEDDED) to use the timecodes in your input video. Choose Start at zero (ZEROBASED) to start
     *         the first frame at zero. Choose Specified start (SPECIFIEDSTART) to start the first frame at the timecode
     *         that you specify in the setting Start timecode (timecodeStart). If you don't specify a value for Timecode
     *         source, the service will use Embedded by default. For more information about timecodes, see
     *         https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * @see InputTimecodeSource
     */
    public String timecodeSourceAsString() {
        return timecodeSource;
    }

    /**
     * Specify the timecode that you want the service to use for this input's initial frame. To use this setting, you
     * must set the Timecode source setting, located under the input settings (InputTimecodeSource), to Specified start
     * (SPECIFIEDSTART). For more information about timecodes, see
     * https://docs.aws.amazon.com/console/mediaconvert/timecode.
     * 
     * @return Specify the timecode that you want the service to use for this input's initial frame. To use this
     *         setting, you must set the Timecode source setting, located under the input settings
     *         (InputTimecodeSource), to Specified start (SPECIFIEDSTART). For more information about timecodes, see
     *         https://docs.aws.amazon.com/console/mediaconvert/timecode.
     */
    public String timecodeStart() {
        return timecodeStart;
    }

    /**
     * Selector for video.
     * 
     * @return Selector for video.
     */
    public VideoSelector videoSelector() {
        return videoSelector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioSelectorGroups());
        hashCode = 31 * hashCode + Objects.hashCode(audioSelectors());
        hashCode = 31 * hashCode + Objects.hashCode(captionSelectors());
        hashCode = 31 * hashCode + Objects.hashCode(crop());
        hashCode = 31 * hashCode + Objects.hashCode(deblockFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(decryptionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(denoiseFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fileInput());
        hashCode = 31 * hashCode + Objects.hashCode(filterEnableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterStrength());
        hashCode = 31 * hashCode + Objects.hashCode(imageInserter());
        hashCode = 31 * hashCode + Objects.hashCode(inputClippings());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(programNumber());
        hashCode = 31 * hashCode + Objects.hashCode(psiControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(supplementalImps());
        hashCode = 31 * hashCode + Objects.hashCode(timecodeSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timecodeStart());
        hashCode = 31 * hashCode + Objects.hashCode(videoSelector());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input) obj;
        return Objects.equals(audioSelectorGroups(), other.audioSelectorGroups())
                && Objects.equals(audioSelectors(), other.audioSelectors())
                && Objects.equals(captionSelectors(), other.captionSelectors()) && Objects.equals(crop(), other.crop())
                && Objects.equals(deblockFilterAsString(), other.deblockFilterAsString())
                && Objects.equals(decryptionSettings(), other.decryptionSettings())
                && Objects.equals(denoiseFilterAsString(), other.denoiseFilterAsString())
                && Objects.equals(fileInput(), other.fileInput())
                && Objects.equals(filterEnableAsString(), other.filterEnableAsString())
                && Objects.equals(filterStrength(), other.filterStrength())
                && Objects.equals(imageInserter(), other.imageInserter())
                && Objects.equals(inputClippings(), other.inputClippings()) && Objects.equals(position(), other.position())
                && Objects.equals(programNumber(), other.programNumber())
                && Objects.equals(psiControlAsString(), other.psiControlAsString())
                && Objects.equals(supplementalImps(), other.supplementalImps())
                && Objects.equals(timecodeSourceAsString(), other.timecodeSourceAsString())
                && Objects.equals(timecodeStart(), other.timecodeStart())
                && Objects.equals(videoSelector(), other.videoSelector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Input").add("AudioSelectorGroups", audioSelectorGroups())
                .add("AudioSelectors", audioSelectors()).add("CaptionSelectors", captionSelectors()).add("Crop", crop())
                .add("DeblockFilter", deblockFilterAsString()).add("DecryptionSettings", decryptionSettings())
                .add("DenoiseFilter", denoiseFilterAsString()).add("FileInput", fileInput())
                .add("FilterEnable", filterEnableAsString()).add("FilterStrength", filterStrength())
                .add("ImageInserter", imageInserter()).add("InputClippings", inputClippings()).add("Position", position())
                .add("ProgramNumber", programNumber()).add("PsiControl", psiControlAsString())
                .add("SupplementalImps", supplementalImps()).add("TimecodeSource", timecodeSourceAsString())
                .add("TimecodeStart", timecodeStart()).add("VideoSelector", videoSelector()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioSelectorGroups":
            return Optional.ofNullable(clazz.cast(audioSelectorGroups()));
        case "AudioSelectors":
            return Optional.ofNullable(clazz.cast(audioSelectors()));
        case "CaptionSelectors":
            return Optional.ofNullable(clazz.cast(captionSelectors()));
        case "Crop":
            return Optional.ofNullable(clazz.cast(crop()));
        case "DeblockFilter":
            return Optional.ofNullable(clazz.cast(deblockFilterAsString()));
        case "DecryptionSettings":
            return Optional.ofNullable(clazz.cast(decryptionSettings()));
        case "DenoiseFilter":
            return Optional.ofNullable(clazz.cast(denoiseFilterAsString()));
        case "FileInput":
            return Optional.ofNullable(clazz.cast(fileInput()));
        case "FilterEnable":
            return Optional.ofNullable(clazz.cast(filterEnableAsString()));
        case "FilterStrength":
            return Optional.ofNullable(clazz.cast(filterStrength()));
        case "ImageInserter":
            return Optional.ofNullable(clazz.cast(imageInserter()));
        case "InputClippings":
            return Optional.ofNullable(clazz.cast(inputClippings()));
        case "Position":
            return Optional.ofNullable(clazz.cast(position()));
        case "ProgramNumber":
            return Optional.ofNullable(clazz.cast(programNumber()));
        case "PsiControl":
            return Optional.ofNullable(clazz.cast(psiControlAsString()));
        case "SupplementalImps":
            return Optional.ofNullable(clazz.cast(supplementalImps()));
        case "TimecodeSource":
            return Optional.ofNullable(clazz.cast(timecodeSourceAsString()));
        case "TimecodeStart":
            return Optional.ofNullable(clazz.cast(timecodeStart()));
        case "VideoSelector":
            return Optional.ofNullable(clazz.cast(videoSelector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Input, T> g) {
        return obj -> g.apply((Input) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Input> {
        /**
         * Specifies set of audio selectors within an input to combine. An input may have multiple audio selector
         * groups. See "Audio Selector Group":#inputs-audio_selector_group for more information.
         * 
         * @param audioSelectorGroups
         *        Specifies set of audio selectors within an input to combine. An input may have multiple audio selector
         *        groups. See "Audio Selector Group":#inputs-audio_selector_group for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioSelectorGroups(Map<String, AudioSelectorGroup> audioSelectorGroups);

        /**
         * Use Audio selectors (AudioSelectors) to specify a track or set of tracks from the input that you will use in
         * your outputs. You can use multiple Audio selectors per input.
         * 
         * @param audioSelectors
         *        Use Audio selectors (AudioSelectors) to specify a track or set of tracks from the input that you will
         *        use in your outputs. You can use multiple Audio selectors per input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioSelectors(Map<String, AudioSelector> audioSelectors);

        /**
         * Use Captions selectors (CaptionSelectors) to specify the captions data from the input that you will use in
         * your outputs. You can use multiple captions selectors per input.
         * 
         * @param captionSelectors
         *        Use Captions selectors (CaptionSelectors) to specify the captions data from the input that you will
         *        use in your outputs. You can use multiple captions selectors per input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionSelectors(Map<String, CaptionSelector> captionSelectors);

        /**
         * Use Cropping selection (crop) to specify the video area that the service will include in the output video
         * frame. If you specify a value here, it will override any value that you specify in the output setting
         * Cropping selection (crop).
         * 
         * @param crop
         *        Use Cropping selection (crop) to specify the video area that the service will include in the output
         *        video frame. If you specify a value here, it will override any value that you specify in the output
         *        setting Cropping selection (crop).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crop(Rectangle crop);

        /**
         * Use Cropping selection (crop) to specify the video area that the service will include in the output video
         * frame. If you specify a value here, it will override any value that you specify in the output setting
         * Cropping selection (crop). This is a convenience that creates an instance of the {@link Rectangle.Builder}
         * avoiding the need to create one manually via {@link Rectangle#builder()}.
         *
         * When the {@link Consumer} completes, {@link Rectangle.Builder#build()} is called immediately and its result
         * is passed to {@link #crop(Rectangle)}.
         * 
         * @param crop
         *        a consumer that will call methods on {@link Rectangle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crop(Rectangle)
         */
        default Builder crop(Consumer<Rectangle.Builder> crop) {
            return crop(Rectangle.builder().applyMutation(crop).build());
        }

        /**
         * Enable Deblock (InputDeblockFilter) to produce smoother motion in the output. Default is disabled. Only
         * manually controllable for MPEG2 and uncompressed video inputs.
         * 
         * @param deblockFilter
         *        Enable Deblock (InputDeblockFilter) to produce smoother motion in the output. Default is disabled.
         *        Only manually controllable for MPEG2 and uncompressed video inputs.
         * @see InputDeblockFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeblockFilter
         */
        Builder deblockFilter(String deblockFilter);

        /**
         * Enable Deblock (InputDeblockFilter) to produce smoother motion in the output. Default is disabled. Only
         * manually controllable for MPEG2 and uncompressed video inputs.
         * 
         * @param deblockFilter
         *        Enable Deblock (InputDeblockFilter) to produce smoother motion in the output. Default is disabled.
         *        Only manually controllable for MPEG2 and uncompressed video inputs.
         * @see InputDeblockFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeblockFilter
         */
        Builder deblockFilter(InputDeblockFilter deblockFilter);

        /**
         * Settings for decrypting any input files that you encrypt before you upload them to Amazon S3. MediaConvert
         * can decrypt files only when you use AWS Key Management Service (KMS) to encrypt the data key that you use to
         * encrypt your content.
         * 
         * @param decryptionSettings
         *        Settings for decrypting any input files that you encrypt before you upload them to Amazon S3.
         *        MediaConvert can decrypt files only when you use AWS Key Management Service (KMS) to encrypt the data
         *        key that you use to encrypt your content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decryptionSettings(InputDecryptionSettings decryptionSettings);

        /**
         * Settings for decrypting any input files that you encrypt before you upload them to Amazon S3. MediaConvert
         * can decrypt files only when you use AWS Key Management Service (KMS) to encrypt the data key that you use to
         * encrypt your content. This is a convenience that creates an instance of the
         * {@link InputDecryptionSettings.Builder} avoiding the need to create one manually via
         * {@link InputDecryptionSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputDecryptionSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #decryptionSettings(InputDecryptionSettings)}.
         * 
         * @param decryptionSettings
         *        a consumer that will call methods on {@link InputDecryptionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decryptionSettings(InputDecryptionSettings)
         */
        default Builder decryptionSettings(Consumer<InputDecryptionSettings.Builder> decryptionSettings) {
            return decryptionSettings(InputDecryptionSettings.builder().applyMutation(decryptionSettings).build());
        }

        /**
         * Enable Denoise (InputDenoiseFilter) to filter noise from the input. Default is disabled. Only applicable to
         * MPEG2, H.264, H.265, and uncompressed video inputs.
         * 
         * @param denoiseFilter
         *        Enable Denoise (InputDenoiseFilter) to filter noise from the input. Default is disabled. Only
         *        applicable to MPEG2, H.264, H.265, and uncompressed video inputs.
         * @see InputDenoiseFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDenoiseFilter
         */
        Builder denoiseFilter(String denoiseFilter);

        /**
         * Enable Denoise (InputDenoiseFilter) to filter noise from the input. Default is disabled. Only applicable to
         * MPEG2, H.264, H.265, and uncompressed video inputs.
         * 
         * @param denoiseFilter
         *        Enable Denoise (InputDenoiseFilter) to filter noise from the input. Default is disabled. Only
         *        applicable to MPEG2, H.264, H.265, and uncompressed video inputs.
         * @see InputDenoiseFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDenoiseFilter
         */
        Builder denoiseFilter(InputDenoiseFilter denoiseFilter);

        /**
         * Specify the source file for your transcoding job. You can use multiple inputs in a single job. The service
         * concatenates these inputs, in the order that you specify them in the job, to create the outputs. If your
         * input format is IMF, specify your input by providing the path to your CPL. For example,
         * "s3://bucket/vf/cpl.xml". If the CPL is in an incomplete IMP, make sure to use *Supplemental IMPs*
         * (SupplementalImps) to specify any supplemental IMPs that contain assets referenced by the CPL.
         * 
         * @param fileInput
         *        Specify the source file for your transcoding job. You can use multiple inputs in a single job. The
         *        service concatenates these inputs, in the order that you specify them in the job, to create the
         *        outputs. If your input format is IMF, specify your input by providing the path to your CPL. For
         *        example, "s3://bucket/vf/cpl.xml". If the CPL is in an incomplete IMP, make sure to use *Supplemental
         *        IMPs* (SupplementalImps) to specify any supplemental IMPs that contain assets referenced by the CPL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileInput(String fileInput);

        /**
         * Use Filter enable (InputFilterEnable) to specify how the transcoding service applies the denoise and deblock
         * filters. You must also enable the filters separately, with Denoise (InputDenoiseFilter) and Deblock
         * (InputDeblockFilter). * Auto - The transcoding service determines whether to apply filtering, depending on
         * input type and quality. * Disable - The input is not filtered. This is true even if you use the API to enable
         * them in (InputDeblockFilter) and (InputDeblockFilter). * Force - The in put is filtered regardless of input
         * type.
         * 
         * @param filterEnable
         *        Use Filter enable (InputFilterEnable) to specify how the transcoding service applies the denoise and
         *        deblock filters. You must also enable the filters separately, with Denoise (InputDenoiseFilter) and
         *        Deblock (InputDeblockFilter). * Auto - The transcoding service determines whether to apply filtering,
         *        depending on input type and quality. * Disable - The input is not filtered. This is true even if you
         *        use the API to enable them in (InputDeblockFilter) and (InputDeblockFilter). * Force - The in put is
         *        filtered regardless of input type.
         * @see InputFilterEnable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputFilterEnable
         */
        Builder filterEnable(String filterEnable);

        /**
         * Use Filter enable (InputFilterEnable) to specify how the transcoding service applies the denoise and deblock
         * filters. You must also enable the filters separately, with Denoise (InputDenoiseFilter) and Deblock
         * (InputDeblockFilter). * Auto - The transcoding service determines whether to apply filtering, depending on
         * input type and quality. * Disable - The input is not filtered. This is true even if you use the API to enable
         * them in (InputDeblockFilter) and (InputDeblockFilter). * Force - The in put is filtered regardless of input
         * type.
         * 
         * @param filterEnable
         *        Use Filter enable (InputFilterEnable) to specify how the transcoding service applies the denoise and
         *        deblock filters. You must also enable the filters separately, with Denoise (InputDenoiseFilter) and
         *        Deblock (InputDeblockFilter). * Auto - The transcoding service determines whether to apply filtering,
         *        depending on input type and quality. * Disable - The input is not filtered. This is true even if you
         *        use the API to enable them in (InputDeblockFilter) and (InputDeblockFilter). * Force - The in put is
         *        filtered regardless of input type.
         * @see InputFilterEnable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputFilterEnable
         */
        Builder filterEnable(InputFilterEnable filterEnable);

        /**
         * Use Filter strength (FilterStrength) to adjust the magnitude the input filter settings (Deblock and Denoise).
         * The range is -5 to 5. Default is 0.
         * 
         * @param filterStrength
         *        Use Filter strength (FilterStrength) to adjust the magnitude the input filter settings (Deblock and
         *        Denoise). The range is -5 to 5. Default is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterStrength(Integer filterStrength);

        /**
         * Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this feature
         * for each input individually. This setting is disabled by default.
         * 
         * @param imageInserter
         *        Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this
         *        feature for each input individually. This setting is disabled by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageInserter(ImageInserter imageInserter);

        /**
         * Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this feature
         * for each input individually. This setting is disabled by default. This is a convenience that creates an
         * instance of the {@link ImageInserter.Builder} avoiding the need to create one manually via
         * {@link ImageInserter#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageInserter.Builder#build()} is called immediately and its
         * result is passed to {@link #imageInserter(ImageInserter)}.
         * 
         * @param imageInserter
         *        a consumer that will call methods on {@link ImageInserter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageInserter(ImageInserter)
         */
        default Builder imageInserter(Consumer<ImageInserter.Builder> imageInserter) {
            return imageInserter(ImageInserter.builder().applyMutation(imageInserter).build());
        }

        /**
         * (InputClippings) contains sets of start and end times that together specify a portion of the input to be used
         * in the outputs. If you provide only a start time, the clip will be the entire input from that point to the
         * end. If you provide only an end time, it will be the entire input up to that point. When you specify more
         * than one input clip, the transcoding service creates the job outputs by stringing the clips together in the
         * order you specify them.
         * 
         * @param inputClippings
         *        (InputClippings) contains sets of start and end times that together specify a portion of the input to
         *        be used in the outputs. If you provide only a start time, the clip will be the entire input from that
         *        point to the end. If you provide only an end time, it will be the entire input up to that point. When
         *        you specify more than one input clip, the transcoding service creates the job outputs by stringing the
         *        clips together in the order you specify them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputClippings(Collection<InputClipping> inputClippings);

        /**
         * (InputClippings) contains sets of start and end times that together specify a portion of the input to be used
         * in the outputs. If you provide only a start time, the clip will be the entire input from that point to the
         * end. If you provide only an end time, it will be the entire input up to that point. When you specify more
         * than one input clip, the transcoding service creates the job outputs by stringing the clips together in the
         * order you specify them.
         * 
         * @param inputClippings
         *        (InputClippings) contains sets of start and end times that together specify a portion of the input to
         *        be used in the outputs. If you provide only a start time, the clip will be the entire input from that
         *        point to the end. If you provide only an end time, it will be the entire input up to that point. When
         *        you specify more than one input clip, the transcoding service creates the job outputs by stringing the
         *        clips together in the order you specify them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputClippings(InputClipping... inputClippings);

        /**
         * (InputClippings) contains sets of start and end times that together specify a portion of the input to be used
         * in the outputs. If you provide only a start time, the clip will be the entire input from that point to the
         * end. If you provide only an end time, it will be the entire input up to that point. When you specify more
         * than one input clip, the transcoding service creates the job outputs by stringing the clips together in the
         * order you specify them. This is a convenience that creates an instance of the {@link List
         * <InputClipping>.Builder} avoiding the need to create one manually via {@link List<InputClipping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputClipping>.Builder#build()} is called immediately and
         * its result is passed to {@link #inputClippings(List<InputClipping>)}.
         * 
         * @param inputClippings
         *        a consumer that will call methods on {@link List<InputClipping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputClippings(List<InputClipping>)
         */
        Builder inputClippings(Consumer<InputClipping.Builder>... inputClippings);

        /**
         * Use Selection placement (position) to define the video area in your output frame. The area outside of the
         * rectangle that you specify here is black. If you specify a value here, it will override any value that you
         * specify in the output setting Selection placement (position). If you specify a value here, this will override
         * any AFD values in your input, even if you set Respond to AFD (RespondToAfd) to Respond (RESPOND). If you
         * specify a value here, this will ignore anything that you specify for the setting Scaling Behavior
         * (scalingBehavior).
         * 
         * @param position
         *        Use Selection placement (position) to define the video area in your output frame. The area outside of
         *        the rectangle that you specify here is black. If you specify a value here, it will override any value
         *        that you specify in the output setting Selection placement (position). If you specify a value here,
         *        this will override any AFD values in your input, even if you set Respond to AFD (RespondToAfd) to
         *        Respond (RESPOND). If you specify a value here, this will ignore anything that you specify for the
         *        setting Scaling Behavior (scalingBehavior).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Rectangle position);

        /**
         * Use Selection placement (position) to define the video area in your output frame. The area outside of the
         * rectangle that you specify here is black. If you specify a value here, it will override any value that you
         * specify in the output setting Selection placement (position). If you specify a value here, this will override
         * any AFD values in your input, even if you set Respond to AFD (RespondToAfd) to Respond (RESPOND). If you
         * specify a value here, this will ignore anything that you specify for the setting Scaling Behavior
         * (scalingBehavior). This is a convenience that creates an instance of the {@link Rectangle.Builder} avoiding
         * the need to create one manually via {@link Rectangle#builder()}.
         *
         * When the {@link Consumer} completes, {@link Rectangle.Builder#build()} is called immediately and its result
         * is passed to {@link #position(Rectangle)}.
         * 
         * @param position
         *        a consumer that will call methods on {@link Rectangle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #position(Rectangle)
         */
        default Builder position(Consumer<Rectangle.Builder> position) {
            return position(Rectangle.builder().applyMutation(position).build());
        }

        /**
         * Use Program (programNumber) to select a specific program from within a multi-program transport stream. Note
         * that Quad 4K is not currently supported. Default is the first program within the transport stream. If the
         * program you specify doesn't exist, the transcoding service will use this default.
         * 
         * @param programNumber
         *        Use Program (programNumber) to select a specific program from within a multi-program transport stream.
         *        Note that Quad 4K is not currently supported. Default is the first program within the transport
         *        stream. If the program you specify doesn't exist, the transcoding service will use this default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programNumber(Integer programNumber);

        /**
         * Set PSI control (InputPsiControl) for transport stream inputs to specify which data the demux process to
         * scans. * Ignore PSI - Scan all PIDs for audio and video. * Use PSI - Scan only PSI data.
         * 
         * @param psiControl
         *        Set PSI control (InputPsiControl) for transport stream inputs to specify which data the demux process
         *        to scans. * Ignore PSI - Scan all PIDs for audio and video. * Use PSI - Scan only PSI data.
         * @see InputPsiControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputPsiControl
         */
        Builder psiControl(String psiControl);

        /**
         * Set PSI control (InputPsiControl) for transport stream inputs to specify which data the demux process to
         * scans. * Ignore PSI - Scan all PIDs for audio and video. * Use PSI - Scan only PSI data.
         * 
         * @param psiControl
         *        Set PSI control (InputPsiControl) for transport stream inputs to specify which data the demux process
         *        to scans. * Ignore PSI - Scan all PIDs for audio and video. * Use PSI - Scan only PSI data.
         * @see InputPsiControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputPsiControl
         */
        Builder psiControl(InputPsiControl psiControl);

        /**
         * Provide a list of any necessary supplemental IMPs. You need supplemental IMPs if the CPL that you're using
         * for your input is in an incomplete IMP. Specify either the supplemental IMP directories with a trailing slash
         * or the ASSETMAP.xml files. For example ["s3://bucket/ov/", "s3://bucket/vf2/ASSETMAP.xml"]. You don't need to
         * specify the IMP that contains your input CPL, because the service automatically detects it.
         * 
         * @param supplementalImps
         *        Provide a list of any necessary supplemental IMPs. You need supplemental IMPs if the CPL that you're
         *        using for your input is in an incomplete IMP. Specify either the supplemental IMP directories with a
         *        trailing slash or the ASSETMAP.xml files. For example ["s3://bucket/ov/",
         *        "s3://bucket/vf2/ASSETMAP.xml"]. You don't need to specify the IMP that contains your input CPL,
         *        because the service automatically detects it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supplementalImps(Collection<String> supplementalImps);

        /**
         * Provide a list of any necessary supplemental IMPs. You need supplemental IMPs if the CPL that you're using
         * for your input is in an incomplete IMP. Specify either the supplemental IMP directories with a trailing slash
         * or the ASSETMAP.xml files. For example ["s3://bucket/ov/", "s3://bucket/vf2/ASSETMAP.xml"]. You don't need to
         * specify the IMP that contains your input CPL, because the service automatically detects it.
         * 
         * @param supplementalImps
         *        Provide a list of any necessary supplemental IMPs. You need supplemental IMPs if the CPL that you're
         *        using for your input is in an incomplete IMP. Specify either the supplemental IMP directories with a
         *        trailing slash or the ASSETMAP.xml files. For example ["s3://bucket/ov/",
         *        "s3://bucket/vf2/ASSETMAP.xml"]. You don't need to specify the IMP that contains your input CPL,
         *        because the service automatically detects it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supplementalImps(String... supplementalImps);

        /**
         * Use this Timecode source setting, located under the input settings (InputTimecodeSource), to specify how the
         * service counts input video frames. This input frame count affects only the behavior of features that apply to
         * a single input at a time, such as input clipping and synchronizing some captions formats. Choose Embedded
         * (EMBEDDED) to use the timecodes in your input video. Choose Start at zero (ZEROBASED) to start the first
         * frame at zero. Choose Specified start (SPECIFIEDSTART) to start the first frame at the timecode that you
         * specify in the setting Start timecode (timecodeStart). If you don't specify a value for Timecode source, the
         * service will use Embedded by default. For more information about timecodes, see
         * https://docs.aws.amazon.com/console/mediaconvert/timecode.
         * 
         * @param timecodeSource
         *        Use this Timecode source setting, located under the input settings (InputTimecodeSource), to specify
         *        how the service counts input video frames. This input frame count affects only the behavior of
         *        features that apply to a single input at a time, such as input clipping and synchronizing some
         *        captions formats. Choose Embedded (EMBEDDED) to use the timecodes in your input video. Choose Start at
         *        zero (ZEROBASED) to start the first frame at zero. Choose Specified start (SPECIFIEDSTART) to start
         *        the first frame at the timecode that you specify in the setting Start timecode (timecodeStart). If you
         *        don't specify a value for Timecode source, the service will use Embedded by default. For more
         *        information about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
         * @see InputTimecodeSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputTimecodeSource
         */
        Builder timecodeSource(String timecodeSource);

        /**
         * Use this Timecode source setting, located under the input settings (InputTimecodeSource), to specify how the
         * service counts input video frames. This input frame count affects only the behavior of features that apply to
         * a single input at a time, such as input clipping and synchronizing some captions formats. Choose Embedded
         * (EMBEDDED) to use the timecodes in your input video. Choose Start at zero (ZEROBASED) to start the first
         * frame at zero. Choose Specified start (SPECIFIEDSTART) to start the first frame at the timecode that you
         * specify in the setting Start timecode (timecodeStart). If you don't specify a value for Timecode source, the
         * service will use Embedded by default. For more information about timecodes, see
         * https://docs.aws.amazon.com/console/mediaconvert/timecode.
         * 
         * @param timecodeSource
         *        Use this Timecode source setting, located under the input settings (InputTimecodeSource), to specify
         *        how the service counts input video frames. This input frame count affects only the behavior of
         *        features that apply to a single input at a time, such as input clipping and synchronizing some
         *        captions formats. Choose Embedded (EMBEDDED) to use the timecodes in your input video. Choose Start at
         *        zero (ZEROBASED) to start the first frame at zero. Choose Specified start (SPECIFIEDSTART) to start
         *        the first frame at the timecode that you specify in the setting Start timecode (timecodeStart). If you
         *        don't specify a value for Timecode source, the service will use Embedded by default. For more
         *        information about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
         * @see InputTimecodeSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputTimecodeSource
         */
        Builder timecodeSource(InputTimecodeSource timecodeSource);

        /**
         * Specify the timecode that you want the service to use for this input's initial frame. To use this setting,
         * you must set the Timecode source setting, located under the input settings (InputTimecodeSource), to
         * Specified start (SPECIFIEDSTART). For more information about timecodes, see
         * https://docs.aws.amazon.com/console/mediaconvert/timecode.
         * 
         * @param timecodeStart
         *        Specify the timecode that you want the service to use for this input's initial frame. To use this
         *        setting, you must set the Timecode source setting, located under the input settings
         *        (InputTimecodeSource), to Specified start (SPECIFIEDSTART). For more information about timecodes, see
         *        https://docs.aws.amazon.com/console/mediaconvert/timecode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timecodeStart(String timecodeStart);

        /**
         * Selector for video.
         * 
         * @param videoSelector
         *        Selector for video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoSelector(VideoSelector videoSelector);

        /**
         * Selector for video. This is a convenience that creates an instance of the {@link VideoSelector.Builder}
         * avoiding the need to create one manually via {@link VideoSelector#builder()}.
         *
         * When the {@link Consumer} completes, {@link VideoSelector.Builder#build()} is called immediately and its
         * result is passed to {@link #videoSelector(VideoSelector)}.
         * 
         * @param videoSelector
         *        a consumer that will call methods on {@link VideoSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoSelector(VideoSelector)
         */
        default Builder videoSelector(Consumer<VideoSelector.Builder> videoSelector) {
            return videoSelector(VideoSelector.builder().applyMutation(videoSelector).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Map<String, AudioSelectorGroup> audioSelectorGroups = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, AudioSelector> audioSelectors = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, CaptionSelector> captionSelectors = DefaultSdkAutoConstructMap.getInstance();

        private Rectangle crop;

        private String deblockFilter;

        private InputDecryptionSettings decryptionSettings;

        private String denoiseFilter;

        private String fileInput;

        private String filterEnable;

        private Integer filterStrength;

        private ImageInserter imageInserter;

        private List<InputClipping> inputClippings = DefaultSdkAutoConstructList.getInstance();

        private Rectangle position;

        private Integer programNumber;

        private String psiControl;

        private List<String> supplementalImps = DefaultSdkAutoConstructList.getInstance();

        private String timecodeSource;

        private String timecodeStart;

        private VideoSelector videoSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(Input model) {
            audioSelectorGroups(model.audioSelectorGroups);
            audioSelectors(model.audioSelectors);
            captionSelectors(model.captionSelectors);
            crop(model.crop);
            deblockFilter(model.deblockFilter);
            decryptionSettings(model.decryptionSettings);
            denoiseFilter(model.denoiseFilter);
            fileInput(model.fileInput);
            filterEnable(model.filterEnable);
            filterStrength(model.filterStrength);
            imageInserter(model.imageInserter);
            inputClippings(model.inputClippings);
            position(model.position);
            programNumber(model.programNumber);
            psiControl(model.psiControl);
            supplementalImps(model.supplementalImps);
            timecodeSource(model.timecodeSource);
            timecodeStart(model.timecodeStart);
            videoSelector(model.videoSelector);
        }

        public final Map<String, AudioSelectorGroup.Builder> getAudioSelectorGroups() {
            return audioSelectorGroups != null ? CollectionUtils.mapValues(audioSelectorGroups, AudioSelectorGroup::toBuilder)
                    : null;
        }

        @Override
        public final Builder audioSelectorGroups(Map<String, AudioSelectorGroup> audioSelectorGroups) {
            this.audioSelectorGroups = ___mapOfAudioSelectorGroupCopier.copy(audioSelectorGroups);
            return this;
        }

        public final void setAudioSelectorGroups(Map<String, AudioSelectorGroup.BuilderImpl> audioSelectorGroups) {
            this.audioSelectorGroups = ___mapOfAudioSelectorGroupCopier.copyFromBuilder(audioSelectorGroups);
        }

        public final Map<String, AudioSelector.Builder> getAudioSelectors() {
            return audioSelectors != null ? CollectionUtils.mapValues(audioSelectors, AudioSelector::toBuilder) : null;
        }

        @Override
        public final Builder audioSelectors(Map<String, AudioSelector> audioSelectors) {
            this.audioSelectors = ___mapOfAudioSelectorCopier.copy(audioSelectors);
            return this;
        }

        public final void setAudioSelectors(Map<String, AudioSelector.BuilderImpl> audioSelectors) {
            this.audioSelectors = ___mapOfAudioSelectorCopier.copyFromBuilder(audioSelectors);
        }

        public final Map<String, CaptionSelector.Builder> getCaptionSelectors() {
            return captionSelectors != null ? CollectionUtils.mapValues(captionSelectors, CaptionSelector::toBuilder) : null;
        }

        @Override
        public final Builder captionSelectors(Map<String, CaptionSelector> captionSelectors) {
            this.captionSelectors = ___mapOfCaptionSelectorCopier.copy(captionSelectors);
            return this;
        }

        public final void setCaptionSelectors(Map<String, CaptionSelector.BuilderImpl> captionSelectors) {
            this.captionSelectors = ___mapOfCaptionSelectorCopier.copyFromBuilder(captionSelectors);
        }

        public final Rectangle.Builder getCrop() {
            return crop != null ? crop.toBuilder() : null;
        }

        @Override
        public final Builder crop(Rectangle crop) {
            this.crop = crop;
            return this;
        }

        public final void setCrop(Rectangle.BuilderImpl crop) {
            this.crop = crop != null ? crop.build() : null;
        }

        public final String getDeblockFilter() {
            return deblockFilter;
        }

        @Override
        public final Builder deblockFilter(String deblockFilter) {
            this.deblockFilter = deblockFilter;
            return this;
        }

        @Override
        public final Builder deblockFilter(InputDeblockFilter deblockFilter) {
            this.deblockFilter(deblockFilter == null ? null : deblockFilter.toString());
            return this;
        }

        public final void setDeblockFilter(String deblockFilter) {
            this.deblockFilter = deblockFilter;
        }

        public final InputDecryptionSettings.Builder getDecryptionSettings() {
            return decryptionSettings != null ? decryptionSettings.toBuilder() : null;
        }

        @Override
        public final Builder decryptionSettings(InputDecryptionSettings decryptionSettings) {
            this.decryptionSettings = decryptionSettings;
            return this;
        }

        public final void setDecryptionSettings(InputDecryptionSettings.BuilderImpl decryptionSettings) {
            this.decryptionSettings = decryptionSettings != null ? decryptionSettings.build() : null;
        }

        public final String getDenoiseFilter() {
            return denoiseFilter;
        }

        @Override
        public final Builder denoiseFilter(String denoiseFilter) {
            this.denoiseFilter = denoiseFilter;
            return this;
        }

        @Override
        public final Builder denoiseFilter(InputDenoiseFilter denoiseFilter) {
            this.denoiseFilter(denoiseFilter == null ? null : denoiseFilter.toString());
            return this;
        }

        public final void setDenoiseFilter(String denoiseFilter) {
            this.denoiseFilter = denoiseFilter;
        }

        public final String getFileInput() {
            return fileInput;
        }

        @Override
        public final Builder fileInput(String fileInput) {
            this.fileInput = fileInput;
            return this;
        }

        public final void setFileInput(String fileInput) {
            this.fileInput = fileInput;
        }

        public final String getFilterEnable() {
            return filterEnable;
        }

        @Override
        public final Builder filterEnable(String filterEnable) {
            this.filterEnable = filterEnable;
            return this;
        }

        @Override
        public final Builder filterEnable(InputFilterEnable filterEnable) {
            this.filterEnable(filterEnable == null ? null : filterEnable.toString());
            return this;
        }

        public final void setFilterEnable(String filterEnable) {
            this.filterEnable = filterEnable;
        }

        public final Integer getFilterStrength() {
            return filterStrength;
        }

        @Override
        public final Builder filterStrength(Integer filterStrength) {
            this.filterStrength = filterStrength;
            return this;
        }

        public final void setFilterStrength(Integer filterStrength) {
            this.filterStrength = filterStrength;
        }

        public final ImageInserter.Builder getImageInserter() {
            return imageInserter != null ? imageInserter.toBuilder() : null;
        }

        @Override
        public final Builder imageInserter(ImageInserter imageInserter) {
            this.imageInserter = imageInserter;
            return this;
        }

        public final void setImageInserter(ImageInserter.BuilderImpl imageInserter) {
            this.imageInserter = imageInserter != null ? imageInserter.build() : null;
        }

        public final Collection<InputClipping.Builder> getInputClippings() {
            return inputClippings != null ? inputClippings.stream().map(InputClipping::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder inputClippings(Collection<InputClipping> inputClippings) {
            this.inputClippings = ___listOfInputClippingCopier.copy(inputClippings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputClippings(InputClipping... inputClippings) {
            inputClippings(Arrays.asList(inputClippings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputClippings(Consumer<InputClipping.Builder>... inputClippings) {
            inputClippings(Stream.of(inputClippings).map(c -> InputClipping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInputClippings(Collection<InputClipping.BuilderImpl> inputClippings) {
            this.inputClippings = ___listOfInputClippingCopier.copyFromBuilder(inputClippings);
        }

        public final Rectangle.Builder getPosition() {
            return position != null ? position.toBuilder() : null;
        }

        @Override
        public final Builder position(Rectangle position) {
            this.position = position;
            return this;
        }

        public final void setPosition(Rectangle.BuilderImpl position) {
            this.position = position != null ? position.build() : null;
        }

        public final Integer getProgramNumber() {
            return programNumber;
        }

        @Override
        public final Builder programNumber(Integer programNumber) {
            this.programNumber = programNumber;
            return this;
        }

        public final void setProgramNumber(Integer programNumber) {
            this.programNumber = programNumber;
        }

        public final String getPsiControl() {
            return psiControl;
        }

        @Override
        public final Builder psiControl(String psiControl) {
            this.psiControl = psiControl;
            return this;
        }

        @Override
        public final Builder psiControl(InputPsiControl psiControl) {
            this.psiControl(psiControl == null ? null : psiControl.toString());
            return this;
        }

        public final void setPsiControl(String psiControl) {
            this.psiControl = psiControl;
        }

        public final Collection<String> getSupplementalImps() {
            return supplementalImps;
        }

        @Override
        public final Builder supplementalImps(Collection<String> supplementalImps) {
            this.supplementalImps = ___listOf__stringPatternS3ASSETMAPXmlCopier.copy(supplementalImps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supplementalImps(String... supplementalImps) {
            supplementalImps(Arrays.asList(supplementalImps));
            return this;
        }

        public final void setSupplementalImps(Collection<String> supplementalImps) {
            this.supplementalImps = ___listOf__stringPatternS3ASSETMAPXmlCopier.copy(supplementalImps);
        }

        public final String getTimecodeSource() {
            return timecodeSource;
        }

        @Override
        public final Builder timecodeSource(String timecodeSource) {
            this.timecodeSource = timecodeSource;
            return this;
        }

        @Override
        public final Builder timecodeSource(InputTimecodeSource timecodeSource) {
            this.timecodeSource(timecodeSource == null ? null : timecodeSource.toString());
            return this;
        }

        public final void setTimecodeSource(String timecodeSource) {
            this.timecodeSource = timecodeSource;
        }

        public final String getTimecodeStart() {
            return timecodeStart;
        }

        @Override
        public final Builder timecodeStart(String timecodeStart) {
            this.timecodeStart = timecodeStart;
            return this;
        }

        public final void setTimecodeStart(String timecodeStart) {
            this.timecodeStart = timecodeStart;
        }

        public final VideoSelector.Builder getVideoSelector() {
            return videoSelector != null ? videoSelector.toBuilder() : null;
        }

        @Override
        public final Builder videoSelector(VideoSelector videoSelector) {
            this.videoSelector = videoSelector;
            return this;
        }

        public final void setVideoSelector(VideoSelector.BuilderImpl videoSelector) {
            this.videoSelector = videoSelector != null ? videoSelector.build() : null;
        }

        @Override
        public Input build() {
            return new Input(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
