/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set (Type) under (OutputGroups)>(OutputGroupSettings) to HLS_GROUP_SETTINGS.
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsGroupSettings.Builder, HlsGroupSettings> {
    private static final SdkField<List<String>> AD_MARKERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(HlsGroupSettings::adMarkersAsStrings))
            .setter(setter(Builder::adMarkersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adMarkers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<HlsAdditionalManifest>> ADDITIONAL_MANIFESTS_FIELD = SdkField
            .<List<HlsAdditionalManifest>> builder(MarshallingType.LIST)
            .getter(getter(HlsGroupSettings::additionalManifests))
            .setter(setter(Builder::additionalManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HlsAdditionalManifest> builder(MarshallingType.SDK_POJO)
                                            .constructor(HlsAdditionalManifest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BASE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsGroupSettings::baseUrl)).setter(setter(Builder::baseUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrl").build()).build();

    private static final SdkField<List<HlsCaptionLanguageMapping>> CAPTION_LANGUAGE_MAPPINGS_FIELD = SdkField
            .<List<HlsCaptionLanguageMapping>> builder(MarshallingType.LIST)
            .getter(getter(HlsGroupSettings::captionLanguageMappings))
            .setter(setter(Builder::captionLanguageMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionLanguageMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HlsCaptionLanguageMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(HlsCaptionLanguageMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CAPTION_LANGUAGE_SETTING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsGroupSettings::captionLanguageSettingAsString)).setter(setter(Builder::captionLanguageSetting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionLanguageSetting").build())
            .build();

    private static final SdkField<String> CLIENT_CACHE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsGroupSettings::clientCacheAsString)).setter(setter(Builder::clientCache))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCache").build()).build();

    private static final SdkField<String> CODEC_SPECIFICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsGroupSettings::codecSpecificationAsString)).setter(setter(Builder::codecSpecification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSpecification").build())
            .build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsGroupSettings::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<DestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField
            .<DestinationSettings> builder(MarshallingType.SDK_POJO).getter(getter(HlsGroupSettings::destinationSettings))
            .setter(setter(Builder::destinationSettings)).constructor(DestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build())
            .build();

    private static final SdkField<String> DIRECTORY_STRUCTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsGroupSettings::directoryStructureAsString)).setter(setter(Builder::directoryStructure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directoryStructure").build())
            .build();

    private static final SdkField<HlsEncryptionSettings> ENCRYPTION_FIELD = SdkField
            .<HlsEncryptionSettings> builder(MarshallingType.SDK_POJO).getter(getter(HlsGroupSettings::encryption))
            .setter(setter(Builder::encryption)).constructor(HlsEncryptionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<String> MANIFEST_COMPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsGroupSettings::manifestCompressionAsString)).setter(setter(Builder::manifestCompression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestCompression").build())
            .build();

    private static final SdkField<String> MANIFEST_DURATION_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsGroupSettings::manifestDurationFormatAsString)).setter(setter(Builder::manifestDurationFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestDurationFormat").build())
            .build();

    private static final SdkField<Double> MIN_FINAL_SEGMENT_LENGTH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(HlsGroupSettings::minFinalSegmentLength)).setter(setter(Builder::minFinalSegmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minFinalSegmentLength").build())
            .build();

    private static final SdkField<Integer> MIN_SEGMENT_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsGroupSettings::minSegmentLength)).setter(setter(Builder::minSegmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minSegmentLength").build()).build();

    private static final SdkField<String> OUTPUT_SELECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsGroupSettings::outputSelectionAsString)).setter(setter(Builder::outputSelection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSelection").build()).build();

    private static final SdkField<String> PROGRAM_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsGroupSettings::programDateTimeAsString)).setter(setter(Builder::programDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTime").build()).build();

    private static final SdkField<Integer> PROGRAM_DATE_TIME_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsGroupSettings::programDateTimePeriod)).setter(setter(Builder::programDateTimePeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTimePeriod").build())
            .build();

    private static final SdkField<String> SEGMENT_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsGroupSettings::segmentControlAsString)).setter(setter(Builder::segmentControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentControl").build()).build();

    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsGroupSettings::segmentLength)).setter(setter(Builder::segmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()).build();

    private static final SdkField<Integer> SEGMENTS_PER_SUBDIRECTORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsGroupSettings::segmentsPerSubdirectory)).setter(setter(Builder::segmentsPerSubdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentsPerSubdirectory").build())
            .build();

    private static final SdkField<String> STREAM_INF_RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsGroupSettings::streamInfResolutionAsString)).setter(setter(Builder::streamInfResolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamInfResolution").build())
            .build();

    private static final SdkField<String> TIMED_METADATA_ID3_FRAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsGroupSettings::timedMetadataId3FrameAsString)).setter(setter(Builder::timedMetadataId3Frame))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Frame").build())
            .build();

    private static final SdkField<Integer> TIMED_METADATA_ID3_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsGroupSettings::timedMetadataId3Period)).setter(setter(Builder::timedMetadataId3Period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Period").build())
            .build();

    private static final SdkField<Integer> TIMESTAMP_DELTA_MILLISECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsGroupSettings::timestampDeltaMilliseconds))
            .setter(setter(Builder::timestampDeltaMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampDeltaMilliseconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKERS_FIELD,
            ADDITIONAL_MANIFESTS_FIELD, BASE_URL_FIELD, CAPTION_LANGUAGE_MAPPINGS_FIELD, CAPTION_LANGUAGE_SETTING_FIELD,
            CLIENT_CACHE_FIELD, CODEC_SPECIFICATION_FIELD, DESTINATION_FIELD, DESTINATION_SETTINGS_FIELD,
            DIRECTORY_STRUCTURE_FIELD, ENCRYPTION_FIELD, MANIFEST_COMPRESSION_FIELD, MANIFEST_DURATION_FORMAT_FIELD,
            MIN_FINAL_SEGMENT_LENGTH_FIELD, MIN_SEGMENT_LENGTH_FIELD, OUTPUT_SELECTION_FIELD, PROGRAM_DATE_TIME_FIELD,
            PROGRAM_DATE_TIME_PERIOD_FIELD, SEGMENT_CONTROL_FIELD, SEGMENT_LENGTH_FIELD, SEGMENTS_PER_SUBDIRECTORY_FIELD,
            STREAM_INF_RESOLUTION_FIELD, TIMED_METADATA_ID3_FRAME_FIELD, TIMED_METADATA_ID3_PERIOD_FIELD,
            TIMESTAMP_DELTA_MILLISECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> adMarkers;

    private final List<HlsAdditionalManifest> additionalManifests;

    private final String baseUrl;

    private final List<HlsCaptionLanguageMapping> captionLanguageMappings;

    private final String captionLanguageSetting;

    private final String clientCache;

    private final String codecSpecification;

    private final String destination;

    private final DestinationSettings destinationSettings;

    private final String directoryStructure;

    private final HlsEncryptionSettings encryption;

    private final String manifestCompression;

    private final String manifestDurationFormat;

    private final Double minFinalSegmentLength;

    private final Integer minSegmentLength;

    private final String outputSelection;

    private final String programDateTime;

    private final Integer programDateTimePeriod;

    private final String segmentControl;

    private final Integer segmentLength;

    private final Integer segmentsPerSubdirectory;

    private final String streamInfResolution;

    private final String timedMetadataId3Frame;

    private final Integer timedMetadataId3Period;

    private final Integer timestampDeltaMilliseconds;

    private HlsGroupSettings(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.additionalManifests = builder.additionalManifests;
        this.baseUrl = builder.baseUrl;
        this.captionLanguageMappings = builder.captionLanguageMappings;
        this.captionLanguageSetting = builder.captionLanguageSetting;
        this.clientCache = builder.clientCache;
        this.codecSpecification = builder.codecSpecification;
        this.destination = builder.destination;
        this.destinationSettings = builder.destinationSettings;
        this.directoryStructure = builder.directoryStructure;
        this.encryption = builder.encryption;
        this.manifestCompression = builder.manifestCompression;
        this.manifestDurationFormat = builder.manifestDurationFormat;
        this.minFinalSegmentLength = builder.minFinalSegmentLength;
        this.minSegmentLength = builder.minSegmentLength;
        this.outputSelection = builder.outputSelection;
        this.programDateTime = builder.programDateTime;
        this.programDateTimePeriod = builder.programDateTimePeriod;
        this.segmentControl = builder.segmentControl;
        this.segmentLength = builder.segmentLength;
        this.segmentsPerSubdirectory = builder.segmentsPerSubdirectory;
        this.streamInfResolution = builder.streamInfResolution;
        this.timedMetadataId3Frame = builder.timedMetadataId3Frame;
        this.timedMetadataId3Period = builder.timedMetadataId3Period;
        this.timestampDeltaMilliseconds = builder.timestampDeltaMilliseconds;
    }

    /**
     * Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine whether
     * SCTE-35 markers appear in the outputs themselves.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdMarkers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine
     *         whether SCTE-35 markers appear in the outputs themselves.
     */
    public List<HlsAdMarkers> adMarkers() {
        return ___listOfHlsAdMarkersCopier.copyStringToEnum(adMarkers);
    }

    /**
     * Returns true if the AdMarkers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAdMarkers() {
        return adMarkers != null && !(adMarkers instanceof SdkAutoConstructList);
    }

    /**
     * Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine whether
     * SCTE-35 markers appear in the outputs themselves.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdMarkers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine
     *         whether SCTE-35 markers appear in the outputs themselves.
     */
    public List<String> adMarkersAsStrings() {
        return adMarkers;
    }

    /**
     * Returns true if the AdditionalManifests property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAdditionalManifests() {
        return additionalManifests != null && !(additionalManifests instanceof SdkAutoConstructList);
    }

    /**
     * By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your job. This
     * default manifest references every output in the output group. To create additional top-level manifests that
     * reference a subset of the outputs in the output group, specify a list of them here.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalManifests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your job.
     *         This default manifest references every output in the output group. To create additional top-level
     *         manifests that reference a subset of the outputs in the output group, specify a list of them here.
     */
    public List<HlsAdditionalManifest> additionalManifests() {
        return additionalManifests;
    }

    /**
     * A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base manifest
     * is delivered from a different URL than the main .m3u8 file.
     * 
     * @return A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base
     *         manifest is delivered from a different URL than the main .m3u8 file.
     */
    public String baseUrl() {
        return baseUrl;
    }

    /**
     * Returns true if the CaptionLanguageMappings property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCaptionLanguageMappings() {
        return captionLanguageMappings != null && !(captionLanguageMappings instanceof SdkAutoConstructList);
    }

    /**
     * Language to be used on Caption outputs
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCaptionLanguageMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Language to be used on Caption outputs
     */
    public List<HlsCaptionLanguageMapping> captionLanguageMappings() {
        return captionLanguageMappings;
    }

    /**
     * Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest. Specify at
     * least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code you
     * specify. Make sure to specify the languages in the order in which they appear in the original source (if the
     * source is embedded format) or the order of the caption selectors (if the source is other than embedded).
     * Otherwise, languages in the manifest will not match up properly with the output captions. None: Include
     * CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line from the manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #captionLanguageSetting} will return {@link HlsCaptionLanguageSetting#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #captionLanguageSettingAsString}.
     * </p>
     * 
     * @return Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest.
     *         Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each
     *         Language Code you specify. Make sure to specify the languages in the order in which they appear in the
     *         original source (if the source is embedded format) or the order of the caption selectors (if the source
     *         is other than embedded). Otherwise, languages in the manifest will not match up properly with the output
     *         captions. None: Include CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line
     *         from the manifest.
     * @see HlsCaptionLanguageSetting
     */
    public HlsCaptionLanguageSetting captionLanguageSetting() {
        return HlsCaptionLanguageSetting.fromValue(captionLanguageSetting);
    }

    /**
     * Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest. Specify at
     * least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code you
     * specify. Make sure to specify the languages in the order in which they appear in the original source (if the
     * source is embedded format) or the order of the caption selectors (if the source is other than embedded).
     * Otherwise, languages in the manifest will not match up properly with the output captions. None: Include
     * CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line from the manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #captionLanguageSetting} will return {@link HlsCaptionLanguageSetting#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #captionLanguageSettingAsString}.
     * </p>
     * 
     * @return Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest.
     *         Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each
     *         Language Code you specify. Make sure to specify the languages in the order in which they appear in the
     *         original source (if the source is embedded format) or the order of the caption selectors (if the source
     *         is other than embedded). Otherwise, languages in the manifest will not match up properly with the output
     *         captions. None: Include CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line
     *         from the manifest.
     * @see HlsCaptionLanguageSetting
     */
    public String captionLanguageSettingAsString() {
        return captionLanguageSetting;
    }

    /**
     * When set to ENABLED, sets #EXT-X-ALLOW-CACHE:no tag, which prevents client from saving media segments for later
     * replay.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientCache} will
     * return {@link HlsClientCache#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clientCacheAsString}.
     * </p>
     * 
     * @return When set to ENABLED, sets #EXT-X-ALLOW-CACHE:no tag, which prevents client from saving media segments for
     *         later replay.
     * @see HlsClientCache
     */
    public HlsClientCache clientCache() {
        return HlsClientCache.fromValue(clientCache);
    }

    /**
     * When set to ENABLED, sets #EXT-X-ALLOW-CACHE:no tag, which prevents client from saving media segments for later
     * replay.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientCache} will
     * return {@link HlsClientCache#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clientCacheAsString}.
     * </p>
     * 
     * @return When set to ENABLED, sets #EXT-X-ALLOW-CACHE:no tag, which prevents client from saving media segments for
     *         later replay.
     * @see HlsClientCache
     */
    public String clientCacheAsString() {
        return clientCache;
    }

    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #codecSpecification} will return {@link HlsCodecSpecification#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #codecSpecificationAsString}.
     * </p>
     * 
     * @return Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * @see HlsCodecSpecification
     */
    public HlsCodecSpecification codecSpecification() {
        return HlsCodecSpecification.fromValue(codecSpecification);
    }

    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #codecSpecification} will return {@link HlsCodecSpecification#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #codecSpecificationAsString}.
     * </p>
     * 
     * @return Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * @see HlsCodecSpecification
     */
    public String codecSpecificationAsString() {
        return codecSpecification;
    }

    /**
     * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts
     * format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the
     * input file. If your job has multiple inputs, the service uses the filename of the first input file.
     * 
     * @return Use Destination (Destination) to specify the S3 output location and the output filename base. Destination
     *         accepts format identifiers. If you do not specify the base filename in the URI, the service will use the
     *         filename of the input file. If your job has multiple inputs, the service uses the filename of the first
     *         input file.
     */
    public String destination() {
        return destination;
    }

    /**
     * Settings associated with the destination. Will vary based on the type of destination
     * 
     * @return Settings associated with the destination. Will vary based on the type of destination
     */
    public DestinationSettings destinationSettings() {
        return destinationSettings;
    }

    /**
     * Indicates whether segments should be placed in subdirectories.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #directoryStructure} will return {@link HlsDirectoryStructure#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #directoryStructureAsString}.
     * </p>
     * 
     * @return Indicates whether segments should be placed in subdirectories.
     * @see HlsDirectoryStructure
     */
    public HlsDirectoryStructure directoryStructure() {
        return HlsDirectoryStructure.fromValue(directoryStructure);
    }

    /**
     * Indicates whether segments should be placed in subdirectories.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #directoryStructure} will return {@link HlsDirectoryStructure#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #directoryStructureAsString}.
     * </p>
     * 
     * @return Indicates whether segments should be placed in subdirectories.
     * @see HlsDirectoryStructure
     */
    public String directoryStructureAsString() {
        return directoryStructure;
    }

    /**
     * DRM settings.
     * 
     * @return DRM settings.
     */
    public HlsEncryptionSettings encryption() {
        return encryption;
    }

    /**
     * When set to GZIP, compresses HLS playlist.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestCompression} will return {@link HlsManifestCompression#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #manifestCompressionAsString}.
     * </p>
     * 
     * @return When set to GZIP, compresses HLS playlist.
     * @see HlsManifestCompression
     */
    public HlsManifestCompression manifestCompression() {
        return HlsManifestCompression.fromValue(manifestCompression);
    }

    /**
     * When set to GZIP, compresses HLS playlist.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestCompression} will return {@link HlsManifestCompression#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #manifestCompressionAsString}.
     * </p>
     * 
     * @return When set to GZIP, compresses HLS playlist.
     * @see HlsManifestCompression
     */
    public String manifestCompressionAsString() {
        return manifestCompression;
    }

    /**
     * Indicates whether the output manifest should use floating point values for segment duration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestDurationFormat} will return {@link HlsManifestDurationFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #manifestDurationFormatAsString}.
     * </p>
     * 
     * @return Indicates whether the output manifest should use floating point values for segment duration.
     * @see HlsManifestDurationFormat
     */
    public HlsManifestDurationFormat manifestDurationFormat() {
        return HlsManifestDurationFormat.fromValue(manifestDurationFormat);
    }

    /**
     * Indicates whether the output manifest should use floating point values for segment duration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestDurationFormat} will return {@link HlsManifestDurationFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #manifestDurationFormatAsString}.
     * </p>
     * 
     * @return Indicates whether the output manifest should use floating point values for segment duration.
     * @see HlsManifestDurationFormat
     */
    public String manifestDurationFormatAsString() {
        return manifestDurationFormat;
    }

    /**
     * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back
     * the end of your video asset. If you know that player devices are hanging on the final segment of your video
     * because the length of your final segment is too short, use this setting to specify a minimum final segment
     * length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you
     * specify a value for this setting, the encoder will combine any final segment that is shorter than the length that
     * you specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5
     * seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final
     * segment is 3.5 seconds.
     * 
     * @return Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices
     *         play back the end of your video asset. If you know that player devices are hanging on the final segment
     *         of your video because the length of your final segment is too short, use this setting to specify a
     *         minimum final segment length, in seconds. Choose a value that is greater than or equal to 1 and less than
     *         your segment length. When you specify a value for this setting, the encoder will combine any final
     *         segment that is shorter than the length that you specify with the previous segment. For example, your
     *         segment length is 3 seconds and your final segment is .5 seconds without a minimum final segment length;
     *         when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
     */
    public Double minFinalSegmentLength() {
        return minFinalSegmentLength;
    }

    /**
     * When set, Minimum Segment Size is enforced by looking ahead and back within the specified range for a nearby
     * avail and extending the segment size if needed.
     * 
     * @return When set, Minimum Segment Size is enforced by looking ahead and back within the specified range for a
     *         nearby avail and extending the segment size if needed.
     */
    public Integer minSegmentLength() {
        return minSegmentLength;
    }

    /**
     * Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputSelection}
     * will return {@link HlsOutputSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #outputSelectionAsString}.
     * </p>
     * 
     * @return Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
     * @see HlsOutputSelection
     */
    public HlsOutputSelection outputSelection() {
        return HlsOutputSelection.fromValue(outputSelection);
    }

    /**
     * Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputSelection}
     * will return {@link HlsOutputSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #outputSelectionAsString}.
     * </p>
     * 
     * @return Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
     * @see HlsOutputSelection
     */
    public String outputSelectionAsString() {
        return outputSelection;
    }

    /**
     * Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows:
     * either the program date and time are initialized using the input timecode source, or the time is initialized
     * using the input timecode source and the date is initialized using the timestamp_offset.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #programDateTime}
     * will return {@link HlsProgramDateTime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #programDateTimeAsString}.
     * </p>
     * 
     * @return Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as
     *         follows: either the program date and time are initialized using the input timecode source, or the time is
     *         initialized using the input timecode source and the date is initialized using the timestamp_offset.
     * @see HlsProgramDateTime
     */
    public HlsProgramDateTime programDateTime() {
        return HlsProgramDateTime.fromValue(programDateTime);
    }

    /**
     * Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows:
     * either the program date and time are initialized using the input timecode source, or the time is initialized
     * using the input timecode source and the date is initialized using the timestamp_offset.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #programDateTime}
     * will return {@link HlsProgramDateTime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #programDateTimeAsString}.
     * </p>
     * 
     * @return Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as
     *         follows: either the program date and time are initialized using the input timecode source, or the time is
     *         initialized using the input timecode source and the date is initialized using the timestamp_offset.
     * @see HlsProgramDateTime
     */
    public String programDateTimeAsString() {
        return programDateTime;
    }

    /**
     * Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
     * 
     * @return Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
     */
    public Integer programDateTimePeriod() {
        return programDateTimePeriod;
    }

    /**
     * When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE tags to index
     * segment for playback.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentControl}
     * will return {@link HlsSegmentControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #segmentControlAsString}.
     * </p>
     * 
     * @return When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE tags
     *         to index segment for playback.
     * @see HlsSegmentControl
     */
    public HlsSegmentControl segmentControl() {
        return HlsSegmentControl.fromValue(segmentControl);
    }

    /**
     * When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE tags to index
     * segment for playback.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentControl}
     * will return {@link HlsSegmentControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #segmentControlAsString}.
     * </p>
     * 
     * @return When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE tags
     *         to index segment for playback.
     * @see HlsSegmentControl
     */
    public String segmentControlAsString() {
        return segmentControl;
    }

    /**
     * Length of MPEG-2 Transport Stream segments to create (in seconds). Note that segments will end on the next
     * keyframe after this number of seconds, so actual segment length may be longer.
     * 
     * @return Length of MPEG-2 Transport Stream segments to create (in seconds). Note that segments will end on the
     *         next keyframe after this number of seconds, so actual segment length may be longer.
     */
    public Integer segmentLength() {
        return segmentLength;
    }

    /**
     * Number of segments to write to a subdirectory before starting a new one. directoryStructure must be
     * SINGLE_DIRECTORY for this setting to have an effect.
     * 
     * @return Number of segments to write to a subdirectory before starting a new one. directoryStructure must be
     *         SINGLE_DIRECTORY for this setting to have an effect.
     */
    public Integer segmentsPerSubdirectory() {
        return segmentsPerSubdirectory;
    }

    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamInfResolution} will return {@link HlsStreamInfResolution#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #streamInfResolutionAsString}.
     * </p>
     * 
     * @return Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * @see HlsStreamInfResolution
     */
    public HlsStreamInfResolution streamInfResolution() {
        return HlsStreamInfResolution.fromValue(streamInfResolution);
    }

    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamInfResolution} will return {@link HlsStreamInfResolution#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #streamInfResolutionAsString}.
     * </p>
     * 
     * @return Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * @see HlsStreamInfResolution
     */
    public String streamInfResolutionAsString() {
        return streamInfResolution;
    }

    /**
     * Indicates ID3 frame that has the timecode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timedMetadataId3Frame} will return {@link HlsTimedMetadataId3Frame#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #timedMetadataId3FrameAsString}.
     * </p>
     * 
     * @return Indicates ID3 frame that has the timecode.
     * @see HlsTimedMetadataId3Frame
     */
    public HlsTimedMetadataId3Frame timedMetadataId3Frame() {
        return HlsTimedMetadataId3Frame.fromValue(timedMetadataId3Frame);
    }

    /**
     * Indicates ID3 frame that has the timecode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timedMetadataId3Frame} will return {@link HlsTimedMetadataId3Frame#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #timedMetadataId3FrameAsString}.
     * </p>
     * 
     * @return Indicates ID3 frame that has the timecode.
     * @see HlsTimedMetadataId3Frame
     */
    public String timedMetadataId3FrameAsString() {
        return timedMetadataId3Frame;
    }

    /**
     * Timed Metadata interval in seconds.
     * 
     * @return Timed Metadata interval in seconds.
     */
    public Integer timedMetadataId3Period() {
        return timedMetadataId3Period;
    }

    /**
     * Provides an extra millisecond delta offset to fine tune the timestamps.
     * 
     * @return Provides an extra millisecond delta offset to fine tune the timestamps.
     */
    public Integer timestampDeltaMilliseconds() {
        return timestampDeltaMilliseconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adMarkersAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(additionalManifests());
        hashCode = 31 * hashCode + Objects.hashCode(baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(captionLanguageMappings());
        hashCode = 31 * hashCode + Objects.hashCode(captionLanguageSettingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientCacheAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codecSpecificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(directoryStructureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(manifestCompressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(manifestDurationFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minFinalSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(minSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(outputSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(programDateTimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(programDateTimePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(segmentControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(segmentsPerSubdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(streamInfResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timedMetadataId3FrameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timedMetadataId3Period());
        hashCode = 31 * hashCode + Objects.hashCode(timestampDeltaMilliseconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsGroupSettings)) {
            return false;
        }
        HlsGroupSettings other = (HlsGroupSettings) obj;
        return Objects.equals(adMarkersAsStrings(), other.adMarkersAsStrings())
                && Objects.equals(additionalManifests(), other.additionalManifests())
                && Objects.equals(baseUrl(), other.baseUrl())
                && Objects.equals(captionLanguageMappings(), other.captionLanguageMappings())
                && Objects.equals(captionLanguageSettingAsString(), other.captionLanguageSettingAsString())
                && Objects.equals(clientCacheAsString(), other.clientCacheAsString())
                && Objects.equals(codecSpecificationAsString(), other.codecSpecificationAsString())
                && Objects.equals(destination(), other.destination())
                && Objects.equals(destinationSettings(), other.destinationSettings())
                && Objects.equals(directoryStructureAsString(), other.directoryStructureAsString())
                && Objects.equals(encryption(), other.encryption())
                && Objects.equals(manifestCompressionAsString(), other.manifestCompressionAsString())
                && Objects.equals(manifestDurationFormatAsString(), other.manifestDurationFormatAsString())
                && Objects.equals(minFinalSegmentLength(), other.minFinalSegmentLength())
                && Objects.equals(minSegmentLength(), other.minSegmentLength())
                && Objects.equals(outputSelectionAsString(), other.outputSelectionAsString())
                && Objects.equals(programDateTimeAsString(), other.programDateTimeAsString())
                && Objects.equals(programDateTimePeriod(), other.programDateTimePeriod())
                && Objects.equals(segmentControlAsString(), other.segmentControlAsString())
                && Objects.equals(segmentLength(), other.segmentLength())
                && Objects.equals(segmentsPerSubdirectory(), other.segmentsPerSubdirectory())
                && Objects.equals(streamInfResolutionAsString(), other.streamInfResolutionAsString())
                && Objects.equals(timedMetadataId3FrameAsString(), other.timedMetadataId3FrameAsString())
                && Objects.equals(timedMetadataId3Period(), other.timedMetadataId3Period())
                && Objects.equals(timestampDeltaMilliseconds(), other.timestampDeltaMilliseconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HlsGroupSettings").add("AdMarkers", adMarkersAsStrings())
                .add("AdditionalManifests", additionalManifests()).add("BaseUrl", baseUrl())
                .add("CaptionLanguageMappings", captionLanguageMappings())
                .add("CaptionLanguageSetting", captionLanguageSettingAsString()).add("ClientCache", clientCacheAsString())
                .add("CodecSpecification", codecSpecificationAsString()).add("Destination", destination())
                .add("DestinationSettings", destinationSettings()).add("DirectoryStructure", directoryStructureAsString())
                .add("Encryption", encryption()).add("ManifestCompression", manifestCompressionAsString())
                .add("ManifestDurationFormat", manifestDurationFormatAsString())
                .add("MinFinalSegmentLength", minFinalSegmentLength()).add("MinSegmentLength", minSegmentLength())
                .add("OutputSelection", outputSelectionAsString()).add("ProgramDateTime", programDateTimeAsString())
                .add("ProgramDateTimePeriod", programDateTimePeriod()).add("SegmentControl", segmentControlAsString())
                .add("SegmentLength", segmentLength()).add("SegmentsPerSubdirectory", segmentsPerSubdirectory())
                .add("StreamInfResolution", streamInfResolutionAsString())
                .add("TimedMetadataId3Frame", timedMetadataId3FrameAsString())
                .add("TimedMetadataId3Period", timedMetadataId3Period())
                .add("TimestampDeltaMilliseconds", timestampDeltaMilliseconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdMarkers":
            return Optional.ofNullable(clazz.cast(adMarkersAsStrings()));
        case "AdditionalManifests":
            return Optional.ofNullable(clazz.cast(additionalManifests()));
        case "BaseUrl":
            return Optional.ofNullable(clazz.cast(baseUrl()));
        case "CaptionLanguageMappings":
            return Optional.ofNullable(clazz.cast(captionLanguageMappings()));
        case "CaptionLanguageSetting":
            return Optional.ofNullable(clazz.cast(captionLanguageSettingAsString()));
        case "ClientCache":
            return Optional.ofNullable(clazz.cast(clientCacheAsString()));
        case "CodecSpecification":
            return Optional.ofNullable(clazz.cast(codecSpecificationAsString()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "DestinationSettings":
            return Optional.ofNullable(clazz.cast(destinationSettings()));
        case "DirectoryStructure":
            return Optional.ofNullable(clazz.cast(directoryStructureAsString()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "ManifestCompression":
            return Optional.ofNullable(clazz.cast(manifestCompressionAsString()));
        case "ManifestDurationFormat":
            return Optional.ofNullable(clazz.cast(manifestDurationFormatAsString()));
        case "MinFinalSegmentLength":
            return Optional.ofNullable(clazz.cast(minFinalSegmentLength()));
        case "MinSegmentLength":
            return Optional.ofNullable(clazz.cast(minSegmentLength()));
        case "OutputSelection":
            return Optional.ofNullable(clazz.cast(outputSelectionAsString()));
        case "ProgramDateTime":
            return Optional.ofNullable(clazz.cast(programDateTimeAsString()));
        case "ProgramDateTimePeriod":
            return Optional.ofNullable(clazz.cast(programDateTimePeriod()));
        case "SegmentControl":
            return Optional.ofNullable(clazz.cast(segmentControlAsString()));
        case "SegmentLength":
            return Optional.ofNullable(clazz.cast(segmentLength()));
        case "SegmentsPerSubdirectory":
            return Optional.ofNullable(clazz.cast(segmentsPerSubdirectory()));
        case "StreamInfResolution":
            return Optional.ofNullable(clazz.cast(streamInfResolutionAsString()));
        case "TimedMetadataId3Frame":
            return Optional.ofNullable(clazz.cast(timedMetadataId3FrameAsString()));
        case "TimedMetadataId3Period":
            return Optional.ofNullable(clazz.cast(timedMetadataId3Period()));
        case "TimestampDeltaMilliseconds":
            return Optional.ofNullable(clazz.cast(timestampDeltaMilliseconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsGroupSettings, T> g) {
        return obj -> g.apply((HlsGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsGroupSettings> {
        /**
         * Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine
         * whether SCTE-35 markers appear in the outputs themselves.
         * 
         * @param adMarkers
         *        Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not
         *        determine whether SCTE-35 markers appear in the outputs themselves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkersWithStrings(Collection<String> adMarkers);

        /**
         * Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine
         * whether SCTE-35 markers appear in the outputs themselves.
         * 
         * @param adMarkers
         *        Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not
         *        determine whether SCTE-35 markers appear in the outputs themselves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkersWithStrings(String... adMarkers);

        /**
         * Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine
         * whether SCTE-35 markers appear in the outputs themselves.
         * 
         * @param adMarkers
         *        Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not
         *        determine whether SCTE-35 markers appear in the outputs themselves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkers(Collection<HlsAdMarkers> adMarkers);

        /**
         * Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine
         * whether SCTE-35 markers appear in the outputs themselves.
         * 
         * @param adMarkers
         *        Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not
         *        determine whether SCTE-35 markers appear in the outputs themselves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkers(HlsAdMarkers... adMarkers);

        /**
         * By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your job. This
         * default manifest references every output in the output group. To create additional top-level manifests that
         * reference a subset of the outputs in the output group, specify a list of them here.
         * 
         * @param additionalManifests
         *        By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your
         *        job. This default manifest references every output in the output group. To create additional top-level
         *        manifests that reference a subset of the outputs in the output group, specify a list of them here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalManifests(Collection<HlsAdditionalManifest> additionalManifests);

        /**
         * By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your job. This
         * default manifest references every output in the output group. To create additional top-level manifests that
         * reference a subset of the outputs in the output group, specify a list of them here.
         * 
         * @param additionalManifests
         *        By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your
         *        job. This default manifest references every output in the output group. To create additional top-level
         *        manifests that reference a subset of the outputs in the output group, specify a list of them here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalManifests(HlsAdditionalManifest... additionalManifests);

        /**
         * By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your job. This
         * default manifest references every output in the output group. To create additional top-level manifests that
         * reference a subset of the outputs in the output group, specify a list of them here. This is a convenience
         * that creates an instance of the {@link List<HlsAdditionalManifest>.Builder} avoiding the need to create one
         * manually via {@link List<HlsAdditionalManifest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HlsAdditionalManifest>.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalManifests(List<HlsAdditionalManifest>)}.
         * 
         * @param additionalManifests
         *        a consumer that will call methods on {@link List<HlsAdditionalManifest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalManifests(List<HlsAdditionalManifest>)
         */
        Builder additionalManifests(Consumer<HlsAdditionalManifest.Builder>... additionalManifests);

        /**
         * A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base
         * manifest is delivered from a different URL than the main .m3u8 file.
         * 
         * @param baseUrl
         *        A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if
         *        base manifest is delivered from a different URL than the main .m3u8 file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseUrl(String baseUrl);

        /**
         * Language to be used on Caption outputs
         * 
         * @param captionLanguageMappings
         *        Language to be used on Caption outputs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionLanguageMappings(Collection<HlsCaptionLanguageMapping> captionLanguageMappings);

        /**
         * Language to be used on Caption outputs
         * 
         * @param captionLanguageMappings
         *        Language to be used on Caption outputs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionLanguageMappings(HlsCaptionLanguageMapping... captionLanguageMappings);

        /**
         * Language to be used on Caption outputs This is a convenience that creates an instance of the {@link List
         * <HlsCaptionLanguageMapping>.Builder} avoiding the need to create one manually via {@link List
         * <HlsCaptionLanguageMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HlsCaptionLanguageMapping>.Builder#build()} is called
         * immediately and its result is passed to {@link #captionLanguageMappings(List<HlsCaptionLanguageMapping>)}.
         * 
         * @param captionLanguageMappings
         *        a consumer that will call methods on {@link List<HlsCaptionLanguageMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captionLanguageMappings(List<HlsCaptionLanguageMapping>)
         */
        Builder captionLanguageMappings(Consumer<HlsCaptionLanguageMapping.Builder>... captionLanguageMappings);

        /**
         * Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest. Specify
         * at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code
         * you specify. Make sure to specify the languages in the order in which they appear in the original source (if
         * the source is embedded format) or the order of the caption selectors (if the source is other than embedded).
         * Otherwise, languages in the manifest will not match up properly with the output captions. None: Include
         * CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line from the manifest.
         * 
         * @param captionLanguageSetting
         *        Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest.
         *        Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for
         *        each Language Code you specify. Make sure to specify the languages in the order in which they appear
         *        in the original source (if the source is embedded format) or the order of the caption selectors (if
         *        the source is other than embedded). Otherwise, languages in the manifest will not match up properly
         *        with the output captions. None: Include CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any
         *        CLOSED-CAPTIONS line from the manifest.
         * @see HlsCaptionLanguageSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsCaptionLanguageSetting
         */
        Builder captionLanguageSetting(String captionLanguageSetting);

        /**
         * Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest. Specify
         * at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code
         * you specify. Make sure to specify the languages in the order in which they appear in the original source (if
         * the source is embedded format) or the order of the caption selectors (if the source is other than embedded).
         * Otherwise, languages in the manifest will not match up properly with the output captions. None: Include
         * CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line from the manifest.
         * 
         * @param captionLanguageSetting
         *        Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest.
         *        Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for
         *        each Language Code you specify. Make sure to specify the languages in the order in which they appear
         *        in the original source (if the source is embedded format) or the order of the caption selectors (if
         *        the source is other than embedded). Otherwise, languages in the manifest will not match up properly
         *        with the output captions. None: Include CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any
         *        CLOSED-CAPTIONS line from the manifest.
         * @see HlsCaptionLanguageSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsCaptionLanguageSetting
         */
        Builder captionLanguageSetting(HlsCaptionLanguageSetting captionLanguageSetting);

        /**
         * When set to ENABLED, sets #EXT-X-ALLOW-CACHE:no tag, which prevents client from saving media segments for
         * later replay.
         * 
         * @param clientCache
         *        When set to ENABLED, sets #EXT-X-ALLOW-CACHE:no tag, which prevents client from saving media segments
         *        for later replay.
         * @see HlsClientCache
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsClientCache
         */
        Builder clientCache(String clientCache);

        /**
         * When set to ENABLED, sets #EXT-X-ALLOW-CACHE:no tag, which prevents client from saving media segments for
         * later replay.
         * 
         * @param clientCache
         *        When set to ENABLED, sets #EXT-X-ALLOW-CACHE:no tag, which prevents client from saving media segments
         *        for later replay.
         * @see HlsClientCache
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsClientCache
         */
        Builder clientCache(HlsClientCache clientCache);

        /**
         * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * 
         * @param codecSpecification
         *        Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * @see HlsCodecSpecification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsCodecSpecification
         */
        Builder codecSpecification(String codecSpecification);

        /**
         * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * 
         * @param codecSpecification
         *        Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * @see HlsCodecSpecification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsCodecSpecification
         */
        Builder codecSpecification(HlsCodecSpecification codecSpecification);

        /**
         * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination
         * accepts format identifiers. If you do not specify the base filename in the URI, the service will use the
         * filename of the input file. If your job has multiple inputs, the service uses the filename of the first input
         * file.
         * 
         * @param destination
         *        Use Destination (Destination) to specify the S3 output location and the output filename base.
         *        Destination accepts format identifiers. If you do not specify the base filename in the URI, the
         *        service will use the filename of the input file. If your job has multiple inputs, the service uses the
         *        filename of the first input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * Settings associated with the destination. Will vary based on the type of destination
         * 
         * @param destinationSettings
         *        Settings associated with the destination. Will vary based on the type of destination
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSettings(DestinationSettings destinationSettings);

        /**
         * Settings associated with the destination. Will vary based on the type of destination This is a convenience
         * that creates an instance of the {@link DestinationSettings.Builder} avoiding the need to create one manually
         * via {@link DestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #destinationSettings(DestinationSettings)}.
         * 
         * @param destinationSettings
         *        a consumer that will call methods on {@link DestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSettings(DestinationSettings)
         */
        default Builder destinationSettings(Consumer<DestinationSettings.Builder> destinationSettings) {
            return destinationSettings(DestinationSettings.builder().applyMutation(destinationSettings).build());
        }

        /**
         * Indicates whether segments should be placed in subdirectories.
         * 
         * @param directoryStructure
         *        Indicates whether segments should be placed in subdirectories.
         * @see HlsDirectoryStructure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsDirectoryStructure
         */
        Builder directoryStructure(String directoryStructure);

        /**
         * Indicates whether segments should be placed in subdirectories.
         * 
         * @param directoryStructure
         *        Indicates whether segments should be placed in subdirectories.
         * @see HlsDirectoryStructure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsDirectoryStructure
         */
        Builder directoryStructure(HlsDirectoryStructure directoryStructure);

        /**
         * DRM settings.
         * 
         * @param encryption
         *        DRM settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(HlsEncryptionSettings encryption);

        /**
         * DRM settings. This is a convenience that creates an instance of the {@link HlsEncryptionSettings.Builder}
         * avoiding the need to create one manually via {@link HlsEncryptionSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsEncryptionSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #encryption(HlsEncryptionSettings)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link HlsEncryptionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(HlsEncryptionSettings)
         */
        default Builder encryption(Consumer<HlsEncryptionSettings.Builder> encryption) {
            return encryption(HlsEncryptionSettings.builder().applyMutation(encryption).build());
        }

        /**
         * When set to GZIP, compresses HLS playlist.
         * 
         * @param manifestCompression
         *        When set to GZIP, compresses HLS playlist.
         * @see HlsManifestCompression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsManifestCompression
         */
        Builder manifestCompression(String manifestCompression);

        /**
         * When set to GZIP, compresses HLS playlist.
         * 
         * @param manifestCompression
         *        When set to GZIP, compresses HLS playlist.
         * @see HlsManifestCompression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsManifestCompression
         */
        Builder manifestCompression(HlsManifestCompression manifestCompression);

        /**
         * Indicates whether the output manifest should use floating point values for segment duration.
         * 
         * @param manifestDurationFormat
         *        Indicates whether the output manifest should use floating point values for segment duration.
         * @see HlsManifestDurationFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsManifestDurationFormat
         */
        Builder manifestDurationFormat(String manifestDurationFormat);

        /**
         * Indicates whether the output manifest should use floating point values for segment duration.
         * 
         * @param manifestDurationFormat
         *        Indicates whether the output manifest should use floating point values for segment duration.
         * @see HlsManifestDurationFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsManifestDurationFormat
         */
        Builder manifestDurationFormat(HlsManifestDurationFormat manifestDurationFormat);

        /**
         * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play
         * back the end of your video asset. If you know that player devices are hanging on the final segment of your
         * video because the length of your final segment is too short, use this setting to specify a minimum final
         * segment length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment
         * length. When you specify a value for this setting, the encoder will combine any final segment that is shorter
         * than the length that you specify with the previous segment. For example, your segment length is 3 seconds and
         * your final segment is .5 seconds without a minimum final segment length; when you set the minimum final
         * segment length to 1, your final segment is 3.5 seconds.
         * 
         * @param minFinalSegmentLength
         *        Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices
         *        play back the end of your video asset. If you know that player devices are hanging on the final
         *        segment of your video because the length of your final segment is too short, use this setting to
         *        specify a minimum final segment length, in seconds. Choose a value that is greater than or equal to 1
         *        and less than your segment length. When you specify a value for this setting, the encoder will combine
         *        any final segment that is shorter than the length that you specify with the previous segment. For
         *        example, your segment length is 3 seconds and your final segment is .5 seconds without a minimum final
         *        segment length; when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minFinalSegmentLength(Double minFinalSegmentLength);

        /**
         * When set, Minimum Segment Size is enforced by looking ahead and back within the specified range for a nearby
         * avail and extending the segment size if needed.
         * 
         * @param minSegmentLength
         *        When set, Minimum Segment Size is enforced by looking ahead and back within the specified range for a
         *        nearby avail and extending the segment size if needed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSegmentLength(Integer minSegmentLength);

        /**
         * Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
         * 
         * @param outputSelection
         *        Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
         * @see HlsOutputSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsOutputSelection
         */
        Builder outputSelection(String outputSelection);

        /**
         * Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
         * 
         * @param outputSelection
         *        Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
         * @see HlsOutputSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsOutputSelection
         */
        Builder outputSelection(HlsOutputSelection outputSelection);

        /**
         * Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows:
         * either the program date and time are initialized using the input timecode source, or the time is initialized
         * using the input timecode source and the date is initialized using the timestamp_offset.
         * 
         * @param programDateTime
         *        Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as
         *        follows: either the program date and time are initialized using the input timecode source, or the time
         *        is initialized using the input timecode source and the date is initialized using the timestamp_offset.
         * @see HlsProgramDateTime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsProgramDateTime
         */
        Builder programDateTime(String programDateTime);

        /**
         * Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows:
         * either the program date and time are initialized using the input timecode source, or the time is initialized
         * using the input timecode source and the date is initialized using the timestamp_offset.
         * 
         * @param programDateTime
         *        Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as
         *        follows: either the program date and time are initialized using the input timecode source, or the time
         *        is initialized using the input timecode source and the date is initialized using the timestamp_offset.
         * @see HlsProgramDateTime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsProgramDateTime
         */
        Builder programDateTime(HlsProgramDateTime programDateTime);

        /**
         * Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
         * 
         * @param programDateTimePeriod
         *        Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programDateTimePeriod(Integer programDateTimePeriod);

        /**
         * When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE tags to
         * index segment for playback.
         * 
         * @param segmentControl
         *        When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE
         *        tags to index segment for playback.
         * @see HlsSegmentControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsSegmentControl
         */
        Builder segmentControl(String segmentControl);

        /**
         * When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE tags to
         * index segment for playback.
         * 
         * @param segmentControl
         *        When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE
         *        tags to index segment for playback.
         * @see HlsSegmentControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsSegmentControl
         */
        Builder segmentControl(HlsSegmentControl segmentControl);

        /**
         * Length of MPEG-2 Transport Stream segments to create (in seconds). Note that segments will end on the next
         * keyframe after this number of seconds, so actual segment length may be longer.
         * 
         * @param segmentLength
         *        Length of MPEG-2 Transport Stream segments to create (in seconds). Note that segments will end on the
         *        next keyframe after this number of seconds, so actual segment length may be longer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentLength(Integer segmentLength);

        /**
         * Number of segments to write to a subdirectory before starting a new one. directoryStructure must be
         * SINGLE_DIRECTORY for this setting to have an effect.
         * 
         * @param segmentsPerSubdirectory
         *        Number of segments to write to a subdirectory before starting a new one. directoryStructure must be
         *        SINGLE_DIRECTORY for this setting to have an effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentsPerSubdirectory(Integer segmentsPerSubdirectory);

        /**
         * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * 
         * @param streamInfResolution
         *        Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * @see HlsStreamInfResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsStreamInfResolution
         */
        Builder streamInfResolution(String streamInfResolution);

        /**
         * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * 
         * @param streamInfResolution
         *        Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * @see HlsStreamInfResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsStreamInfResolution
         */
        Builder streamInfResolution(HlsStreamInfResolution streamInfResolution);

        /**
         * Indicates ID3 frame that has the timecode.
         * 
         * @param timedMetadataId3Frame
         *        Indicates ID3 frame that has the timecode.
         * @see HlsTimedMetadataId3Frame
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsTimedMetadataId3Frame
         */
        Builder timedMetadataId3Frame(String timedMetadataId3Frame);

        /**
         * Indicates ID3 frame that has the timecode.
         * 
         * @param timedMetadataId3Frame
         *        Indicates ID3 frame that has the timecode.
         * @see HlsTimedMetadataId3Frame
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsTimedMetadataId3Frame
         */
        Builder timedMetadataId3Frame(HlsTimedMetadataId3Frame timedMetadataId3Frame);

        /**
         * Timed Metadata interval in seconds.
         * 
         * @param timedMetadataId3Period
         *        Timed Metadata interval in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timedMetadataId3Period(Integer timedMetadataId3Period);

        /**
         * Provides an extra millisecond delta offset to fine tune the timestamps.
         * 
         * @param timestampDeltaMilliseconds
         *        Provides an extra millisecond delta offset to fine tune the timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampDeltaMilliseconds(Integer timestampDeltaMilliseconds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> adMarkers = DefaultSdkAutoConstructList.getInstance();

        private List<HlsAdditionalManifest> additionalManifests = DefaultSdkAutoConstructList.getInstance();

        private String baseUrl;

        private List<HlsCaptionLanguageMapping> captionLanguageMappings = DefaultSdkAutoConstructList.getInstance();

        private String captionLanguageSetting;

        private String clientCache;

        private String codecSpecification;

        private String destination;

        private DestinationSettings destinationSettings;

        private String directoryStructure;

        private HlsEncryptionSettings encryption;

        private String manifestCompression;

        private String manifestDurationFormat;

        private Double minFinalSegmentLength;

        private Integer minSegmentLength;

        private String outputSelection;

        private String programDateTime;

        private Integer programDateTimePeriod;

        private String segmentControl;

        private Integer segmentLength;

        private Integer segmentsPerSubdirectory;

        private String streamInfResolution;

        private String timedMetadataId3Frame;

        private Integer timedMetadataId3Period;

        private Integer timestampDeltaMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsGroupSettings model) {
            adMarkersWithStrings(model.adMarkers);
            additionalManifests(model.additionalManifests);
            baseUrl(model.baseUrl);
            captionLanguageMappings(model.captionLanguageMappings);
            captionLanguageSetting(model.captionLanguageSetting);
            clientCache(model.clientCache);
            codecSpecification(model.codecSpecification);
            destination(model.destination);
            destinationSettings(model.destinationSettings);
            directoryStructure(model.directoryStructure);
            encryption(model.encryption);
            manifestCompression(model.manifestCompression);
            manifestDurationFormat(model.manifestDurationFormat);
            minFinalSegmentLength(model.minFinalSegmentLength);
            minSegmentLength(model.minSegmentLength);
            outputSelection(model.outputSelection);
            programDateTime(model.programDateTime);
            programDateTimePeriod(model.programDateTimePeriod);
            segmentControl(model.segmentControl);
            segmentLength(model.segmentLength);
            segmentsPerSubdirectory(model.segmentsPerSubdirectory);
            streamInfResolution(model.streamInfResolution);
            timedMetadataId3Frame(model.timedMetadataId3Frame);
            timedMetadataId3Period(model.timedMetadataId3Period);
            timestampDeltaMilliseconds(model.timestampDeltaMilliseconds);
        }

        public final Collection<String> getAdMarkers() {
            return adMarkers;
        }

        @Override
        public final Builder adMarkersWithStrings(Collection<String> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copy(adMarkers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adMarkersWithStrings(String... adMarkers) {
            adMarkersWithStrings(Arrays.asList(adMarkers));
            return this;
        }

        @Override
        public final Builder adMarkers(Collection<HlsAdMarkers> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copyEnumToString(adMarkers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adMarkers(HlsAdMarkers... adMarkers) {
            adMarkers(Arrays.asList(adMarkers));
            return this;
        }

        public final void setAdMarkers(Collection<String> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copy(adMarkers);
        }

        public final Collection<HlsAdditionalManifest.Builder> getAdditionalManifests() {
            return additionalManifests != null ? additionalManifests.stream().map(HlsAdditionalManifest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalManifests(Collection<HlsAdditionalManifest> additionalManifests) {
            this.additionalManifests = ___listOfHlsAdditionalManifestCopier.copy(additionalManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(HlsAdditionalManifest... additionalManifests) {
            additionalManifests(Arrays.asList(additionalManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(Consumer<HlsAdditionalManifest.Builder>... additionalManifests) {
            additionalManifests(Stream.of(additionalManifests).map(c -> HlsAdditionalManifest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalManifests(Collection<HlsAdditionalManifest.BuilderImpl> additionalManifests) {
            this.additionalManifests = ___listOfHlsAdditionalManifestCopier.copyFromBuilder(additionalManifests);
        }

        public final String getBaseUrl() {
            return baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public final Collection<HlsCaptionLanguageMapping.Builder> getCaptionLanguageMappings() {
            return captionLanguageMappings != null ? captionLanguageMappings.stream().map(HlsCaptionLanguageMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder captionLanguageMappings(Collection<HlsCaptionLanguageMapping> captionLanguageMappings) {
            this.captionLanguageMappings = ___listOfHlsCaptionLanguageMappingCopier.copy(captionLanguageMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionLanguageMappings(HlsCaptionLanguageMapping... captionLanguageMappings) {
            captionLanguageMappings(Arrays.asList(captionLanguageMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionLanguageMappings(Consumer<HlsCaptionLanguageMapping.Builder>... captionLanguageMappings) {
            captionLanguageMappings(Stream.of(captionLanguageMappings)
                    .map(c -> HlsCaptionLanguageMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCaptionLanguageMappings(Collection<HlsCaptionLanguageMapping.BuilderImpl> captionLanguageMappings) {
            this.captionLanguageMappings = ___listOfHlsCaptionLanguageMappingCopier.copyFromBuilder(captionLanguageMappings);
        }

        public final String getCaptionLanguageSetting() {
            return captionLanguageSetting;
        }

        @Override
        public final Builder captionLanguageSetting(String captionLanguageSetting) {
            this.captionLanguageSetting = captionLanguageSetting;
            return this;
        }

        @Override
        public final Builder captionLanguageSetting(HlsCaptionLanguageSetting captionLanguageSetting) {
            this.captionLanguageSetting(captionLanguageSetting == null ? null : captionLanguageSetting.toString());
            return this;
        }

        public final void setCaptionLanguageSetting(String captionLanguageSetting) {
            this.captionLanguageSetting = captionLanguageSetting;
        }

        public final String getClientCache() {
            return clientCache;
        }

        @Override
        public final Builder clientCache(String clientCache) {
            this.clientCache = clientCache;
            return this;
        }

        @Override
        public final Builder clientCache(HlsClientCache clientCache) {
            this.clientCache(clientCache == null ? null : clientCache.toString());
            return this;
        }

        public final void setClientCache(String clientCache) {
            this.clientCache = clientCache;
        }

        public final String getCodecSpecification() {
            return codecSpecification;
        }

        @Override
        public final Builder codecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
            return this;
        }

        @Override
        public final Builder codecSpecification(HlsCodecSpecification codecSpecification) {
            this.codecSpecification(codecSpecification == null ? null : codecSpecification.toString());
            return this;
        }

        public final void setCodecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
        }

        public final String getDestination() {
            return destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final DestinationSettings.Builder getDestinationSettings() {
            return destinationSettings != null ? destinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder destinationSettings(DestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final void setDestinationSettings(DestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        public final String getDirectoryStructure() {
            return directoryStructure;
        }

        @Override
        public final Builder directoryStructure(String directoryStructure) {
            this.directoryStructure = directoryStructure;
            return this;
        }

        @Override
        public final Builder directoryStructure(HlsDirectoryStructure directoryStructure) {
            this.directoryStructure(directoryStructure == null ? null : directoryStructure.toString());
            return this;
        }

        public final void setDirectoryStructure(String directoryStructure) {
            this.directoryStructure = directoryStructure;
        }

        public final HlsEncryptionSettings.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(HlsEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(HlsEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final String getManifestCompression() {
            return manifestCompression;
        }

        @Override
        public final Builder manifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
            return this;
        }

        @Override
        public final Builder manifestCompression(HlsManifestCompression manifestCompression) {
            this.manifestCompression(manifestCompression == null ? null : manifestCompression.toString());
            return this;
        }

        public final void setManifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
        }

        public final String getManifestDurationFormat() {
            return manifestDurationFormat;
        }

        @Override
        public final Builder manifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
            return this;
        }

        @Override
        public final Builder manifestDurationFormat(HlsManifestDurationFormat manifestDurationFormat) {
            this.manifestDurationFormat(manifestDurationFormat == null ? null : manifestDurationFormat.toString());
            return this;
        }

        public final void setManifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
        }

        public final Double getMinFinalSegmentLength() {
            return minFinalSegmentLength;
        }

        @Override
        public final Builder minFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
            return this;
        }

        public final void setMinFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
        }

        public final Integer getMinSegmentLength() {
            return minSegmentLength;
        }

        @Override
        public final Builder minSegmentLength(Integer minSegmentLength) {
            this.minSegmentLength = minSegmentLength;
            return this;
        }

        public final void setMinSegmentLength(Integer minSegmentLength) {
            this.minSegmentLength = minSegmentLength;
        }

        public final String getOutputSelection() {
            return outputSelection;
        }

        @Override
        public final Builder outputSelection(String outputSelection) {
            this.outputSelection = outputSelection;
            return this;
        }

        @Override
        public final Builder outputSelection(HlsOutputSelection outputSelection) {
            this.outputSelection(outputSelection == null ? null : outputSelection.toString());
            return this;
        }

        public final void setOutputSelection(String outputSelection) {
            this.outputSelection = outputSelection;
        }

        public final String getProgramDateTime() {
            return programDateTime;
        }

        @Override
        public final Builder programDateTime(String programDateTime) {
            this.programDateTime = programDateTime;
            return this;
        }

        @Override
        public final Builder programDateTime(HlsProgramDateTime programDateTime) {
            this.programDateTime(programDateTime == null ? null : programDateTime.toString());
            return this;
        }

        public final void setProgramDateTime(String programDateTime) {
            this.programDateTime = programDateTime;
        }

        public final Integer getProgramDateTimePeriod() {
            return programDateTimePeriod;
        }

        @Override
        public final Builder programDateTimePeriod(Integer programDateTimePeriod) {
            this.programDateTimePeriod = programDateTimePeriod;
            return this;
        }

        public final void setProgramDateTimePeriod(Integer programDateTimePeriod) {
            this.programDateTimePeriod = programDateTimePeriod;
        }

        public final String getSegmentControl() {
            return segmentControl;
        }

        @Override
        public final Builder segmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
            return this;
        }

        @Override
        public final Builder segmentControl(HlsSegmentControl segmentControl) {
            this.segmentControl(segmentControl == null ? null : segmentControl.toString());
            return this;
        }

        public final void setSegmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
        }

        public final Integer getSegmentLength() {
            return segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        public final Integer getSegmentsPerSubdirectory() {
            return segmentsPerSubdirectory;
        }

        @Override
        public final Builder segmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
            this.segmentsPerSubdirectory = segmentsPerSubdirectory;
            return this;
        }

        public final void setSegmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
            this.segmentsPerSubdirectory = segmentsPerSubdirectory;
        }

        public final String getStreamInfResolution() {
            return streamInfResolution;
        }

        @Override
        public final Builder streamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
            return this;
        }

        @Override
        public final Builder streamInfResolution(HlsStreamInfResolution streamInfResolution) {
            this.streamInfResolution(streamInfResolution == null ? null : streamInfResolution.toString());
            return this;
        }

        public final void setStreamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
        }

        public final String getTimedMetadataId3Frame() {
            return timedMetadataId3Frame;
        }

        @Override
        public final Builder timedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
            return this;
        }

        @Override
        public final Builder timedMetadataId3Frame(HlsTimedMetadataId3Frame timedMetadataId3Frame) {
            this.timedMetadataId3Frame(timedMetadataId3Frame == null ? null : timedMetadataId3Frame.toString());
            return this;
        }

        public final void setTimedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
        }

        public final Integer getTimedMetadataId3Period() {
            return timedMetadataId3Period;
        }

        @Override
        public final Builder timedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
            return this;
        }

        public final void setTimedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
        }

        public final Integer getTimestampDeltaMilliseconds() {
            return timestampDeltaMilliseconds;
        }

        @Override
        public final Builder timestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
            this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
            return this;
        }

        public final void setTimestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
            this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
        }

        @Override
        public HlsGroupSettings build() {
            return new HlsGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
