/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * If the location of parameter set NAL units doesn't matter in your workflow, ignore this setting. Use this setting
 * only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container (MP4 outputs). Choose HVC1 to
 * mark your output as HVC1. This makes your output compliant with the following specification: ISO IECJTC1 SC29 N13798
 * Text ISO/IEC FDIS 14496-15 3rd Edition. For these outputs, the service stores parameter set NAL units in the sample
 * headers but not in the samples directly. For MP4 outputs, when you choose HVC1, your output video might not work
 * properly with some downstream systems and video players. The service defaults to marking your output as HEV1. For
 * these outputs, the service writes parameter set NAL units directly into the samples.
 */
@Generated("software.amazon.awssdk:codegen")
public enum H265WriteMp4PackagingType {
    HVC1("HVC1"),

    HEV1("HEV1"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private H265WriteMp4PackagingType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return H265WriteMp4PackagingType corresponding to the value
     */
    public static H265WriteMp4PackagingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(H265WriteMp4PackagingType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link H265WriteMp4PackagingType}s
     */
    public static Set<H265WriteMp4PackagingType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
