/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
 */
@Generated("software.amazon.awssdk:codegen")
public final class H264Settings implements SdkPojo, Serializable, ToCopyableBuilder<H264Settings.Builder, H264Settings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::adaptiveQuantizationAsString)).setter(setter(Builder::adaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build())
            .build();

    private static final SdkField<Integer> BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(H264Settings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<String> CODEC_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::codecLevelAsString)).setter(setter(Builder::codecLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecLevel").build()).build();

    private static final SdkField<String> CODEC_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::codecProfileAsString)).setter(setter(Builder::codecProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecProfile").build()).build();

    private static final SdkField<String> DYNAMIC_SUB_GOP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::dynamicSubGopAsString)).setter(setter(Builder::dynamicSubGop))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicSubGop").build()).build();

    private static final SdkField<String> ENTROPY_ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::entropyEncodingAsString)).setter(setter(Builder::entropyEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entropyEncoding").build()).build();

    private static final SdkField<String> FIELD_ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::fieldEncodingAsString)).setter(setter(Builder::fieldEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldEncoding").build()).build();

    private static final SdkField<String> FLICKER_ADAPTIVE_QUANTIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::flickerAdaptiveQuantizationAsString))
            .setter(setter(Builder::flickerAdaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flickerAdaptiveQuantization")
                    .build()).build();

    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::framerateControlAsString)).setter(setter(Builder::framerateControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()).build();

    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::framerateConversionAlgorithmAsString))
            .setter(setter(Builder::framerateConversionAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm")
                    .build()).build();

    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(H264Settings::framerateDenominator)).setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(H264Settings::framerateNumerator)).setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final SdkField<String> GOP_B_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::gopBReferenceAsString)).setter(setter(Builder::gopBReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopBReference").build()).build();

    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(H264Settings::gopClosedCadence)).setter(setter(Builder::gopClosedCadence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()).build();

    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(H264Settings::gopSize)).setter(setter(Builder::gopSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()).build();

    private static final SdkField<String> GOP_SIZE_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::gopSizeUnitsAsString)).setter(setter(Builder::gopSizeUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSizeUnits").build()).build();

    private static final SdkField<Integer> HRD_BUFFER_INITIAL_FILL_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(H264Settings::hrdBufferInitialFillPercentage))
            .setter(setter(Builder::hrdBufferInitialFillPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferInitialFillPercentage")
                    .build()).build();

    private static final SdkField<Integer> HRD_BUFFER_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(H264Settings::hrdBufferSize)).setter(setter(Builder::hrdBufferSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferSize").build()).build();

    private static final SdkField<String> INTERLACE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::interlaceModeAsString)).setter(setter(Builder::interlaceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interlaceMode").build()).build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(H264Settings::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<Integer> MIN_I_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(H264Settings::minIInterval)).setter(setter(Builder::minIInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minIInterval").build()).build();

    private static final SdkField<Integer> NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(H264Settings::numberBFramesBetweenReferenceFrames))
            .setter(setter(Builder::numberBFramesBetweenReferenceFrames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("numberBFramesBetweenReferenceFrames").build()).build();

    private static final SdkField<Integer> NUMBER_REFERENCE_FRAMES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(H264Settings::numberReferenceFrames)).setter(setter(Builder::numberReferenceFrames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberReferenceFrames").build())
            .build();

    private static final SdkField<String> PAR_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::parControlAsString)).setter(setter(Builder::parControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parControl").build()).build();

    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(H264Settings::parDenominator)).setter(setter(Builder::parDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()).build();

    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(H264Settings::parNumerator)).setter(setter(Builder::parNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()).build();

    private static final SdkField<String> QUALITY_TUNING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::qualityTuningLevelAsString)).setter(setter(Builder::qualityTuningLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualityTuningLevel").build())
            .build();

    private static final SdkField<H264QvbrSettings> QVBR_SETTINGS_FIELD = SdkField
            .<H264QvbrSettings> builder(MarshallingType.SDK_POJO).getter(getter(H264Settings::qvbrSettings))
            .setter(setter(Builder::qvbrSettings)).constructor(H264QvbrSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrSettings").build()).build();

    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::rateControlModeAsString)).setter(setter(Builder::rateControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()).build();

    private static final SdkField<String> REPEAT_PPS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::repeatPpsAsString)).setter(setter(Builder::repeatPps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repeatPps").build()).build();

    private static final SdkField<String> SCENE_CHANGE_DETECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::sceneChangeDetectAsString)).setter(setter(Builder::sceneChangeDetect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneChangeDetect").build()).build();

    private static final SdkField<Integer> SLICES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(H264Settings::slices)).setter(setter(Builder::slices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slices").build()).build();

    private static final SdkField<String> SLOW_PAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::slowPalAsString)).setter(setter(Builder::slowPal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slowPal").build()).build();

    private static final SdkField<Integer> SOFTNESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(H264Settings::softness)).setter(setter(Builder::softness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softness").build()).build();

    private static final SdkField<String> SPATIAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::spatialAdaptiveQuantizationAsString))
            .setter(setter(Builder::spatialAdaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spatialAdaptiveQuantization")
                    .build()).build();

    private static final SdkField<String> SYNTAX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::syntaxAsString)).setter(setter(Builder::syntax))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syntax").build()).build();

    private static final SdkField<String> TELECINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::telecineAsString)).setter(setter(Builder::telecine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telecine").build()).build();

    private static final SdkField<String> TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::temporalAdaptiveQuantizationAsString))
            .setter(setter(Builder::temporalAdaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalAdaptiveQuantization")
                    .build()).build();

    private static final SdkField<String> UNREGISTERED_SEI_TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(H264Settings::unregisteredSeiTimecodeAsString)).setter(setter(Builder::unregisteredSeiTimecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unregisteredSeiTimecode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD,
            BITRATE_FIELD, CODEC_LEVEL_FIELD, CODEC_PROFILE_FIELD, DYNAMIC_SUB_GOP_FIELD, ENTROPY_ENCODING_FIELD,
            FIELD_ENCODING_FIELD, FLICKER_ADAPTIVE_QUANTIZATION_FIELD, FRAMERATE_CONTROL_FIELD,
            FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, GOP_B_REFERENCE_FIELD,
            GOP_CLOSED_CADENCE_FIELD, GOP_SIZE_FIELD, GOP_SIZE_UNITS_FIELD, HRD_BUFFER_INITIAL_FILL_PERCENTAGE_FIELD,
            HRD_BUFFER_SIZE_FIELD, INTERLACE_MODE_FIELD, MAX_BITRATE_FIELD, MIN_I_INTERVAL_FIELD,
            NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD, NUMBER_REFERENCE_FRAMES_FIELD, PAR_CONTROL_FIELD,
            PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD, QUALITY_TUNING_LEVEL_FIELD, QVBR_SETTINGS_FIELD, RATE_CONTROL_MODE_FIELD,
            REPEAT_PPS_FIELD, SCENE_CHANGE_DETECT_FIELD, SLICES_FIELD, SLOW_PAL_FIELD, SOFTNESS_FIELD,
            SPATIAL_ADAPTIVE_QUANTIZATION_FIELD, SYNTAX_FIELD, TELECINE_FIELD, TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD,
            UNREGISTERED_SEI_TIMECODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adaptiveQuantization;

    private final Integer bitrate;

    private final String codecLevel;

    private final String codecProfile;

    private final String dynamicSubGop;

    private final String entropyEncoding;

    private final String fieldEncoding;

    private final String flickerAdaptiveQuantization;

    private final String framerateControl;

    private final String framerateConversionAlgorithm;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private final String gopBReference;

    private final Integer gopClosedCadence;

    private final Double gopSize;

    private final String gopSizeUnits;

    private final Integer hrdBufferInitialFillPercentage;

    private final Integer hrdBufferSize;

    private final String interlaceMode;

    private final Integer maxBitrate;

    private final Integer minIInterval;

    private final Integer numberBFramesBetweenReferenceFrames;

    private final Integer numberReferenceFrames;

    private final String parControl;

    private final Integer parDenominator;

    private final Integer parNumerator;

    private final String qualityTuningLevel;

    private final H264QvbrSettings qvbrSettings;

    private final String rateControlMode;

    private final String repeatPps;

    private final String sceneChangeDetect;

    private final Integer slices;

    private final String slowPal;

    private final Integer softness;

    private final String spatialAdaptiveQuantization;

    private final String syntax;

    private final String telecine;

    private final String temporalAdaptiveQuantization;

    private final String unregisteredSeiTimecode;

    private H264Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.bitrate = builder.bitrate;
        this.codecLevel = builder.codecLevel;
        this.codecProfile = builder.codecProfile;
        this.dynamicSubGop = builder.dynamicSubGop;
        this.entropyEncoding = builder.entropyEncoding;
        this.fieldEncoding = builder.fieldEncoding;
        this.flickerAdaptiveQuantization = builder.flickerAdaptiveQuantization;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopBReference = builder.gopBReference;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.hrdBufferInitialFillPercentage = builder.hrdBufferInitialFillPercentage;
        this.hrdBufferSize = builder.hrdBufferSize;
        this.interlaceMode = builder.interlaceMode;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.numberBFramesBetweenReferenceFrames = builder.numberBFramesBetweenReferenceFrames;
        this.numberReferenceFrames = builder.numberReferenceFrames;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.qualityTuningLevel = builder.qualityTuningLevel;
        this.qvbrSettings = builder.qvbrSettings;
        this.rateControlMode = builder.rateControlMode;
        this.repeatPps = builder.repeatPps;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.slices = builder.slices;
        this.slowPal = builder.slowPal;
        this.softness = builder.softness;
        this.spatialAdaptiveQuantization = builder.spatialAdaptiveQuantization;
        this.syntax = builder.syntax;
        this.telecine = builder.telecine;
        this.temporalAdaptiveQuantization = builder.temporalAdaptiveQuantization;
        this.unregisteredSeiTimecode = builder.unregisteredSeiTimecode;
    }

    /**
     * Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link H264AdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
     * @see H264AdaptiveQuantization
     */
    public H264AdaptiveQuantization adaptiveQuantization() {
        return H264AdaptiveQuantization.fromValue(adaptiveQuantization);
    }

    /**
     * Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link H264AdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
     * @see H264AdaptiveQuantization
     */
    public String adaptiveQuantizationAsString() {
        return adaptiveQuantization;
    }

    /**
     * Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be
     * unique when rounded down to the nearest multiple of 1000.
     * 
     * @return Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates
     *         must be unique when rounded down to the nearest multiple of 1000.
     */
    public Integer bitrate() {
        return bitrate;
    }

    /**
     * Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level to
     * specify, choose Auto (AUTO).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecLevel} will
     * return {@link H264CodecLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecLevelAsString}.
     * </p>
     * 
     * @return Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level
     *         to specify, choose Auto (AUTO).
     * @see H264CodecLevel
     */
    public H264CodecLevel codecLevel() {
        return H264CodecLevel.fromValue(codecLevel);
    }

    /**
     * Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level to
     * specify, choose Auto (AUTO).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecLevel} will
     * return {@link H264CodecLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecLevelAsString}.
     * </p>
     * 
     * @return Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level
     *         to specify, choose Auto (AUTO).
     * @see H264CodecLevel
     */
    public String codecLevelAsString() {
        return codecLevel;
    }

    /**
     * H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecProfile} will
     * return {@link H264CodecProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecProfileAsString}.
     * </p>
     * 
     * @return H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
     * @see H264CodecProfile
     */
    public H264CodecProfile codecProfile() {
        return H264CodecProfile.fromValue(codecProfile);
    }

    /**
     * H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecProfile} will
     * return {@link H264CodecProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecProfileAsString}.
     * </p>
     * 
     * @return H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
     * @see H264CodecProfile
     */
    public String codecProfileAsString() {
        return codecProfile;
    }

    /**
     * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use
     * fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more
     * B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the
     * setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dynamicSubGop}
     * will return {@link H264DynamicSubGop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dynamicSubGopAsString}.
     * </p>
     * 
     * @return Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service
     *         to use fewer B-frames (which infer information based on other frames) for high-motion portions of the
     *         video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value
     *         you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
     * @see H264DynamicSubGop
     */
    public H264DynamicSubGop dynamicSubGop() {
        return H264DynamicSubGop.fromValue(dynamicSubGop);
    }

    /**
     * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use
     * fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more
     * B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the
     * setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dynamicSubGop}
     * will return {@link H264DynamicSubGop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dynamicSubGopAsString}.
     * </p>
     * 
     * @return Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service
     *         to use fewer B-frames (which infer information based on other frames) for high-motion portions of the
     *         video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value
     *         you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
     * @see H264DynamicSubGop
     */
    public String dynamicSubGopAsString() {
        return dynamicSubGop;
    }

    /**
     * Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entropyEncoding}
     * will return {@link H264EntropyEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #entropyEncodingAsString}.
     * </p>
     * 
     * @return Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
     * @see H264EntropyEncoding
     */
    public H264EntropyEncoding entropyEncoding() {
        return H264EntropyEncoding.fromValue(entropyEncoding);
    }

    /**
     * Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entropyEncoding}
     * will return {@link H264EntropyEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #entropyEncodingAsString}.
     * </p>
     * 
     * @return Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
     * @see H264EntropyEncoding
     */
    public String entropyEncodingAsString() {
        return entropyEncoding;
    }

    /**
     * Choosing FORCE_FIELD disables PAFF encoding for interlaced outputs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldEncoding}
     * will return {@link H264FieldEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fieldEncodingAsString}.
     * </p>
     * 
     * @return Choosing FORCE_FIELD disables PAFF encoding for interlaced outputs.
     * @see H264FieldEncoding
     */
    public H264FieldEncoding fieldEncoding() {
        return H264FieldEncoding.fromValue(fieldEncoding);
    }

    /**
     * Choosing FORCE_FIELD disables PAFF encoding for interlaced outputs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldEncoding}
     * will return {@link H264FieldEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fieldEncodingAsString}.
     * </p>
     * 
     * @return Choosing FORCE_FIELD disables PAFF encoding for interlaced outputs.
     * @see H264FieldEncoding
     */
    public String fieldEncodingAsString() {
        return fieldEncoding;
    }

    /**
     * Adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flickerAdaptiveQuantization} will return {@link H264FlickerAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #flickerAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
     * @see H264FlickerAdaptiveQuantization
     */
    public H264FlickerAdaptiveQuantization flickerAdaptiveQuantization() {
        return H264FlickerAdaptiveQuantization.fromValue(flickerAdaptiveQuantization);
    }

    /**
     * Adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flickerAdaptiveQuantization} will return {@link H264FlickerAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #flickerAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
     * @see H264FlickerAdaptiveQuantization
     */
    public String flickerAdaptiveQuantizationAsString() {
        return flickerAdaptiveQuantization;
    }

    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to
     * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
     * decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are
     * creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify
     * which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the
     * service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you
     * specify in the settings FramerateNumerator and FramerateDenominator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link H264FramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
     *         want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
     *         conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the
     *         dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a
     *         fraction. If you are creating your transcoding job specification as a JSON file without the console, use
     *         FramerateControl to specify which value the service uses for the frame rate for this output. Choose
     *         INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if
     *         you want the service to use the frame rate you specify in the settings FramerateNumerator and
     *         FramerateDenominator.
     * @see H264FramerateControl
     */
    public H264FramerateControl framerateControl() {
        return H264FramerateControl.fromValue(framerateControl);
    }

    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to
     * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
     * decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are
     * creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify
     * which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the
     * service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you
     * specify in the settings FramerateNumerator and FramerateDenominator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link H264FramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
     *         want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
     *         conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the
     *         dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a
     *         fraction. If you are creating your transcoding job specification as a JSON file without the console, use
     *         FramerateControl to specify which value the service uses for the frame rate for this output. Choose
     *         INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if
     *         you want the service to use the frame rate you specify in the settings FramerateNumerator and
     *         FramerateDenominator.
     * @see H264FramerateControl
     */
    public String framerateControlAsString() {
        return framerateControl;
    }

    /**
     * Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate drop
     * conversion.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return {@link H264FramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use
     *         duplicate drop conversion.
     * @see H264FramerateConversionAlgorithm
     */
    public H264FramerateConversionAlgorithm framerateConversionAlgorithm() {
        return H264FramerateConversionAlgorithm.fromValue(framerateConversionAlgorithm);
    }

    /**
     * Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate drop
     * conversion.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return {@link H264FramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use
     *         duplicate drop conversion.
     * @see H264FramerateConversionAlgorithm
     */
    public String framerateConversionAlgorithmAsString() {
        return framerateConversionAlgorithm;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this
     * example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of
     *         this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console
     *         for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate.
     *         In this example, specify 23.976.
     */
    public Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * Frame rate numerator - frame rate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
     * 
     * @return Frame rate numerator - frame rate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
     */
    public Integer framerateNumerator() {
        return framerateNumerator;
    }

    /**
     * If enable, use reference B frames for GOP structures that have B frames > 1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopBReference}
     * will return {@link H264GopBReference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #gopBReferenceAsString}.
     * </p>
     * 
     * @return If enable, use reference B frames for GOP structures that have B frames > 1.
     * @see H264GopBReference
     */
    public H264GopBReference gopBReference() {
        return H264GopBReference.fromValue(gopBReference);
    }

    /**
     * If enable, use reference B frames for GOP structures that have B frames > 1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopBReference}
     * will return {@link H264GopBReference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #gopBReferenceAsString}.
     * </p>
     * 
     * @return If enable, use reference B frames for GOP structures that have B frames > 1.
     * @see H264GopBReference
     */
    public String gopBReferenceAsString() {
        return gopBReference;
    }

    /**
     * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining
     * mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output
     * segmenting.
     * 
     * @return Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder
     *         joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break
     *         output segmenting.
     */
    public Integer gopClosedCadence() {
        return gopClosedCadence;
    }

    /**
     * GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
     * 
     * @return GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
     */
    public Double gopSize() {
        return gopSize;
    }

    /**
     * Indicates if the GOP Size in H264 is specified in frames or seconds. If seconds the system will convert the GOP
     * Size into a frame count at run time.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopSizeUnits} will
     * return {@link H264GopSizeUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gopSizeUnitsAsString}.
     * </p>
     * 
     * @return Indicates if the GOP Size in H264 is specified in frames or seconds. If seconds the system will convert
     *         the GOP Size into a frame count at run time.
     * @see H264GopSizeUnits
     */
    public H264GopSizeUnits gopSizeUnits() {
        return H264GopSizeUnits.fromValue(gopSizeUnits);
    }

    /**
     * Indicates if the GOP Size in H264 is specified in frames or seconds. If seconds the system will convert the GOP
     * Size into a frame count at run time.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopSizeUnits} will
     * return {@link H264GopSizeUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gopSizeUnitsAsString}.
     * </p>
     * 
     * @return Indicates if the GOP Size in H264 is specified in frames or seconds. If seconds the system will convert
     *         the GOP Size into a frame count at run time.
     * @see H264GopSizeUnits
     */
    public String gopSizeUnitsAsString() {
        return gopSizeUnits;
    }

    /**
     * Percentage of the buffer that should initially be filled (HRD buffer model).
     * 
     * @return Percentage of the buffer that should initially be filled (HRD buffer model).
     */
    public Integer hrdBufferInitialFillPercentage() {
        return hrdBufferInitialFillPercentage;
    }

    /**
     * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
     * 
     * @return Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
     */
    public Integer hrdBufferSize() {
        return hrdBufferSize;
    }

    /**
     * Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First (TOP_FIELD) and
     * Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having the same field polarity
     * (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default Bottom (FOLLOW_BOTTOM_FIELD)
     * use the same field polarity as the source. Therefore, behavior depends on the input scan type, as follows. - If
     * the source is interlaced, the output will be interlaced with the same polarity as the source (it will follow the
     * source). The output could therefore be a mix of "top field first" and "bottom field first". - If the source is
     * progressive, the output will be interlaced with "top field first" or "bottom field first" polarity, depending on
     * which of the Follow options you chose.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interlaceMode}
     * will return {@link H264InterlaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interlaceModeAsString}.
     * </p>
     * 
     * @return Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First
     *         (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having
     *         the same field polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow,
     *         Default Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore, behavior
     *         depends on the input scan type, as follows. - If the source is interlaced, the output will be interlaced
     *         with the same polarity as the source (it will follow the source). The output could therefore be a mix of
     *         "top field first" and "bottom field first". - If the source is progressive, the output will be interlaced
     *         with "top field first" or "bottom field first" polarity, depending on which of the Follow options you
     *         chose.
     * @see H264InterlaceMode
     */
    public H264InterlaceMode interlaceMode() {
        return H264InterlaceMode.fromValue(interlaceMode);
    }

    /**
     * Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First (TOP_FIELD) and
     * Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having the same field polarity
     * (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default Bottom (FOLLOW_BOTTOM_FIELD)
     * use the same field polarity as the source. Therefore, behavior depends on the input scan type, as follows. - If
     * the source is interlaced, the output will be interlaced with the same polarity as the source (it will follow the
     * source). The output could therefore be a mix of "top field first" and "bottom field first". - If the source is
     * progressive, the output will be interlaced with "top field first" or "bottom field first" polarity, depending on
     * which of the Follow options you chose.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interlaceMode}
     * will return {@link H264InterlaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interlaceModeAsString}.
     * </p>
     * 
     * @return Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First
     *         (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having
     *         the same field polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow,
     *         Default Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore, behavior
     *         depends on the input scan type, as follows. - If the source is interlaced, the output will be interlaced
     *         with the same polarity as the source (it will follow the source). The output could therefore be a mix of
     *         "top field first" and "bottom field first". - If the source is progressive, the output will be interlaced
     *         with "top field first" or "bottom field first" polarity, depending on which of the Follow options you
     *         chose.
     * @see H264InterlaceMode
     */
    public String interlaceModeAsString() {
        return interlaceMode;
    }

    /**
     * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate
     * control mode is QVBR.
     * 
     * @return Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when
     *         Rate control mode is QVBR.
     */
    public Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a
     * scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the
     * scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence
     * resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP
     * stretch = GOP size + Min-I-interval - 1
     * 
     * @return Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection.
     *         If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or
     *         stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting
     *         I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change
     *         Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
     */
    public Integer minIInterval() {
        return minIInterval;
    }

    /**
     * Number of B-frames between reference frames.
     * 
     * @return Number of B-frames between reference frames.
     */
    public Integer numberBFramesBetweenReferenceFrames() {
        return numberBFramesBetweenReferenceFrames;
    }

    /**
     * Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced
     * encoding.
     * 
     * @return Number of reference frames to use. The encoder may use more than requested if using B-frames and/or
     *         interlaced encoding.
     */
    public Integer numberReferenceFrames() {
        return numberReferenceFrames;
    }

    /**
     * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior,
     * Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To use a different
     * PAR, choose (SPECIFIED). In the console, SPECIFIED corresponds to any value other than Follow source. When you
     * choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parControl} will
     * return {@link H264ParControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parControlAsString}.
     * </p>
     * 
     * @return Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
     *         behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To
     *         use a different PAR, choose (SPECIFIED). In the console, SPECIFIED corresponds to any value other than
     *         Follow source. When you choose SPECIFIED for this setting, you must also specify values for the
     *         parNumerator and parDenominator settings.
     * @see H264ParControl
     */
    public H264ParControl parControl() {
        return H264ParControl.fromValue(parControl);
    }

    /**
     * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior,
     * Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To use a different
     * PAR, choose (SPECIFIED). In the console, SPECIFIED corresponds to any value other than Follow source. When you
     * choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parControl} will
     * return {@link H264ParControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parControlAsString}.
     * </p>
     * 
     * @return Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
     *         behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To
     *         use a different PAR, choose (SPECIFIED). In the console, SPECIFIED corresponds to any value other than
     *         Follow source. When you choose SPECIFIED for this setting, you must also specify values for the
     *         parNumerator and parDenominator settings.
     * @see H264ParControl
     */
    public String parControlAsString() {
        return parControl;
    }

    /**
     * Pixel Aspect Ratio denominator.
     * 
     * @return Pixel Aspect Ratio denominator.
     */
    public Integer parDenominator() {
        return parDenominator;
    }

    /**
     * Pixel Aspect Ratio numerator.
     * 
     * @return Pixel Aspect Ratio numerator.
     */
    public Integer parNumerator() {
        return parNumerator;
    }

    /**
     * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for
     * output video quality. The default behavior is faster, lower quality, single-pass encoding.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualityTuningLevel} will return {@link H264QualityTuningLevel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #qualityTuningLevelAsString}.
     * </p>
     * 
     * @return Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding
     *         speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
     * @see H264QualityTuningLevel
     */
    public H264QualityTuningLevel qualityTuningLevel() {
        return H264QualityTuningLevel.fromValue(qualityTuningLevel);
    }

    /**
     * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for
     * output video quality. The default behavior is faster, lower quality, single-pass encoding.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualityTuningLevel} will return {@link H264QualityTuningLevel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #qualityTuningLevelAsString}.
     * </p>
     * 
     * @return Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding
     *         speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
     * @see H264QualityTuningLevel
     */
    public String qualityTuningLevelAsString() {
        return qualityTuningLevel;
    }

    /**
     * Settings for quality-defined variable bitrate encoding with the H.264 codec. Required when you set Rate control
     * mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don't define Rate
     * control mode.
     * 
     * @return Settings for quality-defined variable bitrate encoding with the H.264 codec. Required when you set Rate
     *         control mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you
     *         don't define Rate control mode.
     */
    public H264QvbrSettings qvbrSettings() {
        return qvbrSettings;
    }

    /**
     * Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
     * quality-defined variable bitrate (QVBR).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link H264RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
     *         quality-defined variable bitrate (QVBR).
     * @see H264RateControlMode
     */
    public H264RateControlMode rateControlMode() {
        return H264RateControlMode.fromValue(rateControlMode);
    }

    /**
     * Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
     * quality-defined variable bitrate (QVBR).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link H264RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
     *         quality-defined variable bitrate (QVBR).
     * @see H264RateControlMode
     */
    public String rateControlModeAsString() {
        return rateControlMode;
    }

    /**
     * Places a PPS header on each encoded picture, even if repeated.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #repeatPps} will
     * return {@link H264RepeatPps#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #repeatPpsAsString}.
     * </p>
     * 
     * @return Places a PPS header on each encoded picture, even if repeated.
     * @see H264RepeatPps
     */
    public H264RepeatPps repeatPps() {
        return H264RepeatPps.fromValue(repeatPps);
    }

    /**
     * Places a PPS header on each encoded picture, even if repeated.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #repeatPps} will
     * return {@link H264RepeatPps#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #repeatPpsAsString}.
     * </p>
     * 
     * @return Places a PPS header on each encoded picture, even if repeated.
     * @see H264RepeatPps
     */
    public String repeatPpsAsString() {
        return repeatPps;
    }

    /**
     * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves
     * video quality and is enabled by default. If this output uses QVBR, choose Transition detection
     * (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
     * https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sceneChangeDetect}
     * will return {@link H264SceneChangeDetect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sceneChangeDetectAsString}.
     * </p>
     * 
     * @return Enable this setting to insert I-frames at scene changes that the service automatically detects. This
     *         improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection
     *         (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
     *         https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
     * @see H264SceneChangeDetect
     */
    public H264SceneChangeDetect sceneChangeDetect() {
        return H264SceneChangeDetect.fromValue(sceneChangeDetect);
    }

    /**
     * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves
     * video quality and is enabled by default. If this output uses QVBR, choose Transition detection
     * (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
     * https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sceneChangeDetect}
     * will return {@link H264SceneChangeDetect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sceneChangeDetectAsString}.
     * </p>
     * 
     * @return Enable this setting to insert I-frames at scene changes that the service automatically detects. This
     *         improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection
     *         (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
     *         https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
     * @see H264SceneChangeDetect
     */
    public String sceneChangeDetectAsString() {
        return sceneChangeDetect;
    }

    /**
     * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
     * pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
     * 
     * @return Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
     *         pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
     */
    public Integer slices() {
        return slices;
    }

    /**
     * Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up
     * correspondingly.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slowPal} will
     * return {@link H264SlowPal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #slowPalAsString}.
     * </p>
     * 
     * @return Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up
     *         correspondingly.
     * @see H264SlowPal
     */
    public H264SlowPal slowPal() {
        return H264SlowPal.fromValue(slowPal);
    }

    /**
     * Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up
     * correspondingly.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slowPal} will
     * return {@link H264SlowPal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #slowPalAsString}.
     * </p>
     * 
     * @return Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up
     *         correspondingly.
     * @see H264SlowPal
     */
    public String slowPalAsString() {
        return slowPal;
    }

    /**
     * Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image.
     * 
     * @return Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image.
     */
    public Integer softness() {
        return softness;
    }

    /**
     * Adjust quantization within each frame based on spatial variation of content complexity.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spatialAdaptiveQuantization} will return {@link H264SpatialAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #spatialAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Adjust quantization within each frame based on spatial variation of content complexity.
     * @see H264SpatialAdaptiveQuantization
     */
    public H264SpatialAdaptiveQuantization spatialAdaptiveQuantization() {
        return H264SpatialAdaptiveQuantization.fromValue(spatialAdaptiveQuantization);
    }

    /**
     * Adjust quantization within each frame based on spatial variation of content complexity.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spatialAdaptiveQuantization} will return {@link H264SpatialAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #spatialAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Adjust quantization within each frame based on spatial variation of content complexity.
     * @see H264SpatialAdaptiveQuantization
     */
    public String spatialAdaptiveQuantizationAsString() {
        return spatialAdaptiveQuantization;
    }

    /**
     * Produces a bitstream compliant with SMPTE RP-2027.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syntax} will
     * return {@link H264Syntax#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #syntaxAsString}.
     * </p>
     * 
     * @return Produces a bitstream compliant with SMPTE RP-2027.
     * @see H264Syntax
     */
    public H264Syntax syntax() {
        return H264Syntax.fromValue(syntax);
    }

    /**
     * Produces a bitstream compliant with SMPTE RP-2027.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syntax} will
     * return {@link H264Syntax#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #syntaxAsString}.
     * </p>
     * 
     * @return Produces a bitstream compliant with SMPTE RP-2027.
     * @see H264Syntax
     */
    public String syntaxAsString() {
        return syntax;
    }

    /**
     * This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This field
     * works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the Streams >
     * Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output: Progressive,
     * Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft: produces
     * 23.976; the player converts this output to 29.97i.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telecine} will
     * return {@link H264Telecine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #telecineAsString}.
     * </p>
     * 
     * @return This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This
     *         field works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the
     *         Streams > Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output:
     *         Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976
     *         input. - Soft: produces 23.976; the player converts this output to 29.97i.
     * @see H264Telecine
     */
    public H264Telecine telecine() {
        return H264Telecine.fromValue(telecine);
    }

    /**
     * This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This field
     * works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the Streams >
     * Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output: Progressive,
     * Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft: produces
     * 23.976; the player converts this output to 29.97i.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telecine} will
     * return {@link H264Telecine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #telecineAsString}.
     * </p>
     * 
     * @return This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This
     *         field works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the
     *         Streams > Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output:
     *         Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976
     *         input. - Soft: produces 23.976; the player converts this output to 29.97i.
     * @see H264Telecine
     */
    public String telecineAsString() {
        return telecine;
    }

    /**
     * Adjust quantization within each frame based on temporal variation of content complexity.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #temporalAdaptiveQuantization} will return {@link H264TemporalAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #temporalAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Adjust quantization within each frame based on temporal variation of content complexity.
     * @see H264TemporalAdaptiveQuantization
     */
    public H264TemporalAdaptiveQuantization temporalAdaptiveQuantization() {
        return H264TemporalAdaptiveQuantization.fromValue(temporalAdaptiveQuantization);
    }

    /**
     * Adjust quantization within each frame based on temporal variation of content complexity.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #temporalAdaptiveQuantization} will return {@link H264TemporalAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #temporalAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Adjust quantization within each frame based on temporal variation of content complexity.
     * @see H264TemporalAdaptiveQuantization
     */
    public String temporalAdaptiveQuantizationAsString() {
        return temporalAdaptiveQuantization;
    }

    /**
     * Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #unregisteredSeiTimecode} will return {@link H264UnregisteredSeiTimecode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #unregisteredSeiTimecodeAsString}.
     * </p>
     * 
     * @return Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
     * @see H264UnregisteredSeiTimecode
     */
    public H264UnregisteredSeiTimecode unregisteredSeiTimecode() {
        return H264UnregisteredSeiTimecode.fromValue(unregisteredSeiTimecode);
    }

    /**
     * Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #unregisteredSeiTimecode} will return {@link H264UnregisteredSeiTimecode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #unregisteredSeiTimecodeAsString}.
     * </p>
     * 
     * @return Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
     * @see H264UnregisteredSeiTimecode
     */
    public String unregisteredSeiTimecodeAsString() {
        return unregisteredSeiTimecode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(codecLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codecProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicSubGopAsString());
        hashCode = 31 * hashCode + Objects.hashCode(entropyEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fieldEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(flickerAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(gopBReferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hrdBufferInitialFillPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(hrdBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(numberBFramesBetweenReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(numberReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(parControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(qualityTuningLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(qvbrSettings());
        hashCode = 31 * hashCode + Objects.hashCode(rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(repeatPpsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sceneChangeDetectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slices());
        hashCode = 31 * hashCode + Objects.hashCode(slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(softness());
        hashCode = 31 * hashCode + Objects.hashCode(spatialAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(syntaxAsString());
        hashCode = 31 * hashCode + Objects.hashCode(telecineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(temporalAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(unregisteredSeiTimecodeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H264Settings)) {
            return false;
        }
        H264Settings other = (H264Settings) obj;
        return Objects.equals(adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString())
                && Objects.equals(bitrate(), other.bitrate()) && Objects.equals(codecLevelAsString(), other.codecLevelAsString())
                && Objects.equals(codecProfileAsString(), other.codecProfileAsString())
                && Objects.equals(dynamicSubGopAsString(), other.dynamicSubGopAsString())
                && Objects.equals(entropyEncodingAsString(), other.entropyEncodingAsString())
                && Objects.equals(fieldEncodingAsString(), other.fieldEncodingAsString())
                && Objects.equals(flickerAdaptiveQuantizationAsString(), other.flickerAdaptiveQuantizationAsString())
                && Objects.equals(framerateControlAsString(), other.framerateControlAsString())
                && Objects.equals(framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString())
                && Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator())
                && Objects.equals(gopBReferenceAsString(), other.gopBReferenceAsString())
                && Objects.equals(gopClosedCadence(), other.gopClosedCadence()) && Objects.equals(gopSize(), other.gopSize())
                && Objects.equals(gopSizeUnitsAsString(), other.gopSizeUnitsAsString())
                && Objects.equals(hrdBufferInitialFillPercentage(), other.hrdBufferInitialFillPercentage())
                && Objects.equals(hrdBufferSize(), other.hrdBufferSize())
                && Objects.equals(interlaceModeAsString(), other.interlaceModeAsString())
                && Objects.equals(maxBitrate(), other.maxBitrate()) && Objects.equals(minIInterval(), other.minIInterval())
                && Objects.equals(numberBFramesBetweenReferenceFrames(), other.numberBFramesBetweenReferenceFrames())
                && Objects.equals(numberReferenceFrames(), other.numberReferenceFrames())
                && Objects.equals(parControlAsString(), other.parControlAsString())
                && Objects.equals(parDenominator(), other.parDenominator())
                && Objects.equals(parNumerator(), other.parNumerator())
                && Objects.equals(qualityTuningLevelAsString(), other.qualityTuningLevelAsString())
                && Objects.equals(qvbrSettings(), other.qvbrSettings())
                && Objects.equals(rateControlModeAsString(), other.rateControlModeAsString())
                && Objects.equals(repeatPpsAsString(), other.repeatPpsAsString())
                && Objects.equals(sceneChangeDetectAsString(), other.sceneChangeDetectAsString())
                && Objects.equals(slices(), other.slices()) && Objects.equals(slowPalAsString(), other.slowPalAsString())
                && Objects.equals(softness(), other.softness())
                && Objects.equals(spatialAdaptiveQuantizationAsString(), other.spatialAdaptiveQuantizationAsString())
                && Objects.equals(syntaxAsString(), other.syntaxAsString())
                && Objects.equals(telecineAsString(), other.telecineAsString())
                && Objects.equals(temporalAdaptiveQuantizationAsString(), other.temporalAdaptiveQuantizationAsString())
                && Objects.equals(unregisteredSeiTimecodeAsString(), other.unregisteredSeiTimecodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("H264Settings").add("AdaptiveQuantization", adaptiveQuantizationAsString())
                .add("Bitrate", bitrate()).add("CodecLevel", codecLevelAsString()).add("CodecProfile", codecProfileAsString())
                .add("DynamicSubGop", dynamicSubGopAsString()).add("EntropyEncoding", entropyEncodingAsString())
                .add("FieldEncoding", fieldEncodingAsString())
                .add("FlickerAdaptiveQuantization", flickerAdaptiveQuantizationAsString())
                .add("FramerateControl", framerateControlAsString())
                .add("FramerateConversionAlgorithm", framerateConversionAlgorithmAsString())
                .add("FramerateDenominator", framerateDenominator()).add("FramerateNumerator", framerateNumerator())
                .add("GopBReference", gopBReferenceAsString()).add("GopClosedCadence", gopClosedCadence())
                .add("GopSize", gopSize()).add("GopSizeUnits", gopSizeUnitsAsString())
                .add("HrdBufferInitialFillPercentage", hrdBufferInitialFillPercentage()).add("HrdBufferSize", hrdBufferSize())
                .add("InterlaceMode", interlaceModeAsString()).add("MaxBitrate", maxBitrate())
                .add("MinIInterval", minIInterval())
                .add("NumberBFramesBetweenReferenceFrames", numberBFramesBetweenReferenceFrames())
                .add("NumberReferenceFrames", numberReferenceFrames()).add("ParControl", parControlAsString())
                .add("ParDenominator", parDenominator()).add("ParNumerator", parNumerator())
                .add("QualityTuningLevel", qualityTuningLevelAsString()).add("QvbrSettings", qvbrSettings())
                .add("RateControlMode", rateControlModeAsString()).add("RepeatPps", repeatPpsAsString())
                .add("SceneChangeDetect", sceneChangeDetectAsString()).add("Slices", slices()).add("SlowPal", slowPalAsString())
                .add("Softness", softness()).add("SpatialAdaptiveQuantization", spatialAdaptiveQuantizationAsString())
                .add("Syntax", syntaxAsString()).add("Telecine", telecineAsString())
                .add("TemporalAdaptiveQuantization", temporalAdaptiveQuantizationAsString())
                .add("UnregisteredSeiTimecode", unregisteredSeiTimecodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(adaptiveQuantizationAsString()));
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "CodecLevel":
            return Optional.ofNullable(clazz.cast(codecLevelAsString()));
        case "CodecProfile":
            return Optional.ofNullable(clazz.cast(codecProfileAsString()));
        case "DynamicSubGop":
            return Optional.ofNullable(clazz.cast(dynamicSubGopAsString()));
        case "EntropyEncoding":
            return Optional.ofNullable(clazz.cast(entropyEncodingAsString()));
        case "FieldEncoding":
            return Optional.ofNullable(clazz.cast(fieldEncodingAsString()));
        case "FlickerAdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(flickerAdaptiveQuantizationAsString()));
        case "FramerateControl":
            return Optional.ofNullable(clazz.cast(framerateControlAsString()));
        case "FramerateConversionAlgorithm":
            return Optional.ofNullable(clazz.cast(framerateConversionAlgorithmAsString()));
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        case "GopBReference":
            return Optional.ofNullable(clazz.cast(gopBReferenceAsString()));
        case "GopClosedCadence":
            return Optional.ofNullable(clazz.cast(gopClosedCadence()));
        case "GopSize":
            return Optional.ofNullable(clazz.cast(gopSize()));
        case "GopSizeUnits":
            return Optional.ofNullable(clazz.cast(gopSizeUnitsAsString()));
        case "HrdBufferInitialFillPercentage":
            return Optional.ofNullable(clazz.cast(hrdBufferInitialFillPercentage()));
        case "HrdBufferSize":
            return Optional.ofNullable(clazz.cast(hrdBufferSize()));
        case "InterlaceMode":
            return Optional.ofNullable(clazz.cast(interlaceModeAsString()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "MinIInterval":
            return Optional.ofNullable(clazz.cast(minIInterval()));
        case "NumberBFramesBetweenReferenceFrames":
            return Optional.ofNullable(clazz.cast(numberBFramesBetweenReferenceFrames()));
        case "NumberReferenceFrames":
            return Optional.ofNullable(clazz.cast(numberReferenceFrames()));
        case "ParControl":
            return Optional.ofNullable(clazz.cast(parControlAsString()));
        case "ParDenominator":
            return Optional.ofNullable(clazz.cast(parDenominator()));
        case "ParNumerator":
            return Optional.ofNullable(clazz.cast(parNumerator()));
        case "QualityTuningLevel":
            return Optional.ofNullable(clazz.cast(qualityTuningLevelAsString()));
        case "QvbrSettings":
            return Optional.ofNullable(clazz.cast(qvbrSettings()));
        case "RateControlMode":
            return Optional.ofNullable(clazz.cast(rateControlModeAsString()));
        case "RepeatPps":
            return Optional.ofNullable(clazz.cast(repeatPpsAsString()));
        case "SceneChangeDetect":
            return Optional.ofNullable(clazz.cast(sceneChangeDetectAsString()));
        case "Slices":
            return Optional.ofNullable(clazz.cast(slices()));
        case "SlowPal":
            return Optional.ofNullable(clazz.cast(slowPalAsString()));
        case "Softness":
            return Optional.ofNullable(clazz.cast(softness()));
        case "SpatialAdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(spatialAdaptiveQuantizationAsString()));
        case "Syntax":
            return Optional.ofNullable(clazz.cast(syntaxAsString()));
        case "Telecine":
            return Optional.ofNullable(clazz.cast(telecineAsString()));
        case "TemporalAdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(temporalAdaptiveQuantizationAsString()));
        case "UnregisteredSeiTimecode":
            return Optional.ofNullable(clazz.cast(unregisteredSeiTimecodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<H264Settings, T> g) {
        return obj -> g.apply((H264Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, H264Settings> {
        /**
         * Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
         * 
         * @param adaptiveQuantization
         *        Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
         * @see H264AdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264AdaptiveQuantization
         */
        Builder adaptiveQuantization(String adaptiveQuantization);

        /**
         * Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
         * 
         * @param adaptiveQuantization
         *        Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
         * @see H264AdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264AdaptiveQuantization
         */
        Builder adaptiveQuantization(H264AdaptiveQuantization adaptiveQuantization);

        /**
         * Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates
         * must be unique when rounded down to the nearest multiple of 1000.
         * 
         * @param bitrate
         *        Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs,
         *        bitrates must be unique when rounded down to the nearest multiple of 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Integer bitrate);

        /**
         * Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level to
         * specify, choose Auto (AUTO).
         * 
         * @param codecLevel
         *        Specify an H.264 level that is consistent with your output video settings. If you aren't sure what
         *        level to specify, choose Auto (AUTO).
         * @see H264CodecLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264CodecLevel
         */
        Builder codecLevel(String codecLevel);

        /**
         * Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level to
         * specify, choose Auto (AUTO).
         * 
         * @param codecLevel
         *        Specify an H.264 level that is consistent with your output video settings. If you aren't sure what
         *        level to specify, choose Auto (AUTO).
         * @see H264CodecLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264CodecLevel
         */
        Builder codecLevel(H264CodecLevel codecLevel);

        /**
         * H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
         * 
         * @param codecProfile
         *        H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
         * @see H264CodecProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264CodecProfile
         */
        Builder codecProfile(String codecProfile);

        /**
         * H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
         * 
         * @param codecProfile
         *        H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
         * @see H264CodecProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264CodecProfile
         */
        Builder codecProfile(H264CodecProfile codecProfile);

        /**
         * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to
         * use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and
         * more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for
         * the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
         * 
         * @param dynamicSubGop
         *        Choose Adaptive to improve subjective video quality for high-motion content. This will cause the
         *        service to use fewer B-frames (which infer information based on other frames) for high-motion portions
         *        of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by
         *        the value you provide for the setting B frames between reference frames
         *        (numberBFramesBetweenReferenceFrames).
         * @see H264DynamicSubGop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264DynamicSubGop
         */
        Builder dynamicSubGop(String dynamicSubGop);

        /**
         * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to
         * use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and
         * more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for
         * the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
         * 
         * @param dynamicSubGop
         *        Choose Adaptive to improve subjective video quality for high-motion content. This will cause the
         *        service to use fewer B-frames (which infer information based on other frames) for high-motion portions
         *        of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by
         *        the value you provide for the setting B frames between reference frames
         *        (numberBFramesBetweenReferenceFrames).
         * @see H264DynamicSubGop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264DynamicSubGop
         */
        Builder dynamicSubGop(H264DynamicSubGop dynamicSubGop);

        /**
         * Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
         * 
         * @param entropyEncoding
         *        Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
         * @see H264EntropyEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264EntropyEncoding
         */
        Builder entropyEncoding(String entropyEncoding);

        /**
         * Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
         * 
         * @param entropyEncoding
         *        Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
         * @see H264EntropyEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264EntropyEncoding
         */
        Builder entropyEncoding(H264EntropyEncoding entropyEncoding);

        /**
         * Choosing FORCE_FIELD disables PAFF encoding for interlaced outputs.
         * 
         * @param fieldEncoding
         *        Choosing FORCE_FIELD disables PAFF encoding for interlaced outputs.
         * @see H264FieldEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FieldEncoding
         */
        Builder fieldEncoding(String fieldEncoding);

        /**
         * Choosing FORCE_FIELD disables PAFF encoding for interlaced outputs.
         * 
         * @param fieldEncoding
         *        Choosing FORCE_FIELD disables PAFF encoding for interlaced outputs.
         * @see H264FieldEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FieldEncoding
         */
        Builder fieldEncoding(H264FieldEncoding fieldEncoding);

        /**
         * Adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
         * 
         * @param flickerAdaptiveQuantization
         *        Adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
         * @see H264FlickerAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FlickerAdaptiveQuantization
         */
        Builder flickerAdaptiveQuantization(String flickerAdaptiveQuantization);

        /**
         * Adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
         * 
         * @param flickerAdaptiveQuantization
         *        Adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
         * @see H264FlickerAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FlickerAdaptiveQuantization
         */
        Builder flickerAdaptiveQuantization(H264FlickerAdaptiveQuantization flickerAdaptiveQuantization);

        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown
         * list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If
         * you are creating your transcoding job specification as a JSON file without the console, use FramerateControl
         * to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if
         * you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use
         * the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         * 
         * @param framerateControl
         *        If you are using the console, use the Framerate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in
         *        the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame
         *        rate as a fraction. If you are creating your transcoding job specification as a JSON file without the
         *        console, use FramerateControl to specify which value the service uses for the frame rate for this
         *        output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input.
         *        Choose SPECIFIED if you want the service to use the frame rate you specify in the settings
         *        FramerateNumerator and FramerateDenominator.
         * @see H264FramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FramerateControl
         */
        Builder framerateControl(String framerateControl);

        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown
         * list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If
         * you are creating your transcoding job specification as a JSON file without the console, use FramerateControl
         * to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if
         * you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use
         * the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         * 
         * @param framerateControl
         *        If you are using the console, use the Framerate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in
         *        the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame
         *        rate as a fraction. If you are creating your transcoding job specification as a JSON file without the
         *        console, use FramerateControl to specify which value the service uses for the frame rate for this
         *        output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input.
         *        Choose SPECIFIED if you want the service to use the frame rate you specify in the settings
         *        FramerateNumerator and FramerateDenominator.
         * @see H264FramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FramerateControl
         */
        Builder framerateControl(H264FramerateControl framerateControl);

        /**
         * Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate
         * drop conversion.
         * 
         * @param framerateConversionAlgorithm
         *        Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use
         *        duplicate drop conversion.
         * @see H264FramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(String framerateConversionAlgorithm);

        /**
         * Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate
         * drop conversion.
         * 
         * @param framerateConversionAlgorithm
         *        Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use
         *        duplicate drop conversion.
         * @see H264FramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(H264FramerateConversionAlgorithm framerateConversionAlgorithm);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction.
         * In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs
         * that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify
         * 23.976.
         * 
         * @param framerateDenominator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator
         *        of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Framerate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * Frame rate numerator - frame rate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
         * 
         * @param framerateNumerator
         *        Frame rate numerator - frame rate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);

        /**
         * If enable, use reference B frames for GOP structures that have B frames > 1.
         * 
         * @param gopBReference
         *        If enable, use reference B frames for GOP structures that have B frames > 1.
         * @see H264GopBReference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264GopBReference
         */
        Builder gopBReference(String gopBReference);

        /**
         * If enable, use reference B frames for GOP structures that have B frames > 1.
         * 
         * @param gopBReference
         *        If enable, use reference B frames for GOP structures that have B frames > 1.
         * @see H264GopBReference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264GopBReference
         */
        Builder gopBReference(H264GopBReference gopBReference);

        /**
         * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder
         * joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break
         * output segmenting.
         * 
         * @param gopClosedCadence
         *        Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a
         *        decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0
         *        will break output segmenting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopClosedCadence(Integer gopClosedCadence);

        /**
         * GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
         * 
         * @param gopSize
         *        GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopSize(Double gopSize);

        /**
         * Indicates if the GOP Size in H264 is specified in frames or seconds. If seconds the system will convert the
         * GOP Size into a frame count at run time.
         * 
         * @param gopSizeUnits
         *        Indicates if the GOP Size in H264 is specified in frames or seconds. If seconds the system will
         *        convert the GOP Size into a frame count at run time.
         * @see H264GopSizeUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264GopSizeUnits
         */
        Builder gopSizeUnits(String gopSizeUnits);

        /**
         * Indicates if the GOP Size in H264 is specified in frames or seconds. If seconds the system will convert the
         * GOP Size into a frame count at run time.
         * 
         * @param gopSizeUnits
         *        Indicates if the GOP Size in H264 is specified in frames or seconds. If seconds the system will
         *        convert the GOP Size into a frame count at run time.
         * @see H264GopSizeUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264GopSizeUnits
         */
        Builder gopSizeUnits(H264GopSizeUnits gopSizeUnits);

        /**
         * Percentage of the buffer that should initially be filled (HRD buffer model).
         * 
         * @param hrdBufferInitialFillPercentage
         *        Percentage of the buffer that should initially be filled (HRD buffer model).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage);

        /**
         * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
         * 
         * @param hrdBufferSize
         *        Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hrdBufferSize(Integer hrdBufferSize);

        /**
         * Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First (TOP_FIELD)
         * and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having the same field
         * polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default Bottom
         * (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore, behavior depends on the input
         * scan type, as follows. - If the source is interlaced, the output will be interlaced with the same polarity as
         * the source (it will follow the source). The output could therefore be a mix of "top field first" and
         * "bottom field first". - If the source is progressive, the output will be interlaced with "top field first" or
         * "bottom field first" polarity, depending on which of the Follow options you chose.
         * 
         * @param interlaceMode
         *        Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First
         *        (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output
         *        having the same field polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and
         *        Follow, Default Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore,
         *        behavior depends on the input scan type, as follows. - If the source is interlaced, the output will be
         *        interlaced with the same polarity as the source (it will follow the source). The output could
         *        therefore be a mix of "top field first" and "bottom field first". - If the source is progressive, the
         *        output will be interlaced with "top field first" or "bottom field first" polarity, depending on which
         *        of the Follow options you chose.
         * @see H264InterlaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264InterlaceMode
         */
        Builder interlaceMode(String interlaceMode);

        /**
         * Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First (TOP_FIELD)
         * and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having the same field
         * polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default Bottom
         * (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore, behavior depends on the input
         * scan type, as follows. - If the source is interlaced, the output will be interlaced with the same polarity as
         * the source (it will follow the source). The output could therefore be a mix of "top field first" and
         * "bottom field first". - If the source is progressive, the output will be interlaced with "top field first" or
         * "bottom field first" polarity, depending on which of the Follow options you chose.
         * 
         * @param interlaceMode
         *        Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First
         *        (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output
         *        having the same field polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and
         *        Follow, Default Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore,
         *        behavior depends on the input scan type, as follows. - If the source is interlaced, the output will be
         *        interlaced with the same polarity as the source (it will follow the source). The output could
         *        therefore be a mix of "top field first" and "bottom field first". - If the source is progressive, the
         *        output will be interlaced with "top field first" or "bottom field first" polarity, depending on which
         *        of the Follow options you chose.
         * @see H264InterlaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264InterlaceMode
         */
        Builder interlaceMode(H264InterlaceMode interlaceMode);

        /**
         * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate
         * control mode is QVBR.
         * 
         * @param maxBitrate
         *        Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when
         *        Rate control mode is QVBR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a
         * scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to
         * the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal
         * cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note:
         * Maximum GOP stretch = GOP size + Min-I-interval - 1
         * 
         * @param minIInterval
         *        Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change
         *        Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is
         *        shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well
         *        as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when
         *        Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minIInterval(Integer minIInterval);

        /**
         * Number of B-frames between reference frames.
         * 
         * @param numberBFramesBetweenReferenceFrames
         *        Number of B-frames between reference frames.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames);

        /**
         * Number of reference frames to use. The encoder may use more than requested if using B-frames and/or
         * interlaced encoding.
         * 
         * @param numberReferenceFrames
         *        Number of reference frames to use. The encoder may use more than requested if using B-frames and/or
         *        interlaced encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberReferenceFrames(Integer numberReferenceFrames);

        /**
         * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         * behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To use
         * a different PAR, choose (SPECIFIED). In the console, SPECIFIED corresponds to any value other than Follow
         * source. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and
         * parDenominator settings.
         * 
         * @param parControl
         *        Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         *        behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output.
         *        To use a different PAR, choose (SPECIFIED). In the console, SPECIFIED corresponds to any value other
         *        than Follow source. When you choose SPECIFIED for this setting, you must also specify values for the
         *        parNumerator and parDenominator settings.
         * @see H264ParControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264ParControl
         */
        Builder parControl(String parControl);

        /**
         * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         * behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To use
         * a different PAR, choose (SPECIFIED). In the console, SPECIFIED corresponds to any value other than Follow
         * source. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and
         * parDenominator settings.
         * 
         * @param parControl
         *        Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         *        behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output.
         *        To use a different PAR, choose (SPECIFIED). In the console, SPECIFIED corresponds to any value other
         *        than Follow source. When you choose SPECIFIED for this setting, you must also specify values for the
         *        parNumerator and parDenominator settings.
         * @see H264ParControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264ParControl
         */
        Builder parControl(H264ParControl parControl);

        /**
         * Pixel Aspect Ratio denominator.
         * 
         * @param parDenominator
         *        Pixel Aspect Ratio denominator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parDenominator(Integer parDenominator);

        /**
         * Pixel Aspect Ratio numerator.
         * 
         * @param parNumerator
         *        Pixel Aspect Ratio numerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parNumerator(Integer parNumerator);

        /**
         * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed
         * for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         * 
         * @param qualityTuningLevel
         *        Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding
         *        speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         * @see H264QualityTuningLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264QualityTuningLevel
         */
        Builder qualityTuningLevel(String qualityTuningLevel);

        /**
         * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed
         * for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         * 
         * @param qualityTuningLevel
         *        Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding
         *        speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         * @see H264QualityTuningLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264QualityTuningLevel
         */
        Builder qualityTuningLevel(H264QualityTuningLevel qualityTuningLevel);

        /**
         * Settings for quality-defined variable bitrate encoding with the H.264 codec. Required when you set Rate
         * control mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don't
         * define Rate control mode.
         * 
         * @param qvbrSettings
         *        Settings for quality-defined variable bitrate encoding with the H.264 codec. Required when you set
         *        Rate control mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or
         *        when you don't define Rate control mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qvbrSettings(H264QvbrSettings qvbrSettings);

        /**
         * Settings for quality-defined variable bitrate encoding with the H.264 codec. Required when you set Rate
         * control mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don't
         * define Rate control mode. This is a convenience that creates an instance of the
         * {@link H264QvbrSettings.Builder} avoiding the need to create one manually via
         * {@link H264QvbrSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link H264QvbrSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #qvbrSettings(H264QvbrSettings)}.
         * 
         * @param qvbrSettings
         *        a consumer that will call methods on {@link H264QvbrSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qvbrSettings(H264QvbrSettings)
         */
        default Builder qvbrSettings(Consumer<H264QvbrSettings.Builder> qvbrSettings) {
            return qvbrSettings(H264QvbrSettings.builder().applyMutation(qvbrSettings).build());
        }

        /**
         * Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
         * quality-defined variable bitrate (QVBR).
         * 
         * @param rateControlMode
         *        Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR)
         *        or quality-defined variable bitrate (QVBR).
         * @see H264RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264RateControlMode
         */
        Builder rateControlMode(String rateControlMode);

        /**
         * Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
         * quality-defined variable bitrate (QVBR).
         * 
         * @param rateControlMode
         *        Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR)
         *        or quality-defined variable bitrate (QVBR).
         * @see H264RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264RateControlMode
         */
        Builder rateControlMode(H264RateControlMode rateControlMode);

        /**
         * Places a PPS header on each encoded picture, even if repeated.
         * 
         * @param repeatPps
         *        Places a PPS header on each encoded picture, even if repeated.
         * @see H264RepeatPps
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264RepeatPps
         */
        Builder repeatPps(String repeatPps);

        /**
         * Places a PPS header on each encoded picture, even if repeated.
         * 
         * @param repeatPps
         *        Places a PPS header on each encoded picture, even if repeated.
         * @see H264RepeatPps
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264RepeatPps
         */
        Builder repeatPps(H264RepeatPps repeatPps);

        /**
         * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves
         * video quality and is enabled by default. If this output uses QVBR, choose Transition detection
         * (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
         * https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
         * 
         * @param sceneChangeDetect
         *        Enable this setting to insert I-frames at scene changes that the service automatically detects. This
         *        improves video quality and is enabled by default. If this output uses QVBR, choose Transition
         *        detection (TRANSITION_DETECTION) for further video quality improvement. For more information about
         *        QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
         * @see H264SceneChangeDetect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SceneChangeDetect
         */
        Builder sceneChangeDetect(String sceneChangeDetect);

        /**
         * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves
         * video quality and is enabled by default. If this output uses QVBR, choose Transition detection
         * (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
         * https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
         * 
         * @param sceneChangeDetect
         *        Enable this setting to insert I-frames at scene changes that the service automatically detects. This
         *        improves video quality and is enabled by default. If this output uses QVBR, choose Transition
         *        detection (TRANSITION_DETECTION) for further video quality improvement. For more information about
         *        QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
         * @see H264SceneChangeDetect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SceneChangeDetect
         */
        Builder sceneChangeDetect(H264SceneChangeDetect sceneChangeDetect);

        /**
         * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
         * pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
         * 
         * @param slices
         *        Number of slices per picture. Must be less than or equal to the number of macroblock rows for
         *        progressive pictures, and less than or equal to half the number of macroblock rows for interlaced
         *        pictures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slices(Integer slices);

        /**
         * Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up
         * correspondingly.
         * 
         * @param slowPal
         *        Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped
         *        up correspondingly.
         * @see H264SlowPal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SlowPal
         */
        Builder slowPal(String slowPal);

        /**
         * Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up
         * correspondingly.
         * 
         * @param slowPal
         *        Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped
         *        up correspondingly.
         * @see H264SlowPal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SlowPal
         */
        Builder slowPal(H264SlowPal slowPal);

        /**
         * Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image.
         * 
         * @param softness
         *        Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softness(Integer softness);

        /**
         * Adjust quantization within each frame based on spatial variation of content complexity.
         * 
         * @param spatialAdaptiveQuantization
         *        Adjust quantization within each frame based on spatial variation of content complexity.
         * @see H264SpatialAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SpatialAdaptiveQuantization
         */
        Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization);

        /**
         * Adjust quantization within each frame based on spatial variation of content complexity.
         * 
         * @param spatialAdaptiveQuantization
         *        Adjust quantization within each frame based on spatial variation of content complexity.
         * @see H264SpatialAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SpatialAdaptiveQuantization
         */
        Builder spatialAdaptiveQuantization(H264SpatialAdaptiveQuantization spatialAdaptiveQuantization);

        /**
         * Produces a bitstream compliant with SMPTE RP-2027.
         * 
         * @param syntax
         *        Produces a bitstream compliant with SMPTE RP-2027.
         * @see H264Syntax
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264Syntax
         */
        Builder syntax(String syntax);

        /**
         * Produces a bitstream compliant with SMPTE RP-2027.
         * 
         * @param syntax
         *        Produces a bitstream compliant with SMPTE RP-2027.
         * @see H264Syntax
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264Syntax
         */
        Builder syntax(H264Syntax syntax);

        /**
         * This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This field
         * works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the Streams >
         * Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output: Progressive,
         * Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft:
         * produces 23.976; the player converts this output to 29.97i.
         * 
         * @param telecine
         *        This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This
         *        field works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and
         *        the Streams > Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the
         *        output: Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from
         *        23.976 input. - Soft: produces 23.976; the player converts this output to 29.97i.
         * @see H264Telecine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264Telecine
         */
        Builder telecine(String telecine);

        /**
         * This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This field
         * works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the Streams >
         * Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output: Progressive,
         * Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft:
         * produces 23.976; the player converts this output to 29.97i.
         * 
         * @param telecine
         *        This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This
         *        field works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and
         *        the Streams > Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the
         *        output: Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from
         *        23.976 input. - Soft: produces 23.976; the player converts this output to 29.97i.
         * @see H264Telecine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264Telecine
         */
        Builder telecine(H264Telecine telecine);

        /**
         * Adjust quantization within each frame based on temporal variation of content complexity.
         * 
         * @param temporalAdaptiveQuantization
         *        Adjust quantization within each frame based on temporal variation of content complexity.
         * @see H264TemporalAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264TemporalAdaptiveQuantization
         */
        Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization);

        /**
         * Adjust quantization within each frame based on temporal variation of content complexity.
         * 
         * @param temporalAdaptiveQuantization
         *        Adjust quantization within each frame based on temporal variation of content complexity.
         * @see H264TemporalAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264TemporalAdaptiveQuantization
         */
        Builder temporalAdaptiveQuantization(H264TemporalAdaptiveQuantization temporalAdaptiveQuantization);

        /**
         * Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
         * 
         * @param unregisteredSeiTimecode
         *        Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
         * @see H264UnregisteredSeiTimecode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264UnregisteredSeiTimecode
         */
        Builder unregisteredSeiTimecode(String unregisteredSeiTimecode);

        /**
         * Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
         * 
         * @param unregisteredSeiTimecode
         *        Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
         * @see H264UnregisteredSeiTimecode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264UnregisteredSeiTimecode
         */
        Builder unregisteredSeiTimecode(H264UnregisteredSeiTimecode unregisteredSeiTimecode);
    }

    static final class BuilderImpl implements Builder {
        private String adaptiveQuantization;

        private Integer bitrate;

        private String codecLevel;

        private String codecProfile;

        private String dynamicSubGop;

        private String entropyEncoding;

        private String fieldEncoding;

        private String flickerAdaptiveQuantization;

        private String framerateControl;

        private String framerateConversionAlgorithm;

        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private String gopBReference;

        private Integer gopClosedCadence;

        private Double gopSize;

        private String gopSizeUnits;

        private Integer hrdBufferInitialFillPercentage;

        private Integer hrdBufferSize;

        private String interlaceMode;

        private Integer maxBitrate;

        private Integer minIInterval;

        private Integer numberBFramesBetweenReferenceFrames;

        private Integer numberReferenceFrames;

        private String parControl;

        private Integer parDenominator;

        private Integer parNumerator;

        private String qualityTuningLevel;

        private H264QvbrSettings qvbrSettings;

        private String rateControlMode;

        private String repeatPps;

        private String sceneChangeDetect;

        private Integer slices;

        private String slowPal;

        private Integer softness;

        private String spatialAdaptiveQuantization;

        private String syntax;

        private String telecine;

        private String temporalAdaptiveQuantization;

        private String unregisteredSeiTimecode;

        private BuilderImpl() {
        }

        private BuilderImpl(H264Settings model) {
            adaptiveQuantization(model.adaptiveQuantization);
            bitrate(model.bitrate);
            codecLevel(model.codecLevel);
            codecProfile(model.codecProfile);
            dynamicSubGop(model.dynamicSubGop);
            entropyEncoding(model.entropyEncoding);
            fieldEncoding(model.fieldEncoding);
            flickerAdaptiveQuantization(model.flickerAdaptiveQuantization);
            framerateControl(model.framerateControl);
            framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
            gopBReference(model.gopBReference);
            gopClosedCadence(model.gopClosedCadence);
            gopSize(model.gopSize);
            gopSizeUnits(model.gopSizeUnits);
            hrdBufferInitialFillPercentage(model.hrdBufferInitialFillPercentage);
            hrdBufferSize(model.hrdBufferSize);
            interlaceMode(model.interlaceMode);
            maxBitrate(model.maxBitrate);
            minIInterval(model.minIInterval);
            numberBFramesBetweenReferenceFrames(model.numberBFramesBetweenReferenceFrames);
            numberReferenceFrames(model.numberReferenceFrames);
            parControl(model.parControl);
            parDenominator(model.parDenominator);
            parNumerator(model.parNumerator);
            qualityTuningLevel(model.qualityTuningLevel);
            qvbrSettings(model.qvbrSettings);
            rateControlMode(model.rateControlMode);
            repeatPps(model.repeatPps);
            sceneChangeDetect(model.sceneChangeDetect);
            slices(model.slices);
            slowPal(model.slowPal);
            softness(model.softness);
            spatialAdaptiveQuantization(model.spatialAdaptiveQuantization);
            syntax(model.syntax);
            telecine(model.telecine);
            temporalAdaptiveQuantization(model.temporalAdaptiveQuantization);
            unregisteredSeiTimecode(model.unregisteredSeiTimecode);
        }

        public final String getAdaptiveQuantization() {
            return adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(H264AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        public final Integer getBitrate() {
            return bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getCodecLevel() {
            return codecLevel;
        }

        @Override
        public final Builder codecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
            return this;
        }

        @Override
        public final Builder codecLevel(H264CodecLevel codecLevel) {
            this.codecLevel(codecLevel == null ? null : codecLevel.toString());
            return this;
        }

        public final void setCodecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
        }

        public final String getCodecProfile() {
            return codecProfile;
        }

        @Override
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        public final Builder codecProfile(H264CodecProfile codecProfile) {
            this.codecProfile(codecProfile == null ? null : codecProfile.toString());
            return this;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        public final String getDynamicSubGop() {
            return dynamicSubGop;
        }

        @Override
        public final Builder dynamicSubGop(String dynamicSubGop) {
            this.dynamicSubGop = dynamicSubGop;
            return this;
        }

        @Override
        public final Builder dynamicSubGop(H264DynamicSubGop dynamicSubGop) {
            this.dynamicSubGop(dynamicSubGop == null ? null : dynamicSubGop.toString());
            return this;
        }

        public final void setDynamicSubGop(String dynamicSubGop) {
            this.dynamicSubGop = dynamicSubGop;
        }

        public final String getEntropyEncoding() {
            return entropyEncoding;
        }

        @Override
        public final Builder entropyEncoding(String entropyEncoding) {
            this.entropyEncoding = entropyEncoding;
            return this;
        }

        @Override
        public final Builder entropyEncoding(H264EntropyEncoding entropyEncoding) {
            this.entropyEncoding(entropyEncoding == null ? null : entropyEncoding.toString());
            return this;
        }

        public final void setEntropyEncoding(String entropyEncoding) {
            this.entropyEncoding = entropyEncoding;
        }

        public final String getFieldEncoding() {
            return fieldEncoding;
        }

        @Override
        public final Builder fieldEncoding(String fieldEncoding) {
            this.fieldEncoding = fieldEncoding;
            return this;
        }

        @Override
        public final Builder fieldEncoding(H264FieldEncoding fieldEncoding) {
            this.fieldEncoding(fieldEncoding == null ? null : fieldEncoding.toString());
            return this;
        }

        public final void setFieldEncoding(String fieldEncoding) {
            this.fieldEncoding = fieldEncoding;
        }

        public final String getFlickerAdaptiveQuantization() {
            return flickerAdaptiveQuantization;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(H264FlickerAdaptiveQuantization flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization(flickerAdaptiveQuantization == null ? null : flickerAdaptiveQuantization.toString());
            return this;
        }

        public final void setFlickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
        }

        public final String getFramerateControl() {
            return framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(H264FramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final String getFramerateConversionAlgorithm() {
            return framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(H264FramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm
                    .toString());
            return this;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final String getGopBReference() {
            return gopBReference;
        }

        @Override
        public final Builder gopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
            return this;
        }

        @Override
        public final Builder gopBReference(H264GopBReference gopBReference) {
            this.gopBReference(gopBReference == null ? null : gopBReference.toString());
            return this;
        }

        public final void setGopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
        }

        public final Integer getGopClosedCadence() {
            return gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        public final Double getGopSize() {
            return gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        public final String getGopSizeUnits() {
            return gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(H264GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits == null ? null : gopSizeUnits.toString());
            return this;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        public final Integer getHrdBufferInitialFillPercentage() {
            return hrdBufferInitialFillPercentage;
        }

        @Override
        public final Builder hrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
            return this;
        }

        public final void setHrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
        }

        public final Integer getHrdBufferSize() {
            return hrdBufferSize;
        }

        @Override
        public final Builder hrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
            return this;
        }

        public final void setHrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
        }

        public final String getInterlaceMode() {
            return interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(H264InterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode == null ? null : interlaceMode.toString());
            return this;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getMinIInterval() {
            return minIInterval;
        }

        @Override
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        public final Integer getNumberBFramesBetweenReferenceFrames() {
            return numberBFramesBetweenReferenceFrames;
        }

        @Override
        public final Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
            return this;
        }

        public final void setNumberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
        }

        public final Integer getNumberReferenceFrames() {
            return numberReferenceFrames;
        }

        @Override
        public final Builder numberReferenceFrames(Integer numberReferenceFrames) {
            this.numberReferenceFrames = numberReferenceFrames;
            return this;
        }

        public final void setNumberReferenceFrames(Integer numberReferenceFrames) {
            this.numberReferenceFrames = numberReferenceFrames;
        }

        public final String getParControl() {
            return parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(H264ParControl parControl) {
            this.parControl(parControl == null ? null : parControl.toString());
            return this;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        public final Integer getParDenominator() {
            return parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        public final Integer getParNumerator() {
            return parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        public final String getQualityTuningLevel() {
            return qualityTuningLevel;
        }

        @Override
        public final Builder qualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
            return this;
        }

        @Override
        public final Builder qualityTuningLevel(H264QualityTuningLevel qualityTuningLevel) {
            this.qualityTuningLevel(qualityTuningLevel == null ? null : qualityTuningLevel.toString());
            return this;
        }

        public final void setQualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
        }

        public final H264QvbrSettings.Builder getQvbrSettings() {
            return qvbrSettings != null ? qvbrSettings.toBuilder() : null;
        }

        @Override
        public final Builder qvbrSettings(H264QvbrSettings qvbrSettings) {
            this.qvbrSettings = qvbrSettings;
            return this;
        }

        public final void setQvbrSettings(H264QvbrSettings.BuilderImpl qvbrSettings) {
            this.qvbrSettings = qvbrSettings != null ? qvbrSettings.build() : null;
        }

        public final String getRateControlMode() {
            return rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(H264RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final String getRepeatPps() {
            return repeatPps;
        }

        @Override
        public final Builder repeatPps(String repeatPps) {
            this.repeatPps = repeatPps;
            return this;
        }

        @Override
        public final Builder repeatPps(H264RepeatPps repeatPps) {
            this.repeatPps(repeatPps == null ? null : repeatPps.toString());
            return this;
        }

        public final void setRepeatPps(String repeatPps) {
            this.repeatPps = repeatPps;
        }

        public final String getSceneChangeDetect() {
            return sceneChangeDetect;
        }

        @Override
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        public final Builder sceneChangeDetect(H264SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect == null ? null : sceneChangeDetect.toString());
            return this;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        public final Integer getSlices() {
            return slices;
        }

        @Override
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        public final String getSlowPal() {
            return slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(H264SlowPal slowPal) {
            this.slowPal(slowPal == null ? null : slowPal.toString());
            return this;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        public final Integer getSoftness() {
            return softness;
        }

        @Override
        public final Builder softness(Integer softness) {
            this.softness = softness;
            return this;
        }

        public final void setSoftness(Integer softness) {
            this.softness = softness;
        }

        public final String getSpatialAdaptiveQuantization() {
            return spatialAdaptiveQuantization;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(H264SpatialAdaptiveQuantization spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization(spatialAdaptiveQuantization == null ? null : spatialAdaptiveQuantization.toString());
            return this;
        }

        public final void setSpatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
        }

        public final String getSyntax() {
            return syntax;
        }

        @Override
        public final Builder syntax(String syntax) {
            this.syntax = syntax;
            return this;
        }

        @Override
        public final Builder syntax(H264Syntax syntax) {
            this.syntax(syntax == null ? null : syntax.toString());
            return this;
        }

        public final void setSyntax(String syntax) {
            this.syntax = syntax;
        }

        public final String getTelecine() {
            return telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(H264Telecine telecine) {
            this.telecine(telecine == null ? null : telecine.toString());
            return this;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        public final String getTemporalAdaptiveQuantization() {
            return temporalAdaptiveQuantization;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(H264TemporalAdaptiveQuantization temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization(temporalAdaptiveQuantization == null ? null : temporalAdaptiveQuantization
                    .toString());
            return this;
        }

        public final void setTemporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
        }

        public final String getUnregisteredSeiTimecode() {
            return unregisteredSeiTimecode;
        }

        @Override
        public final Builder unregisteredSeiTimecode(String unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode = unregisteredSeiTimecode;
            return this;
        }

        @Override
        public final Builder unregisteredSeiTimecode(H264UnregisteredSeiTimecode unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode(unregisteredSeiTimecode == null ? null : unregisteredSeiTimecode.toString());
            return this;
        }

        public final void setUnregisteredSeiTimecode(String unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode = unregisteredSeiTimecode;
        }

        @Override
        public H264Settings build() {
            return new H264Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
