/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for F4v container
 */
@Generated("software.amazon.awssdk:codegen")
public final class F4vSettings implements SdkPojo, Serializable, ToCopyableBuilder<F4vSettings.Builder, F4vSettings> {
    private static final SdkField<String> MOOV_PLACEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(F4vSettings::moovPlacementAsString)).setter(setter(Builder::moovPlacement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("moovPlacement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOOV_PLACEMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String moovPlacement;

    private F4vSettings(BuilderImpl builder) {
        this.moovPlacement = builder.moovPlacement;
    }

    /**
     * If set to PROGRESSIVE_DOWNLOAD, the MOOV atom is relocated to the beginning of the archive as required for
     * progressive downloading. Otherwise it is placed normally at the end.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #moovPlacement}
     * will return {@link F4vMoovPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #moovPlacementAsString}.
     * </p>
     * 
     * @return If set to PROGRESSIVE_DOWNLOAD, the MOOV atom is relocated to the beginning of the archive as required
     *         for progressive downloading. Otherwise it is placed normally at the end.
     * @see F4vMoovPlacement
     */
    public F4vMoovPlacement moovPlacement() {
        return F4vMoovPlacement.fromValue(moovPlacement);
    }

    /**
     * If set to PROGRESSIVE_DOWNLOAD, the MOOV atom is relocated to the beginning of the archive as required for
     * progressive downloading. Otherwise it is placed normally at the end.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #moovPlacement}
     * will return {@link F4vMoovPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #moovPlacementAsString}.
     * </p>
     * 
     * @return If set to PROGRESSIVE_DOWNLOAD, the MOOV atom is relocated to the beginning of the archive as required
     *         for progressive downloading. Otherwise it is placed normally at the end.
     * @see F4vMoovPlacement
     */
    public String moovPlacementAsString() {
        return moovPlacement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(moovPlacementAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof F4vSettings)) {
            return false;
        }
        F4vSettings other = (F4vSettings) obj;
        return Objects.equals(moovPlacementAsString(), other.moovPlacementAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("F4vSettings").add("MoovPlacement", moovPlacementAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MoovPlacement":
            return Optional.ofNullable(clazz.cast(moovPlacementAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<F4vSettings, T> g) {
        return obj -> g.apply((F4vSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, F4vSettings> {
        /**
         * If set to PROGRESSIVE_DOWNLOAD, the MOOV atom is relocated to the beginning of the archive as required for
         * progressive downloading. Otherwise it is placed normally at the end.
         * 
         * @param moovPlacement
         *        If set to PROGRESSIVE_DOWNLOAD, the MOOV atom is relocated to the beginning of the archive as required
         *        for progressive downloading. Otherwise it is placed normally at the end.
         * @see F4vMoovPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see F4vMoovPlacement
         */
        Builder moovPlacement(String moovPlacement);

        /**
         * If set to PROGRESSIVE_DOWNLOAD, the MOOV atom is relocated to the beginning of the archive as required for
         * progressive downloading. Otherwise it is placed normally at the end.
         * 
         * @param moovPlacement
         *        If set to PROGRESSIVE_DOWNLOAD, the MOOV atom is relocated to the beginning of the archive as required
         *        for progressive downloading. Otherwise it is placed normally at the end.
         * @see F4vMoovPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see F4vMoovPlacement
         */
        Builder moovPlacement(F4vMoovPlacement moovPlacement);
    }

    static final class BuilderImpl implements Builder {
        private String moovPlacement;

        private BuilderImpl() {
        }

        private BuilderImpl(F4vSettings model) {
            moovPlacement(model.moovPlacement);
        }

        public final String getMoovPlacement() {
            return moovPlacement;
        }

        @Override
        public final Builder moovPlacement(String moovPlacement) {
            this.moovPlacement = moovPlacement;
            return this;
        }

        @Override
        public final Builder moovPlacement(F4vMoovPlacement moovPlacement) {
            this.moovPlacement(moovPlacement == null ? null : moovPlacement.toString());
            return this;
        }

        public final void setMoovPlacement(String moovPlacement) {
            this.moovPlacement = moovPlacement;
        }

        @Override
        public F4vSettings build() {
            return new F4vSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
