/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Choose BROADCASTER_MIXED_AD when the input contains pre-mixed main audio + audio description (AD) as a stereo pair.
 * The value for AudioType will be set to 3, which signals to downstream systems that this stream contains
 * "broadcaster mixed AD". Note that the input received by the encoder must contain pre-mixed audio; the encoder does
 * not perform the mixing. When you choose BROADCASTER_MIXED_AD, the encoder ignores any values you provide in AudioType
 * and FollowInputAudioType. Choose NORMAL when the input does not contain pre-mixed audio + audio description (AD). In
 * this case, the encoder will use any values you provide for AudioType and FollowInputAudioType.
 */
@Generated("software.amazon.awssdk:codegen")
public enum AacAudioDescriptionBroadcasterMix {
    BROADCASTER_MIXED_AD("BROADCASTER_MIXED_AD"),

    NORMAL("NORMAL"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AacAudioDescriptionBroadcasterMix(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AacAudioDescriptionBroadcasterMix corresponding to the value
     */
    public static AacAudioDescriptionBroadcasterMix fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AacAudioDescriptionBroadcasterMix.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AacAudioDescriptionBroadcasterMix}s
     */
    public static Set<AacAudioDescriptionBroadcasterMix> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
