/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Find additional transcoding features under Preprocessors (VideoPreprocessors). Enable the features at each output
 * individually. These features are disabled by default.
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoPreprocessor implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoPreprocessor.Builder, VideoPreprocessor> {
    private static final SdkField<ColorCorrector> COLOR_CORRECTOR_FIELD = SdkField
            .<ColorCorrector> builder(MarshallingType.SDK_POJO).getter(getter(VideoPreprocessor::colorCorrector))
            .setter(setter(Builder::colorCorrector)).constructor(ColorCorrector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorCorrector").build()).build();

    private static final SdkField<Deinterlacer> DEINTERLACER_FIELD = SdkField.<Deinterlacer> builder(MarshallingType.SDK_POJO)
            .getter(getter(VideoPreprocessor::deinterlacer)).setter(setter(Builder::deinterlacer))
            .constructor(Deinterlacer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deinterlacer").build()).build();

    private static final SdkField<DolbyVision> DOLBY_VISION_FIELD = SdkField.<DolbyVision> builder(MarshallingType.SDK_POJO)
            .getter(getter(VideoPreprocessor::dolbyVision)).setter(setter(Builder::dolbyVision))
            .constructor(DolbyVision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dolbyVision").build()).build();

    private static final SdkField<ImageInserter> IMAGE_INSERTER_FIELD = SdkField
            .<ImageInserter> builder(MarshallingType.SDK_POJO).getter(getter(VideoPreprocessor::imageInserter))
            .setter(setter(Builder::imageInserter)).constructor(ImageInserter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageInserter").build()).build();

    private static final SdkField<NoiseReducer> NOISE_REDUCER_FIELD = SdkField.<NoiseReducer> builder(MarshallingType.SDK_POJO)
            .getter(getter(VideoPreprocessor::noiseReducer)).setter(setter(Builder::noiseReducer))
            .constructor(NoiseReducer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noiseReducer").build()).build();

    private static final SdkField<TimecodeBurnin> TIMECODE_BURNIN_FIELD = SdkField
            .<TimecodeBurnin> builder(MarshallingType.SDK_POJO).getter(getter(VideoPreprocessor::timecodeBurnin))
            .setter(setter(Builder::timecodeBurnin)).constructor(TimecodeBurnin::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeBurnin").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLOR_CORRECTOR_FIELD,
            DEINTERLACER_FIELD, DOLBY_VISION_FIELD, IMAGE_INSERTER_FIELD, NOISE_REDUCER_FIELD, TIMECODE_BURNIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final ColorCorrector colorCorrector;

    private final Deinterlacer deinterlacer;

    private final DolbyVision dolbyVision;

    private final ImageInserter imageInserter;

    private final NoiseReducer noiseReducer;

    private final TimecodeBurnin timecodeBurnin;

    private VideoPreprocessor(BuilderImpl builder) {
        this.colorCorrector = builder.colorCorrector;
        this.deinterlacer = builder.deinterlacer;
        this.dolbyVision = builder.dolbyVision;
        this.imageInserter = builder.imageInserter;
        this.noiseReducer = builder.noiseReducer;
        this.timecodeBurnin = builder.timecodeBurnin;
    }

    /**
     * Enable the Color corrector (ColorCorrector) feature if necessary. Enable or disable this feature for each output
     * individually. This setting is disabled by default.
     * 
     * @return Enable the Color corrector (ColorCorrector) feature if necessary. Enable or disable this feature for each
     *         output individually. This setting is disabled by default.
     */
    public ColorCorrector colorCorrector() {
        return colorCorrector;
    }

    /**
     * Use Deinterlacer (Deinterlacer) to produce smoother motion and a clearer picture.
     * 
     * @return Use Deinterlacer (Deinterlacer) to produce smoother motion and a clearer picture.
     */
    public Deinterlacer deinterlacer() {
        return deinterlacer;
    }

    /**
     * Enable Dolby Vision feature to produce Dolby Vision compatible video output.
     * 
     * @return Enable Dolby Vision feature to produce Dolby Vision compatible video output.
     */
    public DolbyVision dolbyVision() {
        return dolbyVision;
    }

    /**
     * Enable the Image inserter (ImageInserter) feature to include a graphic overlay on your video. Enable or disable
     * this feature for each output individually. This setting is disabled by default.
     * 
     * @return Enable the Image inserter (ImageInserter) feature to include a graphic overlay on your video. Enable or
     *         disable this feature for each output individually. This setting is disabled by default.
     */
    public ImageInserter imageInserter() {
        return imageInserter;
    }

    /**
     * Enable the Noise reducer (NoiseReducer) feature to remove noise from your video output if necessary. Enable or
     * disable this feature for each output individually. This setting is disabled by default.
     * 
     * @return Enable the Noise reducer (NoiseReducer) feature to remove noise from your video output if necessary.
     *         Enable or disable this feature for each output individually. This setting is disabled by default.
     */
    public NoiseReducer noiseReducer() {
        return noiseReducer;
    }

    /**
     * Timecode burn-in (TimecodeBurnIn)--Burns the output timecode and specified prefix into the output.
     * 
     * @return Timecode burn-in (TimecodeBurnIn)--Burns the output timecode and specified prefix into the output.
     */
    public TimecodeBurnin timecodeBurnin() {
        return timecodeBurnin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(colorCorrector());
        hashCode = 31 * hashCode + Objects.hashCode(deinterlacer());
        hashCode = 31 * hashCode + Objects.hashCode(dolbyVision());
        hashCode = 31 * hashCode + Objects.hashCode(imageInserter());
        hashCode = 31 * hashCode + Objects.hashCode(noiseReducer());
        hashCode = 31 * hashCode + Objects.hashCode(timecodeBurnin());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoPreprocessor)) {
            return false;
        }
        VideoPreprocessor other = (VideoPreprocessor) obj;
        return Objects.equals(colorCorrector(), other.colorCorrector()) && Objects.equals(deinterlacer(), other.deinterlacer())
                && Objects.equals(dolbyVision(), other.dolbyVision()) && Objects.equals(imageInserter(), other.imageInserter())
                && Objects.equals(noiseReducer(), other.noiseReducer())
                && Objects.equals(timecodeBurnin(), other.timecodeBurnin());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VideoPreprocessor").add("ColorCorrector", colorCorrector()).add("Deinterlacer", deinterlacer())
                .add("DolbyVision", dolbyVision()).add("ImageInserter", imageInserter()).add("NoiseReducer", noiseReducer())
                .add("TimecodeBurnin", timecodeBurnin()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColorCorrector":
            return Optional.ofNullable(clazz.cast(colorCorrector()));
        case "Deinterlacer":
            return Optional.ofNullable(clazz.cast(deinterlacer()));
        case "DolbyVision":
            return Optional.ofNullable(clazz.cast(dolbyVision()));
        case "ImageInserter":
            return Optional.ofNullable(clazz.cast(imageInserter()));
        case "NoiseReducer":
            return Optional.ofNullable(clazz.cast(noiseReducer()));
        case "TimecodeBurnin":
            return Optional.ofNullable(clazz.cast(timecodeBurnin()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoPreprocessor, T> g) {
        return obj -> g.apply((VideoPreprocessor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoPreprocessor> {
        /**
         * Enable the Color corrector (ColorCorrector) feature if necessary. Enable or disable this feature for each
         * output individually. This setting is disabled by default.
         * 
         * @param colorCorrector
         *        Enable the Color corrector (ColorCorrector) feature if necessary. Enable or disable this feature for
         *        each output individually. This setting is disabled by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorCorrector(ColorCorrector colorCorrector);

        /**
         * Enable the Color corrector (ColorCorrector) feature if necessary. Enable or disable this feature for each
         * output individually. This setting is disabled by default. This is a convenience that creates an instance of
         * the {@link ColorCorrector.Builder} avoiding the need to create one manually via
         * {@link ColorCorrector#builder()}.
         *
         * When the {@link Consumer} completes, {@link ColorCorrector.Builder#build()} is called immediately and its
         * result is passed to {@link #colorCorrector(ColorCorrector)}.
         * 
         * @param colorCorrector
         *        a consumer that will call methods on {@link ColorCorrector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorCorrector(ColorCorrector)
         */
        default Builder colorCorrector(Consumer<ColorCorrector.Builder> colorCorrector) {
            return colorCorrector(ColorCorrector.builder().applyMutation(colorCorrector).build());
        }

        /**
         * Use Deinterlacer (Deinterlacer) to produce smoother motion and a clearer picture.
         * 
         * @param deinterlacer
         *        Use Deinterlacer (Deinterlacer) to produce smoother motion and a clearer picture.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deinterlacer(Deinterlacer deinterlacer);

        /**
         * Use Deinterlacer (Deinterlacer) to produce smoother motion and a clearer picture. This is a convenience that
         * creates an instance of the {@link Deinterlacer.Builder} avoiding the need to create one manually via
         * {@link Deinterlacer#builder()}.
         *
         * When the {@link Consumer} completes, {@link Deinterlacer.Builder#build()} is called immediately and its
         * result is passed to {@link #deinterlacer(Deinterlacer)}.
         * 
         * @param deinterlacer
         *        a consumer that will call methods on {@link Deinterlacer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deinterlacer(Deinterlacer)
         */
        default Builder deinterlacer(Consumer<Deinterlacer.Builder> deinterlacer) {
            return deinterlacer(Deinterlacer.builder().applyMutation(deinterlacer).build());
        }

        /**
         * Enable Dolby Vision feature to produce Dolby Vision compatible video output.
         * 
         * @param dolbyVision
         *        Enable Dolby Vision feature to produce Dolby Vision compatible video output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dolbyVision(DolbyVision dolbyVision);

        /**
         * Enable Dolby Vision feature to produce Dolby Vision compatible video output. This is a convenience that
         * creates an instance of the {@link DolbyVision.Builder} avoiding the need to create one manually via
         * {@link DolbyVision#builder()}.
         *
         * When the {@link Consumer} completes, {@link DolbyVision.Builder#build()} is called immediately and its result
         * is passed to {@link #dolbyVision(DolbyVision)}.
         * 
         * @param dolbyVision
         *        a consumer that will call methods on {@link DolbyVision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dolbyVision(DolbyVision)
         */
        default Builder dolbyVision(Consumer<DolbyVision.Builder> dolbyVision) {
            return dolbyVision(DolbyVision.builder().applyMutation(dolbyVision).build());
        }

        /**
         * Enable the Image inserter (ImageInserter) feature to include a graphic overlay on your video. Enable or
         * disable this feature for each output individually. This setting is disabled by default.
         * 
         * @param imageInserter
         *        Enable the Image inserter (ImageInserter) feature to include a graphic overlay on your video. Enable
         *        or disable this feature for each output individually. This setting is disabled by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageInserter(ImageInserter imageInserter);

        /**
         * Enable the Image inserter (ImageInserter) feature to include a graphic overlay on your video. Enable or
         * disable this feature for each output individually. This setting is disabled by default. This is a convenience
         * that creates an instance of the {@link ImageInserter.Builder} avoiding the need to create one manually via
         * {@link ImageInserter#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageInserter.Builder#build()} is called immediately and its
         * result is passed to {@link #imageInserter(ImageInserter)}.
         * 
         * @param imageInserter
         *        a consumer that will call methods on {@link ImageInserter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageInserter(ImageInserter)
         */
        default Builder imageInserter(Consumer<ImageInserter.Builder> imageInserter) {
            return imageInserter(ImageInserter.builder().applyMutation(imageInserter).build());
        }

        /**
         * Enable the Noise reducer (NoiseReducer) feature to remove noise from your video output if necessary. Enable
         * or disable this feature for each output individually. This setting is disabled by default.
         * 
         * @param noiseReducer
         *        Enable the Noise reducer (NoiseReducer) feature to remove noise from your video output if necessary.
         *        Enable or disable this feature for each output individually. This setting is disabled by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noiseReducer(NoiseReducer noiseReducer);

        /**
         * Enable the Noise reducer (NoiseReducer) feature to remove noise from your video output if necessary. Enable
         * or disable this feature for each output individually. This setting is disabled by default. This is a
         * convenience that creates an instance of the {@link NoiseReducer.Builder} avoiding the need to create one
         * manually via {@link NoiseReducer#builder()}.
         *
         * When the {@link Consumer} completes, {@link NoiseReducer.Builder#build()} is called immediately and its
         * result is passed to {@link #noiseReducer(NoiseReducer)}.
         * 
         * @param noiseReducer
         *        a consumer that will call methods on {@link NoiseReducer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noiseReducer(NoiseReducer)
         */
        default Builder noiseReducer(Consumer<NoiseReducer.Builder> noiseReducer) {
            return noiseReducer(NoiseReducer.builder().applyMutation(noiseReducer).build());
        }

        /**
         * Timecode burn-in (TimecodeBurnIn)--Burns the output timecode and specified prefix into the output.
         * 
         * @param timecodeBurnin
         *        Timecode burn-in (TimecodeBurnIn)--Burns the output timecode and specified prefix into the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timecodeBurnin(TimecodeBurnin timecodeBurnin);

        /**
         * Timecode burn-in (TimecodeBurnIn)--Burns the output timecode and specified prefix into the output. This is a
         * convenience that creates an instance of the {@link TimecodeBurnin.Builder} avoiding the need to create one
         * manually via {@link TimecodeBurnin#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimecodeBurnin.Builder#build()} is called immediately and its
         * result is passed to {@link #timecodeBurnin(TimecodeBurnin)}.
         * 
         * @param timecodeBurnin
         *        a consumer that will call methods on {@link TimecodeBurnin.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timecodeBurnin(TimecodeBurnin)
         */
        default Builder timecodeBurnin(Consumer<TimecodeBurnin.Builder> timecodeBurnin) {
            return timecodeBurnin(TimecodeBurnin.builder().applyMutation(timecodeBurnin).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ColorCorrector colorCorrector;

        private Deinterlacer deinterlacer;

        private DolbyVision dolbyVision;

        private ImageInserter imageInserter;

        private NoiseReducer noiseReducer;

        private TimecodeBurnin timecodeBurnin;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoPreprocessor model) {
            colorCorrector(model.colorCorrector);
            deinterlacer(model.deinterlacer);
            dolbyVision(model.dolbyVision);
            imageInserter(model.imageInserter);
            noiseReducer(model.noiseReducer);
            timecodeBurnin(model.timecodeBurnin);
        }

        public final ColorCorrector.Builder getColorCorrector() {
            return colorCorrector != null ? colorCorrector.toBuilder() : null;
        }

        @Override
        public final Builder colorCorrector(ColorCorrector colorCorrector) {
            this.colorCorrector = colorCorrector;
            return this;
        }

        public final void setColorCorrector(ColorCorrector.BuilderImpl colorCorrector) {
            this.colorCorrector = colorCorrector != null ? colorCorrector.build() : null;
        }

        public final Deinterlacer.Builder getDeinterlacer() {
            return deinterlacer != null ? deinterlacer.toBuilder() : null;
        }

        @Override
        public final Builder deinterlacer(Deinterlacer deinterlacer) {
            this.deinterlacer = deinterlacer;
            return this;
        }

        public final void setDeinterlacer(Deinterlacer.BuilderImpl deinterlacer) {
            this.deinterlacer = deinterlacer != null ? deinterlacer.build() : null;
        }

        public final DolbyVision.Builder getDolbyVision() {
            return dolbyVision != null ? dolbyVision.toBuilder() : null;
        }

        @Override
        public final Builder dolbyVision(DolbyVision dolbyVision) {
            this.dolbyVision = dolbyVision;
            return this;
        }

        public final void setDolbyVision(DolbyVision.BuilderImpl dolbyVision) {
            this.dolbyVision = dolbyVision != null ? dolbyVision.build() : null;
        }

        public final ImageInserter.Builder getImageInserter() {
            return imageInserter != null ? imageInserter.toBuilder() : null;
        }

        @Override
        public final Builder imageInserter(ImageInserter imageInserter) {
            this.imageInserter = imageInserter;
            return this;
        }

        public final void setImageInserter(ImageInserter.BuilderImpl imageInserter) {
            this.imageInserter = imageInserter != null ? imageInserter.build() : null;
        }

        public final NoiseReducer.Builder getNoiseReducer() {
            return noiseReducer != null ? noiseReducer.toBuilder() : null;
        }

        @Override
        public final Builder noiseReducer(NoiseReducer noiseReducer) {
            this.noiseReducer = noiseReducer;
            return this;
        }

        public final void setNoiseReducer(NoiseReducer.BuilderImpl noiseReducer) {
            this.noiseReducer = noiseReducer != null ? noiseReducer.build() : null;
        }

        public final TimecodeBurnin.Builder getTimecodeBurnin() {
            return timecodeBurnin != null ? timecodeBurnin.toBuilder() : null;
        }

        @Override
        public final Builder timecodeBurnin(TimecodeBurnin timecodeBurnin) {
            this.timecodeBurnin = timecodeBurnin;
            return this;
        }

        public final void setTimecodeBurnin(TimecodeBurnin.BuilderImpl timecodeBurnin) {
            this.timecodeBurnin = timecodeBurnin != null ? timecodeBurnin.build() : null;
        }

        @Override
        public VideoPreprocessor build() {
            return new VideoPreprocessor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
