/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Video codec settings, (CodecSettings) under (VideoDescription), contains the group of settings related to video
 * encoding. The settings in this group vary depending on the value that you choose for Video codec (Codec). For each
 * codec enum that you choose, define the corresponding settings object. The following lists the codec enum, settings
 * object pairs. * FRAME_CAPTURE, FrameCaptureSettings * H_264, H264Settings * H_265, H265Settings * MPEG2,
 * Mpeg2Settings * PRORES, ProresSettings
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoCodecSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoCodecSettings.Builder, VideoCodecSettings> {
    private static final SdkField<String> CODEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VideoCodecSettings::codecAsString)).setter(setter(Builder::codec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()).build();

    private static final SdkField<FrameCaptureSettings> FRAME_CAPTURE_SETTINGS_FIELD = SdkField
            .<FrameCaptureSettings> builder(MarshallingType.SDK_POJO).getter(getter(VideoCodecSettings::frameCaptureSettings))
            .setter(setter(Builder::frameCaptureSettings)).constructor(FrameCaptureSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureSettings").build())
            .build();

    private static final SdkField<H264Settings> H264_SETTINGS_FIELD = SdkField.<H264Settings> builder(MarshallingType.SDK_POJO)
            .getter(getter(VideoCodecSettings::h264Settings)).setter(setter(Builder::h264Settings))
            .constructor(H264Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("h264Settings").build()).build();

    private static final SdkField<H265Settings> H265_SETTINGS_FIELD = SdkField.<H265Settings> builder(MarshallingType.SDK_POJO)
            .getter(getter(VideoCodecSettings::h265Settings)).setter(setter(Builder::h265Settings))
            .constructor(H265Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("h265Settings").build()).build();

    private static final SdkField<Mpeg2Settings> MPEG2_SETTINGS_FIELD = SdkField
            .<Mpeg2Settings> builder(MarshallingType.SDK_POJO).getter(getter(VideoCodecSettings::mpeg2Settings))
            .setter(setter(Builder::mpeg2Settings)).constructor(Mpeg2Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpeg2Settings").build()).build();

    private static final SdkField<ProresSettings> PRORES_SETTINGS_FIELD = SdkField
            .<ProresSettings> builder(MarshallingType.SDK_POJO).getter(getter(VideoCodecSettings::proresSettings))
            .setter(setter(Builder::proresSettings)).constructor(ProresSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proresSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEC_FIELD,
            FRAME_CAPTURE_SETTINGS_FIELD, H264_SETTINGS_FIELD, H265_SETTINGS_FIELD, MPEG2_SETTINGS_FIELD, PRORES_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String codec;

    private final FrameCaptureSettings frameCaptureSettings;

    private final H264Settings h264Settings;

    private final H265Settings h265Settings;

    private final Mpeg2Settings mpeg2Settings;

    private final ProresSettings proresSettings;

    private VideoCodecSettings(BuilderImpl builder) {
        this.codec = builder.codec;
        this.frameCaptureSettings = builder.frameCaptureSettings;
        this.h264Settings = builder.h264Settings;
        this.h265Settings = builder.h265Settings;
        this.mpeg2Settings = builder.mpeg2Settings;
        this.proresSettings = builder.proresSettings;
    }

    /**
     * Specifies the video codec. This must be equal to one of the enum values defined by the object VideoCodec.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codec} will return
     * {@link VideoCodec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecAsString}.
     * </p>
     * 
     * @return Specifies the video codec. This must be equal to one of the enum values defined by the object VideoCodec.
     * @see VideoCodec
     */
    public VideoCodec codec() {
        return VideoCodec.fromValue(codec);
    }

    /**
     * Specifies the video codec. This must be equal to one of the enum values defined by the object VideoCodec.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codec} will return
     * {@link VideoCodec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecAsString}.
     * </p>
     * 
     * @return Specifies the video codec. This must be equal to one of the enum values defined by the object VideoCodec.
     * @see VideoCodec
     */
    public String codecAsString() {
        return codec;
    }

    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.
     * 
     * @return Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.
     */
    public FrameCaptureSettings frameCaptureSettings() {
        return frameCaptureSettings;
    }

    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
     * 
     * @return Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
     */
    public H264Settings h264Settings() {
        return h264Settings;
    }

    /**
     * Settings for H265 codec
     * 
     * @return Settings for H265 codec
     */
    public H265Settings h265Settings() {
        return h265Settings;
    }

    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
     * 
     * @return Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
     */
    public Mpeg2Settings mpeg2Settings() {
        return mpeg2Settings;
    }

    /**
     * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.
     * 
     * @return Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.
     */
    public ProresSettings proresSettings() {
        return proresSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(frameCaptureSettings());
        hashCode = 31 * hashCode + Objects.hashCode(h264Settings());
        hashCode = 31 * hashCode + Objects.hashCode(h265Settings());
        hashCode = 31 * hashCode + Objects.hashCode(mpeg2Settings());
        hashCode = 31 * hashCode + Objects.hashCode(proresSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoCodecSettings)) {
            return false;
        }
        VideoCodecSettings other = (VideoCodecSettings) obj;
        return Objects.equals(codecAsString(), other.codecAsString())
                && Objects.equals(frameCaptureSettings(), other.frameCaptureSettings())
                && Objects.equals(h264Settings(), other.h264Settings()) && Objects.equals(h265Settings(), other.h265Settings())
                && Objects.equals(mpeg2Settings(), other.mpeg2Settings())
                && Objects.equals(proresSettings(), other.proresSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VideoCodecSettings").add("Codec", codecAsString())
                .add("FrameCaptureSettings", frameCaptureSettings()).add("H264Settings", h264Settings())
                .add("H265Settings", h265Settings()).add("Mpeg2Settings", mpeg2Settings())
                .add("ProresSettings", proresSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Codec":
            return Optional.ofNullable(clazz.cast(codecAsString()));
        case "FrameCaptureSettings":
            return Optional.ofNullable(clazz.cast(frameCaptureSettings()));
        case "H264Settings":
            return Optional.ofNullable(clazz.cast(h264Settings()));
        case "H265Settings":
            return Optional.ofNullable(clazz.cast(h265Settings()));
        case "Mpeg2Settings":
            return Optional.ofNullable(clazz.cast(mpeg2Settings()));
        case "ProresSettings":
            return Optional.ofNullable(clazz.cast(proresSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoCodecSettings, T> g) {
        return obj -> g.apply((VideoCodecSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoCodecSettings> {
        /**
         * Specifies the video codec. This must be equal to one of the enum values defined by the object VideoCodec.
         * 
         * @param codec
         *        Specifies the video codec. This must be equal to one of the enum values defined by the object
         *        VideoCodec.
         * @see VideoCodec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoCodec
         */
        Builder codec(String codec);

        /**
         * Specifies the video codec. This must be equal to one of the enum values defined by the object VideoCodec.
         * 
         * @param codec
         *        Specifies the video codec. This must be equal to one of the enum values defined by the object
         *        VideoCodec.
         * @see VideoCodec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoCodec
         */
        Builder codec(VideoCodec codec);

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.
         * 
         * @param frameCaptureSettings
         *        Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameCaptureSettings(FrameCaptureSettings frameCaptureSettings);

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE. This is a
         * convenience that creates an instance of the {@link FrameCaptureSettings.Builder} avoiding the need to create
         * one manually via {@link FrameCaptureSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link FrameCaptureSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #frameCaptureSettings(FrameCaptureSettings)}.
         * 
         * @param frameCaptureSettings
         *        a consumer that will call methods on {@link FrameCaptureSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameCaptureSettings(FrameCaptureSettings)
         */
        default Builder frameCaptureSettings(Consumer<FrameCaptureSettings.Builder> frameCaptureSettings) {
            return frameCaptureSettings(FrameCaptureSettings.builder().applyMutation(frameCaptureSettings).build());
        }

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
         * 
         * @param h264Settings
         *        Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder h264Settings(H264Settings h264Settings);

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264. This is a
         * convenience that creates an instance of the {@link H264Settings.Builder} avoiding the need to create one
         * manually via {@link H264Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link H264Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #h264Settings(H264Settings)}.
         * 
         * @param h264Settings
         *        a consumer that will call methods on {@link H264Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #h264Settings(H264Settings)
         */
        default Builder h264Settings(Consumer<H264Settings.Builder> h264Settings) {
            return h264Settings(H264Settings.builder().applyMutation(h264Settings).build());
        }

        /**
         * Settings for H265 codec
         * 
         * @param h265Settings
         *        Settings for H265 codec
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder h265Settings(H265Settings h265Settings);

        /**
         * Settings for H265 codec This is a convenience that creates an instance of the {@link H265Settings.Builder}
         * avoiding the need to create one manually via {@link H265Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link H265Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #h265Settings(H265Settings)}.
         * 
         * @param h265Settings
         *        a consumer that will call methods on {@link H265Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #h265Settings(H265Settings)
         */
        default Builder h265Settings(Consumer<H265Settings.Builder> h265Settings) {
            return h265Settings(H265Settings.builder().applyMutation(h265Settings).build());
        }

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
         * 
         * @param mpeg2Settings
         *        Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mpeg2Settings(Mpeg2Settings mpeg2Settings);

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2. This is a
         * convenience that creates an instance of the {@link Mpeg2Settings.Builder} avoiding the need to create one
         * manually via {@link Mpeg2Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Mpeg2Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #mpeg2Settings(Mpeg2Settings)}.
         * 
         * @param mpeg2Settings
         *        a consumer that will call methods on {@link Mpeg2Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mpeg2Settings(Mpeg2Settings)
         */
        default Builder mpeg2Settings(Consumer<Mpeg2Settings.Builder> mpeg2Settings) {
            return mpeg2Settings(Mpeg2Settings.builder().applyMutation(mpeg2Settings).build());
        }

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.
         * 
         * @param proresSettings
         *        Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proresSettings(ProresSettings proresSettings);

        /**
         * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES. This is a
         * convenience that creates an instance of the {@link ProresSettings.Builder} avoiding the need to create one
         * manually via {@link ProresSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProresSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #proresSettings(ProresSettings)}.
         * 
         * @param proresSettings
         *        a consumer that will call methods on {@link ProresSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proresSettings(ProresSettings)
         */
        default Builder proresSettings(Consumer<ProresSettings.Builder> proresSettings) {
            return proresSettings(ProresSettings.builder().applyMutation(proresSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String codec;

        private FrameCaptureSettings frameCaptureSettings;

        private H264Settings h264Settings;

        private H265Settings h265Settings;

        private Mpeg2Settings mpeg2Settings;

        private ProresSettings proresSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoCodecSettings model) {
            codec(model.codec);
            frameCaptureSettings(model.frameCaptureSettings);
            h264Settings(model.h264Settings);
            h265Settings(model.h265Settings);
            mpeg2Settings(model.mpeg2Settings);
            proresSettings(model.proresSettings);
        }

        public final String getCodecAsString() {
            return codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        public final Builder codec(VideoCodec codec) {
            this.codec(codec == null ? null : codec.toString());
            return this;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        public final FrameCaptureSettings.Builder getFrameCaptureSettings() {
            return frameCaptureSettings != null ? frameCaptureSettings.toBuilder() : null;
        }

        @Override
        public final Builder frameCaptureSettings(FrameCaptureSettings frameCaptureSettings) {
            this.frameCaptureSettings = frameCaptureSettings;
            return this;
        }

        public final void setFrameCaptureSettings(FrameCaptureSettings.BuilderImpl frameCaptureSettings) {
            this.frameCaptureSettings = frameCaptureSettings != null ? frameCaptureSettings.build() : null;
        }

        public final H264Settings.Builder getH264Settings() {
            return h264Settings != null ? h264Settings.toBuilder() : null;
        }

        @Override
        public final Builder h264Settings(H264Settings h264Settings) {
            this.h264Settings = h264Settings;
            return this;
        }

        public final void setH264Settings(H264Settings.BuilderImpl h264Settings) {
            this.h264Settings = h264Settings != null ? h264Settings.build() : null;
        }

        public final H265Settings.Builder getH265Settings() {
            return h265Settings != null ? h265Settings.toBuilder() : null;
        }

        @Override
        public final Builder h265Settings(H265Settings h265Settings) {
            this.h265Settings = h265Settings;
            return this;
        }

        public final void setH265Settings(H265Settings.BuilderImpl h265Settings) {
            this.h265Settings = h265Settings != null ? h265Settings.build() : null;
        }

        public final Mpeg2Settings.Builder getMpeg2Settings() {
            return mpeg2Settings != null ? mpeg2Settings.toBuilder() : null;
        }

        @Override
        public final Builder mpeg2Settings(Mpeg2Settings mpeg2Settings) {
            this.mpeg2Settings = mpeg2Settings;
            return this;
        }

        public final void setMpeg2Settings(Mpeg2Settings.BuilderImpl mpeg2Settings) {
            this.mpeg2Settings = mpeg2Settings != null ? mpeg2Settings.build() : null;
        }

        public final ProresSettings.Builder getProresSettings() {
            return proresSettings != null ? proresSettings.toBuilder() : null;
        }

        @Override
        public final Builder proresSettings(ProresSettings proresSettings) {
            this.proresSettings = proresSettings;
            return this;
        }

        public final void setProresSettings(ProresSettings.BuilderImpl proresSettings) {
            this.proresSettings = proresSettings != null ? proresSettings.build() : null;
        }

        @Override
        public VideoCodecSettings build() {
            return new VideoCodecSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
