/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * These settings control how the service handles timecodes throughout the job. These settings don't affect input
 * clipping.
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimecodeConfig implements SdkPojo, Serializable, ToCopyableBuilder<TimecodeConfig.Builder, TimecodeConfig> {
    private static final SdkField<String> ANCHOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TimecodeConfig::anchor)).setter(setter(Builder::anchor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anchor").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TimecodeConfig::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TimecodeConfig::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final SdkField<String> TIMESTAMP_OFFSET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TimecodeConfig::timestampOffset)).setter(setter(Builder::timestampOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampOffset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANCHOR_FIELD, SOURCE_FIELD,
            START_FIELD, TIMESTAMP_OFFSET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String anchor;

    private final String source;

    private final String start;

    private final String timestampOffset;

    private TimecodeConfig(BuilderImpl builder) {
        this.anchor = builder.anchor;
        this.source = builder.source;
        this.start = builder.start;
        this.timestampOffset = builder.timestampOffset;
    }

    /**
     * If you use an editing platform that relies on an anchor timecode, use Anchor Timecode (Anchor) to specify a
     * timecode that will match the input video frame to the output video frame. Use 24-hour format with frame number,
     * (HH:MM:SS:FF) or (HH:MM:SS;FF). This setting ignores frame rate conversion. System behavior for Anchor Timecode
     * varies depending on your setting for Source (TimecodeSource). * If Source (TimecodeSource) is set to Specified
     * Start (SPECIFIEDSTART), the first input frame is the specified value in Start Timecode (Start). Anchor Timecode
     * (Anchor) and Start Timecode (Start) are used calculate output timecode. * If Source (TimecodeSource) is set to
     * Start at 0 (ZEROBASED) the first frame is 00:00:00:00. * If Source (TimecodeSource) is set to Embedded
     * (EMBEDDED), the first frame is the timecode value on the first input frame of the input.
     * 
     * @return If you use an editing platform that relies on an anchor timecode, use Anchor Timecode (Anchor) to specify
     *         a timecode that will match the input video frame to the output video frame. Use 24-hour format with frame
     *         number, (HH:MM:SS:FF) or (HH:MM:SS;FF). This setting ignores frame rate conversion. System behavior for
     *         Anchor Timecode varies depending on your setting for Source (TimecodeSource). * If Source
     *         (TimecodeSource) is set to Specified Start (SPECIFIEDSTART), the first input frame is the specified value
     *         in Start Timecode (Start). Anchor Timecode (Anchor) and Start Timecode (Start) are used calculate output
     *         timecode. * If Source (TimecodeSource) is set to Start at 0 (ZEROBASED) the first frame is 00:00:00:00. *
     *         If Source (TimecodeSource) is set to Embedded (EMBEDDED), the first frame is the timecode value on the
     *         first input frame of the input.
     */
    public String anchor() {
        return anchor;
    }

    /**
     * Use Source (TimecodeSource) to set how timecodes are handled within this job. To make sure that your video,
     * audio, captions, and markers are synchronized and that time-based features, such as image inserter, work
     * correctly, choose the Timecode source option that matches your assets. All timecodes are in a 24-hour format with
     * frame number (HH:MM:SS:FF). * Embedded (EMBEDDED) - Use the timecode that is in the input video. If no embedded
     * timecode is in the source, the service will use Start at 0 (ZEROBASED) instead. * Start at 0 (ZEROBASED) - Set
     * the timecode of the initial frame to 00:00:00:00. * Specified Start (SPECIFIEDSTART) - Set the timecode of the
     * initial frame to a value other than zero. You use Start timecode (Start) to provide this value.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link TimecodeSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return Use Source (TimecodeSource) to set how timecodes are handled within this job. To make sure that your
     *         video, audio, captions, and markers are synchronized and that time-based features, such as image
     *         inserter, work correctly, choose the Timecode source option that matches your assets. All timecodes are
     *         in a 24-hour format with frame number (HH:MM:SS:FF). * Embedded (EMBEDDED) - Use the timecode that is in
     *         the input video. If no embedded timecode is in the source, the service will use Start at 0 (ZEROBASED)
     *         instead. * Start at 0 (ZEROBASED) - Set the timecode of the initial frame to 00:00:00:00. * Specified
     *         Start (SPECIFIEDSTART) - Set the timecode of the initial frame to a value other than zero. You use Start
     *         timecode (Start) to provide this value.
     * @see TimecodeSource
     */
    public TimecodeSource source() {
        return TimecodeSource.fromValue(source);
    }

    /**
     * Use Source (TimecodeSource) to set how timecodes are handled within this job. To make sure that your video,
     * audio, captions, and markers are synchronized and that time-based features, such as image inserter, work
     * correctly, choose the Timecode source option that matches your assets. All timecodes are in a 24-hour format with
     * frame number (HH:MM:SS:FF). * Embedded (EMBEDDED) - Use the timecode that is in the input video. If no embedded
     * timecode is in the source, the service will use Start at 0 (ZEROBASED) instead. * Start at 0 (ZEROBASED) - Set
     * the timecode of the initial frame to 00:00:00:00. * Specified Start (SPECIFIEDSTART) - Set the timecode of the
     * initial frame to a value other than zero. You use Start timecode (Start) to provide this value.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link TimecodeSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return Use Source (TimecodeSource) to set how timecodes are handled within this job. To make sure that your
     *         video, audio, captions, and markers are synchronized and that time-based features, such as image
     *         inserter, work correctly, choose the Timecode source option that matches your assets. All timecodes are
     *         in a 24-hour format with frame number (HH:MM:SS:FF). * Embedded (EMBEDDED) - Use the timecode that is in
     *         the input video. If no embedded timecode is in the source, the service will use Start at 0 (ZEROBASED)
     *         instead. * Start at 0 (ZEROBASED) - Set the timecode of the initial frame to 00:00:00:00. * Specified
     *         Start (SPECIFIEDSTART) - Set the timecode of the initial frame to a value other than zero. You use Start
     *         timecode (Start) to provide this value.
     * @see TimecodeSource
     */
    public String sourceAsString() {
        return source;
    }

    /**
     * Only use when you set Source (TimecodeSource) to Specified start (SPECIFIEDSTART). Use Start timecode (Start) to
     * specify the timecode for the initial frame. Use 24-hour format with frame number, (HH:MM:SS:FF) or (HH:MM:SS;FF).
     * 
     * @return Only use when you set Source (TimecodeSource) to Specified start (SPECIFIEDSTART). Use Start timecode
     *         (Start) to specify the timecode for the initial frame. Use 24-hour format with frame number,
     *         (HH:MM:SS:FF) or (HH:MM:SS;FF).
     */
    public String start() {
        return start;
    }

    /**
     * Only applies to outputs that support program-date-time stamp. Use Timestamp offset (TimestampOffset) to overwrite
     * the timecode date without affecting the time and frame number. Provide the new date as a string in the format
     * "yyyy-mm-dd". To use Time stamp offset, you must also enable Insert program-date-time (InsertProgramDateTime) in
     * the output settings. For example, if the date part of your timecodes is 2002-1-25 and you want to change it to
     * one year later, set Timestamp offset (TimestampOffset) to 2003-1-25.
     * 
     * @return Only applies to outputs that support program-date-time stamp. Use Timestamp offset (TimestampOffset) to
     *         overwrite the timecode date without affecting the time and frame number. Provide the new date as a string
     *         in the format "yyyy-mm-dd". To use Time stamp offset, you must also enable Insert program-date-time
     *         (InsertProgramDateTime) in the output settings. For example, if the date part of your timecodes is
     *         2002-1-25 and you want to change it to one year later, set Timestamp offset (TimestampOffset) to
     *         2003-1-25.
     */
    public String timestampOffset() {
        return timestampOffset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(anchor());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(timestampOffset());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimecodeConfig)) {
            return false;
        }
        TimecodeConfig other = (TimecodeConfig) obj;
        return Objects.equals(anchor(), other.anchor()) && Objects.equals(sourceAsString(), other.sourceAsString())
                && Objects.equals(start(), other.start()) && Objects.equals(timestampOffset(), other.timestampOffset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TimecodeConfig").add("Anchor", anchor()).add("Source", sourceAsString()).add("Start", start())
                .add("TimestampOffset", timestampOffset()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Anchor":
            return Optional.ofNullable(clazz.cast(anchor()));
        case "Source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "TimestampOffset":
            return Optional.ofNullable(clazz.cast(timestampOffset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimecodeConfig, T> g) {
        return obj -> g.apply((TimecodeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimecodeConfig> {
        /**
         * If you use an editing platform that relies on an anchor timecode, use Anchor Timecode (Anchor) to specify a
         * timecode that will match the input video frame to the output video frame. Use 24-hour format with frame
         * number, (HH:MM:SS:FF) or (HH:MM:SS;FF). This setting ignores frame rate conversion. System behavior for
         * Anchor Timecode varies depending on your setting for Source (TimecodeSource). * If Source (TimecodeSource) is
         * set to Specified Start (SPECIFIEDSTART), the first input frame is the specified value in Start Timecode
         * (Start). Anchor Timecode (Anchor) and Start Timecode (Start) are used calculate output timecode. * If Source
         * (TimecodeSource) is set to Start at 0 (ZEROBASED) the first frame is 00:00:00:00. * If Source
         * (TimecodeSource) is set to Embedded (EMBEDDED), the first frame is the timecode value on the first input
         * frame of the input.
         * 
         * @param anchor
         *        If you use an editing platform that relies on an anchor timecode, use Anchor Timecode (Anchor) to
         *        specify a timecode that will match the input video frame to the output video frame. Use 24-hour format
         *        with frame number, (HH:MM:SS:FF) or (HH:MM:SS;FF). This setting ignores frame rate conversion. System
         *        behavior for Anchor Timecode varies depending on your setting for Source (TimecodeSource). * If Source
         *        (TimecodeSource) is set to Specified Start (SPECIFIEDSTART), the first input frame is the specified
         *        value in Start Timecode (Start). Anchor Timecode (Anchor) and Start Timecode (Start) are used
         *        calculate output timecode. * If Source (TimecodeSource) is set to Start at 0 (ZEROBASED) the first
         *        frame is 00:00:00:00. * If Source (TimecodeSource) is set to Embedded (EMBEDDED), the first frame is
         *        the timecode value on the first input frame of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anchor(String anchor);

        /**
         * Use Source (TimecodeSource) to set how timecodes are handled within this job. To make sure that your video,
         * audio, captions, and markers are synchronized and that time-based features, such as image inserter, work
         * correctly, choose the Timecode source option that matches your assets. All timecodes are in a 24-hour format
         * with frame number (HH:MM:SS:FF). * Embedded (EMBEDDED) - Use the timecode that is in the input video. If no
         * embedded timecode is in the source, the service will use Start at 0 (ZEROBASED) instead. * Start at 0
         * (ZEROBASED) - Set the timecode of the initial frame to 00:00:00:00. * Specified Start (SPECIFIEDSTART) - Set
         * the timecode of the initial frame to a value other than zero. You use Start timecode (Start) to provide this
         * value.
         * 
         * @param source
         *        Use Source (TimecodeSource) to set how timecodes are handled within this job. To make sure that your
         *        video, audio, captions, and markers are synchronized and that time-based features, such as image
         *        inserter, work correctly, choose the Timecode source option that matches your assets. All timecodes
         *        are in a 24-hour format with frame number (HH:MM:SS:FF). * Embedded (EMBEDDED) - Use the timecode that
         *        is in the input video. If no embedded timecode is in the source, the service will use Start at 0
         *        (ZEROBASED) instead. * Start at 0 (ZEROBASED) - Set the timecode of the initial frame to 00:00:00:00.
         *        * Specified Start (SPECIFIEDSTART) - Set the timecode of the initial frame to a value other than zero.
         *        You use Start timecode (Start) to provide this value.
         * @see TimecodeSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimecodeSource
         */
        Builder source(String source);

        /**
         * Use Source (TimecodeSource) to set how timecodes are handled within this job. To make sure that your video,
         * audio, captions, and markers are synchronized and that time-based features, such as image inserter, work
         * correctly, choose the Timecode source option that matches your assets. All timecodes are in a 24-hour format
         * with frame number (HH:MM:SS:FF). * Embedded (EMBEDDED) - Use the timecode that is in the input video. If no
         * embedded timecode is in the source, the service will use Start at 0 (ZEROBASED) instead. * Start at 0
         * (ZEROBASED) - Set the timecode of the initial frame to 00:00:00:00. * Specified Start (SPECIFIEDSTART) - Set
         * the timecode of the initial frame to a value other than zero. You use Start timecode (Start) to provide this
         * value.
         * 
         * @param source
         *        Use Source (TimecodeSource) to set how timecodes are handled within this job. To make sure that your
         *        video, audio, captions, and markers are synchronized and that time-based features, such as image
         *        inserter, work correctly, choose the Timecode source option that matches your assets. All timecodes
         *        are in a 24-hour format with frame number (HH:MM:SS:FF). * Embedded (EMBEDDED) - Use the timecode that
         *        is in the input video. If no embedded timecode is in the source, the service will use Start at 0
         *        (ZEROBASED) instead. * Start at 0 (ZEROBASED) - Set the timecode of the initial frame to 00:00:00:00.
         *        * Specified Start (SPECIFIEDSTART) - Set the timecode of the initial frame to a value other than zero.
         *        You use Start timecode (Start) to provide this value.
         * @see TimecodeSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimecodeSource
         */
        Builder source(TimecodeSource source);

        /**
         * Only use when you set Source (TimecodeSource) to Specified start (SPECIFIEDSTART). Use Start timecode (Start)
         * to specify the timecode for the initial frame. Use 24-hour format with frame number, (HH:MM:SS:FF) or
         * (HH:MM:SS;FF).
         * 
         * @param start
         *        Only use when you set Source (TimecodeSource) to Specified start (SPECIFIEDSTART). Use Start timecode
         *        (Start) to specify the timecode for the initial frame. Use 24-hour format with frame number,
         *        (HH:MM:SS:FF) or (HH:MM:SS;FF).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(String start);

        /**
         * Only applies to outputs that support program-date-time stamp. Use Timestamp offset (TimestampOffset) to
         * overwrite the timecode date without affecting the time and frame number. Provide the new date as a string in
         * the format "yyyy-mm-dd". To use Time stamp offset, you must also enable Insert program-date-time
         * (InsertProgramDateTime) in the output settings. For example, if the date part of your timecodes is 2002-1-25
         * and you want to change it to one year later, set Timestamp offset (TimestampOffset) to 2003-1-25.
         * 
         * @param timestampOffset
         *        Only applies to outputs that support program-date-time stamp. Use Timestamp offset (TimestampOffset)
         *        to overwrite the timecode date without affecting the time and frame number. Provide the new date as a
         *        string in the format "yyyy-mm-dd". To use Time stamp offset, you must also enable Insert
         *        program-date-time (InsertProgramDateTime) in the output settings. For example, if the date part of
         *        your timecodes is 2002-1-25 and you want to change it to one year later, set Timestamp offset
         *        (TimestampOffset) to 2003-1-25.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampOffset(String timestampOffset);
    }

    static final class BuilderImpl implements Builder {
        private String anchor;

        private String source;

        private String start;

        private String timestampOffset;

        private BuilderImpl() {
        }

        private BuilderImpl(TimecodeConfig model) {
            anchor(model.anchor);
            source(model.source);
            start(model.start);
            timestampOffset(model.timestampOffset);
        }

        public final String getAnchor() {
            return anchor;
        }

        @Override
        public final Builder anchor(String anchor) {
            this.anchor = anchor;
            return this;
        }

        public final void setAnchor(String anchor) {
            this.anchor = anchor;
        }

        public final String getSourceAsString() {
            return source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(TimecodeSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getStart() {
            return start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        public final String getTimestampOffset() {
            return timestampOffset;
        }

        @Override
        public final Builder timestampOffset(String timestampOffset) {
            this.timestampOffset = timestampOffset;
            return this;
        }

        public final void setTimestampOffset(String timestampOffset) {
            this.timestampOffset = timestampOffset;
        }

        @Override
        public TimecodeConfig build() {
            return new TimecodeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
