/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set (Type) under (OutputGroups)>(OutputGroupSettings) to MS_SMOOTH_GROUP_SETTINGS.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MsSmoothGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MsSmoothGroupSettings.Builder, MsSmoothGroupSettings> {
    private static final SdkField<List<MsSmoothAdditionalManifest>> ADDITIONAL_MANIFESTS_FIELD = SdkField
            .<List<MsSmoothAdditionalManifest>> builder(MarshallingType.LIST)
            .getter(getter(MsSmoothGroupSettings::additionalManifests))
            .setter(setter(Builder::additionalManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MsSmoothAdditionalManifest> builder(MarshallingType.SDK_POJO)
                                            .constructor(MsSmoothAdditionalManifest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUDIO_DEDUPLICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MsSmoothGroupSettings::audioDeduplicationAsString)).setter(setter(Builder::audioDeduplication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDeduplication").build())
            .build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MsSmoothGroupSettings::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<DestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField
            .<DestinationSettings> builder(MarshallingType.SDK_POJO).getter(getter(MsSmoothGroupSettings::destinationSettings))
            .setter(setter(Builder::destinationSettings)).constructor(DestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build())
            .build();

    private static final SdkField<MsSmoothEncryptionSettings> ENCRYPTION_FIELD = SdkField
            .<MsSmoothEncryptionSettings> builder(MarshallingType.SDK_POJO).getter(getter(MsSmoothGroupSettings::encryption))
            .setter(setter(Builder::encryption)).constructor(MsSmoothEncryptionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<Integer> FRAGMENT_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(MsSmoothGroupSettings::fragmentLength)).setter(setter(Builder::fragmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fragmentLength").build()).build();

    private static final SdkField<String> MANIFEST_ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MsSmoothGroupSettings::manifestEncodingAsString)).setter(setter(Builder::manifestEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestEncoding").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_MANIFESTS_FIELD,
            AUDIO_DEDUPLICATION_FIELD, DESTINATION_FIELD, DESTINATION_SETTINGS_FIELD, ENCRYPTION_FIELD, FRAGMENT_LENGTH_FIELD,
            MANIFEST_ENCODING_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<MsSmoothAdditionalManifest> additionalManifests;

    private final String audioDeduplication;

    private final String destination;

    private final DestinationSettings destinationSettings;

    private final MsSmoothEncryptionSettings encryption;

    private final Integer fragmentLength;

    private final String manifestEncoding;

    private MsSmoothGroupSettings(BuilderImpl builder) {
        this.additionalManifests = builder.additionalManifests;
        this.audioDeduplication = builder.audioDeduplication;
        this.destination = builder.destination;
        this.destinationSettings = builder.destinationSettings;
        this.encryption = builder.encryption;
        this.fragmentLength = builder.fragmentLength;
        this.manifestEncoding = builder.manifestEncoding;
    }

    /**
     * Returns true if the AdditionalManifests property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAdditionalManifests() {
        return additionalManifests != null && !(additionalManifests instanceof SdkAutoConstructList);
    }

    /**
     * By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth Streaming
     * output group in your job. This default manifest references every output in the output group. To create additional
     * manifests that reference a subset of the outputs in the output group, specify a list of them here.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalManifests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth
     *         Streaming output group in your job. This default manifest references every output in the output group. To
     *         create additional manifests that reference a subset of the outputs in the output group, specify a list of
     *         them here.
     */
    public List<MsSmoothAdditionalManifest> additionalManifests() {
        return additionalManifests;
    }

    /**
     * COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output group into
     * a single audio stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #audioDeduplication} will return {@link MsSmoothAudioDeduplication#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #audioDeduplicationAsString}.
     * </p>
     * 
     * @return COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output
     *         group into a single audio stream.
     * @see MsSmoothAudioDeduplication
     */
    public MsSmoothAudioDeduplication audioDeduplication() {
        return MsSmoothAudioDeduplication.fromValue(audioDeduplication);
    }

    /**
     * COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output group into
     * a single audio stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #audioDeduplication} will return {@link MsSmoothAudioDeduplication#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #audioDeduplicationAsString}.
     * </p>
     * 
     * @return COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output
     *         group into a single audio stream.
     * @see MsSmoothAudioDeduplication
     */
    public String audioDeduplicationAsString() {
        return audioDeduplication;
    }

    /**
     * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts
     * format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the
     * input file. If your job has multiple inputs, the service uses the filename of the first input file.
     * 
     * @return Use Destination (Destination) to specify the S3 output location and the output filename base. Destination
     *         accepts format identifiers. If you do not specify the base filename in the URI, the service will use the
     *         filename of the input file. If your job has multiple inputs, the service uses the filename of the first
     *         input file.
     */
    public String destination() {
        return destination;
    }

    /**
     * Settings associated with the destination. Will vary based on the type of destination
     * 
     * @return Settings associated with the destination. Will vary based on the type of destination
     */
    public DestinationSettings destinationSettings() {
        return destinationSettings;
    }

    /**
     * If you are using DRM, set DRM System (MsSmoothEncryptionSettings) to specify the value SpekeKeyProvider.
     * 
     * @return If you are using DRM, set DRM System (MsSmoothEncryptionSettings) to specify the value SpekeKeyProvider.
     */
    public MsSmoothEncryptionSettings encryption() {
        return encryption;
    }

    /**
     * Use Fragment length (FragmentLength) to specify the mp4 fragment sizes in seconds. Fragment length must be
     * compatible with GOP size and frame rate.
     * 
     * @return Use Fragment length (FragmentLength) to specify the mp4 fragment sizes in seconds. Fragment length must
     *         be compatible with GOP size and frame rate.
     */
    public Integer fragmentLength() {
        return fragmentLength;
    }

    /**
     * Use Manifest encoding (MsSmoothManifestEncoding) to specify the encoding format for the server and client
     * manifest. Valid options are utf8 and utf16.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #manifestEncoding}
     * will return {@link MsSmoothManifestEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #manifestEncodingAsString}.
     * </p>
     * 
     * @return Use Manifest encoding (MsSmoothManifestEncoding) to specify the encoding format for the server and client
     *         manifest. Valid options are utf8 and utf16.
     * @see MsSmoothManifestEncoding
     */
    public MsSmoothManifestEncoding manifestEncoding() {
        return MsSmoothManifestEncoding.fromValue(manifestEncoding);
    }

    /**
     * Use Manifest encoding (MsSmoothManifestEncoding) to specify the encoding format for the server and client
     * manifest. Valid options are utf8 and utf16.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #manifestEncoding}
     * will return {@link MsSmoothManifestEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #manifestEncodingAsString}.
     * </p>
     * 
     * @return Use Manifest encoding (MsSmoothManifestEncoding) to specify the encoding format for the server and client
     *         manifest. Valid options are utf8 and utf16.
     * @see MsSmoothManifestEncoding
     */
    public String manifestEncodingAsString() {
        return manifestEncoding;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(additionalManifests());
        hashCode = 31 * hashCode + Objects.hashCode(audioDeduplicationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(manifestEncodingAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MsSmoothGroupSettings)) {
            return false;
        }
        MsSmoothGroupSettings other = (MsSmoothGroupSettings) obj;
        return Objects.equals(additionalManifests(), other.additionalManifests())
                && Objects.equals(audioDeduplicationAsString(), other.audioDeduplicationAsString())
                && Objects.equals(destination(), other.destination())
                && Objects.equals(destinationSettings(), other.destinationSettings())
                && Objects.equals(encryption(), other.encryption()) && Objects.equals(fragmentLength(), other.fragmentLength())
                && Objects.equals(manifestEncodingAsString(), other.manifestEncodingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MsSmoothGroupSettings").add("AdditionalManifests", additionalManifests())
                .add("AudioDeduplication", audioDeduplicationAsString()).add("Destination", destination())
                .add("DestinationSettings", destinationSettings()).add("Encryption", encryption())
                .add("FragmentLength", fragmentLength()).add("ManifestEncoding", manifestEncodingAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalManifests":
            return Optional.ofNullable(clazz.cast(additionalManifests()));
        case "AudioDeduplication":
            return Optional.ofNullable(clazz.cast(audioDeduplicationAsString()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "DestinationSettings":
            return Optional.ofNullable(clazz.cast(destinationSettings()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "FragmentLength":
            return Optional.ofNullable(clazz.cast(fragmentLength()));
        case "ManifestEncoding":
            return Optional.ofNullable(clazz.cast(manifestEncodingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MsSmoothGroupSettings, T> g) {
        return obj -> g.apply((MsSmoothGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MsSmoothGroupSettings> {
        /**
         * By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth
         * Streaming output group in your job. This default manifest references every output in the output group. To
         * create additional manifests that reference a subset of the outputs in the output group, specify a list of
         * them here.
         * 
         * @param additionalManifests
         *        By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth
         *        Streaming output group in your job. This default manifest references every output in the output group.
         *        To create additional manifests that reference a subset of the outputs in the output group, specify a
         *        list of them here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalManifests(Collection<MsSmoothAdditionalManifest> additionalManifests);

        /**
         * By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth
         * Streaming output group in your job. This default manifest references every output in the output group. To
         * create additional manifests that reference a subset of the outputs in the output group, specify a list of
         * them here.
         * 
         * @param additionalManifests
         *        By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth
         *        Streaming output group in your job. This default manifest references every output in the output group.
         *        To create additional manifests that reference a subset of the outputs in the output group, specify a
         *        list of them here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalManifests(MsSmoothAdditionalManifest... additionalManifests);

        /**
         * By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth
         * Streaming output group in your job. This default manifest references every output in the output group. To
         * create additional manifests that reference a subset of the outputs in the output group, specify a list of
         * them here. This is a convenience that creates an instance of the {@link List
         * <MsSmoothAdditionalManifest>.Builder} avoiding the need to create one manually via {@link List
         * <MsSmoothAdditionalManifest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MsSmoothAdditionalManifest>.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalManifests(List<MsSmoothAdditionalManifest>)}.
         * 
         * @param additionalManifests
         *        a consumer that will call methods on {@link List<MsSmoothAdditionalManifest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalManifests(List<MsSmoothAdditionalManifest>)
         */
        Builder additionalManifests(Consumer<MsSmoothAdditionalManifest.Builder>... additionalManifests);

        /**
         * COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output group
         * into a single audio stream.
         * 
         * @param audioDeduplication
         *        COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output
         *        group into a single audio stream.
         * @see MsSmoothAudioDeduplication
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MsSmoothAudioDeduplication
         */
        Builder audioDeduplication(String audioDeduplication);

        /**
         * COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output group
         * into a single audio stream.
         * 
         * @param audioDeduplication
         *        COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output
         *        group into a single audio stream.
         * @see MsSmoothAudioDeduplication
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MsSmoothAudioDeduplication
         */
        Builder audioDeduplication(MsSmoothAudioDeduplication audioDeduplication);

        /**
         * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination
         * accepts format identifiers. If you do not specify the base filename in the URI, the service will use the
         * filename of the input file. If your job has multiple inputs, the service uses the filename of the first input
         * file.
         * 
         * @param destination
         *        Use Destination (Destination) to specify the S3 output location and the output filename base.
         *        Destination accepts format identifiers. If you do not specify the base filename in the URI, the
         *        service will use the filename of the input file. If your job has multiple inputs, the service uses the
         *        filename of the first input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * Settings associated with the destination. Will vary based on the type of destination
         * 
         * @param destinationSettings
         *        Settings associated with the destination. Will vary based on the type of destination
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSettings(DestinationSettings destinationSettings);

        /**
         * Settings associated with the destination. Will vary based on the type of destination This is a convenience
         * that creates an instance of the {@link DestinationSettings.Builder} avoiding the need to create one manually
         * via {@link DestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #destinationSettings(DestinationSettings)}.
         * 
         * @param destinationSettings
         *        a consumer that will call methods on {@link DestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSettings(DestinationSettings)
         */
        default Builder destinationSettings(Consumer<DestinationSettings.Builder> destinationSettings) {
            return destinationSettings(DestinationSettings.builder().applyMutation(destinationSettings).build());
        }

        /**
         * If you are using DRM, set DRM System (MsSmoothEncryptionSettings) to specify the value SpekeKeyProvider.
         * 
         * @param encryption
         *        If you are using DRM, set DRM System (MsSmoothEncryptionSettings) to specify the value
         *        SpekeKeyProvider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(MsSmoothEncryptionSettings encryption);

        /**
         * If you are using DRM, set DRM System (MsSmoothEncryptionSettings) to specify the value SpekeKeyProvider. This
         * is a convenience that creates an instance of the {@link MsSmoothEncryptionSettings.Builder} avoiding the need
         * to create one manually via {@link MsSmoothEncryptionSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MsSmoothEncryptionSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #encryption(MsSmoothEncryptionSettings)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link MsSmoothEncryptionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(MsSmoothEncryptionSettings)
         */
        default Builder encryption(Consumer<MsSmoothEncryptionSettings.Builder> encryption) {
            return encryption(MsSmoothEncryptionSettings.builder().applyMutation(encryption).build());
        }

        /**
         * Use Fragment length (FragmentLength) to specify the mp4 fragment sizes in seconds. Fragment length must be
         * compatible with GOP size and frame rate.
         * 
         * @param fragmentLength
         *        Use Fragment length (FragmentLength) to specify the mp4 fragment sizes in seconds. Fragment length
         *        must be compatible with GOP size and frame rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentLength(Integer fragmentLength);

        /**
         * Use Manifest encoding (MsSmoothManifestEncoding) to specify the encoding format for the server and client
         * manifest. Valid options are utf8 and utf16.
         * 
         * @param manifestEncoding
         *        Use Manifest encoding (MsSmoothManifestEncoding) to specify the encoding format for the server and
         *        client manifest. Valid options are utf8 and utf16.
         * @see MsSmoothManifestEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MsSmoothManifestEncoding
         */
        Builder manifestEncoding(String manifestEncoding);

        /**
         * Use Manifest encoding (MsSmoothManifestEncoding) to specify the encoding format for the server and client
         * manifest. Valid options are utf8 and utf16.
         * 
         * @param manifestEncoding
         *        Use Manifest encoding (MsSmoothManifestEncoding) to specify the encoding format for the server and
         *        client manifest. Valid options are utf8 and utf16.
         * @see MsSmoothManifestEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MsSmoothManifestEncoding
         */
        Builder manifestEncoding(MsSmoothManifestEncoding manifestEncoding);
    }

    static final class BuilderImpl implements Builder {
        private List<MsSmoothAdditionalManifest> additionalManifests = DefaultSdkAutoConstructList.getInstance();

        private String audioDeduplication;

        private String destination;

        private DestinationSettings destinationSettings;

        private MsSmoothEncryptionSettings encryption;

        private Integer fragmentLength;

        private String manifestEncoding;

        private BuilderImpl() {
        }

        private BuilderImpl(MsSmoothGroupSettings model) {
            additionalManifests(model.additionalManifests);
            audioDeduplication(model.audioDeduplication);
            destination(model.destination);
            destinationSettings(model.destinationSettings);
            encryption(model.encryption);
            fragmentLength(model.fragmentLength);
            manifestEncoding(model.manifestEncoding);
        }

        public final Collection<MsSmoothAdditionalManifest.Builder> getAdditionalManifests() {
            return additionalManifests != null ? additionalManifests.stream().map(MsSmoothAdditionalManifest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalManifests(Collection<MsSmoothAdditionalManifest> additionalManifests) {
            this.additionalManifests = ___listOfMsSmoothAdditionalManifestCopier.copy(additionalManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(MsSmoothAdditionalManifest... additionalManifests) {
            additionalManifests(Arrays.asList(additionalManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(Consumer<MsSmoothAdditionalManifest.Builder>... additionalManifests) {
            additionalManifests(Stream.of(additionalManifests)
                    .map(c -> MsSmoothAdditionalManifest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalManifests(Collection<MsSmoothAdditionalManifest.BuilderImpl> additionalManifests) {
            this.additionalManifests = ___listOfMsSmoothAdditionalManifestCopier.copyFromBuilder(additionalManifests);
        }

        public final String getAudioDeduplicationAsString() {
            return audioDeduplication;
        }

        @Override
        public final Builder audioDeduplication(String audioDeduplication) {
            this.audioDeduplication = audioDeduplication;
            return this;
        }

        @Override
        public final Builder audioDeduplication(MsSmoothAudioDeduplication audioDeduplication) {
            this.audioDeduplication(audioDeduplication == null ? null : audioDeduplication.toString());
            return this;
        }

        public final void setAudioDeduplication(String audioDeduplication) {
            this.audioDeduplication = audioDeduplication;
        }

        public final String getDestination() {
            return destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final DestinationSettings.Builder getDestinationSettings() {
            return destinationSettings != null ? destinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder destinationSettings(DestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final void setDestinationSettings(DestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        public final MsSmoothEncryptionSettings.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(MsSmoothEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(MsSmoothEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getFragmentLength() {
            return fragmentLength;
        }

        @Override
        public final Builder fragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
            return this;
        }

        public final void setFragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
        }

        public final String getManifestEncodingAsString() {
            return manifestEncoding;
        }

        @Override
        public final Builder manifestEncoding(String manifestEncoding) {
            this.manifestEncoding = manifestEncoding;
            return this;
        }

        @Override
        public final Builder manifestEncoding(MsSmoothManifestEncoding manifestEncoding) {
            this.manifestEncoding(manifestEncoding == null ? null : manifestEncoding.toString());
            return this;
        }

        public final void setManifestEncoding(String manifestEncoding) {
            this.manifestEncoding = manifestEncoding;
        }

        @Override
        public MsSmoothGroupSettings build() {
            return new MsSmoothGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
