/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set Codec, under AudioDescriptions>CodecSettings, to the value MP3.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Mp3Settings implements SdkPojo, Serializable, ToCopyableBuilder<Mp3Settings.Builder, Mp3Settings> {
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Mp3Settings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<Integer> CHANNELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Mp3Settings::channels)).setter(setter(Builder::channels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build()).build();

    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mp3Settings::rateControlModeAsString)).setter(setter(Builder::rateControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()).build();

    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Mp3Settings::sampleRate)).setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()).build();

    private static final SdkField<Integer> VBR_QUALITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Mp3Settings::vbrQuality)).setter(setter(Builder::vbrQuality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vbrQuality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD, CHANNELS_FIELD,
            RATE_CONTROL_MODE_FIELD, SAMPLE_RATE_FIELD, VBR_QUALITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer bitrate;

    private final Integer channels;

    private final String rateControlMode;

    private final Integer sampleRate;

    private final Integer vbrQuality;

    private Mp3Settings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.channels = builder.channels;
        this.rateControlMode = builder.rateControlMode;
        this.sampleRate = builder.sampleRate;
        this.vbrQuality = builder.vbrQuality;
    }

    /**
     * Specify the average bitrate in bits per second.
     * 
     * @return Specify the average bitrate in bits per second.
     */
    public Integer bitrate() {
        return bitrate;
    }

    /**
     * Specify the number of channels in this output audio track. Choosing Mono on the console gives you 1 output
     * channel; choosing Stereo gives you 2. In the API, valid values are 1 and 2.
     * 
     * @return Specify the number of channels in this output audio track. Choosing Mono on the console gives you 1
     *         output channel; choosing Stereo gives you 2. In the API, valid values are 1 and 2.
     */
    public Integer channels() {
        return channels;
    }

    /**
     * Specify whether the service encodes this MP3 audio output with a constant bitrate (CBR) or a variable bitrate
     * (VBR).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link Mp3RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Specify whether the service encodes this MP3 audio output with a constant bitrate (CBR) or a variable
     *         bitrate (VBR).
     * @see Mp3RateControlMode
     */
    public Mp3RateControlMode rateControlMode() {
        return Mp3RateControlMode.fromValue(rateControlMode);
    }

    /**
     * Specify whether the service encodes this MP3 audio output with a constant bitrate (CBR) or a variable bitrate
     * (VBR).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link Mp3RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Specify whether the service encodes this MP3 audio output with a constant bitrate (CBR) or a variable
     *         bitrate (VBR).
     * @see Mp3RateControlMode
     */
    public String rateControlModeAsString() {
        return rateControlMode;
    }

    /**
     * Sample rate in hz.
     * 
     * @return Sample rate in hz.
     */
    public Integer sampleRate() {
        return sampleRate;
    }

    /**
     * Required when you set Bitrate control mode (rateControlMode) to VBR. Specify the audio quality of this MP3 output
     * from 0 (highest quality) to 9 (lowest quality).
     * 
     * @return Required when you set Bitrate control mode (rateControlMode) to VBR. Specify the audio quality of this
     *         MP3 output from 0 (highest quality) to 9 (lowest quality).
     */
    public Integer vbrQuality() {
        return vbrQuality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(channels());
        hashCode = 31 * hashCode + Objects.hashCode(rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(vbrQuality());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mp3Settings)) {
            return false;
        }
        Mp3Settings other = (Mp3Settings) obj;
        return Objects.equals(bitrate(), other.bitrate()) && Objects.equals(channels(), other.channels())
                && Objects.equals(rateControlModeAsString(), other.rateControlModeAsString())
                && Objects.equals(sampleRate(), other.sampleRate()) && Objects.equals(vbrQuality(), other.vbrQuality());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Mp3Settings").add("Bitrate", bitrate()).add("Channels", channels())
                .add("RateControlMode", rateControlModeAsString()).add("SampleRate", sampleRate())
                .add("VbrQuality", vbrQuality()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "Channels":
            return Optional.ofNullable(clazz.cast(channels()));
        case "RateControlMode":
            return Optional.ofNullable(clazz.cast(rateControlModeAsString()));
        case "SampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        case "VbrQuality":
            return Optional.ofNullable(clazz.cast(vbrQuality()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Mp3Settings, T> g) {
        return obj -> g.apply((Mp3Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Mp3Settings> {
        /**
         * Specify the average bitrate in bits per second.
         * 
         * @param bitrate
         *        Specify the average bitrate in bits per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Integer bitrate);

        /**
         * Specify the number of channels in this output audio track. Choosing Mono on the console gives you 1 output
         * channel; choosing Stereo gives you 2. In the API, valid values are 1 and 2.
         * 
         * @param channels
         *        Specify the number of channels in this output audio track. Choosing Mono on the console gives you 1
         *        output channel; choosing Stereo gives you 2. In the API, valid values are 1 and 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Integer channels);

        /**
         * Specify whether the service encodes this MP3 audio output with a constant bitrate (CBR) or a variable bitrate
         * (VBR).
         * 
         * @param rateControlMode
         *        Specify whether the service encodes this MP3 audio output with a constant bitrate (CBR) or a variable
         *        bitrate (VBR).
         * @see Mp3RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mp3RateControlMode
         */
        Builder rateControlMode(String rateControlMode);

        /**
         * Specify whether the service encodes this MP3 audio output with a constant bitrate (CBR) or a variable bitrate
         * (VBR).
         * 
         * @param rateControlMode
         *        Specify whether the service encodes this MP3 audio output with a constant bitrate (CBR) or a variable
         *        bitrate (VBR).
         * @see Mp3RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mp3RateControlMode
         */
        Builder rateControlMode(Mp3RateControlMode rateControlMode);

        /**
         * Sample rate in hz.
         * 
         * @param sampleRate
         *        Sample rate in hz.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(Integer sampleRate);

        /**
         * Required when you set Bitrate control mode (rateControlMode) to VBR. Specify the audio quality of this MP3
         * output from 0 (highest quality) to 9 (lowest quality).
         * 
         * @param vbrQuality
         *        Required when you set Bitrate control mode (rateControlMode) to VBR. Specify the audio quality of this
         *        MP3 output from 0 (highest quality) to 9 (lowest quality).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vbrQuality(Integer vbrQuality);
    }

    static final class BuilderImpl implements Builder {
        private Integer bitrate;

        private Integer channels;

        private String rateControlMode;

        private Integer sampleRate;

        private Integer vbrQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(Mp3Settings model) {
            bitrate(model.bitrate);
            channels(model.channels);
            rateControlMode(model.rateControlMode);
            sampleRate(model.sampleRate);
            vbrQuality(model.vbrQuality);
        }

        public final Integer getBitrate() {
            return bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final Integer getChannels() {
            return channels;
        }

        @Override
        public final Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public final void setChannels(Integer channels) {
            this.channels = channels;
        }

        public final String getRateControlModeAsString() {
            return rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(Mp3RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final Integer getSampleRate() {
            return sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final Integer getVbrQuality() {
            return vbrQuality;
        }

        @Override
        public final Builder vbrQuality(Integer vbrQuality) {
            this.vbrQuality = vbrQuality;
            return this;
        }

        public final void setVbrQuality(Integer vbrQuality) {
            this.vbrQuality = vbrQuality;
        }

        @Override
        public Mp3Settings build() {
            return new Mp3Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
