/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for HLS encryption
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsEncryptionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsEncryptionSettings.Builder, HlsEncryptionSettings> {
    private static final SdkField<String> CONSTANT_INITIALIZATION_VECTOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HlsEncryptionSettings::constantInitializationVector))
            .setter(setter(Builder::constantInitializationVector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constantInitializationVector")
                    .build()).build();

    private static final SdkField<String> ENCRYPTION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsEncryptionSettings::encryptionMethodAsString)).setter(setter(Builder::encryptionMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionMethod").build()).build();

    private static final SdkField<String> INITIALIZATION_VECTOR_IN_MANIFEST_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HlsEncryptionSettings::initializationVectorInManifestAsString))
            .setter(setter(Builder::initializationVectorInManifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationVectorInManifest")
                    .build()).build();

    private static final SdkField<String> OFFLINE_ENCRYPTED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsEncryptionSettings::offlineEncryptedAsString)).setter(setter(Builder::offlineEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offlineEncrypted").build()).build();

    private static final SdkField<SpekeKeyProvider> SPEKE_KEY_PROVIDER_FIELD = SdkField
            .<SpekeKeyProvider> builder(MarshallingType.SDK_POJO).getter(getter(HlsEncryptionSettings::spekeKeyProvider))
            .setter(setter(Builder::spekeKeyProvider)).constructor(SpekeKeyProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spekeKeyProvider").build()).build();

    private static final SdkField<StaticKeyProvider> STATIC_KEY_PROVIDER_FIELD = SdkField
            .<StaticKeyProvider> builder(MarshallingType.SDK_POJO).getter(getter(HlsEncryptionSettings::staticKeyProvider))
            .setter(setter(Builder::staticKeyProvider)).constructor(StaticKeyProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticKeyProvider").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsEncryptionSettings::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONSTANT_INITIALIZATION_VECTOR_FIELD, ENCRYPTION_METHOD_FIELD, INITIALIZATION_VECTOR_IN_MANIFEST_FIELD,
            OFFLINE_ENCRYPTED_FIELD, SPEKE_KEY_PROVIDER_FIELD, STATIC_KEY_PROVIDER_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String constantInitializationVector;

    private final String encryptionMethod;

    private final String initializationVectorInManifest;

    private final String offlineEncrypted;

    private final SpekeKeyProvider spekeKeyProvider;

    private final StaticKeyProvider staticKeyProvider;

    private final String type;

    private HlsEncryptionSettings(BuilderImpl builder) {
        this.constantInitializationVector = builder.constantInitializationVector;
        this.encryptionMethod = builder.encryptionMethod;
        this.initializationVectorInManifest = builder.initializationVectorInManifest;
        this.offlineEncrypted = builder.offlineEncrypted;
        this.spekeKeyProvider = builder.spekeKeyProvider;
        this.staticKeyProvider = builder.staticKeyProvider;
        this.type = builder.type;
    }

    /**
     * This is a 128-bit, 16-byte hex value represented by a 32-character text string. If this parameter is not set then
     * the Initialization Vector will follow the segment number by default.
     * 
     * @return This is a 128-bit, 16-byte hex value represented by a 32-character text string. If this parameter is not
     *         set then the Initialization Vector will follow the segment number by default.
     */
    public String constantInitializationVector() {
        return constantInitializationVector;
    }

    /**
     * Encrypts the segments with the given encryption scheme. Leave blank to disable. Selecting 'Disabled' in the web
     * interface also disables encryption.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMethod}
     * will return {@link HlsEncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionMethodAsString}.
     * </p>
     * 
     * @return Encrypts the segments with the given encryption scheme. Leave blank to disable. Selecting 'Disabled' in
     *         the web interface also disables encryption.
     * @see HlsEncryptionType
     */
    public HlsEncryptionType encryptionMethod() {
        return HlsEncryptionType.fromValue(encryptionMethod);
    }

    /**
     * Encrypts the segments with the given encryption scheme. Leave blank to disable. Selecting 'Disabled' in the web
     * interface also disables encryption.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMethod}
     * will return {@link HlsEncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionMethodAsString}.
     * </p>
     * 
     * @return Encrypts the segments with the given encryption scheme. Leave blank to disable. Selecting 'Disabled' in
     *         the web interface also disables encryption.
     * @see HlsEncryptionType
     */
    public String encryptionMethodAsString() {
        return encryptionMethod;
    }

    /**
     * The Initialization Vector is a 128-bit number used in conjunction with the key for encrypting blocks. If set to
     * INCLUDE, Initialization Vector is listed in the manifest. Otherwise Initialization Vector is not in the manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #initializationVectorInManifest} will return
     * {@link HlsInitializationVectorInManifest#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #initializationVectorInManifestAsString}.
     * </p>
     * 
     * @return The Initialization Vector is a 128-bit number used in conjunction with the key for encrypting blocks. If
     *         set to INCLUDE, Initialization Vector is listed in the manifest. Otherwise Initialization Vector is not
     *         in the manifest.
     * @see HlsInitializationVectorInManifest
     */
    public HlsInitializationVectorInManifest initializationVectorInManifest() {
        return HlsInitializationVectorInManifest.fromValue(initializationVectorInManifest);
    }

    /**
     * The Initialization Vector is a 128-bit number used in conjunction with the key for encrypting blocks. If set to
     * INCLUDE, Initialization Vector is listed in the manifest. Otherwise Initialization Vector is not in the manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #initializationVectorInManifest} will return
     * {@link HlsInitializationVectorInManifest#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #initializationVectorInManifestAsString}.
     * </p>
     * 
     * @return The Initialization Vector is a 128-bit number used in conjunction with the key for encrypting blocks. If
     *         set to INCLUDE, Initialization Vector is listed in the manifest. Otherwise Initialization Vector is not
     *         in the manifest.
     * @see HlsInitializationVectorInManifest
     */
    public String initializationVectorInManifestAsString() {
        return initializationVectorInManifest;
    }

    /**
     * Enable this setting to insert the EXT-X-SESSION-KEY element into the master playlist. This allows for offline
     * Apple HLS FairPlay content protection.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offlineEncrypted}
     * will return {@link HlsOfflineEncrypted#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #offlineEncryptedAsString}.
     * </p>
     * 
     * @return Enable this setting to insert the EXT-X-SESSION-KEY element into the master playlist. This allows for
     *         offline Apple HLS FairPlay content protection.
     * @see HlsOfflineEncrypted
     */
    public HlsOfflineEncrypted offlineEncrypted() {
        return HlsOfflineEncrypted.fromValue(offlineEncrypted);
    }

    /**
     * Enable this setting to insert the EXT-X-SESSION-KEY element into the master playlist. This allows for offline
     * Apple HLS FairPlay content protection.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offlineEncrypted}
     * will return {@link HlsOfflineEncrypted#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #offlineEncryptedAsString}.
     * </p>
     * 
     * @return Enable this setting to insert the EXT-X-SESSION-KEY element into the master playlist. This allows for
     *         offline Apple HLS FairPlay content protection.
     * @see HlsOfflineEncrypted
     */
    public String offlineEncryptedAsString() {
        return offlineEncrypted;
    }

    /**
     * If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption with a
     * SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf settings instead.
     * 
     * @return If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption
     *         with a SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf
     *         settings instead.
     */
    public SpekeKeyProvider spekeKeyProvider() {
        return spekeKeyProvider;
    }

    /**
     * Use these settings to set up encryption with a static key provider.
     * 
     * @return Use these settings to set up encryption with a static key provider.
     */
    public StaticKeyProvider staticKeyProvider() {
        return staticKeyProvider;
    }

    /**
     * Specify whether your DRM encryption key is static or from a key provider that follows the SPEKE standard. For
     * more information about SPEKE, see https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HlsKeyProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specify whether your DRM encryption key is static or from a key provider that follows the SPEKE standard.
     *         For more information about SPEKE, see
     *         https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.
     * @see HlsKeyProviderType
     */
    public HlsKeyProviderType type() {
        return HlsKeyProviderType.fromValue(type);
    }

    /**
     * Specify whether your DRM encryption key is static or from a key provider that follows the SPEKE standard. For
     * more information about SPEKE, see https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HlsKeyProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specify whether your DRM encryption key is static or from a key provider that follows the SPEKE standard.
     *         For more information about SPEKE, see
     *         https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.
     * @see HlsKeyProviderType
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(constantInitializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(initializationVectorInManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offlineEncryptedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spekeKeyProvider());
        hashCode = 31 * hashCode + Objects.hashCode(staticKeyProvider());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsEncryptionSettings)) {
            return false;
        }
        HlsEncryptionSettings other = (HlsEncryptionSettings) obj;
        return Objects.equals(constantInitializationVector(), other.constantInitializationVector())
                && Objects.equals(encryptionMethodAsString(), other.encryptionMethodAsString())
                && Objects.equals(initializationVectorInManifestAsString(), other.initializationVectorInManifestAsString())
                && Objects.equals(offlineEncryptedAsString(), other.offlineEncryptedAsString())
                && Objects.equals(spekeKeyProvider(), other.spekeKeyProvider())
                && Objects.equals(staticKeyProvider(), other.staticKeyProvider())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HlsEncryptionSettings").add("ConstantInitializationVector", constantInitializationVector())
                .add("EncryptionMethod", encryptionMethodAsString())
                .add("InitializationVectorInManifest", initializationVectorInManifestAsString())
                .add("OfflineEncrypted", offlineEncryptedAsString()).add("SpekeKeyProvider", spekeKeyProvider())
                .add("StaticKeyProvider", staticKeyProvider()).add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConstantInitializationVector":
            return Optional.ofNullable(clazz.cast(constantInitializationVector()));
        case "EncryptionMethod":
            return Optional.ofNullable(clazz.cast(encryptionMethodAsString()));
        case "InitializationVectorInManifest":
            return Optional.ofNullable(clazz.cast(initializationVectorInManifestAsString()));
        case "OfflineEncrypted":
            return Optional.ofNullable(clazz.cast(offlineEncryptedAsString()));
        case "SpekeKeyProvider":
            return Optional.ofNullable(clazz.cast(spekeKeyProvider()));
        case "StaticKeyProvider":
            return Optional.ofNullable(clazz.cast(staticKeyProvider()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsEncryptionSettings, T> g) {
        return obj -> g.apply((HlsEncryptionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsEncryptionSettings> {
        /**
         * This is a 128-bit, 16-byte hex value represented by a 32-character text string. If this parameter is not set
         * then the Initialization Vector will follow the segment number by default.
         * 
         * @param constantInitializationVector
         *        This is a 128-bit, 16-byte hex value represented by a 32-character text string. If this parameter is
         *        not set then the Initialization Vector will follow the segment number by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constantInitializationVector(String constantInitializationVector);

        /**
         * Encrypts the segments with the given encryption scheme. Leave blank to disable. Selecting 'Disabled' in the
         * web interface also disables encryption.
         * 
         * @param encryptionMethod
         *        Encrypts the segments with the given encryption scheme. Leave blank to disable. Selecting 'Disabled'
         *        in the web interface also disables encryption.
         * @see HlsEncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsEncryptionType
         */
        Builder encryptionMethod(String encryptionMethod);

        /**
         * Encrypts the segments with the given encryption scheme. Leave blank to disable. Selecting 'Disabled' in the
         * web interface also disables encryption.
         * 
         * @param encryptionMethod
         *        Encrypts the segments with the given encryption scheme. Leave blank to disable. Selecting 'Disabled'
         *        in the web interface also disables encryption.
         * @see HlsEncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsEncryptionType
         */
        Builder encryptionMethod(HlsEncryptionType encryptionMethod);

        /**
         * The Initialization Vector is a 128-bit number used in conjunction with the key for encrypting blocks. If set
         * to INCLUDE, Initialization Vector is listed in the manifest. Otherwise Initialization Vector is not in the
         * manifest.
         * 
         * @param initializationVectorInManifest
         *        The Initialization Vector is a 128-bit number used in conjunction with the key for encrypting blocks.
         *        If set to INCLUDE, Initialization Vector is listed in the manifest. Otherwise Initialization Vector is
         *        not in the manifest.
         * @see HlsInitializationVectorInManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsInitializationVectorInManifest
         */
        Builder initializationVectorInManifest(String initializationVectorInManifest);

        /**
         * The Initialization Vector is a 128-bit number used in conjunction with the key for encrypting blocks. If set
         * to INCLUDE, Initialization Vector is listed in the manifest. Otherwise Initialization Vector is not in the
         * manifest.
         * 
         * @param initializationVectorInManifest
         *        The Initialization Vector is a 128-bit number used in conjunction with the key for encrypting blocks.
         *        If set to INCLUDE, Initialization Vector is listed in the manifest. Otherwise Initialization Vector is
         *        not in the manifest.
         * @see HlsInitializationVectorInManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsInitializationVectorInManifest
         */
        Builder initializationVectorInManifest(HlsInitializationVectorInManifest initializationVectorInManifest);

        /**
         * Enable this setting to insert the EXT-X-SESSION-KEY element into the master playlist. This allows for offline
         * Apple HLS FairPlay content protection.
         * 
         * @param offlineEncrypted
         *        Enable this setting to insert the EXT-X-SESSION-KEY element into the master playlist. This allows for
         *        offline Apple HLS FairPlay content protection.
         * @see HlsOfflineEncrypted
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsOfflineEncrypted
         */
        Builder offlineEncrypted(String offlineEncrypted);

        /**
         * Enable this setting to insert the EXT-X-SESSION-KEY element into the master playlist. This allows for offline
         * Apple HLS FairPlay content protection.
         * 
         * @param offlineEncrypted
         *        Enable this setting to insert the EXT-X-SESSION-KEY element into the master playlist. This allows for
         *        offline Apple HLS FairPlay content protection.
         * @see HlsOfflineEncrypted
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsOfflineEncrypted
         */
        Builder offlineEncrypted(HlsOfflineEncrypted offlineEncrypted);

        /**
         * If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption
         * with a SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf settings
         * instead.
         * 
         * @param spekeKeyProvider
         *        If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM
         *        encryption with a SPEKE-compliant key provider. If your output group type is CMAF, use the
         *        SpekeKeyProviderCmaf settings instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider);

        /**
         * If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption
         * with a SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf settings
         * instead. This is a convenience that creates an instance of the {@link SpekeKeyProvider.Builder} avoiding the
         * need to create one manually via {@link SpekeKeyProvider#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpekeKeyProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #spekeKeyProvider(SpekeKeyProvider)}.
         * 
         * @param spekeKeyProvider
         *        a consumer that will call methods on {@link SpekeKeyProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spekeKeyProvider(SpekeKeyProvider)
         */
        default Builder spekeKeyProvider(Consumer<SpekeKeyProvider.Builder> spekeKeyProvider) {
            return spekeKeyProvider(SpekeKeyProvider.builder().applyMutation(spekeKeyProvider).build());
        }

        /**
         * Use these settings to set up encryption with a static key provider.
         * 
         * @param staticKeyProvider
         *        Use these settings to set up encryption with a static key provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticKeyProvider(StaticKeyProvider staticKeyProvider);

        /**
         * Use these settings to set up encryption with a static key provider. This is a convenience that creates an
         * instance of the {@link StaticKeyProvider.Builder} avoiding the need to create one manually via
         * {@link StaticKeyProvider#builder()}.
         *
         * When the {@link Consumer} completes, {@link StaticKeyProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #staticKeyProvider(StaticKeyProvider)}.
         * 
         * @param staticKeyProvider
         *        a consumer that will call methods on {@link StaticKeyProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staticKeyProvider(StaticKeyProvider)
         */
        default Builder staticKeyProvider(Consumer<StaticKeyProvider.Builder> staticKeyProvider) {
            return staticKeyProvider(StaticKeyProvider.builder().applyMutation(staticKeyProvider).build());
        }

        /**
         * Specify whether your DRM encryption key is static or from a key provider that follows the SPEKE standard. For
         * more information about SPEKE, see https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.
         * 
         * @param type
         *        Specify whether your DRM encryption key is static or from a key provider that follows the SPEKE
         *        standard. For more information about SPEKE, see
         *        https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.
         * @see HlsKeyProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsKeyProviderType
         */
        Builder type(String type);

        /**
         * Specify whether your DRM encryption key is static or from a key provider that follows the SPEKE standard. For
         * more information about SPEKE, see https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.
         * 
         * @param type
         *        Specify whether your DRM encryption key is static or from a key provider that follows the SPEKE
         *        standard. For more information about SPEKE, see
         *        https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.
         * @see HlsKeyProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsKeyProviderType
         */
        Builder type(HlsKeyProviderType type);
    }

    static final class BuilderImpl implements Builder {
        private String constantInitializationVector;

        private String encryptionMethod;

        private String initializationVectorInManifest;

        private String offlineEncrypted;

        private SpekeKeyProvider spekeKeyProvider;

        private StaticKeyProvider staticKeyProvider;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsEncryptionSettings model) {
            constantInitializationVector(model.constantInitializationVector);
            encryptionMethod(model.encryptionMethod);
            initializationVectorInManifest(model.initializationVectorInManifest);
            offlineEncrypted(model.offlineEncrypted);
            spekeKeyProvider(model.spekeKeyProvider);
            staticKeyProvider(model.staticKeyProvider);
            type(model.type);
        }

        public final String getConstantInitializationVector() {
            return constantInitializationVector;
        }

        @Override
        public final Builder constantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
            return this;
        }

        public final void setConstantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
        }

        public final String getEncryptionMethodAsString() {
            return encryptionMethod;
        }

        @Override
        public final Builder encryptionMethod(String encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
            return this;
        }

        @Override
        public final Builder encryptionMethod(HlsEncryptionType encryptionMethod) {
            this.encryptionMethod(encryptionMethod == null ? null : encryptionMethod.toString());
            return this;
        }

        public final void setEncryptionMethod(String encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
        }

        public final String getInitializationVectorInManifestAsString() {
            return initializationVectorInManifest;
        }

        @Override
        public final Builder initializationVectorInManifest(String initializationVectorInManifest) {
            this.initializationVectorInManifest = initializationVectorInManifest;
            return this;
        }

        @Override
        public final Builder initializationVectorInManifest(HlsInitializationVectorInManifest initializationVectorInManifest) {
            this.initializationVectorInManifest(initializationVectorInManifest == null ? null : initializationVectorInManifest
                    .toString());
            return this;
        }

        public final void setInitializationVectorInManifest(String initializationVectorInManifest) {
            this.initializationVectorInManifest = initializationVectorInManifest;
        }

        public final String getOfflineEncryptedAsString() {
            return offlineEncrypted;
        }

        @Override
        public final Builder offlineEncrypted(String offlineEncrypted) {
            this.offlineEncrypted = offlineEncrypted;
            return this;
        }

        @Override
        public final Builder offlineEncrypted(HlsOfflineEncrypted offlineEncrypted) {
            this.offlineEncrypted(offlineEncrypted == null ? null : offlineEncrypted.toString());
            return this;
        }

        public final void setOfflineEncrypted(String offlineEncrypted) {
            this.offlineEncrypted = offlineEncrypted;
        }

        public final SpekeKeyProvider.Builder getSpekeKeyProvider() {
            return spekeKeyProvider != null ? spekeKeyProvider.toBuilder() : null;
        }

        @Override
        public final Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider;
            return this;
        }

        public final void setSpekeKeyProvider(SpekeKeyProvider.BuilderImpl spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider != null ? spekeKeyProvider.build() : null;
        }

        public final StaticKeyProvider.Builder getStaticKeyProvider() {
            return staticKeyProvider != null ? staticKeyProvider.toBuilder() : null;
        }

        @Override
        public final Builder staticKeyProvider(StaticKeyProvider staticKeyProvider) {
            this.staticKeyProvider = staticKeyProvider;
            return this;
        }

        public final void setStaticKeyProvider(StaticKeyProvider.BuilderImpl staticKeyProvider) {
            this.staticKeyProvider = staticKeyProvider != null ? staticKeyProvider.build() : null;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HlsKeyProviderType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public HlsEncryptionSettings build() {
            return new HlsEncryptionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
