/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Caption Language Mapping
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsCaptionLanguageMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsCaptionLanguageMapping.Builder, HlsCaptionLanguageMapping> {
    private static final SdkField<Integer> CAPTION_CHANNEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsCaptionLanguageMapping::captionChannel)).setter(setter(Builder::captionChannel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionChannel").build()).build();

    private static final SdkField<String> CUSTOM_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsCaptionLanguageMapping::customLanguageCode)).setter(setter(Builder::customLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLanguageCode").build())
            .build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsCaptionLanguageMapping::languageCodeAsString)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()).build();

    private static final SdkField<String> LANGUAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsCaptionLanguageMapping::languageDescription)).setter(setter(Builder::languageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTION_CHANNEL_FIELD,
            CUSTOM_LANGUAGE_CODE_FIELD, LANGUAGE_CODE_FIELD, LANGUAGE_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer captionChannel;

    private final String customLanguageCode;

    private final String languageCode;

    private final String languageDescription;

    private HlsCaptionLanguageMapping(BuilderImpl builder) {
        this.captionChannel = builder.captionChannel;
        this.customLanguageCode = builder.customLanguageCode;
        this.languageCode = builder.languageCode;
        this.languageDescription = builder.languageDescription;
    }

    /**
     * Caption channel.
     * 
     * @return Caption channel.
     */
    public Integer captionChannel() {
        return captionChannel;
    }

    /**
     * Specify the language for this captions channel, using the ISO 639-2 or ISO 639-3 three-letter language code
     * 
     * @return Specify the language for this captions channel, using the ISO 639-2 or ISO 639-3 three-letter language
     *         code
     */
    public String customLanguageCode() {
        return customLanguageCode;
    }

    /**
     * Specify the language, using the ISO 639-2 three-letter code listed at
     * https://www.loc.gov/standards/iso639-2/php/code_list.php.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Specify the language, using the ISO 639-2 three-letter code listed at
     *         https://www.loc.gov/standards/iso639-2/php/code_list.php.
     * @see LanguageCode
     */
    public LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * Specify the language, using the ISO 639-2 three-letter code listed at
     * https://www.loc.gov/standards/iso639-2/php/code_list.php.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Specify the language, using the ISO 639-2 three-letter code listed at
     *         https://www.loc.gov/standards/iso639-2/php/code_list.php.
     * @see LanguageCode
     */
    public String languageCodeAsString() {
        return languageCode;
    }

    /**
     * Caption language description.
     * 
     * @return Caption language description.
     */
    public String languageDescription() {
        return languageDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(captionChannel());
        hashCode = 31 * hashCode + Objects.hashCode(customLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(languageDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsCaptionLanguageMapping)) {
            return false;
        }
        HlsCaptionLanguageMapping other = (HlsCaptionLanguageMapping) obj;
        return Objects.equals(captionChannel(), other.captionChannel())
                && Objects.equals(customLanguageCode(), other.customLanguageCode())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(languageDescription(), other.languageDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HlsCaptionLanguageMapping").add("CaptionChannel", captionChannel())
                .add("CustomLanguageCode", customLanguageCode()).add("LanguageCode", languageCodeAsString())
                .add("LanguageDescription", languageDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CaptionChannel":
            return Optional.ofNullable(clazz.cast(captionChannel()));
        case "CustomLanguageCode":
            return Optional.ofNullable(clazz.cast(customLanguageCode()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "LanguageDescription":
            return Optional.ofNullable(clazz.cast(languageDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsCaptionLanguageMapping, T> g) {
        return obj -> g.apply((HlsCaptionLanguageMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsCaptionLanguageMapping> {
        /**
         * Caption channel.
         * 
         * @param captionChannel
         *        Caption channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionChannel(Integer captionChannel);

        /**
         * Specify the language for this captions channel, using the ISO 639-2 or ISO 639-3 three-letter language code
         * 
         * @param customLanguageCode
         *        Specify the language for this captions channel, using the ISO 639-2 or ISO 639-3 three-letter language
         *        code
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLanguageCode(String customLanguageCode);

        /**
         * Specify the language, using the ISO 639-2 three-letter code listed at
         * https://www.loc.gov/standards/iso639-2/php/code_list.php.
         * 
         * @param languageCode
         *        Specify the language, using the ISO 639-2 three-letter code listed at
         *        https://www.loc.gov/standards/iso639-2/php/code_list.php.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * Specify the language, using the ISO 639-2 three-letter code listed at
         * https://www.loc.gov/standards/iso639-2/php/code_list.php.
         * 
         * @param languageCode
         *        Specify the language, using the ISO 639-2 three-letter code listed at
         *        https://www.loc.gov/standards/iso639-2/php/code_list.php.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * Caption language description.
         * 
         * @param languageDescription
         *        Caption language description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageDescription(String languageDescription);
    }

    static final class BuilderImpl implements Builder {
        private Integer captionChannel;

        private String customLanguageCode;

        private String languageCode;

        private String languageDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsCaptionLanguageMapping model) {
            captionChannel(model.captionChannel);
            customLanguageCode(model.customLanguageCode);
            languageCode(model.languageCode);
            languageDescription(model.languageDescription);
        }

        public final Integer getCaptionChannel() {
            return captionChannel;
        }

        @Override
        public final Builder captionChannel(Integer captionChannel) {
            this.captionChannel = captionChannel;
            return this;
        }

        public final void setCaptionChannel(Integer captionChannel) {
            this.captionChannel = captionChannel;
        }

        public final String getCustomLanguageCode() {
            return customLanguageCode;
        }

        @Override
        public final Builder customLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
            return this;
        }

        public final void setCustomLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
        }

        public final String getLanguageCodeAsString() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getLanguageDescription() {
            return languageDescription;
        }

        @Override
        public final Builder languageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
            return this;
        }

        public final void setLanguageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
        }

        @Override
        public HlsCaptionLanguageMapping build() {
            return new HlsCaptionLanguageMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
