/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use these settings when you set DolbyVisionLevel6Mode to SPECIFY to override the MaxCLL and MaxFALL values in your
 * input with new values.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DolbyVisionLevel6Metadata implements SdkPojo, Serializable,
        ToCopyableBuilder<DolbyVisionLevel6Metadata.Builder, DolbyVisionLevel6Metadata> {
    private static final SdkField<Integer> MAX_CLL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DolbyVisionLevel6Metadata::maxCll)).setter(setter(Builder::maxCll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCll").build()).build();

    private static final SdkField<Integer> MAX_FALL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DolbyVisionLevel6Metadata::maxFall)).setter(setter(Builder::maxFall))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFall").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(MAX_CLL_FIELD, MAX_FALL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxCll;

    private final Integer maxFall;

    private DolbyVisionLevel6Metadata(BuilderImpl builder) {
        this.maxCll = builder.maxCll;
        this.maxFall = builder.maxFall;
    }

    /**
     * Maximum Content Light Level. Static HDR metadata that corresponds to the brightest pixel in the entire stream.
     * Measured in nits.
     * 
     * @return Maximum Content Light Level. Static HDR metadata that corresponds to the brightest pixel in the entire
     *         stream. Measured in nits.
     */
    public Integer maxCll() {
        return maxCll;
    }

    /**
     * Maximum Frame-Average Light Level. Static HDR metadata that corresponds to the highest frame-average brightness
     * in the entire stream. Measured in nits.
     * 
     * @return Maximum Frame-Average Light Level. Static HDR metadata that corresponds to the highest frame-average
     *         brightness in the entire stream. Measured in nits.
     */
    public Integer maxFall() {
        return maxFall;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxCll());
        hashCode = 31 * hashCode + Objects.hashCode(maxFall());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DolbyVisionLevel6Metadata)) {
            return false;
        }
        DolbyVisionLevel6Metadata other = (DolbyVisionLevel6Metadata) obj;
        return Objects.equals(maxCll(), other.maxCll()) && Objects.equals(maxFall(), other.maxFall());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DolbyVisionLevel6Metadata").add("MaxCll", maxCll()).add("MaxFall", maxFall()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxCll":
            return Optional.ofNullable(clazz.cast(maxCll()));
        case "MaxFall":
            return Optional.ofNullable(clazz.cast(maxFall()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DolbyVisionLevel6Metadata, T> g) {
        return obj -> g.apply((DolbyVisionLevel6Metadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DolbyVisionLevel6Metadata> {
        /**
         * Maximum Content Light Level. Static HDR metadata that corresponds to the brightest pixel in the entire
         * stream. Measured in nits.
         * 
         * @param maxCll
         *        Maximum Content Light Level. Static HDR metadata that corresponds to the brightest pixel in the entire
         *        stream. Measured in nits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCll(Integer maxCll);

        /**
         * Maximum Frame-Average Light Level. Static HDR metadata that corresponds to the highest frame-average
         * brightness in the entire stream. Measured in nits.
         * 
         * @param maxFall
         *        Maximum Frame-Average Light Level. Static HDR metadata that corresponds to the highest frame-average
         *        brightness in the entire stream. Measured in nits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFall(Integer maxFall);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxCll;

        private Integer maxFall;

        private BuilderImpl() {
        }

        private BuilderImpl(DolbyVisionLevel6Metadata model) {
            maxCll(model.maxCll);
            maxFall(model.maxFall);
        }

        public final Integer getMaxCll() {
            return maxCll;
        }

        @Override
        public final Builder maxCll(Integer maxCll) {
            this.maxCll = maxCll;
            return this;
        }

        public final void setMaxCll(Integer maxCll) {
            this.maxCll = maxCll;
        }

        public final Integer getMaxFall() {
            return maxFall;
        }

        @Override
        public final Builder maxFall(Integer maxFall) {
            this.maxFall = maxFall;
            return this;
        }

        public final void setMaxFall(Integer maxFall) {
            this.maxFall = maxFall;
        }

        @Override
        public DolbyVisionLevel6Metadata build() {
            return new DolbyVisionLevel6Metadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
