/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * There are two sources for color metadata, the input file and the job input settings Color space (ColorSpace) and HDR
 * master display information settings(Hdr10Metadata). The Color space usage setting determines which takes precedence.
 * Choose Force (FORCE) to use color metadata from the input job settings. If you don't specify values for those
 * settings, the service defaults to using metadata from your input. FALLBACK - Choose Fallback (FALLBACK) to use color
 * metadata from the source when it is present. If there's no color metadata in your input file, the service defaults to
 * using values you specify in the input settings.
 */
@Generated("software.amazon.awssdk:codegen")
public enum ColorSpaceUsage {
    FORCE("FORCE"),

    FALLBACK("FALLBACK"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ColorSpaceUsage(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ColorSpaceUsage corresponding to the value
     */
    public static ColorSpaceUsage fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ColorSpaceUsage.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ColorSpaceUsage}s
     */
    public static Set<ColorSpaceUsage> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
